/*
 * Decompiled with CFR 0.152.
 */
package ch.ionesoft.ilp.book.icb;

import ch.ionesoft.ilp.book.icb.ICBDashboardRequestDelegate;
import ch.ionesoft.ilp.book.icb.ICBLearningStatisticsRequestDelegate;
import ch.ionesoft.ilp.book.icb.ICBLoggerRequestDelegate;
import ch.ionesoft.ilp.book.icb.ICBModelRequestDelegate;
import ch.ionesoft.ilp.book.icb.ICBNavigationRequestDelegate;
import ch.ionesoft.ilp.book.icb.ICBProductRequestDelegate;
import ch.ionesoft.ilp.book.icb.ICBRequestDelegate;
import ch.ionesoft.ilp.book.icb.ICBRequestHandlingException;
import ch.ionesoft.ilp.book.icb.ICBScenarioRequestDelegate;
import ch.ionesoft.ilp.book.icb.ICBTaskRequestDelegate;
import ch.ionesoft.ilp.book.icb.ICBUserRequestDelegate;
import ch.ionesoft.ilp.book.mo.ILPCourseDef;
import ch.ionesoft.ilp.book.mo.ILPResource;
import java.util.HashMap;
import java.util.Map;

public abstract class ICBRequestHandler {
    private static final String ICB_REQUEST_DELEGATION_DASHBOARD = "dashboard";
    private static final String ICB_REQUEST_DELEGATION_LOGGER = "logger";
    private static final String ICB_REQUEST_DELEGATION_MODEL = "model";
    private static final String ICB_REQUEST_DELEGATION_PRODUCT = "product";
    private static final String ICB_REQUEST_DELEGATION_USER = "user";
    private static final String ICB_REQUEST_DELEGATION_LEARNING_STATISTICS = "learningStatistics";
    private static final String ICB_REQUEST_DELEGATION_NAVIGATION = "baseNavigation";
    private static final String ICB_REQUEST_DELEGATION_SCENARIO = "scenario";
    private static final String ICB_REQUEST_DELEGATION_TASK = "task";
    private Map<String, ICBRequestDelegate> requestDelegates = new HashMap<String, ICBRequestDelegate>();
    private ICBViewDelegate viewDelegate;

    public ICBRequestHandler(ICBViewDelegate iCBViewDelegate) {
        this.viewDelegate = iCBViewDelegate;
    }

    public void setICBViewDelegate(ICBViewDelegate iCBViewDelegate) {
        this.viewDelegate = iCBViewDelegate;
    }

    protected ICBRequestDelegate getRequestDelegate(String string) throws ICBRequestHandlingException {
        ICBRequestDelegate iCBRequestDelegate = this.requestDelegates.get(string);
        if (iCBRequestDelegate == null) {
            if (string.equals(ICB_REQUEST_DELEGATION_LOGGER)) {
                iCBRequestDelegate = new ICBLoggerRequestDelegate();
            } else if (string.equals(ICB_REQUEST_DELEGATION_MODEL)) {
                iCBRequestDelegate = new ICBModelRequestDelegate();
            } else if (string.equals(ICB_REQUEST_DELEGATION_PRODUCT)) {
                iCBRequestDelegate = new ICBProductRequestDelegate();
            } else if (string.equals(ICB_REQUEST_DELEGATION_DASHBOARD)) {
                iCBRequestDelegate = new ICBDashboardRequestDelegate(this.viewDelegate);
            } else if (string.equals(ICB_REQUEST_DELEGATION_USER)) {
                iCBRequestDelegate = new ICBUserRequestDelegate();
            } else if (string.equals(ICB_REQUEST_DELEGATION_NAVIGATION)) {
                iCBRequestDelegate = new ICBNavigationRequestDelegate(this.viewDelegate);
            } else if (string.equals(ICB_REQUEST_DELEGATION_SCENARIO)) {
                iCBRequestDelegate = new ICBScenarioRequestDelegate(this.viewDelegate);
            } else if (string.equals(ICB_REQUEST_DELEGATION_LEARNING_STATISTICS)) {
                iCBRequestDelegate = new ICBLearningStatisticsRequestDelegate(this.viewDelegate);
            } else if (string.equals(ICB_REQUEST_DELEGATION_TASK)) {
                iCBRequestDelegate = new ICBTaskRequestDelegate(this.viewDelegate);
            } else {
                throw new ICBRequestHandlingException("Unknown request delegate identifier", ICBRequestHandlingException.ICBRequestHandlingExceptionType.EXCEPTION_TYPE_EXECUTION);
            }
            this.requestDelegates.put(string, iCBRequestDelegate);
        }
        return iCBRequestDelegate;
    }

    public static interface ICBViewDelegate {
        public void navigateTo(String var1);

        public void navigateToCourse(ILPCourseDef var1);

        public void navigateToDashboard();

        public String courseSymbolForCourse(ILPCourseDef var1);

        public void startScenario(String var1);

        public void openLessonsContent(ILPResource var1, boolean var2);
    }
}

