/*
 * Decompiled with CFR 0.152.
 */
package ch.ionesoft.ilp.book.icb;

import ch.ionesoft.ilp.base.co.ILPLogManager;
import ch.ionesoft.ilp.base.co.ILogger;
import ch.ionesoft.ilp.base.co.h;
import ch.ionesoft.ilp.book.angular.base.model.c;
import ch.ionesoft.ilp.book.angular.base.model.d;
import ch.ionesoft.ilp.book.angular.model.R;
import ch.ionesoft.ilp.book.angular.model.b;
import ch.ionesoft.ilp.book.angular.model.l;
import ch.ionesoft.ilp.book.ia.b;
import ch.ionesoft.ilp.book.icb.ICBRequestDelegate;
import ch.ionesoft.ilp.book.icb.ICBRequestHandlingException;
import ch.ionesoft.ilp.book.icb.RFC3339DateFormat;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.io.IOException;
import java.text.DateFormat;
import java.util.TimeZone;
import org.apache.commons.lang3.SystemUtils;

public abstract class ICBRequestDelegateBase
implements ICBRequestDelegate {
    private static ILogger logger = ILPLogManager.getLogger(ICBRequestDelegateBase.class);

    public static ObjectMapper getObjectMapper() {
        return new ObjectMapper().disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES).disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS).registerModule((Module)new JavaTimeModule()).setDateFormat((DateFormat)new RFC3339DateFormat()).setTimeZone(TimeZone.getTimeZone("UTC"));
    }

    public static <T> T getObjectFromJsonPayload(String string, Class<T> clazz) throws ICBRequestHandlingException {
        try {
            return (T)ICBRequestDelegateBase.getObjectMapper().readValue(string, clazz);
        }
        catch (IOException iOException) {
            logger.d((Object)("Could not read request object from payload: " + string), (Throwable)iOException);
            throw new ICBRequestHandlingException(string, ICBRequestHandlingException.ICBRequestHandlingExceptionType.EXCEPTION_TYPE_EXECUTION);
        }
    }

    public c extractEnvelope(String string) throws ICBRequestHandlingException {
        return ICBRequestDelegateBase.getObjectFromJsonPayload(string, c.class);
    }

    protected String writeResponse(Object object) throws ICBRequestHandlingException {
        try {
            return ICBRequestDelegateBase.getObjectMapper().writeValueAsString(object);
        }
        catch (JsonProcessingException jsonProcessingException) {
            logger.d((Object)("Could not write response object: " + object), (Throwable)jsonProcessingException);
            throw new ICBRequestHandlingException("Error serializing the response object", ICBRequestHandlingException.ICBRequestHandlingExceptionType.EXCEPTION_TYPE_EXECUTION);
        }
    }

    @Override
    public String serializedResponseEnvelope(d d2) throws ICBRequestHandlingException {
        try {
            return ICBRequestDelegateBase.getObjectMapper().writeValueAsString((Object)d2);
        }
        catch (JsonProcessingException jsonProcessingException) {
            logger.d((Object)("Could not serialize response envelope: " + d2), (Throwable)jsonProcessingException);
            throw new ICBRequestHandlingException("Error serializing the response envelope", ICBRequestHandlingException.ICBRequestHandlingExceptionType.EXCEPTION_TYPE_EXECUTION);
        }
    }

    protected b.a getAppPlatformEnum() {
        if (SystemUtils.IS_OS_WINDOWS) {
            return b.a.b;
        }
        if (SystemUtils.IS_OS_MAC) {
            return b.a.c;
        }
        return b.a.d;
    }

    protected R createGlobalResponse(b.a a2) {
        return this.createGlobalResponse(a2, null, null);
    }

    protected R createGlobalResponse(b.a a2, String string, String string2) {
        R r2 = new R();
        r2.b(a2.a());
        r2.d(string);
        r2.f(string2);
        return r2;
    }

    protected l createDetailResponse(b.a a2) {
        return this.createDetailResponse(a2, null, null);
    }

    protected l createDetailResponse(b.a a2, String string, String string2) {
        l l2 = new l();
        l2.b(a2.a());
        l2.d(string);
        l2.f(string2);
        return l2;
    }

    protected String getBundleFileUrl(String string, String string2) {
        return String.valueOf(h.V()) + "fileSynch" + "/" + string + "/" + string2;
    }
}

