/*
 * Decompiled with CFR 0.152.
 */
package ch.ionesoft.ilp.book.icb;

import ch.ionesoft.ilp.base.co.ILPLogManager;
import ch.ionesoft.ilp.base.co.ILogger;
import ch.ionesoft.ilp.base.he.SystemHelper;
import ch.ionesoft.ilp.book.angular.model.C;
import ch.ionesoft.ilp.book.angular.model.D;
import ch.ionesoft.ilp.book.angular.model.E;
import ch.ionesoft.ilp.book.angular.model.G;
import ch.ionesoft.ilp.book.angular.model.H;
import ch.ionesoft.ilp.book.angular.model.I;
import ch.ionesoft.ilp.book.angular.model.L;
import ch.ionesoft.ilp.book.angular.model.M;
import ch.ionesoft.ilp.book.angular.model.N;
import ch.ionesoft.ilp.book.angular.model.V;
import ch.ionesoft.ilp.book.angular.model.X;
import ch.ionesoft.ilp.book.angular.model.Y;
import ch.ionesoft.ilp.book.angular.model.Z;
import ch.ionesoft.ilp.book.angular.model.a;
import ch.ionesoft.ilp.book.angular.model.aa;
import ch.ionesoft.ilp.book.angular.model.ab;
import ch.ionesoft.ilp.book.angular.model.ac;
import ch.ionesoft.ilp.book.angular.model.ad;
import ch.ionesoft.ilp.book.angular.model.ai;
import ch.ionesoft.ilp.book.angular.model.au;
import ch.ionesoft.ilp.book.angular.model.av;
import ch.ionesoft.ilp.book.angular.model.aw;
import ch.ionesoft.ilp.book.angular.model.ax;
import ch.ionesoft.ilp.book.angular.model.b;
import ch.ionesoft.ilp.book.angular.model.f;
import ch.ionesoft.ilp.book.angular.model.h;
import ch.ionesoft.ilp.book.angular.model.j;
import ch.ionesoft.ilp.book.angular.model.k;
import ch.ionesoft.ilp.book.angular.model.l;
import ch.ionesoft.ilp.book.angular.model.m;
import ch.ionesoft.ilp.book.angular.model.n;
import ch.ionesoft.ilp.book.angular.model.o;
import ch.ionesoft.ilp.book.angular.model.p;
import ch.ionesoft.ilp.book.angular.model.q;
import ch.ionesoft.ilp.book.angular.model.u;
import ch.ionesoft.ilp.book.angular.model.v;
import ch.ionesoft.ilp.book.angular.model.z;
import ch.ionesoft.ilp.book.co.ILPAdvertisementController;
import ch.ionesoft.ilp.book.co.ILPBookHelper;
import ch.ionesoft.ilp.book.co.ILPBookRegistry;
import ch.ionesoft.ilp.book.co.ILPProfileManager;
import ch.ionesoft.ilp.book.ia.b;
import ch.ionesoft.ilp.book.ia.d;
import ch.ionesoft.ilp.book.icb.ICBRequestDelegateBase;
import ch.ionesoft.ilp.book.icb.ICBRequestHandler;
import ch.ionesoft.ilp.book.icb.ICBRequestHandlingException;
import ch.ionesoft.ilp.book.mo.ILPCourseDef;
import ch.ionesoft.ilp.book.mo.ILPEProduct;
import ch.ionesoft.ilp.book.mo.ILPExercise;
import ch.ionesoft.ilp.book.mo.ILPIssueDef;
import ch.ionesoft.ilp.book.mo.ILPLicense;
import ch.ionesoft.ilp.book.mo.ILPNews;
import ch.ionesoft.ilp.book.mo.ILPScenarioDefinition;
import ch.ionesoft.ilp.book.mo.ILPScenarioSpecification;
import ch.ionesoft.ilp.book.mo.ILPTopic;
import ch.ionesoft.ilp.book.pe.g;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;

public class ICBDashboardRequestDelegate
extends ICBRequestDelegateBase {
    private static ILogger logger = ILPLogManager.getLogger(ICBDashboardRequestDelegate.class);
    private static final String ANDROID_ASSET_BASE_PATH = "/android_asset/angular/assets/";
    private final ICBRequestHandler.ICBViewDelegate viewDelegate;

    public ICBDashboardRequestDelegate(ICBRequestHandler.ICBViewDelegate iCBViewDelegate) {
        this.viewDelegate = iCBViewDelegate;
    }

    @Override
    public String handleRequest(String string, String string2) throws ICBRequestHandlingException {
        logger.b((Object)("Handling request: " + string));
        if (string.equals("lastVisitedModels")) {
            return this.handleLastVisitedModelsRequest();
        }
        if (string.equals("countCompletedExercises")) {
            return this.handleCountCompletedExerciseRequest();
        }
        if (string.equals("getEbookActions")) {
            return this.handleGetEbookActionsRequest();
        }
        if (string.equals("getAppConfiguration")) {
            return this.handleGetAppConfigurationRequest();
        }
        if (string.equals("getNewsFeed")) {
            return this.handleGetNewsFeedRequest(string2);
        }
        if (string.equals("updateNewsItems")) {
            return this.handleUpdateNewsItems(string2);
        }
        if (string.equals("getNumScenarios")) {
            return this.handleGetNumScenariosRequest();
        }
        if (string.equals("getStatisticsOverview")) {
            return this.handleGetStatisticsOverviewRequest(string2);
        }
        if (string.equals("getAdvertisement")) {
            return this.handleGetAdvertisementRequest();
        }
        if (string.equals("getNumNewFeedbacks")) {
            return this.handleGetNumNewFeedbacksRequest();
        }
        logger.d((Object)("Command for request unrecognized: " + string));
        throw new ICBRequestHandlingException("Unrecognized request command", ICBRequestHandlingException.ICBRequestHandlingExceptionType.EXCEPTION_TYPE_EXECUTION);
    }

    private String handleGetNumNewFeedbacksRequest() throws ICBRequestHandlingException {
        I i2 = new I();
        H h2 = new H();
        h2.b((int)ch.ionesoft.ilp.book.pe.f.a().aw());
        i2.b(this.createGlobalResponse(b.a.a, null, null));
        i2.b(h2);
        return this.writeResponse(i2);
    }

    private String handleGetNumScenariosRequest() throws ICBRequestHandlingException {
        L l2 = new L();
        List<ILPScenarioSpecification> list = ch.ionesoft.ilp.book.pe.f.a().a(ILPScenarioDefinition.ScenarioOwner.SCENARIO_OWNER_UNDEFINED, ILPScenarioDefinition.ScenarioType.SCENARIO_TYPE_STATIC, ILPScenarioDefinition.ScenarioPlayMode.SCENARIO_PLAYMODE_UNDEFINED, ILPScenarioDefinition.ScenarioDefinitionStatus.SCENARIO_DEF_STATUS_UNDEFINED);
        this.removeSpecificationsWithoutDefinition(list);
        List<ILPScenarioSpecification> list2 = ch.ionesoft.ilp.book.pe.f.a().a(ILPScenarioDefinition.ScenarioOwner.SCENARIO_OWNER_UNDEFINED, ILPScenarioDefinition.ScenarioType.SCENARIO_TYPE_DYNAMIC, ILPScenarioDefinition.ScenarioPlayMode.SCENARIO_PLAYMODE_UNDEFINED, ILPScenarioDefinition.ScenarioDefinitionStatus.SCENARIO_DEF_STATUS_UNDEFINED);
        this.removeSpecificationsWithoutDefinition(list2);
        ai ai2 = new ai();
        ai2.d(list2 != null ? list2.size() : 0);
        ai2.b(list != null ? list.size() : 0);
        l2.b(this.createGlobalResponse(b.a.a, null, null));
        l2.b(ai2);
        return this.writeResponse(l2);
    }

    private void removeSpecificationsWithoutDefinition(List<ILPScenarioSpecification> list) {
        if (list != null && !list.isEmpty()) {
            Iterator<ILPScenarioSpecification> iterator = list.iterator();
            while (iterator.hasNext()) {
                try {
                    ILPScenarioSpecification iLPScenarioSpecification = iterator.next();
                    if (iLPScenarioSpecification.getScenarioDefinition() != null) continue;
                    iterator.remove();
                }
                catch (Exception exception) {
                    logger.d((Object)"Could not check if scenarioSpecifation has a definition", (Throwable)exception);
                }
            }
        }
    }

    private String handleGetAdvertisementRequest() throws ICBRequestHandlingException {
        u u2 = new u();
        a a2 = new a();
        try {
            a2.b(ILPAdvertisementController.instance().readContentsOfAdvertisementFile());
        }
        catch (IOException iOException) {
            logger.d((Object)"Could not read advertisementData from html file", (Throwable)iOException);
            a2.b("");
        }
        u2.b(this.createGlobalResponse(b.a.a, null, null));
        u2.b(a2);
        return this.writeResponse(u2);
    }

    private String handleGetStatisticsOverviewRequest(String string) throws ICBRequestHandlingException {
        N n2 = new N();
        M m2 = ICBDashboardRequestDelegate.getObjectFromJsonPayload(string, M.class);
        List<h> list = m2.a();
        for (h h2 : list) {
            Object object;
            boolean bl2 = true;
            k k2 = new k();
            j j2 = new j();
            j2.b(h2);
            try {
                object = ch.ionesoft.ilp.book.pe.f.a().a(h2.a(), h2.b());
                if (object == null) {
                    throw new Exception("No course definition found");
                }
                j2.b(object.getTitle());
                j2.d(object.getCourseProduct().getPrintCodeOrEdition());
                j2.f(this.viewDelegate.courseSymbolForCourse((ILPCourseDef)object));
                List<ILPIssueDef> list2 = ch.ionesoft.ilp.book.pe.f.a().f((ILPCourseDef)object);
                int n3 = 0;
                av av2 = new av();
                q q2 = new q();
                BigDecimal bigDecimal = BigDecimal.ZERO;
                av2.b(bigDecimal);
                av2.d(bigDecimal);
                q2.b(bigDecimal);
                q2.d(bigDecimal);
                q2.f(bigDecimal);
                q2.h(bigDecimal);
                for (ILPIssueDef iLPIssueDef : list2) {
                    boolean bl3 = false;
                    List<ILPTopic> list3 = ch.ionesoft.ilp.book.pe.f.a().f(iLPIssueDef);
                    long l2 = 0L;
                    if (list3 != null) {
                        av2.b(av2.a().add(BigDecimal.valueOf(list3.size())));
                        l2 = ch.ionesoft.ilp.book.pe.f.a().w(iLPIssueDef);
                        if (l2 > 0L) {
                            bl3 = true;
                        }
                    }
                    av2.d(av2.b().add(BigDecimal.valueOf(l2)));
                    List<ILPExercise> list4 = ch.ionesoft.ilp.book.pe.f.a().g(iLPIssueDef);
                    int n4 = 0;
                    int n5 = 0;
                    int n6 = 0;
                    if (list4 != null) {
                        q2.b(q2.b().add(BigDecimal.valueOf(list4.size())));
                        for (ILPExercise iLPExercise : list4) {
                            if (iLPExercise.getProcessed() == null || !iLPExercise.getProcessed().booleanValue()) continue;
                            if (iLPExercise.isSupportAutoRating()) {
                                if (iLPExercise.getRating() != null && iLPExercise.getRating().floatValue() >= 1.0f) {
                                    ++n4;
                                } else {
                                    ++n5;
                                }
                            } else {
                                ++n6;
                            }
                            bl3 = true;
                        }
                    }
                    q2.d(q2.c().add(BigDecimal.valueOf(n4)));
                    q2.f(q2.d().add(BigDecimal.valueOf(n5)));
                    q2.h(q2.e().add(BigDecimal.valueOf(n6)));
                    if (!bl3) continue;
                    ++n3;
                }
                j2.b(av2);
                j2.b(q2);
                j2.b(BigDecimal.valueOf(n3));
            }
            catch (Exception exception) {
                logger.d((Object)"", (Throwable)exception);
                bl2 = false;
            }
            k2.b(j2);
            object = bl2 ? b.a.a : b.a.c;
            k2.b(this.createDetailResponse((b.a)((Object)object), null, null));
            n2.a(k2);
        }
        n2.b(this.createGlobalResponse(b.a.a, null, null));
        return this.writeResponse(n2);
    }

    private String handleCountCompletedExerciseRequest() throws ICBRequestHandlingException {
        G g2 = new G();
        f f2 = new f();
        f2.b(1337);
        g2.b(this.createGlobalResponse(b.a.a, null, null));
        g2.b(f2);
        return this.writeResponse(g2);
    }

    private String handleGetAppConfigurationRequest() throws ICBRequestHandlingException {
        v v2 = new v();
        b b2 = new b();
        b2.b(ch.ionesoft.ilp.base.co.f.b().Z());
        b2.b(this.getAppPlatformEnum());
        b2.d(ch.ionesoft.ilp.base.co.g.a().e());
        b2.b(ch.ionesoft.ilp.base.co.g.a().w());
        b2.c(SystemHelper.isVeryFirstInstallation());
        b2.f(ILPBookRegistry.instance().isFreshInstallation());
        b2.b(ILPProfileManager.instance().countExistingProfiles());
        b2.h(true);
        b2.j(true);
        if (SystemHelper.isAndroidSystem()) {
            b2.f(ANDROID_ASSET_BASE_PATH);
        }
        v2.b(this.createGlobalResponse(b.a.a, null, null));
        v2.b(b2);
        return this.writeResponse(v2);
    }

    private String handleGetEbookActionsRequest() throws ICBRequestHandlingException {
        z z2 = new z();
        m m2 = new m();
        ArrayList<ILPEProduct> arrayList = new ArrayList();
        try {
            arrayList = ch.ionesoft.ilp.book.pe.f.a().G();
        }
        catch (Exception exception) {
            logger.d((Object)"Could not fetch eProducts with license.", (Throwable)exception);
        }
        o o2 = new o();
        o2.b(this.countNewEbooksAvailable(arrayList));
        m2.b(o2);
        n n2 = new n();
        n2.b(this.countEbookUpdatesAvailable(arrayList));
        m2.b(n2);
        z2.b(this.createGlobalResponse(b.a.a, null, null));
        z2.b(m2);
        return this.writeResponse(z2);
    }

    private int countEbookUpdatesAvailable(List<ILPEProduct> list) {
        int n2 = 0;
        for (ILPEProduct iLPEProduct : list) {
            try {
                ILPBookHelper.EProductState eProductState = ILPBookHelper.getEProductState(iLPEProduct, false);
                if (iLPEProduct.determineLicense() == null || !eProductState.equals((Object)ILPBookHelper.EProductState.PORTAL_EPRODUCT_STATE_UPDATE_AVAILABLE)) continue;
                ++n2;
            }
            catch (Exception exception) {
                logger.d((Object)("Could not check if update is available for eproduct: " + iLPEProduct), (Throwable)exception);
            }
        }
        return n2;
    }

    private int countNewEbooksAvailable(List<ILPEProduct> list) {
        ArrayList<ILPEProduct> arrayList = new ArrayList<ILPEProduct>();
        for (ILPEProduct list22 : list) {
            try {
                ILPBookHelper.EProductState exception = ILPBookHelper.getEProductState(list22, false);
                if (list22.determineLicense() == null || list22.determineLicense().getLicensePolicyEnum() == ILPLicense.LicensePolicy.LICENSE_POLICY_RESTRICTED || !exception.equals((Object)ILPBookHelper.EProductState.PORTAL_EPRODUCT_STATE_READY_TO_INSTALL) && !exception.equals((Object)ILPBookHelper.EProductState.PORTAL_EPRODUCT_STATE_INSTALL_INCOMPLETE)) continue;
                arrayList.add(list22);
            }
            catch (Exception exception) {
                logger.d((Object)("Could not check if newer edition is available for eproduct: " + list22), (Throwable)exception);
            }
        }
        List<ILPEProduct> list2 = ch.ionesoft.ilp.book.pe.f.a().a((List<ILPEProduct>)arrayList);
        return list2 != null ? list2.size() : 0;
    }

    private String handleGetNewsFeedRequest(String string) throws ICBRequestHandlingException {
        D d2 = ICBDashboardRequestDelegate.getObjectFromJsonPayload(string, D.class);
        boolean bl2 = false;
        boolean bl3 = false;
        if (d2.c() != null) {
            bl2 = d2.c();
        }
        if (d2.d() != null) {
            bl3 = d2.d();
        }
        long l2 = 0L;
        long l3 = 0L;
        if (d2.a() != null) {
            l2 = d2.a().longValue();
        }
        if (d2.b() != null) {
            l3 = d2.b().longValue();
        }
        E e2 = new E();
        aa aa2 = new aa();
        if (this.hasNextNewsPage(l2, l3)) {
            aa2.b((int)(l3 + l2));
        }
        if (l3 - l2 >= 0L) {
            aa2.d((int)(l3 - l2));
        }
        aa2.b(this.getNewsDtos(bl2, bl3, l2, l3));
        e2.b(this.createGlobalResponse(b.a.a, null, null));
        e2.b(aa2);
        return this.writeResponse(e2);
    }

    private boolean hasNextNewsPage(long l2, long l3) {
        long l4 = ch.ionesoft.ilp.book.pe.f.a().au();
        return l3 + l2 < l4;
    }

    private List<ab> getNewsDtos(boolean bl2, boolean bl3, long l2, long l3) {
        List<ILPNews> list = ch.ionesoft.ilp.book.pe.f.a().a(bl2, bl3, l2, l3);
        ArrayList<ab> arrayList = new ArrayList<ab>();
        if (list != null && !list.isEmpty()) {
            for (ILPNews iLPNews : list) {
                try {
                    ab ab2 = new ab();
                    ab2.b(d.b());
                    ab2.d(String.valueOf(iLPNews.getPk()));
                    ab2.b(OffsetDateTime.parse(iLPNews.getCreatedAt().toString()));
                    ab2.f(iLPNews.getPreparedTitle());
                    ab2.h(iLPNews.getPreparedExcerpt());
                    ab2.j(iLPNews.getPreparedDescription());
                    ab2.b(iLPNews.getItemLevel().asICBEnum());
                    ab2.b(iLPNews.getItemContext().asICBEnum());
                    ab2.a(iLPNews.getNewsRead());
                    arrayList.add(ab2);
                }
                catch (Exception exception) {
                    logger.d((Object)("Could not create newsDto from ILPNews item: " + iLPNews), (Throwable)exception);
                }
            }
        }
        return arrayList;
    }

    private void createTestNewsItems() {
        int n2 = 0;
        while (n2 < 100) {
            if (ch.ionesoft.ilp.book.pe.f.a().aH(String.valueOf(n2)) != null) {
                return;
            }
            ILPNews iLPNews = new ILPNews();
            iLPNews.setKey(String.valueOf(n2));
            iLPNews.setCreatedAt(DateTime.now());
            iLPNews.setTitle("TestNews " + n2);
            iLPNews.setExcerpt("Das ist eine TestNews");
            iLPNews.setDescription("Das ist die Beschreibung der TestNews");
            iLPNews.setItemContext(ILPNews.ItemContext.ITEM_CONTEXT_GENERAL);
            iLPNews.setItemLevel(ILPNews.ItemLevel.ITEM_LEVEL_INFO);
            iLPNews.setNewsRead(false);
            try {
                g.a().aT().createOrUpdate((Object)iLPNews);
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
            }
            ++n2;
        }
    }

    private String handleUpdateNewsItems(String string) throws ICBRequestHandlingException {
        aw aw2 = ICBDashboardRequestDelegate.getObjectFromJsonPayload(string, aw.class);
        List<ac> list = aw2.a();
        ArrayList<ad> arrayList = new ArrayList<ad>();
        int n2 = 0;
        for (ac object2 : list) {
            try {
                String exception = object2.a();
                boolean bl2 = object2.b();
                ILPNews iLPNews = ch.ionesoft.ilp.book.pe.f.a().v(Integer.valueOf(exception));
                iLPNews.setNewsRead(bl2);
                g.a().aT().update((Object)iLPNews);
                arrayList.add(this.buildNewsItemUpdateDetail(this.createDetailResponse(b.a.a, null, null), object2));
                ++n2;
            }
            catch (Exception exception) {
                logger.d((Object)("Could not proccess ICBNewItemUpdateDto: " + object2), (Throwable)exception);
                arrayList.add(this.buildNewsItemUpdateDetail(this.createDetailResponse(b.a.c, null, null), object2));
            }
        }
        ax ax2 = new ax();
        ax2.b(arrayList);
        if (n2 == list.size()) {
            ax2.b(this.createGlobalResponse(b.a.a, "All DTOs successfully handled", null));
        } else if (n2 > 0) {
            ax2.b(this.createGlobalResponse(b.a.b, "Some DTOs could not be handled", null));
        } else {
            ax2.b(this.createGlobalResponse(b.a.c, "DTOs could not be handled", null));
        }
        return this.writeResponse(ax2);
    }

    private ad buildNewsItemUpdateDetail(l l2, ac ac2) {
        ad ad2 = new ad();
        ad2.b(l2);
        ad2.b(ac2);
        return ad2;
    }

    private String handleLastVisitedModelsRequest() throws ICBRequestHandlingException {
        List<Object> list = new ArrayList();
        try {
            list = ch.ionesoft.ilp.book.pe.f.a().l();
        }
        catch (ch.ionesoft.ilp.book.pe.j j2) {
            throw new ICBRequestHandlingException("Could not fetch installed courses", ICBRequestHandlingException.ICBRequestHandlingExceptionType.EXCEPTION_TYPE_EXECUTION);
        }
        C c2 = new C();
        TreeMap treeMap = new TreeMap(Collections.reverseOrder());
        for (ILPCourseDef object : list) {
            try {
                Object object2;
                Object object3;
                h h2 = new h();
                h2.b(object.getCourseId());
                h2.d(object.getReference());
                h2.f(object.getMandantId());
                h2.h(object.getProductReference());
                Z z2 = new Z();
                Y y2 = new Y();
                ILPIssueDef iLPIssueDef = ILPProfileManager.instance().getCurrentProfile().currentIssueForCourseId_courseReference(object.getCourseId(), object.getReference(), false);
                ILPTopic iLPTopic = ch.ionesoft.ilp.book.pe.f.a().p(iLPIssueDef);
                ILPExercise iLPExercise = ch.ionesoft.ilp.book.pe.f.a().b(iLPIssueDef, (ILPExercise.ExerciseGroup)null);
                DateTime dateTime = null;
                DateTime dateTime2 = null;
                if (iLPTopic != null) {
                    dateTime = iLPTopic.getLastAccess();
                }
                if (iLPExercise != null) {
                    dateTime2 = iLPExercise.getLastAccess();
                }
                Boolean bl2 = null;
                if (dateTime == null && dateTime2 == null) {
                    logger.b((Object)"no topic nor exercise last access info");
                    continue;
                }
                bl2 = dateTime != null && dateTime2 != null ? Boolean.valueOf(dateTime.isAfter((ReadableInstant)dateTime2)) : (dateTime != null ? Boolean.valueOf(true) : Boolean.valueOf(false));
                if (bl2.booleanValue()) {
                    object3 = new V();
                    ((V)object3).b(iLPTopic.getIssue().getIssueId());
                    ((V)object3).d(iLPTopic.getIssue().getReference());
                    ((V)object3).f(iLPTopic.getIssue().getProductReference());
                    object2 = new au();
                    ((au)object2).b(au.a.a(iLPTopic.getTopicType().name()));
                    ((au)object2).b(iLPTopic.getTitle());
                    ((au)object2).d(iLPTopic.getReference());
                    ((au)object2).b(iLPTopic.getOrder());
                    ((au)object2).d(iLPTopic.getSubOrder());
                    ((au)object2).f(iLPTopic.getAccessPath());
                    ((au)object2).b(iLPTopic.getUserTopic());
                    ((au)object2).f(iLPTopic.getLevel());
                    z2.b((V)object3);
                    z2.b((au)object2);
                } else {
                    object3 = new V();
                    ((V)object3).b(iLPExercise.getIssue().getIssueId());
                    ((V)object3).d(iLPExercise.getIssue().getReference());
                    ((V)object3).f(iLPExercise.getIssue().getProductReference());
                    object2 = new p();
                    ((p)object2).d(iLPExercise.getExerciseId());
                    ((p)object2).f(iLPExercise.getReference());
                    ((p)object2).h(iLPExercise.getNodeId());
                    ((p)object2).b(iLPExercise.getGroup());
                    try {
                        ((p)object2).b(p.a.a(iLPExercise.getExerciseType().name()));
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        ((p)object2).b(p.a.a);
                    }
                    y2.b((V)object3);
                    y2.a((p)object2);
                }
                object3 = new X();
                ((X)object3).b(h2);
                ((X)object3).b(z2);
                ((X)object3).b(y2);
                treeMap.put(bl2 != false ? dateTime.getMillis() : dateTime2.getMillis(), object3);
            }
            catch (Exception exception) {
                logger.d((Object)("Could not prepare ILPCourseDef: " + object + " for lastVisitedModels request"), (Throwable)exception);
            }
        }
        for (Map.Entry entry : treeMap.entrySet()) {
            c2.a((X)entry.getValue());
        }
        c2.b(this.createGlobalResponse(b.a.a, null, null));
        return this.writeResponse(c2);
    }
}

