/*
 * Decompiled with CFR 0.152.
 */
package ch.ionesoft.ilp.book.co;

import ch.ionesoft.ilp.base.co.ILPLogManager;
import ch.ionesoft.ilp.base.co.ILogger;
import ch.ionesoft.ilp.base.co.b;
import ch.ionesoft.ilp.base.fo.z;
import ch.ionesoft.ilp.base.he.StringHelper;
import ch.ionesoft.ilp.book.he.c;
import ch.ionesoft.ilp.book.mo.ILPAnswer;
import ch.ionesoft.ilp.book.mo.ILPCourseDef;
import ch.ionesoft.ilp.book.mo.ILPExercise;
import ch.ionesoft.ilp.book.mo.ILPIssueDef;
import ch.ionesoft.ilp.book.mo.ILPQuestion;
import ch.ionesoft.ilp.book.mo.ILPResource;
import ch.ionesoft.ilp.book.mo.ILPTopic;
import ch.ionesoft.ilp.book.pe.f;
import ch.ionesoft.ilp.book.pe.g;
import ch.ionesoft.ilp.book.pe.j;
import ch.ionesoft.ilp.book.rm.a;
import com.j256.ormlite.misc.TransactionManager;
import com.j256.ormlite.support.ConnectionSource;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class ILPResourceReferenceLinker {
    private static final ILogger logger = ILPLogManager.getLogger(ILPResourceReferenceLinker.class);
    private static final String REFERENCE_REGEX = "<(iframe|image|img|source|a)[^>]*?(xlink:href|href|src)=['\"]([^>]*?)['\"].*?>";
    private static final String REFERENCE_DATA_TITLE_REGEX = "data-title=['\"]([^>]*?)['\"]";
    private static final int DEFAULT_THRESHOLD_IMAGE_SIZE_BYTES = 200;
    private static final int DEFAULT_MIN_IMAGE_WIDTH = 30;
    private static final int DEFAULT_MIN_IMAGE_HEIGHT = 30;
    private int thresholdImageSizeBytes;
    private float minImageHeight;
    private float minImageWidth;
    private long order;
    private String[] excludeFilenameList = new String[0];

    public void linkResourcesOfCourse(ILPCourseDef iLPCourseDef, c c2, ILPResource.ResourceGroup[] resourceGroupArray) {
        if (iLPCourseDef == null) {
            return;
        }
        logger.b((Object)("Starting to link referenced resources of course: " + iLPCourseDef.getCourseId()));
        float f2 = iLPCourseDef.getIssues().size();
        int n2 = 1;
        this.order = 0L;
        try {
            for (ILPIssueDef iLPIssueDef : iLPCourseDef.getIssues()) {
                if (c2 != null) {
                    c2.a((float)n2++ / f2);
                }
                this.linkResourcesOfIssue(iLPIssueDef, resourceGroupArray);
            }
            logger.b((Object)("Finished linking referenced resources of course: " + iLPCourseDef.getCourseId()));
        }
        catch (Exception exception) {
            logger.d((Object)("Could not link referenced resources of course: " + iLPCourseDef), (Throwable)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void linkResourcesOfIssue(final ILPIssueDef iLPIssueDef, final ILPResource.ResourceGroup[] resourceGroupArray) {
        ConnectionSource connectionSource;
        g.a().b(iLPIssueDef);
        this.thresholdImageSizeBytes = iLPIssueDef.propertyIntWithName_defaultValue("resourceLinkerThresholdSizeBytes", 200);
        this.minImageWidth = iLPIssueDef.propertyIntWithName_defaultValue("resourceLinkerMinImageWidth", 30);
        this.minImageHeight = iLPIssueDef.propertyIntWithName_defaultValue("resourceLinkerMinImageHeight", 30);
        this.excludeFilenameList = StringUtils.split((String)iLPIssueDef.propertyStringWithName_defaultValue("resourceLinkerExcludeFilenames", ""), (String)",");
        try {
            connectionSource = g.a().I();
            synchronized (connectionSource) {
                TransactionManager.callInTransaction((ConnectionSource)g.a().I(), (Callable)new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        for (ILPTopic iLPTopic : iLPIssueDef.getTopics()) {
                            try {
                                if (iLPTopic.isAliasTopic()) continue;
                                ILPResourceReferenceLinker.this.linkTopic_regex_issue_resourceGroups(iLPTopic, ILPResourceReferenceLinker.REFERENCE_REGEX, iLPIssueDef, resourceGroupArray);
                            }
                            catch (Throwable throwable) {
                                logger.c((Object)("Could not link referenced resources of topic: " + iLPTopic), throwable);
                            }
                        }
                        return null;
                    }
                });
            }
        }
        catch (SQLException sQLException) {
            logger.d((Object)("Error linking referenced resources of topics in issue: " + iLPIssueDef), (Throwable)sQLException);
        }
        try {
            connectionSource = g.a().I();
            synchronized (connectionSource) {
                TransactionManager.callInTransaction((ConnectionSource)g.a().I(), (Callable)new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        for (ILPExercise iLPExercise : iLPIssueDef.getExercises()) {
                            try {
                                ILPResourceReferenceLinker.this.linkExercise_regex_issue_resourceGroups(iLPExercise, ILPResourceReferenceLinker.REFERENCE_REGEX, iLPIssueDef, resourceGroupArray);
                            }
                            catch (Throwable throwable) {
                                logger.c((Object)("Could not link referenced resources of exercise: " + iLPExercise), throwable);
                            }
                            for (ILPQuestion iLPQuestion : iLPExercise.getQuestions()) {
                                try {
                                    ILPResourceReferenceLinker.this.linkQuestion_regex_issue_resourceGroups(iLPQuestion, ILPResourceReferenceLinker.REFERENCE_REGEX, iLPIssueDef, resourceGroupArray);
                                }
                                catch (Throwable throwable) {
                                    logger.c((Object)("Could not link referenced resources of question: " + iLPQuestion), throwable);
                                }
                                for (ILPAnswer iLPAnswer : iLPQuestion.getAnswers()) {
                                    try {
                                        ILPResourceReferenceLinker.this.linkAnswer_regex_issue_resourceGroups(iLPAnswer, ILPResourceReferenceLinker.REFERENCE_REGEX, iLPIssueDef, resourceGroupArray);
                                    }
                                    catch (Throwable throwable) {
                                        logger.c((Object)("Could not link referenced resources of answer: " + iLPAnswer), throwable);
                                    }
                                }
                            }
                        }
                        return null;
                    }
                });
            }
        }
        catch (SQLException sQLException) {
            logger.d((Object)("Error linking referenced resources of exercises in issue: " + iLPIssueDef), (Throwable)sQLException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void linkResourcesOfTopics(final List<ILPTopic> list, final ILPResource.ResourceGroup[] resourceGroupArray) {
        if (list == null || list.isEmpty()) {
            return;
        }
        final ILPIssueDef iLPIssueDef = list.get(0).getIssue();
        g.a().b(iLPIssueDef);
        this.thresholdImageSizeBytes = iLPIssueDef.propertyIntWithName_defaultValue("resourceLinkerThresholdSizeBytes", 200);
        this.minImageWidth = iLPIssueDef.propertyIntWithName_defaultValue("resourceLinkerMinImageWidth", 30);
        this.minImageHeight = iLPIssueDef.propertyIntWithName_defaultValue("resourceLinkerMinImageHeight", 30);
        this.excludeFilenameList = StringUtils.split((String)iLPIssueDef.propertyStringWithName_defaultValue("resourceLinkerExcludeFilenames", ""), (String)",");
        try {
            ConnectionSource connectionSource = g.a().I();
            synchronized (connectionSource) {
                TransactionManager.callInTransaction((ConnectionSource)g.a().I(), (Callable)new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        for (ILPTopic iLPTopic : list) {
                            try {
                                if (iLPTopic.isAliasTopic()) continue;
                                ILPResourceReferenceLinker.this.linkTopic_regex_issue_resourceGroups(iLPTopic, ILPResourceReferenceLinker.REFERENCE_REGEX, iLPIssueDef, resourceGroupArray);
                            }
                            catch (Throwable throwable) {
                                logger.c((Object)("Could not link referenced resources of topic: " + iLPTopic), throwable);
                            }
                        }
                        return null;
                    }
                });
            }
        }
        catch (SQLException sQLException) {
            logger.d((Object)("Error linking referenced resources of topics in issue: " + iLPIssueDef), (Throwable)sQLException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void linkResourcesOfExercises(final List<ILPExercise> list, final ILPResource.ResourceGroup[] resourceGroupArray) {
        if (list == null || list.isEmpty()) {
            return;
        }
        final ILPIssueDef iLPIssueDef = list.get(0).getIssue();
        g.a().b(iLPIssueDef);
        this.thresholdImageSizeBytes = iLPIssueDef.propertyIntWithName_defaultValue("resourceLinkerThresholdSizeBytes", 200);
        this.minImageWidth = iLPIssueDef.propertyIntWithName_defaultValue("resourceLinkerMinImageWidth", 30);
        this.minImageHeight = iLPIssueDef.propertyIntWithName_defaultValue("resourceLinkerMinImageHeight", 30);
        this.excludeFilenameList = StringUtils.split((String)iLPIssueDef.propertyStringWithName_defaultValue("resourceLinkerExcludeFilenames", ""), (String)",");
        try {
            ConnectionSource connectionSource = g.a().I();
            synchronized (connectionSource) {
                TransactionManager.callInTransaction((ConnectionSource)g.a().I(), (Callable)new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        for (ILPExercise iLPExercise : list) {
                            try {
                                ILPResourceReferenceLinker.this.linkExercise_regex_issue_resourceGroups(iLPExercise, ILPResourceReferenceLinker.REFERENCE_REGEX, iLPIssueDef, resourceGroupArray);
                            }
                            catch (Throwable throwable) {
                                logger.c((Object)("Could not link referenced resources of exercise: " + iLPExercise), throwable);
                            }
                            for (ILPQuestion iLPQuestion : iLPExercise.getQuestions()) {
                                try {
                                    ILPResourceReferenceLinker.this.linkQuestion_regex_issue_resourceGroups(iLPQuestion, ILPResourceReferenceLinker.REFERENCE_REGEX, iLPIssueDef, resourceGroupArray);
                                }
                                catch (Throwable throwable) {
                                    logger.c((Object)("Could not link referenced resources of question: " + iLPQuestion), throwable);
                                }
                                for (ILPAnswer iLPAnswer : iLPQuestion.getAnswers()) {
                                    try {
                                        ILPResourceReferenceLinker.this.linkAnswer_regex_issue_resourceGroups(iLPAnswer, ILPResourceReferenceLinker.REFERENCE_REGEX, iLPIssueDef, resourceGroupArray);
                                    }
                                    catch (Throwable throwable) {
                                        logger.c((Object)("Could not link referenced resources of answer: " + iLPAnswer), throwable);
                                    }
                                }
                            }
                        }
                        return null;
                    }
                });
            }
        }
        catch (SQLException sQLException) {
            logger.d((Object)("Error linking referenced resources of exercises in issue: " + iLPIssueDef), (Throwable)sQLException);
        }
    }

    protected void linkTopic_regex_issue_resourceGroups(ILPTopic iLPTopic, String string, ILPIssueDef iLPIssueDef, ILPResource.ResourceGroup[] resourceGroupArray) throws SQLException, j {
        if (iLPTopic.getResource() == null) {
            logger.c((Object)("Could not link topic without having a resource: " + iLPTopic));
            return;
        }
        String string2 = iLPTopic.getResource().getDataString();
        List<ILPResource> list = this.findReferencingResourcesInHtml_regex_issue_resourceGroups(string2, string, iLPIssueDef, resourceGroupArray);
        for (ILPResource iLPResource : list) {
            ILPResource.ResourceReference resourceReference = iLPTopic.isUserTopic() != false ? ILPResource.ResourceReference.RESOURCE_REFERENCE_USER_TOPIC : ILPResource.ResourceReference.RESOURCE_REFERENCE_TOPIC;
            iLPResource.setResourceReference(resourceReference);
            if (!iLPTopic.hasReferencedResource(iLPResource)) {
                iLPTopic.addReferencedResourceObject(iLPResource);
                iLPResource.setOrder(this.order++);
            }
            g.a().H().update((Object)iLPResource);
            logger.a((Object)("Linked resource " + iLPResource.getHref() + " to topic " + iLPTopic));
        }
    }

    protected void linkExercise_regex_issue_resourceGroups(ILPExercise iLPExercise, String string, ILPIssueDef iLPIssueDef, ILPResource.ResourceGroup[] resourceGroupArray) throws SQLException, j {
        ILPResource.ResourceReference resourceReference = ILPResource.ResourceReference.RESOURCE_REFERENCE_EXERCISE_TEXT;
        String string2 = iLPExercise.getText();
        if (StringUtils.isEmpty((CharSequence)string2)) {
            return;
        }
        List<ILPResource> list = this.findReferencingResourcesInHtml_regex_issue_resourceGroups(string2, string, iLPIssueDef, resourceGroupArray);
        for (ILPResource iLPResource : list) {
            iLPResource.setResourceReference(resourceReference);
            if (!iLPExercise.hasReferencedResource(iLPResource, new ILPResource.ResourceReference[]{resourceReference})) {
                iLPExercise.addReferencedResourceObject(iLPResource);
                iLPResource.setOrder(this.order++);
            }
            g.a().H().update((Object)iLPResource);
            logger.a((Object)("Linked resource " + iLPResource.getHref() + " to exercise " + (iLPExercise.getTitle() != null ? iLPExercise.getTitle() : iLPExercise.getExerciseId())));
        }
    }

    protected void linkQuestion_regex_issue_resourceGroups(ILPQuestion iLPQuestion, String string, ILPIssueDef iLPIssueDef, ILPResource.ResourceGroup[] resourceGroupArray) throws SQLException, j {
        ILPExercise iLPExercise = iLPQuestion.getExercise();
        ILPResource.ResourceReference resourceReference = ILPResource.ResourceReference.RESOURCE_REFERENCE_QUESTION_TEXT;
        String string2 = iLPQuestion.getText();
        if (StringUtils.isEmpty((CharSequence)string2)) {
            return;
        }
        List<ILPResource> list = this.findReferencingResourcesInHtml_regex_issue_resourceGroups(string2, string, iLPIssueDef, resourceGroupArray);
        for (ILPResource iLPResource : list) {
            iLPResource.setResourceReference(resourceReference);
            if (!iLPExercise.hasReferencedResource(iLPResource, new ILPResource.ResourceReference[]{resourceReference})) {
                iLPExercise.addReferencedResourceObject(iLPResource);
                iLPResource.setOrder(this.order++);
            }
            g.a().H().update((Object)iLPResource);
            logger.a((Object)("Linked resource " + iLPResource.getHref() + " to question of exercise " + (iLPExercise.getTitle() != null ? iLPExercise.getTitle() : iLPExercise.getExerciseId())));
        }
    }

    protected void linkAnswer_regex_issue_resourceGroups(ILPAnswer iLPAnswer, String string, ILPIssueDef iLPIssueDef, ILPResource.ResourceGroup[] resourceGroupArray) throws SQLException, j {
        ILPResource.ResourceReference resourceReference;
        ILPExercise iLPExercise = iLPAnswer.getQuestion().getExercise();
        if (ILPAnswer.AnswerType.ANSWER_TYPE_TEMPLATE.equals((Object)iLPAnswer.getAnswerType())) {
            resourceReference = ILPResource.ResourceReference.RESOURCE_REFERENCE_ANSWER_TEMPLATE;
        } else if (ILPAnswer.AnswerType.ANSWER_TYPE_CORRECT.equals((Object)iLPAnswer.getAnswerType())) {
            resourceReference = ILPResource.ResourceReference.RESOURCE_REFERENCE_ANSWER_CORRECT;
        } else if (ILPAnswer.AnswerType.ANSWER_TYPE_USER.equals((Object)iLPAnswer.getAnswerType())) {
            resourceReference = ILPResource.ResourceReference.RESOURCE_REFERENCE_ANSWER_USER;
        } else {
            logger.d((Object)"Answer has no answer type");
            resourceReference = ILPResource.ResourceReference.RESOURCE_REFERENCE_UNDEFINED;
        }
        String string2 = iLPAnswer.getText();
        if (StringUtils.isEmpty((CharSequence)string2)) {
            return;
        }
        List<ILPResource> list = this.findReferencingResourcesInHtml_regex_issue_resourceGroups(string2, string, iLPIssueDef, resourceGroupArray);
        for (ILPResource iLPResource : list) {
            iLPResource.setResourceReference(resourceReference);
            if (!iLPExercise.hasReferencedResource(iLPResource, new ILPResource.ResourceReference[]{resourceReference})) {
                iLPExercise.addReferencedResourceObject(iLPResource);
                iLPResource.setOrder(this.order++);
            }
            g.a().H().update((Object)iLPResource);
            logger.a((Object)("Linked resource " + iLPResource.getHref() + " to answer of exercise " + (iLPExercise.getTitle() != null ? iLPExercise.getTitle() : iLPExercise.getExerciseId())));
        }
    }

    protected List<ILPResource> findReferencingResourcesInHtml_regex_issue_resourceGroups(String string, String string2, ILPIssueDef iLPIssueDef, ILPResource.ResourceGroup[] resourceGroupArray) throws SQLException, j {
        ArrayList<ILPResource> arrayList = new ArrayList<ILPResource>();
        Pattern pattern = Pattern.compile(string2);
        Matcher matcher = pattern.matcher(string);
        List<ILPResource.ResourceGroup> list = Arrays.asList(resourceGroupArray);
        ArrayList<String> arrayList2 = new ArrayList<String>();
        while (matcher.find()) {
            List<ILPResource> list2;
            String string3 = StringHelper.substringWithRange((String)string, (int)matcher.start(0), (int)matcher.end(0));
            String string4 = StringHelper.substringWithRange((String)string, (int)matcher.start(1), (int)matcher.end(1));
            String string5 = StringHelper.substringWithRange((String)string, (int)matcher.start(2), (int)matcher.end(2));
            String string6 = StringHelper.substringWithRange((String)string, (int)matcher.start(3), (int)matcher.end(3));
            string6 = StringHelper.decodeFromPercentEscapeString((String)string6);
            if (StringUtils.isEmpty((CharSequence)(string6 = string6.trim())) || string6.startsWith("data:image/png")) continue;
            boolean bl2 = false;
            boolean bl3 = false;
            String string7 = null;
            ILPResource.ResourceGroup[] resourceGroupArray2 = null;
            if ("img".equals(string4) && "src".equals(string5) && list.contains((Object)ILPResource.ResourceGroup.RESOURCE_GROUP_IMAGE)) {
                if (string6.startsWith("http://localhost/")) {
                    string6 = StringHelper.extractString_after((String)string6, (String)"http://localhost/");
                }
                resourceGroupArray2 = new ILPResource.ResourceGroup[]{ILPResource.ResourceGroup.RESOURCE_GROUP_IMAGE};
            } else if ("source".equals(string4) && "src".equals(string5) && (list.contains((Object)ILPResource.ResourceGroup.RESOURCE_GROUP_VIDEO) || list.contains((Object)ILPResource.ResourceGroup.RESOURCE_GROUP_AUDIO))) {
                resourceGroupArray2 = new ILPResource.ResourceGroup[]{ILPResource.ResourceGroup.RESOURCE_GROUP_AUDIO, ILPResource.ResourceGroup.RESOURCE_GROUP_VIDEO};
                if (string6.startsWith("http://localhost/asset")) {
                    bl3 = true;
                    string7 = StringHelper.extractString_after((String)string6, (String)"http://localhost/asset/");
                }
            } else if ("a".equals(string4) && "href".equals(string5) || "iframe".equals(string4) && "src".equals(string5)) {
                if (string6.startsWith("http://localhost/asset")) {
                    bl3 = true;
                    string7 = StringHelper.extractString_after((String)string6, (String)"http://localhost/asset/");
                    resourceGroupArray2 = new ILPResource.ResourceGroup[]{ILPResource.ResourceGroup.RESOURCE_GROUP_AUDIO, ILPResource.ResourceGroup.RESOURCE_GROUP_VIDEO, ILPResource.ResourceGroup.RESOURCE_GROUP_DOCUMENT};
                }
                if (string6.startsWith("http") && !string6.startsWith("http://localhost")) {
                    bl2 = true;
                    resourceGroupArray2 = new ILPResource.ResourceGroup[]{ILPResource.ResourceGroup.RESOURCE_GROUP_AUDIO, ILPResource.ResourceGroup.RESOURCE_GROUP_VIDEO, ILPResource.ResourceGroup.RESOURCE_GROUP_DOCUMENT, ILPResource.ResourceGroup.RESOURCE_GROUP_HTML, ILPResource.ResourceGroup.RESOURCE_GROUP_IMAGE};
                }
            }
            string6 = string6.replace("\\", "/");
            if (string7 != null) {
                string7 = string7.replace("\\", "/");
            }
            if (!bl2) {
                list2 = null;
                if (bl3) {
                    list2 = f.a().b(string7, iLPIssueDef, resourceGroupArray2);
                } else {
                    list2 = f.a().a(string6, iLPIssueDef, resourceGroupArray2);
                    if (list2 == null || list2.isEmpty()) {
                        list2 = f.a().a(StringHelper.pruneRelativePath((String)string6), iLPIssueDef, resourceGroupArray2);
                    }
                }
                if (list2 == null || list2.size() == 0) {
                    ILPIssueDef iLPIssueDef2 = iLPIssueDef.getCourse().firstIssue();
                    if (!iLPIssueDef.getCourse().isIssueBased() && !iLPIssueDef2.equals(iLPIssueDef)) {
                        if (bl3) {
                            list2 = f.a().b(string7, iLPIssueDef2, resourceGroupArray2);
                        } else {
                            list2 = f.a().a(string6, iLPIssueDef2, resourceGroupArray2);
                            if (list2 == null || list2.isEmpty()) {
                                list2 = f.a().a(StringHelper.pruneRelativePath((String)string6), iLPIssueDef2, resourceGroupArray2);
                            }
                        }
                    }
                }
                if (list2 != null && list2.size() > 0) {
                    for (ILPResource iLPResource : list2) {
                        if (!list.contains((Object)iLPResource.getResourceGroup()) || this.isArtefactResource(iLPResource)) continue;
                        arrayList.add(iLPResource);
                    }
                    continue;
                }
                String string8 = b.b().t("ILPBase.application.url.scheme");
                if (string6.contains(".html") || string6.contains(".xhtml") || string6.startsWith("http://localhost") || string6.startsWith("data:image/") || string6.startsWith("#") || string6.startsWith("\u201c") || string6.startsWith("mailto:") || string6.startsWith("database/resource/pk") || string6.startsWith(String.valueOf(string8) + "://")) continue;
                logger.c((Object)("No resource found for link: " + string6 + " in issue: " + iLPIssueDef));
                continue;
            }
            if (arrayList2.contains(string6)) continue;
            list2 = new ILPResource(ILPResource.ResourceLocation.RESOURCE_LOCATION_WEB);
            ((ILPResource)((Object)list2)).setHref(string6);
            a.a().k((ILPResource)((Object)list2));
            if (!StringUtils.isEmpty((CharSequence)((ILPResource)((Object)list2)).getMediaType())) {
                Pattern pattern2 = Pattern.compile(REFERENCE_DATA_TITLE_REGEX);
                Matcher matcher2 = pattern2.matcher(string3);
                String string9 = null;
                while (matcher2.find()) {
                    string9 = StringHelper.substringWithRange((String)string3, (int)matcher2.start(1), (int)matcher2.end(1));
                }
                if (StringHelper.isBlank(string9)) {
                    string9 = StringHelper.lastPathComponent((String)string6);
                }
                if (StringUtils.isNotBlank(string9)) {
                    ((ILPResource)((Object)list2)).setTitle(string9);
                }
                ((ILPResource)((Object)list2)).setIdentifier(string6);
                ((ILPResource)((Object)list2)).setIssue(iLPIssueDef);
                g.a().H().create(list2);
                arrayList.add((ILPResource)((Object)list2));
                arrayList2.add(string6);
                continue;
            }
            if (string6.contains("?external=") || !StringHelper.extractString_after_ifNotFound((String)string6, (String)"://", (String)"").contains("/") || string6.startsWith("#") || string6.startsWith("http://") || string6.startsWith("https://")) continue;
            logger.c((Object)("Could not detect mediaType from link: " + string6 + ". Add known patterns to ILPResourceTopicLinker.detectUrlMimetype"));
        }
        return arrayList;
    }

    private boolean isArtefactResource(ILPResource iLPResource) {
        block14: {
            if (ILPResource.ResourceGroup.RESOURCE_GROUP_IMAGE.equals((Object)iLPResource.getResourceGroup())) {
                if (ArrayUtils.contains((Object[])this.excludeFilenameList, (Object)iLPResource.getHref()) || ArrayUtils.contains((Object[])this.excludeFilenameList, (Object)StringHelper.lastPathComponent((String)iLPResource.getHref()))) {
                    return true;
                }
                if (iLPResource.getData() != null && (iLPResource.getSizeBytes() == null || iLPResource.getSizeBytes() < (long)this.thresholdImageSizeBytes)) {
                    z z2 = null;
                    try {
                        z2 = z.a((byte[])iLPResource.getData());
                        if (z2 == null) {
                            logger.c((Object)("Could not detect size on: " + iLPResource.getHref() + ", " + " in: " + iLPResource.getIssue()));
                            return false;
                        }
                        ch.ionesoft.ilp.base.fo.b b2 = z2.k();
                        if (b2 != null && b2.b > 0.0f && b2.a > 0.0f) {
                            if (b2.b < this.minImageHeight || b2.a < this.minImageWidth) {
                                logger.a((Object)("Ignoring resource " + iLPResource.getHref() + " with size: " + b2));
                                return true;
                            }
                            break block14;
                        }
                        logger.c((Object)("Could not detect size on: " + iLPResource.getHref() + ", " + " in: " + iLPResource.getIssue() + " for determining artefact"));
                        return false;
                    }
                    catch (Throwable throwable) {
                        logger.d((Object)("Could not detect size on: " + iLPResource.getHref() + ", " + " in: " + iLPResource.getIssue() + " for determining artefact, reason: " + throwable), throwable);
                    }
                    finally {
                        if (z2 != null) {
                            z2.i();
                        }
                    }
                }
            }
        }
        return false;
    }
}

