/*
 * Decompiled with CFR 0.152.
 */
package ch.ionesoft.ilp.book.co;

import ch.ionesoft.ilp.base.co.ILPLogManager;
import ch.ionesoft.ilp.base.co.ILogger;
import ch.ionesoft.ilp.base.co.h;
import ch.ionesoft.ilp.base.co.p;
import ch.ionesoft.ilp.base.he.ConverterUtil;
import ch.ionesoft.ilp.base.he.FileHelper;
import ch.ionesoft.ilp.base.he.StringHelper;
import ch.ionesoft.ilp.book.analytics.a;
import ch.ionesoft.ilp.book.au.b;
import ch.ionesoft.ilp.book.au.c;
import ch.ionesoft.ilp.book.cl.f;
import ch.ionesoft.ilp.book.cl.g;
import ch.ionesoft.ilp.book.cl.j;
import ch.ionesoft.ilp.book.co.ClientInformation;
import ch.ionesoft.ilp.book.co.IAUserManager;
import ch.ionesoft.ilp.book.co.ILPAdvertisementController;
import ch.ionesoft.ilp.book.co.ILPBookRegistry;
import ch.ionesoft.ilp.book.co.ILPBookSettingsHelper;
import ch.ionesoft.ilp.book.co.ILPConfigurationManager;
import ch.ionesoft.ilp.book.co.ILPInitializer;
import ch.ionesoft.ilp.book.co.ILPLessonsManager;
import ch.ionesoft.ilp.book.co.ILPProfile;
import ch.ionesoft.ilp.book.co.ILPWorkspace;
import ch.ionesoft.ilp.book.mo.ILPAccount;
import ch.ionesoft.ilp.book.mo.ILPUser;
import ch.ionesoft.ilp.book.msg.q;
import ch.ionesoft.ilp.book.pe.g;
import ch.ionesoft.ilp.book.scenario.ILPScenarioManager;
import ch.ionesoft.ilp.book.syn.d;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;

public class ILPProfileManager {
    private static ILogger logger = ILPLogManager.getLogger(ILPProfileManager.class);
    private static ILPProfileManager profileManager;
    private ILPProfile currentProfile;
    private ILPWorkspace workspace;
    private ClientInformation clientInformation = null;

    public static synchronized ILPProfileManager instance() {
        if (profileManager == null) {
            profileManager = new ILPProfileManager();
            return profileManager;
        }
        return profileManager;
    }

    public void init() {
        if (!FileHelper.fileExistsAtPath((String)h.e().getAbsolutePath())) {
            this.setWorkspace(new ILPWorkspace());
        } else {
            this.setWorkspace(this.loadWorkspaceFromJson());
        }
        ILPProfile iLPProfile = this.detectCurrentProfile();
        this.setCurrentProfile(iLPProfile);
        this.initializeCurrentProfile();
        logger.b((Object)String.format(Locale.ENGLISH, "Current Profile has AssetStage: %s", ch.ionesoft.ilp.base.co.g.a().Q()));
    }

    private ILPProfile detectCurrentProfile() {
        ILPProfile iLPProfile;
        if (this.countExistingProfiles() == 0 || this.getWorkspace().getCurrentProfileId().equals("0")) {
            iLPProfile = this.getInitialProfile();
        } else {
            iLPProfile = this.loadProfileFromJson(this.getWorkspace().getCurrentProfileId());
            if (iLPProfile != null) {
                iLPProfile.setProfileState(ProfileState.PROFILE_STATE_RUNNING);
            }
        }
        if (iLPProfile == null || !iLPProfile.isStayLoggedIn()) {
            logger.c((Object)"Current profile did not allow to stay logged in, resetting to initial profile");
            iLPProfile = this.getInitialProfile();
        }
        return iLPProfile;
    }

    private void initializeCurrentProfile() {
        logger.b((Object)("Initializing profile: " + this.currentProfile.getId() + " with subject: " + this.currentProfile.getSubject() + ", contact email: " + StringHelper.maskEmail((String)this.currentProfile.getContactEmail())));
        this.initializeAuthorizationManager();
        this.reconnectDatabase();
        this.currentProfile.migrateKeychainToSecureStore();
        this.initializeAuthenticationService();
        this.initializeProperties();
        this.resetKeystore();
        ILPBookRegistry.instance().authorizationManager().d();
        FileHelper.assureDirectoryExistsForPath((File)h.q());
        FileHelper.assureDirectoryExistsForPath((File)h.s());
    }

    public void initializeCloudAndSharingService() {
        this.initializeCloud(this.currentProfile.isUseCloud());
        ILPInitializer.instance().initializeSharingAndSynchronizeGroups();
    }

    public void initializeCloud(boolean bl2) {
        ILPBookRegistry.instance().getCloudService().d();
        this.currentProfile.setUseCloud(bl2);
        this.writeProfileToJson(this.currentProfile);
        if (!this.currentProfile.isInitialProfile() && bl2) {
            ILPBookSettingsHelper.instance().setCloudServiceType(g.a.c);
        } else {
            ILPBookSettingsHelper.instance().setCloudServiceType(g.a.a);
        }
        logger.b((Object)("Initializing cloud to: " + (Object)((Object)ILPBookSettingsHelper.instance().getCloudServiceType())));
        ILPInitializer.instance().initializeCloudServices();
        if (ILPBookRegistry.instance().getCloudService().e()) {
            try {
                ILPBookRegistry.instance().getCloudService().p();
            }
            catch (Exception exception) {
                logger.d((Object)"Could not updateCoursesProductsWithCloudData", (Throwable)exception);
            }
            IAUserManager.checkCloudMigration();
        } else {
            if (this.currentProfile.isUseCloud().booleanValue()) {
                logger.d((Object)"Could not update course product cloud data and check cloud migration");
            }
            ch.ionesoft.ilp.base.co.f.b().D().displayWarningCode("message.cloud.not.connected", new Object[0]);
        }
    }

    private void initializeAuthenticationService() {
        ILPBookRegistry.instance().getAuthenticationService().a();
    }

    private void initializeAuthorizationManager() {
        ILPBookRegistry iLPBookRegistry = ILPBookRegistry.instance();
        c c2 = c.a();
        iLPBookRegistry.setAuthorizationManager(c2);
    }

    private ILPProfile getInitialProfile() {
        ILPProfile iLPProfile = new ILPProfile();
        iLPProfile.setId("0");
        iLPProfile.setProfileState(ProfileState.PROFILE_STATE_INITIAL);
        iLPProfile.setAssetStage(h.b.b);
        return iLPProfile;
    }

    public void createNewProfile() {
        ILPProfile iLPProfile = new ILPProfile(new Date());
        String string = this.getNewProfileId();
        iLPProfile.setId(string);
        iLPProfile.setReference(UUID.randomUUID().toString());
        iLPProfile.setProfileState(ProfileState.PROFILE_STATE_CREATING);
        ch.ionesoft.ilp.book.syn.b.b().a();
        logger.b((Object)("Creating new profile: " + iLPProfile));
        iLPProfile.setStayLoggedIn(true);
        this.reconnectProfile(iLPProfile);
    }

    public void resetToInitialProfile() {
        logger.b((Object)"Reset to initial profile");
        ch.ionesoft.ilp.base.co.f.b().D().closeAllExternalShells();
        q.a().c();
        j.b();
        ILPProfile iLPProfile = this.getInitialProfile();
        this.reconnectProfile(iLPProfile);
    }

    private void reconnectProfile(ILPProfile iLPProfile) {
        this.setCurrentProfile(iLPProfile);
        this.initializeProperties();
        this.resetKeystore();
        this.reconnectDatabase();
    }

    public void saveCurrentProfile() {
        this.persistWorkspace();
        if (StringHelper.isBlank((String)this.currentProfile.getSubject())) {
            logger.b((Object)"Did not save current profile, no subject set (yet).");
            return;
        }
        this.persistCurrentProfile();
    }

    public void softRestartWithCurrentProfile(IAUserManager.OnUpdateUserProfileCallback onUpdateUserProfileCallback) {
        q.a().c();
        ch.ionesoft.ilp.base.co.f.b().D().closeAllExternalShells();
        this.initializeProperties();
        this.resetKeystore();
        this.initializeAuthenticationService();
        this.reconnectDatabase();
        IAUserManager.askForSLA(false, false);
        ILPBookRegistry.instance().authorizationManager().d();
        ILPConfigurationManager iLPConfigurationManager = new ILPConfigurationManager();
        ILPProfile iLPProfile = ILPProfileManager.instance().getCurrentProfile();
        if (!iLPProfile.isResynchConfig()) {
            iLPConfigurationManager.synchronizeConfigurationFiles(false, false, true);
        } else {
            iLPConfigurationManager.synchronizeConfigurationFiles(true, true, true);
            iLPProfile.setResynchConfig(false);
            profileManager.saveCurrentProfile();
        }
        this.initializeCloudAndSharingService();
        ILPInitializer.instance().finalizeDBMigration();
        IAUserManager iAUserManager = new IAUserManager();
        iAUserManager.updateUserAndLicensesSynch(false, onUpdateUserProfileCallback);
        ILPInitializer.instance().initializeApplicationPermissions();
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("forcePortalIconCheck", false);
        ILPBookRegistry.instance().getPlatformFactory().postEvent("updateNotificationIcon", hashMap);
        q.a().b();
        q.a().d();
        ILPLessonsManager.getInstance().synchronizeTasks();
        ILPAdvertisementController.instance().downloadAdvertisementHTMLFile();
        ILPScenarioManager.reset();
    }

    private void persistCurrentProfile() {
        if (!FileHelper.fileExistsAtPath((String)h.c((String)this.currentProfile.getId()).getParent())) {
            FileHelper.createDirectory((String)h.c((String)this.currentProfile.getId()).getParent());
        }
        this.writeProfileToJson(this.currentProfile);
    }

    private void persistWorkspace() {
        if (this.currentProfile != null) {
            if (!this.currentProfile.getId().equals("0")) {
                this.getWorkspace().addExistingProfileId(this.currentProfile.getId());
            }
            this.getWorkspace().setCurrentProfileId(this.currentProfile.getId());
        }
        this.getWorkspace().setVerificationToken("");
        this.writeWorkspaceToJson(this.getWorkspace());
    }

    private void reconnectDatabase() {
        logger.b((Object)"Disconnect database");
        g.a().c();
        File file = h.E();
        ch.ionesoft.ilp.base.co.f.b().z(file.getAbsolutePath());
        ch.ionesoft.ilp.base.fo.g g2 = ILPBookRegistry.instance().getDatabaseDescriptor();
        ILPBookRegistry.instance().setDatabaseDir(file);
        ILPInitializer.instance().configureDatabase(g2, file);
        g.a().D().clearAll();
        logger.b((Object)("Reconfigured database to dir: " + file.getAbsolutePath()));
    }

    private void initializeProperties() {
        p.b();
        p.f();
    }

    private void resetKeystore() {
        try {
            this.getCurrentProfile().resetProfileKeychain();
            if (!ILPProfileManager.isInitialProfileActive()) {
                ILPBookRegistry.instance().getAuthenticationService().m();
            }
        }
        catch (Exception exception) {
            logger.d((Object)"Could not reset keychain", (Throwable)exception);
        }
    }

    public List<ILPProfile> getAllProfiles() {
        ArrayList<ILPProfile> arrayList = new ArrayList<ILPProfile>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        arrayList2.addAll(this.getWorkspace().getExistingProfileIds());
        for (String string : arrayList2) {
            ILPProfile iLPProfile = this.loadProfileFromJson(string);
            if (iLPProfile == null) continue;
            arrayList.add(iLPProfile);
        }
        return arrayList;
    }

    public ILPProfile fetchProfile(String string) {
        if (this.currentProfile.getId().equals(string)) {
            return this.currentProfile;
        }
        return this.loadProfileFromJson(string);
    }

    public int countExistingProfiles() {
        return this.getWorkspace().getExistingProfileIds().size();
    }

    public boolean shallDisplayAssetStageForProfiles() {
        boolean bl2 = false;
        for (ILPProfile iLPProfile : this.getAllProfiles()) {
            if (iLPProfile == null || !iLPProfile.getAssetStage().equals((Object)h.b.d) && !iLPProfile.getAssetStage().equals((Object)h.b.c)) continue;
            bl2 = true;
            break;
        }
        return bl2;
    }

    public void updateCurrentProfile(String string, String string2, String string3, String string4, String string5, h.b b2, String string6, boolean bl2) {
        if (StringHelper.isNotBlank((String)string)) {
            ILPProfileManager.instance().getCurrentProfile().setProfileName(string);
        }
        if (StringHelper.isNotBlank((String)string2)) {
            ILPProfileManager.instance().getCurrentProfile().setSubject(string2);
        }
        if (StringHelper.isNotBlank((String)string3)) {
            ILPProfileManager.instance().getCurrentProfile().setFirstname(string3);
        }
        if (StringHelper.isNotBlank((String)string4)) {
            ILPProfileManager.instance().getCurrentProfile().setLastname(string4);
        }
        if (StringHelper.isNotBlank((String)string5)) {
            ILPProfileManager.instance().getCurrentProfile().setContactEmail(string5);
        }
        if (StringHelper.isNotBlank((String)string6)) {
            ILPProfileManager.instance().getCurrentProfile().setColorIndex(string6);
        }
        if (b2 != null) {
            ILPProfileManager.instance().getCurrentProfile().setAssetStage(b2);
            if (ILPProfileManager.instance().getCurrentProfile().getProfileState().equals((Object)ProfileState.PROFILE_STATE_CREATING)) {
                ch.ionesoft.ilp.base.co.f.b().a(this.currentProfile.getAssetStage());
            } else if (!ILPProfileManager.instance().getCurrentProfile().getAssetStage().equals((Object)b2)) {
                logger.d((Object)"Could not updatechange current asset stage. Possible only in profile state creating.");
            }
        }
        ILPProfileManager.instance().getCurrentProfile().setStayLoggedIn(bl2);
        try {
            ILPProfileManager.instance().saveCurrentProfile();
        }
        catch (Exception exception) {
            logger.d((Object)"Could not save current profile and update workspace.", (Throwable)exception);
        }
    }

    public void updateProfile(String string, String string2, boolean bl2, boolean bl3, boolean bl4) {
        ILPProfile iLPProfile = this.fetchProfile(string);
        if (StringHelper.isNotBlank((String)string2)) {
            iLPProfile.setProfileName(string2);
        }
        logger.b((Object)String.format("Updating profile %s, %s with useCloud: %b, stayLoggedIn: %b, softRestartRequired: %b", string, string2, bl2, bl3, bl4));
        iLPProfile.setUseCloud(bl2);
        iLPProfile.setStayLoggedIn(bl3);
        try {
            this.writeProfileToJson(iLPProfile);
            logger.b((Object)String.format(Locale.ENGLISH, "Profile %s, with name %s updated", string, string2));
            if (bl4) {
                this.softRestartWithCurrentProfile(new IAUserManager.OnUpdateUserProfileCallback(){

                    @Override
                    public void onSuccess() {
                    }

                    @Override
                    public void onFailure(b b2) {
                    }
                });
            }
        }
        catch (Exception exception) {
            logger.d((Object)"Could not update profile", (Throwable)exception);
        }
    }

    public void activateProfile(String string) {
        logger.b((Object)("Activating profile: " + string));
        a.a().b("ChangeProfile");
        this.clearClientInformation();
        ILPProfile iLPProfile = this.loadProfileFromJson(string);
        iLPProfile.setProfileState(ProfileState.PROFILE_STATE_EXISTING);
        this.setCurrentProfile(iLPProfile);
        this.currentProfile.migrateKeychainToSecureStore();
        this.initializeAuthenticationService();
    }

    public void deleteProfile(String string) {
        if (ILPProfileManager.instance().getCurrentProfile().getId().equals(string)) {
            this.synchronizeCloud();
        }
        try {
            this.getWorkspace().removeExistingProfileId(string);
            this.writeWorkspaceToJson(this.getWorkspace());
            File file = h.b((String)string);
            FileHelper.removeDirectory((File)file);
            logger.b((Object)String.format(Locale.ENGLISH, "Deleted profile directory %s", file.getAbsolutePath()));
        }
        catch (Exception exception) {
            logger.d((Object)String.format(Locale.ENGLISH, "Could not delete profile with id %s", string), (Throwable)exception);
        }
    }

    private void synchronizeCloud() {
        logger.b((Object)"Synchronizing cloud");
        try {
            f f2 = ILPBookRegistry.instance().getCloudService();
            if (f2.f()) {
                d.a().a(true, false);
            }
        }
        catch (Exception exception) {
            logger.d((Object)"Could not synchronize cloud", (Throwable)exception);
        }
    }

    public ILPProfile getCurrentProfile() {
        return this.currentProfile;
    }

    private void setCurrentProfile(ILPProfile iLPProfile) {
        logger.b((Object)("Setting profile to " + iLPProfile));
        this.currentProfile = iLPProfile;
        ch.ionesoft.ilp.base.co.f.b().E(iLPProfile.getId());
        ch.ionesoft.ilp.base.co.f.b().a(iLPProfile.getAssetStage());
        this.saveCurrentProfile();
    }

    public String getNewProfileId() {
        int n2 = -1;
        try {
            n2 = ILPBookSettingsHelper.instance().getNextProfileNumber();
        }
        catch (Exception exception) {
            logger.c((Object)"Could not get highest profile number from workspace properties. May not be set yet. (First start or backup restore)");
        }
        if (n2 < 0 || FileHelper.fileExistsAtPath((String)h.c((String)("" + n2)).getParent())) {
            logger.b((Object)"Try to determine the profile number by counting the folders. ");
            n2 = 1;
            for (String string : this.getWorkspace().getExistingProfileIds()) {
                int n3 = ConverterUtil.convertDecimalStringToInteger_defaultValue((String)string, (Integer)0);
                if (n2 > n3) continue;
                n2 = n3 + 1;
            }
            while (FileHelper.fileExistsAtPath((String)h.c((String)("" + n2)).getParent())) {
                ++n2;
            }
        }
        ILPBookSettingsHelper.instance().setNextProfileNumber(n2);
        return String.valueOf(n2);
    }

    private ILPWorkspace loadWorkspaceFromJson() {
        ILPWorkspace iLPWorkspace = new ILPWorkspace();
        try {
            byte[] byArray = FileHelper.readFile((File)h.e());
            ObjectMapper objectMapper = new ObjectMapper();
            objectMapper.configure(DeserializationFeature.UNWRAP_ROOT_VALUE, true);
            iLPWorkspace = (ILPWorkspace)objectMapper.readValue(byArray, ILPWorkspace.class);
        }
        catch (Exception exception) {
            logger.d((Object)("Could not load workspace.json: " + h.e().getAbsolutePath()), (Throwable)exception);
        }
        return iLPWorkspace;
    }

    public void writeWorkspaceToJson(ILPWorkspace iLPWorkspace) {
        try {
            File file = h.d();
            if (!file.exists()) {
                FileHelper.createDirectory((File)file);
            }
            ObjectMapper objectMapper = new ObjectMapper();
            objectMapper.configure(SerializationFeature.WRAP_ROOT_VALUE, true);
            objectMapper.writeValue(h.e(), (Object)iLPWorkspace);
        }
        catch (IOException iOException) {
            logger.d((Object)("Could not write workspace.json to " + h.e()), (Throwable)iOException);
        }
    }

    public ILPWorkspace getWorkspace() {
        return this.workspace;
    }

    public void setWorkspace(ILPWorkspace iLPWorkspace) {
        this.workspace = iLPWorkspace;
    }

    public boolean hasProfileWithEnvironment() {
        return this.getCurrentProfile() != null && this.getCurrentProfile().hasEnvironment();
    }

    private ILPProfile loadProfileFromJson(String string) {
        ILPProfile iLPProfile = new ILPProfile();
        try {
            File file = h.c((String)string);
            if (file.exists()) {
                String string2 = FileHelper.contentsOfFile((File)file);
                iLPProfile = ILPProfile.parse(string2);
            } else {
                logger.c((Object)("Could not find .profile.json for profile ID " + string + ", remove profile entry from .workspace.json"));
                this.getWorkspace().removeExistingProfileId(string);
                this.persistWorkspace();
            }
        }
        catch (Exception exception) {
            logger.d((Object)("Could not find .profile.json: " + h.c((String)string).getAbsolutePath() + ", " + exception));
        }
        return iLPProfile;
    }

    private void writeProfileToJson(ILPProfile iLPProfile) {
        try {
            File file = h.c((String)iLPProfile.getId());
            iLPProfile.serializeIntoFile(file);
        }
        catch (Exception exception) {
            logger.d((Object)("Could not write .profile.json to " + h.c((String)iLPProfile.getId()).getAbsolutePath()), (Throwable)exception);
        }
    }

    public static boolean isInitialProfileActive() {
        return ILPProfileManager.instance().getCurrentProfile().isInitialProfile();
    }

    private void clearClientInformation() {
        this.clientInformation = null;
    }

    public static void logProfileStatus() {
        logger.b((Object)"Profile Status - - - - - - - - - - - - - - - - - - - - - - - - - - - -");
        try {
            ILPProfile iLPProfile = ILPProfileManager.instance().getCurrentProfile();
            if (iLPProfile != null && ILPProfileManager.isInitialProfileActive()) {
                logger.b((Object)"Current profile is initial profile");
            } else if (iLPProfile != null) {
                logger.b((Object)("Current profile id: " + iLPProfile.getId()));
                logger.b((Object)("Current profile name: " + iLPProfile.getProfileName()));
                logger.b((Object)("Current profile subject: " + iLPProfile.getSubject()));
                logger.b((Object)("Current profile assetStage: " + iLPProfile.getAssetStage().c()));
                logger.b((Object)("Current profile stayLoggedIn: " + (iLPProfile.isStayLoggedIn() ? "true" : "false")));
                logger.b((Object)("Current profile creationDate: " + iLPProfile.getCreationDate()));
                logger.b((Object)("Current profile useCloud: " + (iLPProfile.isUseCloud() != false ? "true" : "false")));
                logger.b((Object)("Current profile cloudEncryptionKey: " + StringHelper.truncate_toLength((String)iLPProfile.getCloudEncryptionKey(), (int)2)));
                logger.b((Object)("Current profile deleted: " + (iLPProfile.isDeleted() ? "true" : "false")));
            } else {
                logger.c((Object)"Current profile is null");
            }
            logger.b((Object)("Total number of existing profiles noted in workspace: " + ILPProfileManager.instance().countExistingProfiles()));
        }
        catch (Exception exception) {
            logger.d((Object)"Could not log profile status", (Throwable)exception);
        }
    }

    public static void logAccountStatus() {
        logger.b((Object)"Account Status - - - - - - - - - - - - - - - - - - - - - - - - - - - -");
        ILPUser iLPUser = ILPBookRegistry.instance().getCurrentUser();
        try {
            if (iLPUser == null) {
                logger.b((Object)"No user logged in");
            } else {
                logger.b((Object)String.format(Locale.ENGLISH, "Current deviceId: %s", ch.ionesoft.ilp.base.co.g.a().ag()));
                logger.b((Object)("Current user subject: " + iLPUser.getSubject()));
                logger.b((Object)("Current user firstname: " + iLPUser.getFirstname()));
                logger.b((Object)("Current user lastname: " + iLPUser.getLastname()));
                logger.b((Object)("Current user contactEmail: " + iLPUser.getEmail()));
                logger.b((Object)"Current user accounts: ");
                for (ILPAccount iLPAccount : iLPUser.getAccounts()) {
                    logger.b((Object)("  identity provider: " + iLPAccount.getIdentityProvider().getIdentityProviderIdentifier() + ", login name: " + iLPAccount.getLoginNameOrExternalId()));
                }
            }
        }
        catch (Exception exception) {
            logger.d((Object)"Could not log account status", (Throwable)exception);
        }
    }

    public void deleteProfileBySubject(String string) {
        List<ILPProfile> list = this.getAllProfiles();
        for (ILPProfile iLPProfile : list) {
            if (!iLPProfile.getSubject().equals(string)) continue;
            this.deleteProfile(iLPProfile.getId());
        }
    }

    public static enum ProfileState {
        PROFILE_STATE_UNDEFINED(0),
        PROFILE_STATE_INITIAL(1),
        PROFILE_STATE_CREATING(2),
        PROFILE_STATE_CREATING_LINK_ACCOUNT(3),
        PROFILE_STATE_EXISTING(4),
        PROFILE_STATE_RUNNING(5),
        PROFILE_STATE_RUNNING_LINK_ACCOUNT(6),
        PROFILE_STATE_CREATING_NEXT_STEPS(7);

        private int type;
        private static final Map<Integer, ProfileState> lookupType;

        static {
            lookupType = new HashMap<Integer, ProfileState>();
            for (ProfileState profileState : EnumSet.allOf(ProfileState.class)) {
                lookupType.put(profileState.getType(), profileState);
            }
        }

        private ProfileState(int n3) {
            this.type = n3;
        }

        public int getType() {
            return this.type;
        }

        public static ProfileState get(int n2) {
            ProfileState profileState = lookupType.get(n2);
            if (profileState == null) {
                profileState = PROFILE_STATE_UNDEFINED;
            }
            return profileState;
        }

        public String toString() {
            return "ProfileState " + this.name();
        }
    }
}

