/*
 * Decompiled with CFR 0.152.
 */
package ch.ionesoft.ilp.book.co;

import ch.ionesoft.ilp.base.co.ILPLogManager;
import ch.ionesoft.ilp.base.co.ILogger;
import ch.ionesoft.ilp.base.co.h;
import ch.ionesoft.ilp.base.co.p;
import ch.ionesoft.ilp.base.fo.z;
import ch.ionesoft.ilp.base.he.ConverterUtil;
import ch.ionesoft.ilp.base.he.FileHelper;
import ch.ionesoft.ilp.base.he.Keychain;
import ch.ionesoft.ilp.base.he.SecureStore;
import ch.ionesoft.ilp.base.he.StringHelper;
import ch.ionesoft.ilp.book.au.d;
import ch.ionesoft.ilp.book.co.ILPBookRegistry;
import ch.ionesoft.ilp.book.co.ILPBookSettingsHelper;
import ch.ionesoft.ilp.book.co.ILPInitializer;
import ch.ionesoft.ilp.book.co.ILPProfileManager;
import ch.ionesoft.ilp.book.mo.ILPAccount;
import ch.ionesoft.ilp.book.mo.ILPAgent;
import ch.ionesoft.ilp.book.mo.ILPCourseDef;
import ch.ionesoft.ilp.book.mo.ILPEnvironment;
import ch.ionesoft.ilp.book.mo.ILPEnvironmentConfig;
import ch.ionesoft.ilp.book.mo.ILPIssueDef;
import ch.ionesoft.ilp.book.mo.ILPMandant;
import ch.ionesoft.ilp.book.mo.ILPProperty;
import ch.ionesoft.ilp.book.mo.ILPScenario;
import ch.ionesoft.ilp.book.mo.ILPTopic;
import ch.ionesoft.ilp.book.mo.ILPUser;
import ch.ionesoft.ilp.book.pe.f;
import ch.ionesoft.ilp.book.pe.j;
import com.j256.ormlite.dao.CloseableIterator;
import java.io.File;
import java.io.IOException;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.json.ionesoft.g;
import org.json.ionesoft.i;

public class ILPProfile {
    private static ILogger logger = ILPLogManager.getLogger(ILPProfile.class);
    protected static final String KEYCHAIN_ID_TOKEN_KEY = "IA.ID_TOKEN.KEY";
    protected static final String KEYCHAIN_REFRESH_TOKEN_KEY = "IA.REFRESH_TOKEN.KEY";
    protected static final String KEYCHAIN_AUTH_SERVICE = "IA.AUTH.SERVICE";
    protected static final String KEYCHAIN_SUBJECT_KEY = "IA.AUTH.SUBJECT";
    protected static final String KEYCHAIN_CLIENT_ID_KEY = "IA.AUTH.CLIENT_ID";
    protected static final String KEYCHAIN_CLIENT_SECRET_KEY = "IA.AUTH.CLIENT_SECRET";
    public static final String INITIAL_PROFILE_ID = "0";
    private String id;
    private String reference;
    private String subject;
    private String profileName;
    private String email;
    private String firstname;
    private String lastname;
    private String colorIndex;
    private String bannerFilename;
    private h.b assetStage;
    private Boolean useCloud;
    private boolean stayLoggedIn;
    private boolean deleted;
    private Date creationDate;
    private boolean resynchConfig;
    private List<String> providers = new ArrayList<String>();
    private Map<String, String> accounts = new HashMap<String, String>();
    private Map<String, String> currentIssueIds = new HashMap<String, String>(4);
    private Map<String, String> currentIssueReferences = new HashMap<String, String>(4);
    private Map<String, String> currentCourseReferences = new HashMap<String, String>(4);
    private Map<String, Integer> currentExerciseGroupReferences = new HashMap<String, Integer>(4);
    private String currentCourseId;
    private String currentCourseReference;
    private String currentMandantId;
    private Map<String, String> currentAgentIds = new HashMap<String, String>();
    private ILPProfileManager.ProfileState profileState;
    private ILPMandant currentMandant;
    private ILPCourseDef currentCourse;
    private ILPIssueDef currentIssue;
    private ILPUser currentUser;
    private Keychain profileKeychain;
    private SecureStore profileSecureStore;
    private String cloudEncryptionKey;
    private ILPEnvironmentConfig environmentConfig;
    private d licensePermissionManager;

    public ILPProfile() {
    }

    public ILPProfile(Date date) {
        this.setCreationDate(date);
    }

    public static ILPProfile parse(String string) {
        try {
            Object object;
            i i2 = new i(string);
            i i3 = i2.f("profile");
            ILPProfile iLPProfile = new ILPProfile();
            iLPProfile.id = i3.h("id");
            try {
                iLPProfile.reference = i3.h("reference");
            }
            catch (Exception exception) {
                iLPProfile.reference = UUID.randomUUID().toString();
                logger.b((Object)("Successfully created reference: " + iLPProfile.reference + " for profile: " + iLPProfile));
            }
            iLPProfile.subject = i3.h("subject");
            iLPProfile.profileName = i3.t("profileName");
            iLPProfile.email = i3.t("email");
            iLPProfile.firstname = i3.t("firstname");
            iLPProfile.lastname = i3.t("lastname");
            iLPProfile.colorIndex = i3.t("colorIndex");
            iLPProfile.assetStage = h.b.b((String)i3.t("assetStage"));
            iLPProfile.stayLoggedIn = i3.b("stayLoggedIn");
            iLPProfile.deleted = i3.b("deleted");
            iLPProfile.bannerFilename = i3.t("bannerFilePath");
            try {
                iLPProfile.useCloud = i3.b("useCloud");
            }
            catch (Exception exception) {
                iLPProfile.useCloud = null;
            }
            try {
                object = i3.e("providers");
                int n2 = 0;
                while (n2 < object.a()) {
                    iLPProfile.providers.add(object.h(n2));
                    ++n2;
                }
            }
            catch (g g2) {
            }
            catch (Exception exception) {
                logger.c((Object)"Could not get providers from json.", (Throwable)exception);
            }
            try {
                iLPProfile.resynchConfig = i3.b("resynchConfig");
            }
            catch (Exception exception) {
                // empty catch block
            }
            object = i3.t("creationDate");
            if (StringUtils.isNotEmpty((CharSequence)object)) {
                try {
                    if (((String)object).startsWith("00")) {
                        iLPProfile.setCreationDate(FileHelper.getFileCreationDate((File)h.c((String)iLPProfile.id)));
                    } else {
                        iLPProfile.setCreationDate(ConverterUtil.parseTimestampFromAnyFormat((String)object));
                    }
                }
                catch (Exception exception) {
                    logger.c((Object)("Could not parse creationDate: " + (String)object));
                }
            }
            try {
                i i4 = i3.q("accounts");
                if (i4 != null) {
                    Iterator iterator = i4.a();
                    while (iterator.hasNext()) {
                        String string2 = (String)iterator.next();
                        String string3 = (String)i4.a(string2);
                        iLPProfile.accounts.put(string2, string3);
                    }
                } else {
                    logger.c((Object)("Profile: " + iLPProfile.profileName + " has not yet accounts stored."));
                }
            }
            catch (Exception exception) {
                logger.c((Object)"Could not read accounts from profile.json. ", (Throwable)exception);
            }
            return iLPProfile;
        }
        catch (g g3) {
            logger.d((Object)"Could not parse profile json", (Throwable)g3);
            return null;
        }
    }

    public static ILPProfile parse(File file) throws IOException {
        String string = FileHelper.contentsOfFile((File)file);
        return ILPProfile.parse(string);
    }

    public void serializeIntoFile(File file) {
        try {
            i i2 = new i();
            i2.c("id", (Object)this.id);
            if (StringHelper.isNotBlank((String)this.reference)) {
                i2.c("reference", (Object)this.reference);
            }
            i2.c("subject", (Object)this.subject);
            i2.c("profileName", (Object)this.profileName);
            i2.c("email", (Object)this.email);
            i2.c("firstname", (Object)this.firstname);
            i2.c("lastname", (Object)this.lastname);
            i2.c("colorIndex", (Object)this.colorIndex);
            i2.c("assetStage", (Object)this.assetStage);
            i2.c("useCloud", (Object)this.useCloud);
            i2.b("stayLoggedIn", this.stayLoggedIn);
            i2.b("deleted", this.deleted);
            i2.b("resynchConfig", this.resynchConfig);
            i2.c("bannerFilePath", (Object)this.bannerFilename);
            if (!this.providers.isEmpty()) {
                i2.a("providers", this.providers);
            }
            if (this.getCreationDate() != null) {
                i2.c("creationDate", (Object)ConverterUtil.formatISOTimestamp((Date)this.getCreationDate()));
            }
            if (!this.accounts.isEmpty()) {
                i2.a("accounts", this.accounts);
            }
            i i3 = new i();
            i3.c("profile", (Object)i2);
            FileHelper.writeFile((File)file, (String)i3.toString());
        }
        catch (g g2) {
            logger.d((Object)"Could not serialize ILPProfile into json", (Throwable)g2);
        }
        catch (IOException iOException) {
            logger.d((Object)("Could not write ILPProfile into file: " + file), (Throwable)iOException);
        }
    }

    public void addProvidersToJson() {
        try {
            if (ILPProfileManager.instance().getCurrentProfile().getCurrentUser() == null) {
                return;
            }
            this.providers.clear();
            List<ILPAccount> list = f.a().e(this.currentUser);
            for (ILPAccount iLPAccount : list) {
                this.providers.add(iLPAccount.getIdentityProvider().getIdentityProviderIdentifier());
            }
        }
        catch (Exception exception) {
            logger.d((Object)"Could not add providers to json: ", (Throwable)exception);
        }
    }

    public boolean isInitialProfile() {
        return this.getId().equals(INITIAL_PROFILE_ID);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String string) {
        this.id = string;
    }

    public String getReference() {
        return this.reference;
    }

    public void setReference(String string) {
        this.reference = string;
    }

    public String getSubject() {
        return this.subject != null ? this.subject : "";
    }

    public void setSubject(String string) {
        this.subject = string;
    }

    public String getProfileName() {
        return this.profileName != null ? this.profileName : "";
    }

    public void setProfileName(String string) {
        this.profileName = string;
    }

    public String getContactEmail() {
        return this.email != null ? this.email : "";
    }

    public void setContactEmail(String string) {
        this.email = string;
    }

    public String getUsername() {
        Iterator<Map.Entry<String, String>> iterator = this.accounts.entrySet().iterator();
        if (iterator.hasNext()) {
            Map.Entry<String, String> entry = iterator.next();
            return entry.getValue();
        }
        return this.getContactEmail();
    }

    public String getProviderNameAndUsername() {
        Iterator<Map.Entry<String, String>> iterator = this.accounts.entrySet().iterator();
        if (iterator.hasNext()) {
            Map.Entry<String, String> entry = iterator.next();
            return String.valueOf(entry.getKey()) + " - " + entry.getValue();
        }
        return "";
    }

    public Map<String, String> getAccounts() {
        return this.accounts;
    }

    public String getFirstname() {
        return this.firstname != null ? this.firstname : "";
    }

    public void setFirstname(String string) {
        this.firstname = string;
    }

    public String getLastname() {
        return this.lastname != null ? this.lastname : "";
    }

    public void setLastname(String string) {
        this.lastname = string;
    }

    public void setBannerFilename(String string) {
        this.bannerFilename = string;
    }

    public String getBannerFilename() {
        return this.bannerFilename != null ? this.bannerFilename : "";
    }

    public boolean isResynchConfig() {
        return this.resynchConfig;
    }

    public void setResynchConfig(boolean bl2) {
        this.resynchConfig = bl2;
    }

    public ILPUser getCurrentUser() {
        if (this.currentUser == null) {
            try {
                this.currentUser = f.a().B(this.subject);
                if (this.currentUser == null && !this.isInitialProfile()) {
                    logger.c((Object)("CurrentUser with subject: " + this.subject + " not found in current database. Be aware the right database is connected (not working during login)"));
                }
            }
            catch (j j2) {
                logger.d((Object)("Could not fetch current user with subject: " + this.subject), (Throwable)j2);
            }
        }
        return this.currentUser;
    }

    public void loadCurrentUserFromDatabase() {
        try {
            this.currentUser = f.a().B(this.subject);
        }
        catch (j j2) {
            logger.d((Object)"Could not load current user from database: ", (Throwable)j2);
        }
    }

    public String currentCourseId() {
        if (this.currentCourseId == null) {
            this.currentCourseId = p.e().c("course.currentCourseId");
        }
        return this.currentCourseId;
    }

    public void setCurrentCourseId(String string) {
        this.currentCourseId = string;
        p.e().a(string, "course.currentCourseId");
        p.e().g();
    }

    public String getCurrentETestingUser() {
        return p.e().c("etest.username");
    }

    public void setCurrentETestingUser(String string) {
        p.e().a(string, "etest.username");
        p.e().g();
    }

    public void clearCurrentEtestingUser() {
        this.setCurrentETestingUser(null);
    }

    public Integer getCurrentETestingTime(ILPScenario iLPScenario) {
        String string = p.e().c(this.getElapesdTimeUserKey(iLPScenario));
        if (StringHelper.isNotBlank((String)string)) {
            return p.e().f(this.getElapesdTimeUserKey(iLPScenario));
        }
        return 0;
    }

    public void setCurrentETestingTime(Integer n2, ILPScenario iLPScenario) {
        p.e().a(String.valueOf(n2), this.getElapesdTimeUserKey(iLPScenario));
        p.e().g();
    }

    public boolean hasUserETestTimeSetForScenario(ILPScenario iLPScenario) {
        return this.getCurrentETestingTime(iLPScenario) != null;
    }

    private String getElapesdTimeUserKey(ILPScenario iLPScenario) {
        return "etest.elapsedTime." + this.getCurrentETestingUser() + "." + iLPScenario.getId();
    }

    public String currentCourseReference() {
        if (this.currentCourseReference == null) {
            this.currentCourseReference = p.e().c("course.currentCourseReference");
        }
        return this.currentCourseReference;
    }

    public void setCurrentCourseReference(String string) {
        this.currentCourseReference = string;
        p.e().a(string, "course.currentCourseReference");
        p.e().g();
    }

    private String currentCourseReferenceForCourseId(String string) {
        String string2 = this.currentCourseReferences.get(string);
        if (string2 == null && (string2 = p.e().c(String.format(Locale.ENGLISH, "course.%s.currentCourseReference", string))) != null) {
            this.currentCourseReferences.put(string, string2);
        }
        return string2;
    }

    private void setCurrentCourseReference_forCourseId(String string, String string2) {
        this.currentCourseReferences.put(string2, string);
        p.e().a(String.format(Locale.ENGLISH, "course.%s.currentCourseReference", string2), (Object)string);
        p.e().g();
    }

    public String currentIssueIdForCourseId_courseReference(String string, String string2) {
        String string3 = this.currentIssueIds.get(String.valueOf(string) + "_" + string2);
        if (string3 == null && (string3 = p.e().c(String.format(Locale.ENGLISH, "course.%s.reference.%s.currentIssueId", string, string2))) != null) {
            this.currentIssueIds.put(String.valueOf(string) + "_" + string2, string3);
        }
        return string3;
    }

    public void removeAllAccounts() {
        this.accounts.clear();
    }

    public void addAccount(String string, String string2) {
        this.accounts.put(string, string2);
    }

    public Integer currentExerciseGroup(String string) {
        Integer n2 = this.currentExerciseGroupReferences.get(string);
        if (n2 == null) {
            n2 = p.e().a(String.format(Locale.ENGLISH, "course.%s.currentExerciseGroupReference", string), -1);
            if (n2 >= 0) {
                this.currentExerciseGroupReferences.put(string, n2);
            } else {
                return null;
            }
        }
        return n2;
    }

    public void setCurrentExerciseGroupReference_forCourseId(int n2, String string) {
        this.currentExerciseGroupReferences.put(string, n2);
        p.e().a(String.format(Locale.ENGLISH, "course.%s.currentExerciseGroupReference", string), (Object)n2);
        p.e().g();
    }

    private void setCurrentIssueId_forCourseId_courseReference(String string, String string2, String string3) {
        this.currentIssueIds.put(String.valueOf(string2) + "_" + string3, string);
        p.e().a(string, String.format(Locale.ENGLISH, "course.%s.reference.%s.currentIssueId", string2, string3));
        p.e().g();
    }

    private String currentIssueReferenceForCourseId_courseReference(String string, String string2) {
        String string3 = this.currentIssueReferences.get(String.valueOf(string) + "_" + string2);
        if (string3 == null && (string3 = p.e().c(String.format(Locale.ENGLISH, "course.%s.reference.%s.currentIssueReference", string, string2))) != null) {
            this.currentIssueReferences.put(String.valueOf(string) + "_" + string2, string3);
        }
        return string3;
    }

    public void setCurrentIssueReference_forCourseId_courseReference(String string, String string2, String string3) {
        this.currentIssueReferences.put(String.valueOf(string2) + "_" + string3, string);
        p.e().a(string, String.format(Locale.ENGLISH, "course.%s.reference.%s.currentIssueReference", string2, string3));
        p.e().g();
    }

    public void removeCurrentIssueForCourseId_courseReference(String string, String string2) {
        this.currentIssueIds.remove(String.valueOf(string) + "_" + string2);
        this.currentIssueReferences.remove(String.valueOf(string) + "_" + string2);
        p.e().b(String.format(Locale.ENGLISH, "course.%s.reference.%s.currentIssueId", string, string2));
        p.e().b(String.format(Locale.ENGLISH, "course.%s.reference.%s.currentIssueReference", string, string2));
        p.e().g();
    }

    public void updateSettingsForCurrentCourse(ILPCourseDef iLPCourseDef) {
        if (iLPCourseDef != null) {
            this.setCurrentMandantId(iLPCourseDef.getMandantId());
            this.setCurrentCourseId(iLPCourseDef.getCourseId());
            this.setCurrentCourseReference(iLPCourseDef.getReference());
            this.setCurrentCourseReference_forCourseId(iLPCourseDef.getReference(), iLPCourseDef.getCourseId());
        }
    }

    public void updateSettingsForCurrentIssue(ILPIssueDef iLPIssueDef) {
        if (iLPIssueDef != null && iLPIssueDef.getIssueId() != null) {
            this.setCurrentCourseId(iLPIssueDef.getCourse().getCourseId());
            this.setCurrentCourseReference(iLPIssueDef.getCourse().getReference());
            this.setCurrentCourseReference_forCourseId(iLPIssueDef.getCourse().getReference(), iLPIssueDef.getCourse().getCourseId());
            this.setCurrentIssueId_forCourseId_courseReference(iLPIssueDef.getIssueId(), iLPIssueDef.getCourse().getCourseId(), iLPIssueDef.getCourse().getReference());
            this.setCurrentIssueReference_forCourseId_courseReference(iLPIssueDef.getReference(), iLPIssueDef.getCourse().getCourseId(), iLPIssueDef.getCourse().getReference());
        }
    }

    public ILPCourseDef currentCourseFromSettings() {
        f f2 = f.a();
        String string = this.currentCourseId();
        String string2 = this.currentCourseReference();
        ILPCourseDef iLPCourseDef = null;
        try {
            if (string2 != null && string2.length() > 0) {
                iLPCourseDef = f2.a(string, string2);
            }
            if (iLPCourseDef == null && string != null && string.length() > 0) {
                iLPCourseDef = f2.a(string);
            }
        }
        catch (Exception exception) {
            logger.d((Object)"Could not fetch course from settings", (Throwable)exception);
        }
        return iLPCourseDef;
    }

    public ILPIssueDef currentIssueFromSettings() throws j {
        f f2 = f.a();
        String string = this.currentIssueIdForCourseId_courseReference(this.currentCourseId, this.currentCourseReference);
        String string2 = this.currentIssueReferenceForCourseId_courseReference(this.currentCourseId, this.currentCourseReference);
        ILPCourseDef iLPCourseDef = this.currentCourseFromSettings();
        ILPIssueDef iLPIssueDef = null;
        if (iLPCourseDef != null && iLPCourseDef.getReference().length() > 0 && string2.length() > 0) {
            iLPIssueDef = f2.b(string, string2, iLPCourseDef.getCourseId(), iLPCourseDef.getReference());
        }
        if (iLPIssueDef == null && StringUtils.isNotBlank((CharSequence)string)) {
            iLPIssueDef = f2.d(string, iLPCourseDef.getCourseId(), iLPCourseDef.getReference());
        }
        return iLPIssueDef;
    }

    public ILPIssueDef currentIssueFromSettingsForCourse(ILPCourseDef iLPCourseDef) throws j {
        return this.currentIssueFromSettingsForCourseId_courseReference_defaultIssueId(iLPCourseDef.getCourseId(), iLPCourseDef.getReference(), null);
    }

    public ILPIssueDef currentIssueFromSettingsForCourseId_courseReference_defaultIssueId(String string, String string2, String string3) throws j {
        ILPCourseDef iLPCourseDef;
        f f2 = f.a();
        if (string2.length() == 0) {
            string2 = this.currentCourseReferenceForCourseId(string);
        }
        if ((iLPCourseDef = string2.length() > 0 ? f2.a(string, string2) : f2.g(string)) == null) {
            return null;
        }
        String string4 = this.currentIssueIdForCourseId_courseReference(string, string2);
        String string5 = this.currentIssueReferenceForCourseId_courseReference(string, string2);
        ILPIssueDef iLPIssueDef = null;
        if (StringUtils.isNotBlank((CharSequence)string4)) {
            iLPIssueDef = f2.b(string4, string5, iLPCourseDef.getCourseId(), iLPCourseDef.getReference());
        }
        if (iLPIssueDef == null && StringUtils.isNotBlank((CharSequence)string4)) {
            iLPIssueDef = f2.d(string4, iLPCourseDef.getCourseId(), iLPCourseDef.getReference());
        }
        if (iLPIssueDef == null && (iLPIssueDef = f2.c(iLPCourseDef.getCourseId(), iLPCourseDef.getReference())) != null && f2.s(iLPIssueDef) == 0L && f2.t(iLPIssueDef) == 0L) {
            iLPIssueDef = f2.e(iLPCourseDef);
        }
        if (iLPIssueDef == null && StringUtils.isNotBlank((CharSequence)string3)) {
            iLPIssueDef = f2.d(string3, iLPCourseDef.getCourseId(), iLPCourseDef.getReference());
        }
        if (!(iLPIssueDef != null && iLPIssueDef.getCourse() != null && iLPIssueDef.getCourse().equals(iLPCourseDef) || (iLPIssueDef = f2.f(iLPCourseDef.getCourseId(), iLPCourseDef.getReference())) != null)) {
            iLPIssueDef = f2.e(iLPCourseDef.getCourseId(), iLPCourseDef.getReference());
        }
        return iLPIssueDef;
    }

    public ILPIssueDef currentIssueForCourseId_courseReference(String string, String string2, boolean bl2) {
        ILPIssueDef iLPIssueDef = null;
        try {
            ILPCourseDef iLPCourseDef = f.a().a(string, string2);
            if (bl2) {
                iLPIssueDef = iLPCourseDef.getForceLoadIssue();
            }
            if (iLPIssueDef == null) {
                iLPIssueDef = this.currentIssueFromSettingsForCourseId_courseReference_defaultIssueId(string, string2, "");
            }
        }
        catch (Exception exception) {
            logger.d((Object)("Could not detect current issue for courseId: " + string + ", courseReference: " + string2 + ". Reason: " + exception), (Throwable)exception);
        }
        return iLPIssueDef;
    }

    public ILPTopic currentTopicForCourseId_courseReference(String string, String string2, boolean bl2) {
        ILPTopic iLPTopic = null;
        try {
            ILPIssueDef iLPIssueDef = this.currentIssueForCourseId_courseReference(string, string2, bl2);
            if (iLPIssueDef != null) {
                if (!iLPIssueDef.isForceLoad() || !bl2) {
                    iLPTopic = f.a().p(iLPIssueDef);
                }
                if (iLPTopic == null) {
                    iLPTopic = f.a().q(iLPIssueDef);
                }
            }
        }
        catch (Exception exception) {
            logger.d((Object)("Could not detect current topic for courseId: " + string + ", courseReference: " + string2 + ". Reason: " + exception), (Throwable)exception);
        }
        return iLPTopic;
    }

    public ILPCourseDef getCurrentCourse() {
        return this.currentCourse;
    }

    public void setCurrentCourse(ILPCourseDef iLPCourseDef) {
        ILPCourseDef iLPCourseDef2 = this.getCurrentCourse();
        if (iLPCourseDef2 == null || !iLPCourseDef2.equals(iLPCourseDef)) {
            this.currentCourse = iLPCourseDef;
            if (iLPCourseDef != null) {
                this.updateSettingsForCurrentCourse(iLPCourseDef);
                ILPInitializer.instance().configureForNewCourse(iLPCourseDef);
            }
        }
    }

    public void setCurrentIssue(ILPIssueDef iLPIssueDef) {
        ILPIssueDef iLPIssueDef2 = this.getCurrentIssue();
        if (iLPIssueDef == null || iLPIssueDef2 != iLPIssueDef || this.getCurrentCourse() != iLPIssueDef.getCourse()) {
            this.currentIssue = iLPIssueDef;
            if (iLPIssueDef != null) {
                this.updateSettingsForCurrentIssue(iLPIssueDef);
                this.setCurrentCourse(iLPIssueDef.getCourse());
                ILPInitializer.instance().configureForNewIssue(iLPIssueDef);
            }
        }
    }

    public ILPIssueDef getCurrentIssue() {
        return this.currentIssue;
    }

    @Deprecated
    public boolean hasLmsLoginProvided() {
        return this.lmsUsernameForCurrentAgent().length() > 0 && this.lmsPasswordForCurrentAgent().length() > 0;
    }

    public String lmsUsernameForCurrentAgent() {
        String string = this.currentAgentId();
        return this.lmsUsernameForAgentId(string);
    }

    public String lmsUsernameForAgentId(String string) {
        String string2 = p.e().c(String.format("login.lms.username.%s", string));
        return string2 != null ? string2 : "";
    }

    public String lmsSuccessfullLoginCookie() {
        return ILPBookSettingsHelper.instance().lmsSuccessfullLoginCookie();
    }

    public void setLmsUsernameForCurrentAgent(String string) {
        String string2 = this.currentAgentId();
        this.setLmsUsernameForAgentId(string, string2);
    }

    public void setLmsUsernameForAgentId(String string, String string2) {
        if (StringHelper.isEmpty((String)string) || StringHelper.isEmpty((String)string2)) {
            logger.c((Object)"Could not save username for agent. Empty string");
            return;
        }
        p.e().a(string, String.format("login.lms.username.%s", string2));
        p.e().g();
    }

    public void setLmsPasswordForCurrentAgent(String string) {
        String string2 = this.currentAgentId();
        this.setLmsPasswordForAgentId(string, string2);
    }

    public void setLmsPasswordForAgentId(String string, String string2) {
        String string3 = this.lmsUsernameForAgentId(string2);
        if (string3.length() == 0) {
            return;
        }
        ILPBookRegistry.instance().getProfileSecureStore().addEntry(string3, string2, string);
    }

    public String lmsPasswordForCurrentAgent() {
        return this.lmsPasswordForAgentId(this.currentAgentId());
    }

    public String lmsPasswordForAgentId(String string) {
        String string2 = this.lmsUsernameForAgentId(string);
        if (string2.length() == 0) {
            return "";
        }
        return ILPBookRegistry.instance().getProfileSecureStore().getEntry(string2, string);
    }

    public ILPMandant currentMandant() {
        return this.getEnvironment() != null ? this.getEnvironment().mandantWithId(this.currentMandantId()) : null;
    }

    public ILPAgent currentAgent() {
        ILPMandant iLPMandant = this.currentMandant();
        if (iLPMandant != null) {
            String string = iLPMandant.getMandantIdentifier();
            String string2 = ILPProfileManager.instance().getCurrentProfile().currentAgentIdForMandantId(string);
            return iLPMandant.agentWithId(string2);
        }
        logger.d((Object)("Could not find a mandant config for " + this.currentMandantId));
        return new ILPAgent();
    }

    public z getImageForCurrentAgent() {
        ILPAgent iLPAgent = this.currentAgent();
        return iLPAgent.coverImageForAgent();
    }

    public z getImageForCurrentMandant() {
        ILPMandant iLPMandant = this.currentMandant();
        return iLPMandant.coverImageForMandant();
    }

    public void setCurrentAgent(ILPAgent iLPAgent) {
        this.setCurrentAgentId_forMandantId(iLPAgent.getAgentIdentifier(), iLPAgent.getMandant().getMandantIdentifier());
    }

    public ILPMandant getMandantWithId(String string) {
        return this.getEnvironment().mandantWithId(string);
    }

    public boolean hasEnvironment() {
        ILPEnvironment iLPEnvironment = this.getEnvironment();
        return iLPEnvironment != null && iLPEnvironment.getName() != null;
    }

    public ILPEnvironment getEnvironment() {
        return f.a().U(ch.ionesoft.ilp.base.co.f.b().w());
    }

    public String getColorIndex() {
        return this.colorIndex != null ? this.colorIndex : "";
    }

    public void setColorIndex(String string) {
        this.colorIndex = string;
    }

    public h.b getAssetStage() {
        return this.assetStage != null ? this.assetStage : h.b.b;
    }

    public void setAssetStage(h.b b2) {
        this.assetStage = b2;
        ch.ionesoft.ilp.base.co.f.b().a(b2);
    }

    public Boolean isUseCloud() {
        if (this.useCloud == null && this.getAssetStage() == h.b.b && !this.isInitialProfile()) {
            this.setUseCloud(true);
            ILPProfileManager.instance().saveCurrentProfile();
        }
        if (this.useCloud != null && this.useCloud.booleanValue()) {
            return true;
        }
        return false;
    }

    public void setUseCloud(Boolean bl2) {
        this.useCloud = bl2;
    }

    public boolean isStayLoggedIn() {
        return this.stayLoggedIn;
    }

    public void setStayLoggedIn(boolean bl2) {
        this.stayLoggedIn = bl2;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public void setDeleted(boolean bl2) {
        this.deleted = bl2;
    }

    public ILPProfileManager.ProfileState getProfileState() {
        return this.profileState;
    }

    public void setProfileState(ILPProfileManager.ProfileState profileState) {
        this.profileState = profileState;
    }

    public ILPMandant getCurrentMandant() {
        return this.currentMandant;
    }

    public void setCurrentMandant(ILPMandant iLPMandant) {
        this.currentMandant = iLPMandant;
        if (iLPMandant != null) {
            this.setCurrentMandantId(iLPMandant.getMandantIdentifier());
        }
    }

    public String currentMandantId() {
        if (this.currentMandantId == null || this.currentMandantId.length() == 0) {
            this.currentMandantId = p.e().c("environment.currentMandantId");
        }
        if (this.currentMandantId == null) {
            ILPMandant iLPMandant = f.a().W("");
            this.currentMandantId = iLPMandant.getMandantIdentifier();
        }
        return this.currentMandantId;
    }

    public void setCurrentMandantId(String string) {
        this.currentMandantId = string;
        p.e().a(string, "environment.currentMandantId");
        p.e().g();
    }

    String currentAgentIdForMandantId(String string) {
        String string2 = this.currentAgentIds.get(string);
        if (string2 == null && (string2 = p.e().c(String.format(Locale.ENGLISH, "environment.mandant.%s.currentAgentId", string))) != null) {
            this.currentAgentIds.put(string, string2);
        }
        return string2;
    }

    void setCurrentAgentId_forMandantId(String string, String string2) {
        this.currentAgentIds.put(string2, string);
        p.e().a(string, String.format(Locale.ENGLISH, "environment.mandant.%s.currentAgentId", string2));
        p.e().g();
    }

    private String currentAgentId() {
        ILPMandant iLPMandant = this.currentMandant();
        String string = iLPMandant.getMandantIdentifier();
        String string2 = this.currentAgentIds.get(string);
        if (string2 == null && (string2 = p.e().c(String.format(Locale.ENGLISH, "environment.mandant.%s.currentAgentId", string))) != null) {
            this.currentAgentIds.put(string, string2);
        }
        return string2;
    }

    public String getInitials() {
        String string = "";
        if (!StringHelper.isBlank((String)this.firstname)) {
            string = String.valueOf(string) + this.firstname.substring(0, 1).toUpperCase();
        }
        if (!StringHelper.isBlank((String)this.lastname)) {
            string = String.valueOf(string) + this.lastname.substring(0, 1).toUpperCase();
        }
        if (string.length() == 0 && !StringHelper.isBlank((String)this.getEmailOrSubject())) {
            string = String.valueOf(string) + this.getEmailOrSubject().substring(0, 1).toUpperCase();
        }
        return string;
    }

    public String getEmailOrSubject() {
        return this.email != null ? this.email : (this.subject != null ? this.subject : "");
    }

    public Keychain getProfileKeychain() {
        if (this.profileKeychain == null) {
            logger.b((Object)"configure profile keychain");
            this.configureProfileKeychain();
        }
        return this.profileKeychain;
    }

    public void setProfileKeychain(Keychain keychain) {
        this.profileKeychain = keychain;
    }

    private void configureProfileKeychain() {
        Keychain keychain = Keychain.configureKeychain((File)h.l(), (String)".profile.keystore");
        this.setProfileKeychain(keychain);
    }

    public void resetProfileKeychain() {
        this.profileKeychain = null;
    }

    public synchronized SecureStore getProfileSecureStore() {
        if (this.profileSecureStore == null) {
            logger.b((Object)"Configure profile SecureStore");
            this.configureProfileSecureStore();
        }
        return this.profileSecureStore;
    }

    private void configureProfileSecureStore() {
        this.profileSecureStore = SecureStore.configureSecureStore((File)h.l(), (String)".secureStore.dat");
    }

    public ILPEnvironmentConfig getEnvironmentConfig() {
        return this.environmentConfig;
    }

    public void setEnvironmentConfig(ILPEnvironmentConfig iLPEnvironmentConfig) {
        this.environmentConfig = iLPEnvironmentConfig;
        ILPBookSettingsHelper.instance().environmentConfigChanged();
    }

    public String getCloudEncryptionKey() {
        if (this.currentUser == null) {
            logger.c((Object)"Could not get cloudEncryptionKey, user is null");
            return null;
        }
        if (StringUtils.isBlank((CharSequence)this.cloudEncryptionKey)) {
            CloseableIterator closeableIterator = this.currentUser.getProperties().closeableIterator();
            try {
                try {
                    while (closeableIterator.hasNext()) {
                        ILPProperty iLPProperty = (ILPProperty)closeableIterator.next();
                        if (!iLPProperty.getKey().equals("cloud.encryptionKey")) continue;
                        this.cloudEncryptionKey = iLPProperty.getValueDecrypted();
                        break;
                    }
                }
                catch (Exception exception) {
                    logger.d((Object)"Could not get property: cloud.encryptionKey", (Throwable)exception);
                    try {
                        closeableIterator.close();
                    }
                    catch (IOException iOException) {
                        logger.d((Object)"Could not close iterator. ", (Throwable)iOException);
                    }
                }
            }
            finally {
                try {
                    closeableIterator.close();
                }
                catch (IOException iOException) {
                    logger.d((Object)"Could not close iterator. ", (Throwable)iOException);
                }
            }
        }
        return this.cloudEncryptionKey;
    }

    public d getLicensePermissionManager() {
        if (this.licensePermissionManager == null) {
            this.licensePermissionManager = new d();
        }
        return this.licensePermissionManager;
    }

    public void storeIdToken(String string) {
        try {
            SecureStore secureStore = ILPBookRegistry.instance().getProfileSecureStore();
            secureStore.removeEntry(KEYCHAIN_ID_TOKEN_KEY, KEYCHAIN_AUTH_SERVICE);
            if (StringUtils.isNotBlank((CharSequence)string)) {
                secureStore.addEntry(KEYCHAIN_ID_TOKEN_KEY, KEYCHAIN_AUTH_SERVICE, string);
            }
        }
        catch (Exception exception) {
            logger.d((Object)"Could not store id token in keychain", (Throwable)exception);
        }
    }

    public String loadIdToken() {
        SecureStore secureStore = ILPBookRegistry.instance().getProfileSecureStore();
        if (secureStore != null) {
            return secureStore.getEntry(KEYCHAIN_ID_TOKEN_KEY, KEYCHAIN_AUTH_SERVICE);
        }
        logger.d((Object)"Could not load id token from keychain, keychain is null");
        return null;
    }

    public void storeRefreshToken(String string) {
        try {
            SecureStore secureStore = ILPBookRegistry.instance().getProfileSecureStore();
            secureStore.removeEntry(KEYCHAIN_REFRESH_TOKEN_KEY, KEYCHAIN_AUTH_SERVICE);
            secureStore.addEntry(KEYCHAIN_REFRESH_TOKEN_KEY, KEYCHAIN_AUTH_SERVICE, string);
        }
        catch (Exception exception) {
            logger.d((Object)"Could not store refresh token in keychain", (Throwable)exception);
        }
    }

    public void storeSubject(String string) {
        try {
            SecureStore secureStore = ILPBookRegistry.instance().getProfileSecureStore();
            secureStore.removeEntry(KEYCHAIN_SUBJECT_KEY, KEYCHAIN_AUTH_SERVICE);
            secureStore.addEntry(KEYCHAIN_SUBJECT_KEY, KEYCHAIN_AUTH_SERVICE, string);
        }
        catch (Exception exception) {
            logger.d((Object)"Could not store refresh token in keychain", (Throwable)exception);
        }
    }

    public String loadRefreshToken() {
        SecureStore secureStore = ILPBookRegistry.instance().getProfileSecureStore();
        if (secureStore != null) {
            return secureStore.getEntry(KEYCHAIN_REFRESH_TOKEN_KEY, KEYCHAIN_AUTH_SERVICE);
        }
        logger.d((Object)"Coul not load refresh token from keychain, keychain is null");
        return null;
    }

    public String loadSubject() {
        SecureStore secureStore = ILPBookRegistry.instance().getProfileSecureStore();
        if (secureStore != null) {
            return secureStore.getEntry(KEYCHAIN_SUBJECT_KEY, KEYCHAIN_AUTH_SERVICE);
        }
        logger.d((Object)"Could not load subject from keychain, keychain is null");
        return null;
    }

    public void deleteTokensFromStore() {
        try {
            SecureStore secureStore = ILPBookRegistry.instance().getProfileSecureStore();
            secureStore.removeEntry(KEYCHAIN_REFRESH_TOKEN_KEY, KEYCHAIN_AUTH_SERVICE);
            secureStore.removeEntry(KEYCHAIN_ID_TOKEN_KEY, KEYCHAIN_AUTH_SERVICE);
            secureStore.removeEntry(KEYCHAIN_SUBJECT_KEY, KEYCHAIN_AUTH_SERVICE);
            secureStore.removeEntry(KEYCHAIN_CLIENT_ID_KEY, KEYCHAIN_AUTH_SERVICE);
            secureStore.removeEntry(KEYCHAIN_CLIENT_SECRET_KEY, KEYCHAIN_AUTH_SERVICE);
        }
        catch (Exception exception) {
            logger.d((Object)"Could not delete tokens in keychain", (Throwable)exception);
        }
    }

    public int hashCode() {
        int n2 = 31;
        int n3 = 1;
        n3 = 31 * n3 + (this.id == null ? 0 : this.id.hashCode());
        return n3;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ILPProfile iLPProfile = (ILPProfile)object;
        return !(this.id == null ? iLPProfile.id != null : !this.id.equals(iLPProfile.id));
    }

    public String toString() {
        return "ILPProfile [id=" + this.id + ", reference=" + this.reference + ", profileName=" + this.profileName + ", created at: " + this.getCreationDate() + ", email=" + StringHelper.maskEmail((String)this.email) + ", assetStage=" + this.assetStage + ", subject=" + this.subject + "]";
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(Date date) {
        this.creationDate = date;
    }

    public List<String> getProviders() {
        return this.providers;
    }

    public void setProviders(List<String> list) {
        this.providers = list;
    }

    public void migrateKeychainToSecureStore() {
        Object object;
        Object object2;
        if (!this.doesProfileKeychainExist()) {
            return;
        }
        logger.b((Object)"==== Start Keychain Migration ====");
        try {
            object2 = this.getProfileKeychain();
            object = object2.getStore();
            Enumeration<String> enumeration = ((KeyStore)object).aliases();
            while (enumeration.hasMoreElements()) {
                String string = enumeration.nextElement();
                if (!((KeyStore)object).isKeyEntry(string) || string == null || !string.contains("@")) continue;
                String string2 = StringHelper.extractStringFrom_until((String)string, (String)"@");
                String string3 = StringHelper.extractString_after((String)string, (String)"@");
                String string4 = object2.getPassword(string2, string3);
                string2 = string2.toUpperCase();
                string3 = string3.toUpperCase();
                this.getProfileSecureStore().addEntry(string2, string3, string4);
                logger.b((Object)"Successfully migrated entry: ");
                logger.b((Object)("Key: " + string2));
                logger.b((Object)("Conext (service): " + string3));
                logger.b((Object)("Password: " + StringHelper.obfuscate_afterLength((String)string4, (int)2)));
                logger.b((Object)"==============================");
            }
            logger.b((Object)"==== Successfully migrated Profile-Keychain ====");
        }
        catch (Exception exception) {
            logger.d((Object)"Could not migrate profile Keychain to SecureStore. Delete the old files anyway. ", (Throwable)exception);
        }
        try {
            object2 = new File(h.l(), ".profile.keystore");
            object = new File(object2 + ".bak");
            if (((File)object2).exists() && ((File)object2).delete()) {
                logger.b((Object)("Successfully deleted old Keystore: " + ((File)object2).getAbsolutePath()));
            }
            if (((File)object).exists() && ((File)object).delete()) {
                logger.b((Object)("Successfully deleted old Keystore Backup: " + ((File)object2).getAbsolutePath()));
            }
        }
        catch (Exception exception) {
            logger.d((Object)"Could not delete Profile-Keychain. ", (Throwable)exception);
        }
    }

    private boolean doesProfileKeychainExist() {
        File file = new File(h.l(), ".profile.keystore");
        return file.exists();
    }
}

