/*
 * Decompiled with CFR 0.152.
 */
package ch.ionesoft.ilp.book.co;

import ch.ionesoft.ilp.base.gdata.f;
import ch.ionesoft.ilp.book.mo.ILPIssueDef;
import java.util.ArrayList;
import java.util.List;

public abstract class ILPMigrationMapping {
    private boolean isRelevantMapping = false;
    private boolean writeAsComment = true;
    private List<String> notifications = new ArrayList<String>();
    private ILPIssueDef sourceIssue;
    private ILPIssueDef targetIssue;

    public void updateStatusOfMappingWith(MappingStatus mappingStatus, String string) {
        Boolean bl2;
        Boolean bl3 = mappingStatus.isRelevantMapping();
        if (bl3 != null && bl3.booleanValue()) {
            this.setRelevantMapping(bl3);
        }
        if ((bl2 = mappingStatus.isWriteAsComment()) != null && !bl2.booleanValue()) {
            this.setWriteAsComment(bl2);
        }
        this.getNotifications().add(String.valueOf(mappingStatus.getMessageCode()) + " : " + string);
    }

    public abstract f createMappingXMLElement();

    public boolean isWriteAsComment() {
        return this.writeAsComment;
    }

    public void setWriteAsComment(boolean bl2) {
        this.writeAsComment = bl2;
    }

    public boolean isRelevantMapping() {
        return this.isRelevantMapping;
    }

    public void setRelevantMapping(boolean bl2) {
        this.isRelevantMapping = bl2;
    }

    public List<String> getNotifications() {
        return this.notifications;
    }

    public void setNotifications(List<String> list) {
        this.notifications = list;
    }

    public String getSourceIssueId() {
        return this.sourceIssue.getIssueId();
    }

    public String getTargetIssueId() {
        return this.targetIssue != null ? this.targetIssue.getIssueId() : "";
    }

    public ILPIssueDef getTargetIssue() {
        return this.targetIssue;
    }

    public void setTargetIssue(ILPIssueDef iLPIssueDef) {
        this.targetIssue = iLPIssueDef;
    }

    public void setSourceIssue(ILPIssueDef iLPIssueDef) {
        this.sourceIssue = iLPIssueDef;
    }

    public ILPIssueDef getSourceIssue() {
        return this.sourceIssue;
    }

    public static enum MappingStatus {
        MAPPING_STATUS_MATCH(false, true, ""),
        TOPIC_MAPPING_STATUS_WARNING_DIFFERENT_ORDER(false, null, "W1 - different order"),
        TOPIC_MAPPING_STATUS_WARNING_DIFFERENT_ID(true, false, "W2 - different id"),
        EXERCISE_MAPPING_STATUS_WARNING_DIFFERENT_ID(false, null, "W3 - different id"),
        EXERCISE_MAPPING_STATUS_WARNING_DIFFERENT_REFERENCE(false, null, "W4 - different reference"),
        EXERCISE_MAPPING_STATUS_WARNING_DIFFERENT_TITLE(true, null, "W5 - different titles"),
        EXERCISE_MAPPING_STATUS_WARNING_MATCHING_TITLE_BUT_DIFFERENT_REFERENCE_AND_OR_ID(true, true, "W6 - matching title but different id and/or reference"),
        MAPPING_STATUS_WARNING_MULTIPLE_MATCHING_TARGETS(true, true, "W7 - multiple matches"),
        MAPPING_STATUS_ERROR_NO_MATCHING_TARGET(true, true, "E - missing target");

        private Boolean isRelevantMapping;
        private Boolean writeAsComment;
        private String messageCode;

        private MappingStatus(Boolean bl2, Boolean bl3, String string2) {
            this.setRelevantMapping(bl2);
            this.setWriteAsComment(bl3);
            this.setMessageCode(string2);
        }

        public Boolean isRelevantMapping() {
            return this.isRelevantMapping;
        }

        public void setRelevantMapping(Boolean bl2) {
            if (bl2 != null) {
                this.isRelevantMapping = bl2;
            }
        }

        public Boolean isWriteAsComment() {
            return this.writeAsComment;
        }

        public void setWriteAsComment(Boolean bl2) {
            if (bl2 != null) {
                this.writeAsComment = bl2;
            }
        }

        public String getMessageCode() {
            return this.messageCode;
        }

        public void setMessageCode(String string) {
            this.messageCode = string;
        }
    }
}

