/*
 * Decompiled with CFR 0.152.
 */
package ch.ionesoft.ilp.book.co;

import ch.ionesoft.ilp.base.co.ILPLogManager;
import ch.ionesoft.ilp.base.co.ILogger;
import ch.ionesoft.ilp.base.co.h;
import ch.ionesoft.ilp.base.gdata.e;
import ch.ionesoft.ilp.base.gdata.f;
import ch.ionesoft.ilp.base.he.ConverterUtil;
import ch.ionesoft.ilp.base.he.DESEncrypter;
import ch.ionesoft.ilp.base.he.FileHelper;
import ch.ionesoft.ilp.base.he.Helper;
import ch.ionesoft.ilp.base.he.StringHelper;
import ch.ionesoft.ilp.book.co.ILPBookSettingsHelper;
import ch.ionesoft.ilp.book.co.ILPBookTypes;
import ch.ionesoft.ilp.book.mo.ILPCourseDef;
import ch.ionesoft.ilp.book.mo.ILPCourseProduct;
import ch.ionesoft.ilp.book.mo.ILPExercise;
import ch.ionesoft.ilp.book.mo.ILPIssueDef;
import ch.ionesoft.ilp.book.mo.ILPTopic;
import ch.ionesoft.ilp.book.syn.a;
import ch.ionesoft.ilp.book.syn.d;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;

public class ILPMigrationManager {
    private static ILogger logger = ILPLogManager.getLogger(ILPMigrationManager.class);
    private static ILPMigrationManager instance = new ILPMigrationManager();
    private Map<ILPCourseProduct, Set<MappingElement>> mappingCache = new HashMap<ILPCourseProduct, Set<MappingElement>>();
    private Set<String> loadedMappingFiles = new HashSet<String>();

    public static ILPMigrationManager instance() {
        return instance;
    }

    private ILPMigrationManager() {
    }

    public List<ILPCourseProduct> getMigratableCoursesTo(ILPCourseProduct iLPCourseProduct) {
        ArrayList<ILPCourseProduct> arrayList = new ArrayList<ILPCourseProduct>();
        if (iLPCourseProduct == null) {
            return arrayList;
        }
        this.loadMigrationMappingsForCourse(iLPCourseProduct);
        Set<MappingElement> set = this.mappingCache.get(iLPCourseProduct);
        if (set == null) {
            return arrayList;
        }
        for (MappingElement mappingElement : set) {
            ILPCourseProduct iLPCourseProduct2 = mappingElement.sourceCourse;
            if (iLPCourseProduct2 == null) {
                logger.c((Object)("Invalid mapping element, sourceCourse is null: " + mappingElement));
                continue;
            }
            if (!this.isCourseMigratableTo(iLPCourseProduct2, iLPCourseProduct)) continue;
            arrayList.add(iLPCourseProduct2);
        }
        Collections.sort(arrayList, new Comparator<ILPCourseProduct>(){

            @Override
            public int compare(ILPCourseProduct iLPCourseProduct, ILPCourseProduct iLPCourseProduct2) {
                return iLPCourseProduct.getEdition() - iLPCourseProduct2.getEdition();
            }
        });
        return arrayList;
    }

    public void removeMappingsForTargetCourse(ILPCourseProduct iLPCourseProduct) {
        Set<MappingElement> set = this.mappingCache.get(iLPCourseProduct);
        if (set != null) {
            for (MappingElement mappingElement : set) {
                this.mappingCache.remove(mappingElement);
                String string = this.buildMappingFileKey(mappingElement.mappingFile);
                this.loadedMappingFiles.remove(string);
            }
        }
    }

    private boolean isCourseMigratableTo(ILPCourseProduct iLPCourseProduct, ILPCourseProduct iLPCourseProduct2) {
        if (iLPCourseProduct.equals(iLPCourseProduct2)) {
            return false;
        }
        if (iLPCourseProduct.getEdition() >= iLPCourseProduct2.getEdition()) {
            return false;
        }
        if (iLPCourseProduct.getHasCloudData().booleanValue()) {
            return true;
        }
        return iLPCourseProduct.getCourse() != null && iLPCourseProduct.getCourse().hasSyncData();
    }

    private String mappingsDirForCourse(ILPCourseProduct iLPCourseProduct) {
        return ILPBookSettingsHelper.instance().mappingsDirForCourse(iLPCourseProduct);
    }

    private void loadMigrationMappingsForCourse(ILPCourseProduct iLPCourseProduct) {
        File file = new File(this.mappingsDirForCourse(iLPCourseProduct));
        File[] fileArray = file.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File file, String string) {
                return string.endsWith("xml");
            }
        });
        if (fileArray == null || fileArray.length == 0) {
            return;
        }
        File[] fileArray2 = fileArray;
        int n2 = fileArray.length;
        int n3 = 0;
        while (n3 < n2) {
            File file2 = fileArray2[n3];
            if (!this.isMappingFileLoaded(file2)) {
                this.loadMappingFile(file2);
            }
            ++n3;
        }
    }

    private boolean isMappingFileLoaded(File file) {
        String string = this.buildMappingFileKey(file);
        return this.loadedMappingFiles.contains(string);
    }

    private String buildMappingFileKey(File file) {
        Date date = FileHelper.getFileModificationDate((String)file.getAbsolutePath());
        return String.valueOf(file.getAbsolutePath()) + "_" + date;
    }

    private void loadMappingFile(File file) {
        try {
            e e2;
            logger.b((Object)("Loading mapping file: " + file.getName()));
            String string = this.buildMappingFileKey(file);
            MappingElement mappingElement = new MappingElement();
            DESEncrypter dESEncrypter = h.ai();
            try {
                e2 = e.a((File)file, (boolean)false, (DESEncrypter)dESEncrypter);
            }
            catch (Exception exception) {
                logger.c((Object)("Mapping file cannot be parsed, trying without encryption: " + file + ". Reason: " + exception));
                e2 = e.a((File)file, (boolean)false, null);
                try {
                    dESEncrypter.encrypt(file);
                }
                catch (Exception exception2) {
                    // empty catch block
                }
            }
            boolean bl2 = e2.a().a("delete", Boolean.valueOf(false));
            if (bl2) {
                logger.b((Object)("Deleting mappingFile: " + file));
                FileUtils.deleteQuietly((File)file);
                this.loadedMappingFiles.remove(string);
                return;
            }
            ILPCourseProduct iLPCourseProduct = this.parseCourseOnDocument_elementName(e2, "//targetCourse");
            ILPCourseProduct iLPCourseProduct2 = this.parseCourseOnDocument_elementName(e2, "//sourceCourse");
            if (iLPCourseProduct2 == null || iLPCourseProduct == null) {
                logger.c((Object)("Source course product: " + iLPCourseProduct2 + ", or target course product: " + iLPCourseProduct + " not loaded, might not have a license. Aborting mapping file detection"));
                return;
            }
            mappingElement.document = e2;
            mappingElement.targetCourse = iLPCourseProduct;
            mappingElement.sourceCourse = iLPCourseProduct2;
            mappingElement.mappingFile = file;
            this.loadedMappingFiles.add(string);
            Set<MappingElement> set = this.mappingCache.get(iLPCourseProduct);
            if (set == null) {
                set = new HashSet<MappingElement>();
                this.mappingCache.put(iLPCourseProduct, set);
            }
            if (!set.contains(mappingElement)) {
                set.add(mappingElement);
            }
        }
        catch (Exception exception) {
            Helper.logActionText_withException((String)("Could not load mapping file: " + file), (Throwable)exception);
        }
    }

    private ILPCourseProduct parseCourseOnDocument_elementName(e e2, String string) {
        ILPCourseProduct iLPCourseProduct = null;
        List list = e2.c(string);
        if (list.size() != 1) {
            logger.d((Object)("Could not find element with xpath: " + string + " in mapping file"));
            return iLPCourseProduct;
        }
        f f2 = (f)list.get(0);
        String string2 = f2.c("courseId", null);
        String string3 = f2.c("reference", null);
        Integer n2 = f2.a("edition", null);
        iLPCourseProduct = ch.ionesoft.ilp.book.pe.f.a().j(string2, string3);
        if (iLPCourseProduct == null) {
            logger.d((Object)("Could not find course with courseId: " + string2 + ", courseReference: " + string3));
            return iLPCourseProduct;
        }
        if (!iLPCourseProduct.getEdition().equals(n2)) {
            logger.c((Object)("Invalid edition specified in mapping file on: " + string + ". Specified: " + n2 + ", but actually: " + iLPCourseProduct.getEdition()));
        }
        return iLPCourseProduct;
    }

    public ILPIssueDef determineIssueForImportIntoCourse(ILPCourseProduct iLPCourseProduct, ILPIssueDef iLPIssueDef) {
        if (iLPCourseProduct == null) {
            return iLPIssueDef;
        }
        if (iLPIssueDef == null) {
            return iLPIssueDef;
        }
        if (iLPIssueDef.getCourse().getCourseProduct().equals(iLPCourseProduct)) {
            return iLPIssueDef;
        }
        List<MappingElement> list = this.getMappingElementsForTargetCourse_fromSourceCourse(iLPCourseProduct, iLPIssueDef.getCourse().getCourseProduct());
        for (MappingElement mappingElement : list) {
            ILPIssueDef iLPIssueDef2 = this.fetchTargetIssueFromSourceIssue_inTargetCourse_usingMappingElement(iLPIssueDef, iLPCourseProduct, mappingElement);
            if (iLPIssueDef2 == null) continue;
            return iLPIssueDef2;
        }
        return iLPIssueDef;
    }

    private ILPIssueDef fetchTargetIssueFromSourceIssue_inTargetCourse_usingMappingElement(ILPIssueDef iLPIssueDef, ILPCourseProduct iLPCourseProduct, MappingElement mappingElement) {
        try {
            Object object2;
            String string = iLPIssueDef.getIssueId();
            List<f> list = this.fetchIssueElementsForSourceIssue_document(iLPIssueDef, mappingElement.document);
            for (Object object2 : list) {
                String string2 = object2.c("sourceIssueId", null);
                if (!iLPIssueDef.getIssueId().equals(string2)) continue;
                string = object2.c("targetIssueId", string);
            }
            object2 = ch.ionesoft.ilp.book.pe.f.a().d(string, iLPCourseProduct.getCourseIdentifier(), iLPCourseProduct.getCourseReference());
            if (object2 == null) {
                logger.c((Object)("No target issue found from mappings with issueId: " + iLPIssueDef.getIssueId()));
            }
            return object2;
        }
        catch (Exception exception) {
            logger.d((Object)("Could not detect targetIssue for sourceIssue: " + iLPIssueDef), (Throwable)exception);
            return iLPIssueDef;
        }
    }

    public ILPTopic determineTopicForImportIntoCourse(ILPCourseProduct iLPCourseProduct, ILPTopic iLPTopic) {
        if (iLPCourseProduct == null) {
            return iLPTopic;
        }
        if (iLPTopic == null) {
            return iLPTopic;
        }
        if (iLPTopic.getIssue().getCourse().getCourseProduct().equals(iLPCourseProduct)) {
            return iLPTopic;
        }
        List<MappingElement> list = this.getMappingElementsForTargetCourse_fromSourceCourse(iLPCourseProduct, iLPTopic.getIssue().getCourse().getCourseProduct());
        for (MappingElement mappingElement : list) {
            ILPTopic iLPTopic2 = this.fetchTargetTopicFromSourceTopic_inTargetCourse_usingMappingElement(iLPTopic, iLPCourseProduct, mappingElement);
            if (iLPTopic2 == null) continue;
            return iLPTopic2;
        }
        return iLPTopic;
    }

    public ILPExercise determineExerciseForImportIntoCourse(ILPCourseProduct iLPCourseProduct, ILPExercise iLPExercise) {
        if (iLPCourseProduct == null) {
            return iLPExercise;
        }
        if (iLPExercise == null) {
            return iLPExercise;
        }
        if (iLPExercise.getIssue().getCourse().getCourseProduct().equals(iLPCourseProduct)) {
            return iLPExercise;
        }
        List<MappingElement> list = this.getMappingElementsForTargetCourse_fromSourceCourse(iLPCourseProduct, iLPExercise.getIssue().getCourse().getCourseProduct());
        for (MappingElement mappingElement : list) {
            ILPExercise iLPExercise2 = this.fetchTargetExerciseFromSourceExercise_inTargetCourse_usingMappingElement(iLPExercise, iLPCourseProduct, mappingElement);
            if (iLPExercise2 == null) continue;
            return iLPExercise2;
        }
        return iLPExercise;
    }

    private List<MappingElement> getMappingElementsForTargetCourse_fromSourceCourse(ILPCourseProduct iLPCourseProduct, ILPCourseProduct iLPCourseProduct2) {
        this.loadMigrationMappingsForCourse(iLPCourseProduct);
        ArrayList<MappingElement> arrayList = new ArrayList<MappingElement>();
        Set<MappingElement> set = this.mappingCache.get(iLPCourseProduct);
        if (set == null) {
            return arrayList;
        }
        for (MappingElement mappingElement : set) {
            if (!mappingElement.sourceCourse.equals(iLPCourseProduct2) || !mappingElement.targetCourse.equals(iLPCourseProduct)) continue;
            arrayList.add(mappingElement);
        }
        return arrayList;
    }

    private ILPTopic fetchTargetTopicFromSourceTopic_inTargetCourse_usingMappingElement(ILPTopic iLPTopic, ILPCourseProduct iLPCourseProduct, MappingElement mappingElement) {
        Object object2;
        Integer n2;
        int n3;
        String string;
        String string2;
        String string3;
        ILPTopic iLPTopic2;
        block26: {
            block25: {
                try {
                    iLPTopic2 = null;
                    string3 = iLPTopic.getIssue().getIssueId();
                    string2 = null;
                    string = null;
                    boolean bl2 = false;
                    n3 = 0;
                    n2 = null;
                    List<f> list = this.fetchIssueElementsForSourceIssue_document(iLPTopic.getIssue(), mappingElement.document);
                    for (Object object2 : list) {
                        String string4;
                        string3 = object2.c("targetIssueId", null);
                        if (object2.r().size() == 0) {
                            int n4 = 0;
                            string4 = object2.c("topicIdShift", null);
                            if (StringUtils.isNotEmpty((CharSequence)string4)) {
                                n4 = ConverterUtil.convertDecimalStringToInteger_defaultValue((String)string4, (Integer)0);
                            }
                            string2 = this.applyShift(iLPTopic.getAccessPath(), n4);
                            bl2 = object2.a("exclude", Boolean.valueOf(bl2));
                        } else {
                            List list2 = null;
                            if (StringUtils.isNotEmpty((CharSequence)iLPTopic.getAccessPath())) {
                                string4 = String.format("topic[@sourceTopicId='%s']", iLPTopic.getAccessPath());
                                list2 = object2.m(string4);
                            }
                            if (list2 == null || list2.size() == 0) {
                                string4 = String.format("topic[@sourceTopicTitle='%s']", iLPTopic.getTitle());
                                list2 = object2.m(string4);
                            }
                            f f2 = null;
                            if (list2.size() >= 1) {
                                for (f f3 : list2) {
                                    Integer n5 = f3.b("sourceTopicOrder", null);
                                    if (n5 == null || n5 != iLPTopic.getOrder()) continue;
                                    f2 = f3;
                                    break;
                                }
                                if (f2 == null && list2.size() > 1) {
                                    logger.c((Object)("More than one topic element is matching the sourceTopic: " + iLPTopic + ". Taking first"));
                                }
                                if (f2 == null) {
                                    f2 = (f)list2.get(0);
                                }
                                if ((string2 = f2.c("targetTopicId", string2)) == null) {
                                    string = f2.c("targetTopicTitle", string);
                                }
                                n3 = f2.a("targetTopicOccurrence", Integer.valueOf(1)) - 1;
                                n2 = f2.b("targetTopicOrder", null);
                            }
                            boolean bl3 = bl2 = f2 != null ? f2.a("exclude", Boolean.valueOf(bl2)) : false;
                        }
                        if (StringUtils.isNotBlank((CharSequence)string) || StringUtils.isNotBlank((CharSequence)string2)) break;
                    }
                    if (!bl2) break block25;
                    return null;
                }
                catch (Exception exception) {
                    logger.d((Object)("Could not detect targetTopic for sourceTopic: " + iLPTopic), (Throwable)exception);
                    return iLPTopic;
                }
            }
            if (!StringUtils.isBlank((CharSequence)string3)) break block26;
            logger.c((Object)"No targetIssueId defined or found with");
            return null;
        }
        object2 = ch.ionesoft.ilp.book.pe.f.a().d(string3, iLPCourseProduct.getCourseIdentifier(), iLPCourseProduct.getCourseReference());
        if (StringUtils.isEmpty(string2)) {
            string2 = iLPTopic.getAccessPath();
        }
        if (StringUtils.isEmpty(string)) {
            string = iLPTopic.getTitle();
        }
        if (StringUtils.isNotBlank((CharSequence)string2)) {
            iLPTopic2 = ch.ionesoft.ilp.book.pe.f.a().h(string2, (ILPIssueDef)object2);
        }
        if (iLPTopic2 == null && n2 != null) {
            iLPTopic2 = ch.ionesoft.ilp.book.pe.f.a().b(n2, (ILPIssueDef)object2);
        }
        if (iLPTopic2 == null && StringUtils.isNotEmpty((CharSequence)string)) {
            List<ILPTopic> list = ch.ionesoft.ilp.book.pe.f.a().a(string, (int)iLPTopic.getLevel(), (ILPIssueDef)object2);
            if (list.size() > n3) {
                iLPTopic2 = (ILPTopic)list.get(n3);
            }
            if (iLPTopic2 == null && (list = ch.ionesoft.ilp.book.pe.f.a().a(string, (ILPIssueDef)object2)).size() > n3) {
                iLPTopic2 = list.get(n3);
            }
            if (list.size() > 1) {
                logger.c((Object)("More than one topic found with same title: " + string + " and level: " + iLPTopic.getLevel() + " for sourceTopic: " + iLPTopic + ". Taking first"));
                if (iLPTopic2 == null) {
                    iLPTopic2 = list.get(0);
                }
            }
        }
        if (iLPTopic2 == null && (StringUtils.isNotEmpty((CharSequence)string) || StringUtils.isNotEmpty((CharSequence)string2)) && !iLPTopic.isUserTopic().booleanValue()) {
            logger.c((Object)("No topic found with same title: " + string + " or topicId: " + string2 + " with level " + iLPTopic.getLevel() + " for sourceTopic: " + iLPTopic));
        }
        return iLPTopic2;
    }

    private ILPExercise fetchTargetExerciseFromSourceExercise_inTargetCourse_usingMappingElement(ILPExercise iLPExercise, ILPCourseProduct iLPCourseProduct, MappingElement mappingElement) {
        ILPExercise iLPExercise2;
        block21: {
            String string;
            String string2;
            block20: {
                Object object2;
                ILPExercise.ExerciseGroup exerciseGroup;
                Integer n2;
                Integer n3;
                Integer n4;
                String string3;
                block19: {
                    try {
                        iLPExercise2 = null;
                        string3 = iLPExercise.getIssue().getIssueId();
                        string2 = null;
                        string = null;
                        n4 = null;
                        n3 = null;
                        n2 = null;
                        exerciseGroup = iLPExercise.getExerciseGroup();
                        boolean bl2 = false;
                        List<f> list = this.fetchIssueElementsForSourceIssue_document(iLPExercise.getIssue(), mappingElement.document);
                        for (Object object2 : list) {
                            Object object3;
                            string3 = object2.c("targetIssueId", null);
                            if (object2.r().size() == 0) {
                                int n5 = 0;
                                object3 = object2.c("exerciseIdShift", null);
                                if (StringUtils.isNotEmpty((CharSequence)object3)) {
                                    n5 = ConverterUtil.convertDecimalStringToInteger_defaultValue((String)object3, (Integer)0);
                                }
                                string2 = this.applyShift(iLPExercise.getExerciseId(), n5);
                                n4 = object2.b("exerciseGroup", null);
                                n3 = object2.b("sourceExerciseGroup", null);
                                n2 = object2.b("targetExerciseGroup", null);
                                bl2 = object2.a("exclude", Boolean.valueOf(bl2));
                            } else {
                                String string4 = String.format("exercise[@sourceExerciseId='%s']", iLPExercise.getExerciseId());
                                object3 = object2.m(string4);
                                if (object3.size() == 0) {
                                    string4 = String.format("exercise[@sourceExerciseReference='%s']", iLPExercise.getReference());
                                    object3 = object2.m(string4);
                                }
                                f f2 = null;
                                if (object3.size() > 1) {
                                    logger.c((Object)("More than one exercise element is matching the sourceExercise: " + iLPExercise + ". Taking first"));
                                }
                                if (object3.size() >= 1 && (string2 = (f2 = (f)object3.get(0)).c("targetExerciseId", string2)) == null) {
                                    string = f2.c("targetExerciseReference", string);
                                }
                                if (f2 != null) {
                                    n4 = f2.b("exerciseGroup", null);
                                    n3 = f2.b("sourceExerciseGroup", null);
                                    n2 = f2.b("targetExerciseGroup", null);
                                    bl2 = f2.a("exclude", Boolean.valueOf(bl2));
                                }
                            }
                            if (StringUtils.isNotBlank((CharSequence)string2) || n2 != null) break;
                        }
                        if (!bl2) break block19;
                        return null;
                    }
                    catch (Exception exception) {
                        logger.d((Object)("Could not detect targetExercise for sourceExercise: " + iLPExercise), (Throwable)exception);
                        return iLPExercise;
                    }
                }
                if (n4 != null && n4.intValue() != iLPExercise.getExerciseGroup().getCode()) {
                    return iLPExercise;
                }
                if (n3 != null && n3.intValue() == iLPExercise.getExerciseGroup().getCode()) {
                    exerciseGroup = ILPExercise.ExerciseGroup.get(n2);
                }
                object2 = ch.ionesoft.ilp.book.pe.f.a().d(string3, iLPCourseProduct.getCourseIdentifier(), iLPCourseProduct.getCourseReference());
                if (StringUtils.isEmpty(string2)) {
                    string2 = iLPExercise.getExerciseId();
                }
                if (StringUtils.isEmpty(string)) {
                    string = iLPExercise.getReference();
                }
                if (iLPExercise2 == null && StringUtils.isNotEmpty((CharSequence)string)) {
                    iLPExercise2 = ch.ionesoft.ilp.book.pe.f.a().a(string, (ILPIssueDef)object2, exerciseGroup);
                }
                if (StringUtils.isNotBlank((CharSequence)string2)) {
                    iLPExercise2 = ch.ionesoft.ilp.book.pe.f.a().c(string2, (ILPIssueDef)object2, exerciseGroup);
                }
                if (iLPExercise2 != null || !StringUtils.isNotEmpty((CharSequence)string) && !StringUtils.isNotEmpty((CharSequence)string2)) break block20;
                logger.c((Object)("No exercise found with same reference: " + string + " or exerciseId: " + string2 + " for " + " for sourceExercise: " + iLPExercise));
                return null;
            }
            if (iLPExercise2.getExerciseType().equals((Object)iLPExercise.getExerciseType())) break block21;
            logger.c((Object)("Exercise with reference: " + string + " or exerciseId: " + string2 + " does not have the same exerciseType(" + (Object)((Object)iLPExercise2.getExerciseType()) + ") as sourceExercise: " + iLPExercise));
            return null;
        }
        return iLPExercise2;
    }

    private String applyShift(String string, int n2) {
        if (StringUtils.isEmpty((CharSequence)string) || n2 == 0) {
            return string;
        }
        String string2 = StringHelper.extractPrefixInteger((String)string);
        if (string2.length() > 0) {
            int n3 = Integer.parseInt(string2);
            int n4 = n3 + n2;
            String string3 = StringHelper.replaceFirstOccurrenceOfString_withString_inString((String)string2, (String)("" + n4), (String)string);
            return string3;
        }
        return string;
    }

    private List<f> fetchIssueElementsForSourceIssue_document(ILPIssueDef iLPIssueDef, e e2) {
        String string = String.format("//issue[@sourceIssueId='%s']", iLPIssueDef.getIssueId());
        return e2.c(string);
    }

    public ILPCourseDef prepareFleetingCourseMigration(ILPCourseProduct iLPCourseProduct) {
        ILPCourseDef iLPCourseDef = iLPCourseProduct.getCourse();
        if (iLPCourseDef == null || iLPCourseDef.getEProduct().getContentState().intValue() != ILPBookTypes.ContentState.CONTENT_STATE_FULLY_LOADED.getType()) {
            iLPCourseProduct.getEProduct().install(new a());
            iLPCourseDef = iLPCourseProduct.getCourse();
            if (iLPCourseDef == null) {
                logger.c((Object)String.format(Locale.ENGLISH, "Could not install migrateFromCourse for fleeting course migration. courseId: %s, courseReference: %s", iLPCourseProduct.getCourseIdentifier(), iLPCourseProduct.getCourseReference()));
                return iLPCourseDef;
            }
        }
        d.a().a(iLPCourseDef, true, false);
        return iLPCourseDef;
    }

    private class MappingElement {
        private ILPCourseProduct targetCourse;
        private ILPCourseProduct sourceCourse;
        private e document;
        private File mappingFile;

        private MappingElement() {
        }

        public int hashCode() {
            int n2 = 31;
            int n3 = 1;
            n3 = 31 * n3 + this.getOuterType().hashCode();
            n3 = 31 * n3 + (this.sourceCourse == null ? 0 : this.sourceCourse.hashCode());
            n3 = 31 * n3 + (this.targetCourse == null ? 0 : this.targetCourse.hashCode());
            return n3;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            MappingElement mappingElement = (MappingElement)object;
            if (!this.getOuterType().equals(mappingElement.getOuterType())) {
                return false;
            }
            if (this.sourceCourse == null ? mappingElement.sourceCourse != null : !this.sourceCourse.equals(mappingElement.sourceCourse)) {
                return false;
            }
            return !(this.targetCourse == null ? mappingElement.targetCourse != null : !this.targetCourse.equals(mappingElement.targetCourse));
        }

        private ILPMigrationManager getOuterType() {
            return ILPMigrationManager.this;
        }
    }
}

