/*
 * Decompiled with CFR 0.152.
 */
package ch.ionesoft.ilp.book.co;

import ch.ionesoft.ilp.base.co.ILPLogManager;
import ch.ionesoft.ilp.base.co.ILogger;
import ch.ionesoft.ilp.base.gdata.b;
import ch.ionesoft.ilp.base.gdata.c;
import ch.ionesoft.ilp.base.gdata.d;
import ch.ionesoft.ilp.base.gdata.e;
import ch.ionesoft.ilp.base.gdata.f;
import ch.ionesoft.ilp.base.gdata.i;
import ch.ionesoft.ilp.base.he.StringHelper;
import ch.ionesoft.ilp.book.co.ILPMigrationMapping;
import ch.ionesoft.ilp.book.co.ILPMigrationMappingExercise;
import ch.ionesoft.ilp.book.co.ILPMigrationMappingTopic;
import ch.ionesoft.ilp.book.mo.ILPCourseDef;
import ch.ionesoft.ilp.book.mo.ILPExercise;
import ch.ionesoft.ilp.book.mo.ILPIssueDef;
import ch.ionesoft.ilp.book.mo.ILPTopic;
import ch.ionesoft.ilp.book.pe.j;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class ILPMigrationFileGenerator {
    private static final String MIGRATION_ATTRIBUTE_VALUE_MAP_ALL = "all";
    private static final String MIGRATION_ATTRIBUTE_NAME_MAP = "map";
    private static final String MIGRATION_ELEMENT_NAME_ISSUE = "issue";
    private static final String MIGRATION_ATTRIBUTE_NAME_TARGET_ISSUE_TITLE = "targetIssueTitle";
    private static final String MIGRATION_ATTRIBUTE_NAME_TARGET_ISSUE_ID = "targetIssueId";
    private static final String MIGRATION_ATTRIBUTE_NAME_SOURCE_ISSUE_TITLE = "sourceIssueTitle";
    private static final String MIGRATION_ATTRIBUTE_NAME_SOURCE_ISSUE_ID = "sourceIssueId";
    private static final String ERROR_MSG_EMPTY_TARGET_ISSUE_ID = "E - EMTY TARGET ISSUE ID";
    private static ILogger logger = ILPLogManager.getLogger(ILPMigrationFileGenerator.class);
    private StringBuilder HTMLResponseBuilder = new StringBuilder();
    private Boolean createTemplate;

    public void generateTemplateMappingFile(ILPCourseDef iLPCourseDef, File file) {
        this.setCreateTemplate(true);
        if (!this.courseHasTopicsOrExercises(iLPCourseDef)) {
            String string = "Could not generate migration file. Source course is null or has no topics and exercises. Source course is: " + iLPCourseDef;
            logger.d((Object)string);
            this.HTMLResponseBuilder.append("<p>" + string + "</p>");
            return;
        }
        try {
            List<ILPIssueDef> list = ch.ionesoft.ilp.book.pe.f.a().h(iLPCourseDef.getCourseId(), iLPCourseDef.getReference());
            List<ILPMigrationMappingTopic> list2 = this.createTopicMappings(list, null);
            List<ILPMigrationMappingExercise> list3 = this.createExerciseMappings(list, null);
            ArrayList<ILPMigrationMapping> arrayList = new ArrayList<ILPMigrationMapping>();
            arrayList.addAll(list2);
            arrayList.addAll(list3);
            File file2 = this.writeMigrationMappingFile(arrayList, iLPCourseDef, null, file);
            this.HTMLResponseBuilder.append("<p>Output to: " + file2 + ".</p>");
            this.HTMLResponseBuilder.append("<p>Finished.</p>");
        }
        catch (j j2) {
            String string = "Could not generate template migration mapping file for source course with reference '" + iLPCourseDef.getReference() + "'. Probably problem fetching topics.";
            logger.d((Object)string, (Throwable)j2);
            this.HTMLResponseBuilder.append("<p>Finished with error(s): </p><p>" + string + "</p>");
        }
        catch (Exception exception) {
            String string = "Could not generate migration mapping file for source course with reference '" + iLPCourseDef.getReference() + "'.";
            logger.d((Object)string, (Throwable)exception);
            this.HTMLResponseBuilder.append("Finished with error(s): </p><p>" + string + "</p>");
        }
    }

    public void generateMigrationFileForCourses(ILPCourseDef iLPCourseDef, ILPCourseDef iLPCourseDef2, File file, String string) throws IOException {
        this.setCreateTemplate(false);
        if (!this.courseHasTopicsOrExercises(iLPCourseDef)) {
            String string2 = "Could not generate migration file. Source course is null or has no topics and exercises. Source course is: " + iLPCourseDef;
            logger.d((Object)string2);
            this.HTMLResponseBuilder.append("<p>" + string2 + "</p>");
            return;
        }
        if (!this.courseHasTopicsOrExercises(iLPCourseDef2)) {
            String string3 = "Could not generate migration file. Target course is null or has no topics and exercises. Target course is: " + iLPCourseDef2;
            logger.d((Object)string3);
            this.HTMLResponseBuilder.append("<p>" + string3 + "</p>");
            return;
        }
        ILPMigrationMapping.MappingStatus.TOPIC_MAPPING_STATUS_WARNING_DIFFERENT_ORDER.setRelevantMapping(false);
        if (StringHelper.isNotBlank((String)string) && string.equals("true")) {
            logger.b((Object)"Different order is relevant mapping, will be shown in mapping file.");
            ILPMigrationMapping.MappingStatus.TOPIC_MAPPING_STATUS_WARNING_DIFFERENT_ORDER.setRelevantMapping(true);
        }
        try {
            List<ILPIssueDef> list = ch.ionesoft.ilp.book.pe.f.a().h(iLPCourseDef.getCourseId(), iLPCourseDef.getReference());
            List<ILPIssueDef> list2 = ch.ionesoft.ilp.book.pe.f.a().h(iLPCourseDef2.getCourseId(), iLPCourseDef2.getReference());
            List<ILPMigrationMappingTopic> list3 = this.createTopicMappings(list, list2);
            List<ILPMigrationMappingExercise> list4 = this.createExerciseMappings(list, list2);
            ArrayList<ILPMigrationMapping> arrayList = new ArrayList<ILPMigrationMapping>();
            arrayList.addAll(list3);
            arrayList.addAll(list4);
            File file2 = this.writeMigrationMappingFile(arrayList, iLPCourseDef, iLPCourseDef2, file);
            this.HTMLResponseBuilder.append("<p>Output to: " + file2 + ".</p>");
            this.HTMLResponseBuilder.append("<p>Finished.</p>");
        }
        catch (j j2) {
            String string4 = "Could not generate migration mapping file for source course with reference '" + iLPCourseDef.getReference() + "' and target course with reference '" + iLPCourseDef2.getReference() + "'. Probably problem fetching topics.";
            logger.d((Object)string4, (Throwable)j2);
            this.HTMLResponseBuilder.append("<p>Finished with error(s): </p><p>" + string4 + "</p>");
        }
        catch (Exception exception) {
            String string5 = "Could not generate migration mapping file for source course with reference '" + iLPCourseDef.getReference() + "' and target course with reference '" + iLPCourseDef2.getReference() + "'.";
            logger.d((Object)string5, (Throwable)exception);
            this.HTMLResponseBuilder.append("Finished with error(s): </p><p>" + string5 + "</p>");
        }
    }

    public boolean courseHasTopicsOrExercises(ILPCourseDef iLPCourseDef) {
        List<ILPTopic> list = this.fetchAllTopicsOfCourse(iLPCourseDef);
        List<ILPExercise> list2 = this.fetchAllExercisesOfCourse(iLPCourseDef);
        return iLPCourseDef != null && (!list.isEmpty() || !list2.isEmpty());
    }

    private List<ILPTopic> fetchAllTopicsOfCourse(ILPCourseDef iLPCourseDef) {
        ArrayList<ILPTopic> arrayList = new ArrayList<ILPTopic>();
        try {
            List<ILPIssueDef> list = ch.ionesoft.ilp.book.pe.f.a().h(iLPCourseDef.getCourseId(), iLPCourseDef.getReference());
            for (ILPIssueDef iLPIssueDef : list) {
                arrayList.addAll(ch.ionesoft.ilp.book.pe.f.a().f(iLPIssueDef));
            }
            return arrayList;
        }
        catch (j j2) {
            logger.d((Object)("Could not fetch all topics of course: " + iLPCourseDef));
            return arrayList;
        }
    }

    private List<ILPExercise> fetchAllExercisesOfCourse(ILPCourseDef iLPCourseDef) {
        ArrayList<ILPExercise> arrayList = new ArrayList<ILPExercise>();
        try {
            List<ILPIssueDef> list = ch.ionesoft.ilp.book.pe.f.a().h(iLPCourseDef.getCourseId(), iLPCourseDef.getReference());
            for (ILPIssueDef iLPIssueDef : list) {
                List<ILPExercise.ExerciseGroup> list2 = ch.ionesoft.ilp.book.pe.f.a().I(iLPIssueDef);
                for (ILPExercise.ExerciseGroup exerciseGroup : list2) {
                    arrayList.addAll(ch.ionesoft.ilp.book.pe.f.a().d(iLPIssueDef, exerciseGroup));
                }
            }
            return arrayList;
        }
        catch (j j2) {
            logger.d((Object)("Could not fetch all exercises of course: " + iLPCourseDef));
            return arrayList;
        }
    }

    private List<ILPMigrationMappingTopic> createTopicMappings(List<ILPIssueDef> list, List<ILPIssueDef> list2) throws j {
        ArrayList<ILPMigrationMappingTopic> arrayList = new ArrayList<ILPMigrationMappingTopic>();
        for (ILPIssueDef iLPIssueDef : list) {
            ILPMigrationMappingTopic iLPMigrationMappingTopic;
            List<ILPTopic> list3 = ch.ionesoft.ilp.book.pe.f.a().f(iLPIssueDef);
            ILPIssueDef iLPIssueDef2 = this.retrieveEquivalentIssue(iLPIssueDef, list2);
            if (iLPIssueDef2 == null) {
                for (ILPTopic iLPTopic : list3) {
                    iLPMigrationMappingTopic = new ILPMigrationMappingTopic(iLPTopic, this.checkIfIsUnique(iLPTopic));
                    iLPMigrationMappingTopic.updateStatusOfMappingWith(ILPMigrationMapping.MappingStatus.MAPPING_STATUS_ERROR_NO_MATCHING_TARGET, "");
                    iLPMigrationMappingTopic.setTargetIssue(null);
                    arrayList.add(iLPMigrationMappingTopic);
                }
                continue;
            }
            for (ILPTopic iLPTopic : list3) {
                iLPMigrationMappingTopic = this.determineAndAddTargetTopicForSourceTopicInIssues(iLPTopic, iLPIssueDef2);
                arrayList.add(iLPMigrationMappingTopic);
            }
        }
        return arrayList;
    }

    private boolean checkIfIsUnique(ILPTopic iLPTopic) {
        List<ILPTopic> list;
        Object object;
        ILPIssueDef iLPIssueDef;
        block3: {
            iLPIssueDef = iLPTopic.getIssue();
            try {
                String string = iLPTopic.getTitle();
                if (!StringHelper.isNotBlank((String)string) || !((object = ch.ionesoft.ilp.book.pe.f.a().a(string, iLPIssueDef)) != null & object.size() > 1)) break block3;
                return false;
            }
            catch (j j2) {
                logger.d((Object)"Could not determine if topic is unique.", (Throwable)j2);
                return false;
            }
        }
        object = iLPTopic.getAccessPath();
        return !StringHelper.isNotBlank((String)object) || !((list = this.fetchTopicsWithAccessPath((String)object, iLPIssueDef)) != null & list.size() > 1);
    }

    private List<ILPTopic> fetchTopicsWithAccessPath(String string, ILPIssueDef iLPIssueDef) {
        ArrayList<ILPTopic> arrayList = new ArrayList<ILPTopic>();
        try {
            List<ILPTopic> list = ch.ionesoft.ilp.book.pe.f.a().f(iLPIssueDef);
            for (ILPTopic iLPTopic : list) {
                String string2 = iLPTopic.getAccessPath();
                if (!StringHelper.isNotBlank((String)string2) || !string2.equals(string)) continue;
                arrayList.add(iLPTopic);
            }
        }
        catch (j j2) {
            logger.c((Object)("Could not fetch topics with access path: " + string));
        }
        return arrayList;
    }

    private List<ILPMigrationMappingExercise> createExerciseMappings(List<ILPIssueDef> list, List<ILPIssueDef> list2) throws j {
        ArrayList<ILPMigrationMappingExercise> arrayList = new ArrayList<ILPMigrationMappingExercise>();
        for (ILPIssueDef iLPIssueDef : list) {
            ILPIssueDef iLPIssueDef2 = this.retrieveEquivalentIssue(iLPIssueDef, list2);
            List<ILPExercise.ExerciseGroup> list3 = ch.ionesoft.ilp.book.pe.f.a().I(iLPIssueDef);
            for (ILPExercise.ExerciseGroup exerciseGroup : list3) {
                ILPMigrationMappingExercise iLPMigrationMappingExercise;
                List<ILPExercise> list4 = ch.ionesoft.ilp.book.pe.f.a().d(iLPIssueDef, exerciseGroup);
                if (iLPIssueDef2 == null) {
                    for (ILPExercise iLPExercise : list4) {
                        iLPMigrationMappingExercise = new ILPMigrationMappingExercise(iLPExercise, exerciseGroup);
                        iLPMigrationMappingExercise.setTargetIssue(null);
                        iLPMigrationMappingExercise.updateStatusOfMappingWith(ILPMigrationMapping.MappingStatus.MAPPING_STATUS_ERROR_NO_MATCHING_TARGET, "");
                        arrayList.add(iLPMigrationMappingExercise);
                    }
                    continue;
                }
                for (ILPExercise iLPExercise : list4) {
                    iLPMigrationMappingExercise = this.determineAndAddTargetExerciseForSourceExerciseInIssues(iLPExercise, iLPIssueDef2, exerciseGroup);
                    arrayList.add(iLPMigrationMappingExercise);
                }
            }
        }
        return arrayList;
    }

    private File writeMigrationMappingFile(List<ILPMigrationMapping> list, ILPCourseDef iLPCourseDef, ILPCourseDef iLPCourseDef2, File file) {
        boolean bl2;
        f f2 = new f("mappings");
        this.addMappingCourseElements(iLPCourseDef, iLPCourseDef2, f2);
        this.HTMLResponseBuilder.append("<p>Added mappings:</p>");
        LinkedHashMap<String, List<ILPMigrationMapping>> linkedHashMap = this.sortMappingsBySourceAndTargetIssue(list);
        for (Map.Entry<String, List<ILPMigrationMapping>> object2 : linkedHashMap.entrySet()) {
            f bl22 = this.createMappingIssueElement(object2);
            boolean bl3 = this.extractSourceIssueIdFromMapEntry(object2).equals(this.extractTargetIssueIdFromMapEntry(object2));
            boolean bl4 = StringHelper.isBlank((String)this.extractTargetIssueIdFromMapEntry(object2));
            int n2 = 0;
            for (ILPMigrationMapping iLPMigrationMapping : object2.getValue()) {
                if (!iLPMigrationMapping.isRelevantMapping()) continue;
                ++n2;
                bl22.b((d)new i("\n\t   \t\n"));
                c c2 = this.createNotificationComment(iLPMigrationMapping);
                if (c2 != null && !this.getCreateTemplate().booleanValue()) {
                    bl22.a(c2);
                }
                f f3 = iLPMigrationMapping.createMappingXMLElement();
                if (iLPMigrationMapping.isWriteAsComment() && !this.getCreateTemplate().booleanValue()) {
                    String string = f3.o();
                    string = string.replaceAll("--", "&#45&#45");
                    if (c2 != null) {
                        c2.a("\n\t\t" + string + "\n\t");
                        continue;
                    }
                    if (this.getCreateTemplate().booleanValue()) continue;
                    bl22.a(new c(string));
                    continue;
                }
                bl22.b(f3);
            }
            if (n2 != 0) {
                this.HTMLResponseBuilder.append("<p>Mappings: " + String.format(Locale.ENGLISH, "%02d", n2) + " | Source issue: '" + this.extractSourceIssueIdFromMapEntry(object2) + "' | Target issue: '" + this.extractTargetIssueIdFromMapEntry(object2) + "'</p>");
            }
            if (!bl22.v() && !bl22.w() && bl3) continue;
            if (bl4 && !this.getCreateTemplate().booleanValue()) {
                f2.a(new c(ERROR_MSG_EMPTY_TARGET_ISSUE_ID));
                f2.a(new c("\n\t" + bl22.o().replaceAll("<!--", "    ").replaceAll("-->", "   ") + "\n"));
                continue;
            }
            f2.b(bl22);
        }
        e e2 = e.a((f)f2);
        File file2 = new File(file, this.createMigrationMappingFilename(iLPCourseDef, iLPCourseDef2));
        if (!file2.getParentFile().exists() && !file2.getParentFile().mkdirs()) {
            logger.c((Object)("Could not create dir: " + file2.getParentFile()));
        }
        if (!(bl2 = e2.a(file2, true))) {
            logger.d((Object)String.format(Locale.ENGLISH, "Could not write %s", file2.getAbsolutePath()));
        } else {
            logger.b((Object)("Writing migration mapping file to :" + file2));
        }
        return file2;
    }

    private ILPIssueDef extractSourceIssueFromMapEntry(Map.Entry<String, List<ILPMigrationMapping>> entry) {
        List<ILPMigrationMapping> list = entry.getValue();
        for (ILPMigrationMapping iLPMigrationMapping : list) {
            if (iLPMigrationMapping.getSourceIssue() == null) continue;
            return iLPMigrationMapping.getSourceIssue();
        }
        return null;
    }

    private ILPIssueDef extractTargetIssueFromMapEntry(Map.Entry<String, List<ILPMigrationMapping>> entry) {
        List<ILPMigrationMapping> list = entry.getValue();
        for (ILPMigrationMapping iLPMigrationMapping : list) {
            if (iLPMigrationMapping.getTargetIssue() == null) continue;
            return iLPMigrationMapping.getTargetIssue();
        }
        return null;
    }

    private c createNotificationComment(ILPMigrationMapping iLPMigrationMapping) {
        String string2;
        List<String> list = iLPMigrationMapping.getNotifications();
        StringBuilder stringBuilder = new StringBuilder();
        for (String string2 : list) {
            if (!StringHelper.isNotBlank((String)string2)) continue;
            if (!stringBuilder.toString().isEmpty()) {
                stringBuilder.append(", ");
            } else {
                stringBuilder.append(" ");
            }
            stringBuilder.append(string2);
        }
        string2 = stringBuilder.toString();
        if (StringHelper.isNotBlank((String)string2)) {
            return new c(string2);
        }
        return null;
    }

    private f createMappingIssueElement(Map.Entry<String, List<ILPMigrationMapping>> entry) {
        ILPIssueDef iLPIssueDef = this.extractSourceIssueFromMapEntry(entry);
        ILPIssueDef iLPIssueDef2 = this.extractTargetIssueFromMapEntry(entry);
        f f2 = new f(MIGRATION_ELEMENT_NAME_ISSUE);
        f2.a(new b(MIGRATION_ATTRIBUTE_NAME_SOURCE_ISSUE_ID, iLPIssueDef.getIssueId()));
        f2.a(new b(MIGRATION_ATTRIBUTE_NAME_SOURCE_ISSUE_TITLE, iLPIssueDef.getTitle()));
        f2.a(new b(MIGRATION_ATTRIBUTE_NAME_TARGET_ISSUE_ID, iLPIssueDef2 == null || iLPIssueDef2.getIssueId() == null ? "" : iLPIssueDef2.getIssueId()));
        f2.a(new b(MIGRATION_ATTRIBUTE_NAME_TARGET_ISSUE_TITLE, iLPIssueDef2 == null || iLPIssueDef2.getTitle() == null ? "" : iLPIssueDef2.getTitle()));
        f2.a(new b(MIGRATION_ATTRIBUTE_NAME_MAP, MIGRATION_ATTRIBUTE_VALUE_MAP_ALL));
        return f2;
    }

    private String extractSourceIssueIdFromMapEntry(Map.Entry<String, List<ILPMigrationMapping>> entry) {
        ILPIssueDef iLPIssueDef = this.extractSourceIssueFromMapEntry(entry);
        return iLPIssueDef.getIssueId();
    }

    private String extractTargetIssueIdFromMapEntry(Map.Entry<String, List<ILPMigrationMapping>> entry) {
        ILPIssueDef iLPIssueDef = this.extractTargetIssueFromMapEntry(entry);
        return iLPIssueDef == null || iLPIssueDef.getIssueId() == null ? "" : iLPIssueDef.getIssueId();
    }

    private LinkedHashMap<String, List<ILPMigrationMapping>> sortMappingsBySourceAndTargetIssue(List<ILPMigrationMapping> list) {
        LinkedHashMap<String, List<ILPMigrationMapping>> linkedHashMap = new LinkedHashMap<String, List<ILPMigrationMapping>>();
        for (ILPMigrationMapping iLPMigrationMapping : list) {
            String string;
            String string2 = iLPMigrationMapping.getSourceIssueId();
            String string3 = this.createIssueMappingKey(string2, string = iLPMigrationMapping.getTargetIssueId());
            List<ILPMigrationMapping> list2 = linkedHashMap.get(string3);
            if (list2 == null) {
                list2 = new ArrayList<ILPMigrationMapping>();
            }
            list2.add(iLPMigrationMapping);
            linkedHashMap.put(string3, list2);
        }
        return linkedHashMap;
    }

    private String createIssueMappingKey(String string, String string2) {
        return String.valueOf(string) + "-" + string2;
    }

    private String extractTargetIssueIdFromMapKey(String string) {
        return StringHelper.extractString_after((String)string, (String)"-");
    }

    private String extractSourceIssueIdFromMapKey(String string) {
        return StringHelper.extractStringFrom_until((String)string, (String)"-");
    }

    private f addMappingCourseElements(ILPCourseDef iLPCourseDef, ILPCourseDef iLPCourseDef2, f f2) {
        f f3 = new f("targetCourse");
        this.addCourseAttributesToElem(f3, iLPCourseDef2);
        f2.b(f3);
        f f4 = new f("sourceCourse");
        this.addCourseAttributesToElem(f4, iLPCourseDef);
        f2.b(f4);
        return f2;
    }

    private String createMigrationMappingFilename(ILPCourseDef iLPCourseDef, ILPCourseDef iLPCourseDef2) {
        if (this.getCreateTemplate().booleanValue() || iLPCourseDef2 == null) {
            return "mapping_" + iLPCourseDef.getCourseId() + "_" + iLPCourseDef.getReference() + "_template.xml";
        }
        if (iLPCourseDef.getCourseId().equals(iLPCourseDef2.getCourseId())) {
            return "mapping_" + iLPCourseDef2.getCourseId() + "_" + iLPCourseDef2.getReference() + "_edition_" + iLPCourseDef2.getEdition() + "_from_" + iLPCourseDef.getEdition() + ".xml";
        }
        return "mapping_" + iLPCourseDef2.getCourseId() + "_" + iLPCourseDef2.getReference() + "_from_" + iLPCourseDef.getCourseId() + "_" + iLPCourseDef.getReference() + ".xml";
    }

    private void addCourseAttributesToElem(f f2, ILPCourseDef iLPCourseDef) {
        String string = "";
        String string2 = "";
        String string3 = "";
        String string4 = "";
        String string5 = "";
        if (iLPCourseDef != null && !this.getCreateTemplate().booleanValue()) {
            string = iLPCourseDef.getMandantId();
            string2 = iLPCourseDef.getCourseId();
            string3 = iLPCourseDef.getReference();
            string4 = iLPCourseDef.getLanguageCode();
            string5 = "" + iLPCourseDef.getEdition();
        }
        f2.a(new b("mandantId", string));
        f2.a(new b("courseId", string2));
        f2.a(new b("reference", string3));
        f2.a(new b("language", string4));
        f2.a(new b("edition", string5));
    }

    private ILPMigrationMappingTopic determineAndAddTargetTopicForSourceTopicInIssues(ILPTopic iLPTopic, ILPIssueDef iLPIssueDef) throws j {
        ILPTopic iLPTopic2 = null;
        ILPMigrationMappingTopic iLPMigrationMappingTopic = new ILPMigrationMappingTopic(iLPTopic, this.checkIfIsUnique(iLPTopic));
        iLPMigrationMappingTopic.setTargetIssue(iLPIssueDef);
        List<ILPTopic> list = ch.ionesoft.ilp.book.pe.f.a().f(iLPIssueDef);
        List<ILPTopic> list2 = this.retrieveMatchingTopics(iLPTopic, list);
        if (!list2.isEmpty()) {
            iLPMigrationMappingTopic.updateStatusOfMappingWith(ILPMigrationMapping.MappingStatus.MAPPING_STATUS_MATCH, "");
            iLPTopic2 = list2.get(0);
        } else {
            list2 = this.retrieveTopicsWithTitleAndId(iLPTopic.getTitle(), iLPTopic.getAccessPath(), list);
            if (!list2.isEmpty()) {
                iLPTopic2 = list2.get(0);
                iLPMigrationMappingTopic.updateStatusOfMappingWith(ILPMigrationMapping.MappingStatus.TOPIC_MAPPING_STATUS_WARNING_DIFFERENT_ORDER, "source: " + iLPTopic.getOrder() + " | target: " + iLPTopic2.getOrder());
            } else {
                list2 = this.retrieveTopicsWithTitle(iLPTopic.getTitle(), list);
                if (!list2.isEmpty()) {
                    iLPTopic2 = list2.get(0);
                    if (!iLPTopic.getOrder().equals(iLPTopic2.getOrder())) {
                        iLPMigrationMappingTopic.updateStatusOfMappingWith(ILPMigrationMapping.MappingStatus.TOPIC_MAPPING_STATUS_WARNING_DIFFERENT_ORDER, "source: " + iLPTopic.getOrder() + " | target: " + iLPTopic2.getOrder());
                    }
                    if (!this.topicIdIsEquivalent(iLPTopic.getAccessPath(), iLPTopic2.getAccessPath())) {
                        iLPMigrationMappingTopic.updateStatusOfMappingWith(ILPMigrationMapping.MappingStatus.TOPIC_MAPPING_STATUS_WARNING_DIFFERENT_ID, "");
                    }
                } else {
                    iLPMigrationMappingTopic.updateStatusOfMappingWith(ILPMigrationMapping.MappingStatus.MAPPING_STATUS_ERROR_NO_MATCHING_TARGET, "");
                    return iLPMigrationMappingTopic;
                }
            }
        }
        if (list2.size() > 1) {
            StringBuilder stringBuilder = new StringBuilder();
            for (ILPTopic iLPTopic3 : list2) {
                stringBuilder.append(String.valueOf(iLPTopic3.toString()) + ", ");
            }
            iLPMigrationMappingTopic.updateStatusOfMappingWith(ILPMigrationMapping.MappingStatus.MAPPING_STATUS_WARNING_MULTIPLE_MATCHING_TARGETS, stringBuilder.toString());
        }
        iLPMigrationMappingTopic.setTargetTopic(iLPTopic2);
        return iLPMigrationMappingTopic;
    }

    private ILPMigrationMappingExercise determineAndAddTargetExerciseForSourceExerciseInIssues(ILPExercise iLPExercise, ILPIssueDef iLPIssueDef, ILPExercise.ExerciseGroup exerciseGroup) throws j {
        ILPExercise iLPExercise2 = null;
        ILPMigrationMappingExercise iLPMigrationMappingExercise = new ILPMigrationMappingExercise(iLPExercise, exerciseGroup);
        iLPMigrationMappingExercise.setTargetIssue(iLPIssueDef);
        List<ILPExercise> list = ch.ionesoft.ilp.book.pe.f.a().d(iLPIssueDef, exerciseGroup);
        List<ILPExercise> list2 = this.retrieveExercisesWithReferenceIdAndTitle(iLPExercise.getReference(), iLPExercise.getExerciseId(), iLPExercise.getTitle(), list);
        if (!list2.isEmpty()) {
            iLPExercise2 = list2.get(0);
            iLPMigrationMappingExercise.updateStatusOfMappingWith(ILPMigrationMapping.MappingStatus.MAPPING_STATUS_MATCH, "");
        } else {
            list2 = this.retrieveExercisesWithReferenceAndTitle(iLPExercise.getReference(), iLPExercise.getTitle(), list);
            if (!list2.isEmpty()) {
                iLPExercise2 = list2.get(0);
                iLPMigrationMappingExercise.updateStatusOfMappingWith(ILPMigrationMapping.MappingStatus.EXERCISE_MAPPING_STATUS_WARNING_DIFFERENT_ID, "source: " + iLPExercise.getExerciseId() + " | target: " + iLPExercise2.getExerciseId());
            } else {
                list2 = this.retrieveExercisesWithIdAndTitle(iLPExercise.getExerciseId(), iLPExercise.getTitle(), list);
                if (!list2.isEmpty()) {
                    iLPExercise2 = list2.get(0);
                    iLPMigrationMappingExercise.updateStatusOfMappingWith(ILPMigrationMapping.MappingStatus.EXERCISE_MAPPING_STATUS_WARNING_DIFFERENT_REFERENCE, "source: " + iLPExercise.getReference() + " | target: " + iLPExercise2.getReference());
                } else {
                    list2 = this.retrieveExercisesWithTitle(iLPExercise.getTitle(), list);
                    if (!list2.isEmpty()) {
                        iLPExercise2 = list2.get(0);
                        iLPMigrationMappingExercise.updateStatusOfMappingWith(ILPMigrationMapping.MappingStatus.EXERCISE_MAPPING_STATUS_WARNING_MATCHING_TITLE_BUT_DIFFERENT_REFERENCE_AND_OR_ID, "source reference: " + iLPExercise.getReference() + " | target reference: " + iLPExercise2.getReference());
                    } else {
                        iLPMigrationMappingExercise.updateStatusOfMappingWith(ILPMigrationMapping.MappingStatus.MAPPING_STATUS_ERROR_NO_MATCHING_TARGET, "");
                        return iLPMigrationMappingExercise;
                    }
                }
            }
        }
        if (list2.size() > 1) {
            StringBuilder stringBuilder = new StringBuilder();
            for (ILPExercise iLPExercise3 : list2) {
                stringBuilder.append(iLPExercise3.getExerciseId());
            }
            iLPMigrationMappingExercise.updateStatusOfMappingWith(ILPMigrationMapping.MappingStatus.MAPPING_STATUS_WARNING_MULTIPLE_MATCHING_TARGETS, stringBuilder.toString());
        }
        iLPExercise2 = list2.get(0);
        iLPMigrationMappingExercise.setTargetExercise(iLPExercise2);
        if (!iLPExercise.getTitle().equals(iLPExercise2.getTitle())) {
            iLPMigrationMappingExercise.updateStatusOfMappingWith(ILPMigrationMapping.MappingStatus.EXERCISE_MAPPING_STATUS_WARNING_DIFFERENT_TITLE, "source: " + iLPExercise.getTitle() + " | target: " + iLPExercise2.getTitle());
        }
        return iLPMigrationMappingExercise;
    }

    private ILPIssueDef retrieveEquivalentIssue(ILPIssueDef iLPIssueDef, List<ILPIssueDef> list) {
        if (list == null) {
            return null;
        }
        List<ILPIssueDef> list2 = this.retrieveIssuesWithIdAndTitle(iLPIssueDef.getIssueId(), iLPIssueDef.getTitle(), list);
        if (list2.isEmpty()) {
            list2 = this.retrieveIssuesWithTitle(iLPIssueDef.getTitle(), list);
        }
        if (list2.isEmpty()) {
            list2 = this.retrieveIssuesWithTitleWithoutLeadingNumber(iLPIssueDef.getTitle(), list);
        }
        if (!list2.isEmpty()) {
            if (list2.size() > 1) {
                logger.d((Object)"Multiple equivalent target issues found. Returning first.");
            }
            return list2.get(0);
        }
        logger.d((Object)"No equivalent target issue found.");
        return null;
    }

    private List<ILPIssueDef> retrieveIssuesWithTitleWithoutLeadingNumber(String string, List<ILPIssueDef> list) {
        string = StringHelper.removePrefixNumber((String)string);
        ArrayList<ILPIssueDef> arrayList = new ArrayList<ILPIssueDef>();
        for (ILPIssueDef iLPIssueDef : list) {
            if (!this.pruneSpaces(StringHelper.removePrefixNumber((String)iLPIssueDef.getTitle())).equals(this.pruneSpaces(string))) continue;
            arrayList.add(iLPIssueDef);
        }
        return arrayList;
    }

    private List<ILPIssueDef> retrieveIssuesWithIdAndTitle(String string, String string2, List<ILPIssueDef> list) {
        ArrayList<ILPIssueDef> arrayList = new ArrayList<ILPIssueDef>();
        List<ILPIssueDef> list2 = this.retrieveIssuesWithTitle(string2, list);
        for (ILPIssueDef iLPIssueDef : list2) {
            if (!iLPIssueDef.getIssueId().equals(string)) continue;
            arrayList.add(iLPIssueDef);
        }
        return arrayList;
    }

    private List<ILPIssueDef> retrieveIssuesWithTitle(String string, List<ILPIssueDef> list) {
        ArrayList<ILPIssueDef> arrayList = new ArrayList<ILPIssueDef>();
        for (ILPIssueDef iLPIssueDef : list) {
            if (!this.pruneSpaces(iLPIssueDef.getTitle()).equals(this.pruneSpaces(string))) continue;
            arrayList.add(iLPIssueDef);
        }
        return arrayList;
    }

    private List<ILPExercise> retrieveExercisesWithReferenceIdAndTitle(String string, String string2, String string3, List<ILPExercise> list) {
        ArrayList<ILPExercise> arrayList = new ArrayList<ILPExercise>();
        for (ILPExercise iLPExercise : list) {
            if (iLPExercise.getReference() == null || !iLPExercise.getReference().equals(string) || iLPExercise.getExerciseId() == null || !iLPExercise.getExerciseId().equals(string2) || iLPExercise.getTitle() == null || !this.pruneSpaces(iLPExercise.getTitle()).equals(this.pruneSpaces(string3))) continue;
            arrayList.add(iLPExercise);
        }
        return arrayList;
    }

    private List<ILPExercise> retrieveExercisesWithReferenceAndTitle(String string, String string2, List<ILPExercise> list) {
        ArrayList<ILPExercise> arrayList = new ArrayList<ILPExercise>();
        for (ILPExercise iLPExercise : list) {
            if (iLPExercise.getReference() == null || !iLPExercise.getReference().equals(string) || iLPExercise.getTitle() == null || !this.pruneSpaces(iLPExercise.getTitle()).equals(this.pruneSpaces(string2))) continue;
            arrayList.add(iLPExercise);
        }
        return arrayList;
    }

    private List<ILPExercise> retrieveExercisesWithIdAndTitle(String string, String string2, List<ILPExercise> list) {
        ArrayList<ILPExercise> arrayList = new ArrayList<ILPExercise>();
        for (ILPExercise iLPExercise : list) {
            if (iLPExercise.getExerciseId() == null || !iLPExercise.getExerciseId().equals(string) || iLPExercise.getTitle() == null || !iLPExercise.getTitle().equals(string2)) continue;
            arrayList.add(iLPExercise);
        }
        return arrayList;
    }

    private List<ILPExercise> retrieveExercisesWithTitle(String string, List<ILPExercise> list) {
        ArrayList<ILPExercise> arrayList = new ArrayList<ILPExercise>();
        for (ILPExercise iLPExercise : list) {
            if (iLPExercise.getTitle() == null || !iLPExercise.getTitle().equals(string)) continue;
            arrayList.add(iLPExercise);
        }
        return arrayList;
    }

    private List<ILPTopic> retrieveMatchingTopics(ILPTopic iLPTopic, List<ILPTopic> list) {
        List<ILPTopic> list2 = this.retrieveTopicsWithReference(iLPTopic.getReference(), list);
        if (list2 != null && !list2.isEmpty()) {
            return list2;
        }
        return this.retrieveTopicsWithTitleIdAndOrder(iLPTopic.getTitle(), iLPTopic.getAccessPath(), iLPTopic.getOrder(), list);
    }

    private List<ILPTopic> retrieveTopicsWithReference(String string, List<ILPTopic> list) {
        if (StringHelper.isBlank((String)string)) {
            return null;
        }
        ArrayList<ILPTopic> arrayList = new ArrayList<ILPTopic>();
        for (ILPTopic iLPTopic : list) {
            if (!this.topicIdIsEquivalent(iLPTopic.getReference(), string)) continue;
            arrayList.add(iLPTopic);
        }
        return arrayList;
    }

    private List<ILPTopic> retrieveTopicsWithTitleIdAndOrder(String string, String string2, Integer n2, List<ILPTopic> list) {
        ArrayList<ILPTopic> arrayList = new ArrayList<ILPTopic>();
        for (ILPTopic iLPTopic : list) {
            if (!this.topicIdIsEquivalent(iLPTopic.getAccessPath(), string2) || iLPTopic.getTitle() == null || !iLPTopic.getTitle().equals(string) || iLPTopic.getOrder() == null || !iLPTopic.getOrder().equals(n2)) continue;
            arrayList.add(iLPTopic);
        }
        return arrayList;
    }

    private List<ILPTopic> retrieveTopicsWithTitleAndId(String string, String string2, List<ILPTopic> list) {
        ArrayList<ILPTopic> arrayList = new ArrayList<ILPTopic>();
        for (ILPTopic iLPTopic : list) {
            if (!this.topicIdIsEquivalent(iLPTopic.getAccessPath(), string2) || iLPTopic.getTitle() == null || !this.pruneSpaces(iLPTopic.getTitle()).equals(this.pruneSpaces(string))) continue;
            arrayList.add(iLPTopic);
        }
        return arrayList;
    }

    private List<ILPTopic> retrieveTopicsWithTitle(String string, List<ILPTopic> list) {
        ArrayList<ILPTopic> arrayList = new ArrayList<ILPTopic>();
        for (ILPTopic iLPTopic : list) {
            if (iLPTopic.getTitle() == null || !this.pruneSpaces(iLPTopic.getTitle()).equals(this.pruneSpaces(string))) continue;
            arrayList.add(iLPTopic);
        }
        return arrayList;
    }

    private boolean topicIdIsEquivalent(String string, String string2) {
        if (string == null) {
            return string2 == null;
        }
        if (string2 == null) {
            return string == null;
        }
        return string.equals(string2);
    }

    private String pruneSpaces(String string) {
        return StringHelper.removeAllWhitespaceAndNewlines((String)string);
    }

    public String getHtmlResponse() {
        return this.HTMLResponseBuilder.toString();
    }

    public Boolean getCreateTemplate() {
        return this.createTemplate;
    }

    public void setCreateTemplate(Boolean bl2) {
        this.createTemplate = bl2;
    }
}

