/*
 * Decompiled with CFR 0.152.
 */
package ch.ionesoft.ilp.book.co;

import ch.ionesoft.ilp.base.co.ILPLogManager;
import ch.ionesoft.ilp.base.co.ILogger;
import ch.ionesoft.ilp.base.co.b;
import ch.ionesoft.ilp.base.fo.x;
import ch.ionesoft.ilp.book.beookLms.model.ac;
import ch.ionesoft.ilp.book.beookLms.model.bS;
import ch.ionesoft.ilp.book.beookLms.model.bv;
import ch.ionesoft.ilp.book.beookLms.model.cP;
import ch.ionesoft.ilp.book.beookLms.model.ca;
import ch.ionesoft.ilp.book.beookLms.model.cj;
import ch.ionesoft.ilp.book.beookLms.model.cu;
import ch.ionesoft.ilp.book.beookLms.model.dA;
import ch.ionesoft.ilp.book.beookLms.model.eg;
import ch.ionesoft.ilp.book.co.ILPBookSettingsHelper;
import ch.ionesoft.ilp.book.co.ILPProfileManager;
import ch.ionesoft.ilp.book.ia.beookLms.a;
import ch.ionesoft.ilp.book.ia.d;
import ch.ionesoft.ilp.book.lr.e;
import ch.ionesoft.ilp.book.mo.ILPGroup;
import ch.ionesoft.ilp.book.mo.ILPGroup_User;
import ch.ionesoft.ilp.book.mo.ILPResource;
import ch.ionesoft.ilp.book.mo.ILPScenarioSpecification;
import ch.ionesoft.ilp.book.mo.ILPUser;
import ch.ionesoft.ilp.book.mo.lms.ILPLessonsContent;
import ch.ionesoft.ilp.book.mo.lms.ILPLessonsFolder;
import ch.ionesoft.ilp.book.mo.lms.ILPLessonsTask;
import ch.ionesoft.ilp.book.pe.f;
import ch.ionesoft.ilp.book.pe.g;
import ch.ionesoft.ilp.book.pe.j;
import ch.ionesoft.ilp.book.scenario.n;
import ch.ionesoft.ilp.book.syn.im.k;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;

public class ILPLessonsManager {
    private static ILogger logger = ILPLogManager.getLogger(ILPLessonsManager.class);
    private List<TasksObserver> observers = new ArrayList<TasksObserver>();
    private boolean synchronizationRunning = false;
    private static final List<ILPLessonsContent.LessonsContentType> PRELOAD_CONTENT_TYPES = Arrays.asList(ILPLessonsContent.LessonsContentType.LESSONS_CONTENT_TYPE_SCENARIO, ILPLessonsContent.LessonsContentType.LESSONS_CONTENT_TYPE_DOCUMENT, ILPLessonsContent.LessonsContentType.LESSONS_CONTENT_TYPE_IMAGE);
    private static ILPLessonsManager instance;

    public static ILPLessonsManager getInstance() {
        if (instance == null) {
            instance = new ILPLessonsManager();
        }
        return instance;
    }

    public void attach(TasksObserver tasksObserver) {
        try {
            this.observers.add(tasksObserver);
        }
        catch (Exception exception) {
            logger.d((Object)"Could not attach news observer", (Throwable)exception);
        }
    }

    private void notifyObservers() {
        for (TasksObserver tasksObserver : this.observers) {
            try {
                tasksObserver.onTaskCreated();
            }
            catch (Exception exception) {
                logger.d((Object)("Could not notify observer: " + tasksObserver), (Throwable)exception);
            }
        }
    }

    public static boolean isTaskActive(ILPLessonsTask iLPLessonsTask) {
        return iLPLessonsTask != null && iLPLessonsTask.getState() != ILPLessonsTask.LessonsTaskState.LESSONS_TASK_STATE_CANCELED;
    }

    public boolean completeTask(ILPLessonsTask iLPLessonsTask) throws SQLException {
        iLPLessonsTask.setProcessingState(ILPLessonsTask.LessonsProcessingState.LESSONS_PROCESSING_STATE_COMPLETED);
        g.a().aU().update((Object)iLPLessonsTask);
        return new a().a(iLPLessonsTask);
    }

    public void synchronizeSingleTask(String string) {
        if (ILPProfileManager.isInitialProfileActive()) {
            return;
        }
        if (!x.a().a(false)) {
            ch.ionesoft.ilp.base.co.f.b().D().sayCode("message.network.notAvailable", new Object[0]);
            return;
        }
        if (!ILPBookSettingsHelper.instance().isLoggedIn()) {
            ch.ionesoft.ilp.base.co.f.b().D().sayCode("message.asset.login.required", new Object[0]);
            return;
        }
        try {
            a a2 = new a();
            cj cj2 = a2.a(string);
            if (cj2 == null) {
                return;
            }
            cu cu2 = cj2.a();
            if (this.handleTasks(Arrays.asList(cu2), true)) {
                logger.b((Object)("Successfully synced task with taskId from lms: " + string));
            } else {
                logger.d((Object)("Could not sync task with taskId: " + string));
            }
        }
        catch (Exception exception) {
            logger.d((Object)("Could not sync task with taskId: " + string), (Throwable)exception);
        }
    }

    public void synchronizeTasks() {
        if (!b.b().g("ILPBase.config.lessons")) {
            return;
        }
        if (ILPProfileManager.isInitialProfileActive()) {
            return;
        }
        if (!x.a().a(false)) {
            ch.ionesoft.ilp.base.co.f.b().D().sayCode("message.network.notAvailable", new Object[0]);
            return;
        }
        if (!ILPBookSettingsHelper.instance().isLoggedIn()) {
            ch.ionesoft.ilp.base.co.f.b().D().sayCode("message.asset.login.required", new Object[0]);
            return;
        }
        if (this.synchronizationRunning) {
            logger.c((Object)"LMS synchronization is already running skip call. ");
            return;
        }
        try {
            this.synchronizationRunning = true;
            Long l2 = this.getCurrentTaskVersion();
            logger.b((Object)("Start synchronizing tasks from service with current version: " + l2));
            a a2 = new a();
            a2.a(ILPProfileManager.instance().getCurrentProfile().getCurrentUser());
            bS bS2 = a2.a(l2);
            if (bS2 == null) {
                return;
            }
            try {
                Long l3 = bS2.a();
                if (this.handleGroups(bS2.c())) {
                    logger.b((Object)"Successfully synched all groups from lms");
                } else {
                    logger.d((Object)"Something went wrong in group sync");
                }
                boolean bl2 = true;
                if (l2 == null || l2 == 0L) {
                    logger.b((Object)"Current lessons task version is 0. Do not fetch feedbacks during task sync");
                    bl2 = false;
                }
                if (this.handleTasks(bS2.b(), bl2)) {
                    logger.b((Object)("Successfully synched all tasks from lms. Set currentAssignementVersion to: " + l3));
                } else {
                    logger.d((Object)("Something went wrong in task sync. Set currentAssignementVersion to: " + l3));
                }
                this.setCurrentTaskVersion(l3);
                this.notifyObservers();
            }
            catch (Exception exception) {
                logger.d((Object)"Could not synchronize tasks from lessons server. ", (Throwable)exception);
            }
        }
        finally {
            this.synchronizationRunning = false;
        }
    }

    public boolean isSynchronizationRunning() {
        return this.synchronizationRunning;
    }

    private boolean handleGroups(List<ca> list) {
        boolean bl2 = false;
        for (ca ca2 : list) {
            try {
                ILPGroup_User iLPGroup_User;
                ILPGroup iLPGroup = f.a().u(ca2.a());
                boolean bl3 = false;
                if (iLPGroup == null) {
                    iLPGroup = new ILPGroup();
                    bl3 = true;
                }
                iLPGroup.setGroupID(ca2.a());
                if (ca2.b() != null && !ca2.b().isEmpty()) {
                    iLPGroup.setGroupType(ILPGroup.GroupType.get(ca2.b()));
                } else {
                    iLPGroup.setGroupType(ILPGroup.GroupType.GROUP_TYPE_LESSONS);
                }
                iLPGroup.setName(ca2.c());
                iLPGroup.setCreationDate(d.a(ca2.e()));
                iLPGroup.setLastUpdate(d.a(ca2.f()));
                iLPGroup.setGroupAdminState(ILPGroup.GroupAdminState.GROUP_ADMIN_STATE_OPEN);
                iLPGroup.setGroupMemberState(ILPGroup.GroupMemberState.GROUP_MEMBER_STATE_JOINED);
                iLPGroup.setAdmin(this.handleOwner(ca2.i()));
                g.a().T().createOrUpdate((Object)iLPGroup);
                ILPUser iLPUser = ILPProfileManager.instance().getCurrentProfile().getCurrentUser();
                if (bl3) {
                    iLPGroup_User = new ILPGroup_User(iLPGroup, iLPUser);
                    iLPGroup_User.setRole(ILPGroup_User.MembershipRole.MEMBERSHIP_ROLE_MEMBER);
                    iLPGroup_User.setStatus(ILPGroup_User.MembershipStatus.MEMBERSHIP_STATUS_JOINED);
                    g.a().aa().create((Object)iLPGroup_User);
                } else {
                    iLPGroup_User = f.a().a(iLPGroup, iLPUser);
                    iLPGroup_User.setStatus(ILPGroup_User.MembershipStatus.MEMBERSHIP_STATUS_JOINED);
                    g.a().aa().update((Object)iLPGroup_User);
                }
                logger.b((Object)("Successfully created or updated group: " + iLPGroup));
            }
            catch (Exception exception) {
                logger.d((Object)("Could not import groupDto from lessons: " + ca2), (Throwable)exception);
                bl2 = true;
            }
        }
        return !bl2;
    }

    private boolean handleTasks(List<cu> list, boolean bl2) throws SQLException, j {
        boolean bl3 = false;
        for (cu cu2 : list) {
            try {
                Object object;
                this.updateOrCreateFolderStructure(cu2.d(), null);
                dA dA2 = cu2.a();
                cP cP2 = cu2.b();
                String string = dA2.a();
                String string2 = cP2.b();
                ILPLessonsTask iLPLessonsTask = f.a().aI(string);
                if (iLPLessonsTask == null) {
                    iLPLessonsTask = new ILPLessonsTask(string, string2, new DateTime((Object)Date.from(dA2.d().toInstant())));
                    g.a().aU().create((Object)iLPLessonsTask);
                }
                eg eg2 = dA2.i();
                iLPLessonsTask.setType(ILPLessonsTask.LessonsTaskType.get(eg2.a().a()));
                ILPUser iLPUser = this.handleOwner(dA2.k());
                iLPLessonsTask.setOwner(iLPUser);
                ILPLessonsTask.LessonsTaskState lessonsTaskState = ILPLessonsTask.LessonsTaskState.get(dA2.j().a().a());
                iLPLessonsTask.setState(lessonsTaskState);
                ILPLessonsTask.LessonsProcessingState lessonsProcessingState = ILPLessonsTask.LessonsProcessingState.get(cP2.f().a().a());
                iLPLessonsTask.setProcessingState(lessonsProcessingState);
                ILPLessonsTask.LessonsTaskExerciseAnswerDisplayMode lessonsTaskExerciseAnswerDisplayMode = ILPLessonsTask.LessonsTaskExerciseAnswerDisplayMode.get(cP2.g().a().a());
                iLPLessonsTask.setExerciseAnswerDisplayMode(lessonsTaskExerciseAnswerDisplayMode);
                iLPLessonsTask.setTitle(dA2.b());
                iLPLessonsTask.setDescription(dA2.c());
                iLPLessonsTask.setPublishedAt(dA2.e());
                iLPLessonsTask.setLearningAnalyticsEnabled(dA2.r());
                iLPLessonsTask.setCreatedAt(cP2.j());
                iLPLessonsTask.setStartedAt(cP2.l());
                iLPLessonsTask.setEstimatedAt(cP2.k());
                iLPLessonsTask.setDeliveredAt(cP2.m());
                iLPLessonsTask.setLastModifiedAt(cP2.n());
                iLPLessonsTask.setUserSubmittedAt(cP2.o());
                String string3 = dA2.n();
                if (StringUtils.isNotBlank((CharSequence)string3)) {
                    object = f.a().aL(string3);
                    iLPLessonsTask.setFolder((ILPLessonsFolder)object);
                }
                g.a().aU().createOrUpdate((Object)iLPLessonsTask);
                object = this.handleContents((ILPLessonsContent.LessonsContentModel)iLPLessonsTask, dA2.m());
                this.resolveAndDownloadAssets((List<ILPLessonsContent>)object);
                this.importScenario(iLPLessonsTask);
                iLPLessonsTask.setTaskSyncState(ILPLessonsTask.LessonsTaskSyncState.LESSONS_TASK_SYNC_STATE_OK.getCode());
                g.a().aU().update((Object)iLPLessonsTask);
                this.createGroupToTaskRelation(cP2, iLPLessonsTask);
                if (ILPLessonsManager.isTaskActive(iLPLessonsTask) && bl2) {
                    e.a().c(iLPLessonsTask);
                } else {
                    this.setSpecificationsDeletedForCancelledTask(iLPLessonsTask);
                }
                iLPLessonsTask.setLastSyncDate(new DateTime());
                g.a().aU().update((Object)iLPLessonsTask);
                logger.b((Object)("Successfully created or update task: " + iLPLessonsTask));
            }
            catch (Exception exception) {
                logger.d((Object)("Could not import taskDto from lessons: " + cu2), (Throwable)exception);
                bl3 = true;
            }
        }
        return !bl3;
    }

    private void setSpecificationsDeletedForCancelledTask(ILPLessonsTask iLPLessonsTask) {
        try {
            List<ILPScenarioSpecification> list = f.a().a(iLPLessonsTask);
            if (CollectionUtils.isEmpty(list)) {
                return;
            }
            for (ILPScenarioSpecification iLPScenarioSpecification : list) {
                try {
                    iLPScenarioSpecification.setDeleted(true);
                    g.a().aM().update((Object)iLPScenarioSpecification);
                }
                catch (Exception exception) {
                    logger.d((Object)("Could not set specification to deleted, specification: " + iLPScenarioSpecification), (Throwable)exception);
                }
            }
        }
        catch (Exception exception) {
            logger.d((Object)("Could not set specifications to deleted for cancelled task: " + iLPLessonsTask), (Throwable)exception);
        }
    }

    private void createGroupToTaskRelation(cP cP2, ILPLessonsTask iLPLessonsTask) {
        try {
            if (iLPLessonsTask.isOwnerCopy()) {
                return;
            }
            ch.ionesoft.ilp.book.beookLms.model.d d2 = cP2.e().b();
            if (d2 == null) {
                logger.c((Object)("No GroupContext found in TaskAssignmentDTO2: " + cP2 + ", for task: " + iLPLessonsTask));
                return;
            }
            ILPGroup iLPGroup = f.a().u(d2.a());
            if (iLPGroup == null) {
                logger.c((Object)("Could not map group to task. group with Id: " + d2.a() + " no found in DB"));
            }
            iLPLessonsTask.addGroupObject(iLPGroup);
        }
        catch (Exception exception) {
            logger.d((Object)("Could not create group to task relation with TaskAssignmentDTO2: " + cP2 + ", for task: " + iLPLessonsTask));
        }
    }

    private void updateOrCreateFolderStructure(ac ac2, ILPLessonsFolder iLPLessonsFolder) throws SQLException, IOException {
        ILPLessonsContent iLPLessonsContent;
        if (ac2 == null) {
            return;
        }
        String string = ac2.a();
        ILPLessonsFolder iLPLessonsFolder2 = f.a().aL(string);
        if (iLPLessonsFolder2 == null) {
            iLPLessonsFolder2 = new ILPLessonsFolder(string);
        }
        iLPLessonsFolder2.setParentFolder(iLPLessonsFolder);
        iLPLessonsFolder2.setTitle(ac2.b());
        iLPLessonsFolder2.setFolderColor(ILPLessonsFolder.LessonsColorTag.get(ac2.e().a().a()));
        ILPLessonsContent iLPLessonsContent2 = this.handleContents((ILPLessonsContent.LessonsContentModel)iLPLessonsFolder2, ac2.c());
        if (iLPLessonsContent2 != null) {
            iLPLessonsFolder2.setBanner(iLPLessonsContent2);
        }
        if ((iLPLessonsContent = this.handleContents((ILPLessonsContent.LessonsContentModel)iLPLessonsFolder2, ac2.d())) != null) {
            iLPLessonsFolder2.setIcon(iLPLessonsContent);
        }
        g.a().aY().createOrUpdate((Object)iLPLessonsFolder2);
        this.resolveAndDownloadAssets(Arrays.asList(iLPLessonsContent2, iLPLessonsContent));
        if (ac2.h() != null) {
            for (ac ac3 : ac2.h()) {
                this.updateOrCreateFolderStructure(ac3, iLPLessonsFolder2);
            }
        }
    }

    private void importScenario(ILPLessonsTask iLPLessonsTask) throws SQLException, n {
        List<ILPLessonsContent> list = f.a().a(iLPLessonsTask, ILPLessonsContent.LessonsContentType.LESSONS_CONTENT_TYPE_SCENARIO);
        if (list == null || list.isEmpty()) {
            return;
        }
        if (list.size() > 1) {
            logger.c((Object)("Task provided multiple contents of type: " + (Object)((Object)ILPLessonsContent.LessonsContentType.LESSONS_CONTENT_TYPE_SCENARIO) + " this should not be possible. "));
        }
        ILPLessonsContent iLPLessonsContent = list.get(0);
        ILPResource iLPResource = iLPLessonsContent.getResource();
        try {
            g.a().H().refresh((Object)iLPResource);
        }
        catch (Exception exception) {
            logger.d((Object)("Could not refresh resource: " + iLPResource), (Throwable)exception);
        }
        File file = iLPResource.getAbsolutPath();
        logger.b((Object)("Parse scenarioFile from resource: " + iLPResource + ", absoluteFile: " + file));
        k k2 = new k();
        k2.a(true);
        ILPScenarioSpecification iLPScenarioSpecification = k2.a(file, iLPLessonsTask);
        iLPScenarioSpecification.setTask(iLPLessonsTask);
        iLPScenarioSpecification.setResource(iLPResource);
        g.a().aM().update((Object)iLPScenarioSpecification);
        iLPLessonsTask.setScenarioSpecification(iLPScenarioSpecification);
        g.a().aU().update((Object)iLPLessonsTask);
    }

    private ILPLessonsContent handleContents(ILPLessonsContent.LessonsContentModel lessonsContentModel, ch.ionesoft.ilp.book.beookLms.model.j j2) throws SQLException, IOException {
        if (j2 == null) {
            return null;
        }
        List<ILPLessonsContent> list = this.handleContents(lessonsContentModel, Arrays.asList(j2));
        if (list != null && !list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    private List<ILPLessonsContent> handleContents(ILPLessonsContent.LessonsContentModel lessonsContentModel, List<ch.ionesoft.ilp.book.beookLms.model.j> list) throws SQLException, IOException {
        ArrayList<ILPLessonsContent> arrayList = new ArrayList<ILPLessonsContent>();
        if (list == null) {
            return arrayList;
        }
        for (ch.ionesoft.ilp.book.beookLms.model.j j2 : list) {
            if (j2 == null) continue;
            String string = j2.a();
            Integer n2 = j2.c();
            ILPLessonsContent.LessonsContentType lessonsContentType = ILPLessonsContent.LessonsContentType.get(j2.e().a().a());
            String string2 = j2.b();
            String string3 = j2.d();
            ILPLessonsContent iLPLessonsContent = lessonsContentModel.getContentForModel(string, n2);
            if (iLPLessonsContent == null) {
                ILPLessonsContent iLPLessonsContent2 = f.a().a(string, (Long)n2.longValue());
                iLPLessonsContent = new ILPLessonsContent(lessonsContentModel, string, n2.longValue(), string2, lessonsContentType, string3);
                g.a().aV().create((Object)iLPLessonsContent);
                ILPResource iLPResource = null;
                if (iLPLessonsContent2 == null) {
                    iLPResource = new ILPResource(ILPResource.ResourceLocation.RESOURCE_LOCATION_UCS_SERVER);
                    iLPResource.setResourceReference(ILPResource.ResourceReference.RESOURCE_REFERENCE_LESSONS_TASK);
                    iLPResource.setMediaType(string3);
                } else {
                    ILPResource iLPResource2 = iLPLessonsContent2.getResource();
                    try {
                        g.a().H().refresh((Object)iLPResource2);
                    }
                    catch (Exception exception) {
                        logger.d((Object)("Could not refresh resource: " + iLPResource2), (Throwable)exception);
                    }
                    iLPResource = new ILPResource();
                    iLPResource.setHref(iLPResource2.getHref());
                    iLPResource.setResourceLocation(iLPResource2.getResourceLocation());
                    iLPResource.setMediaType(iLPResource2.getMediaType());
                    iLPResource.setResourceReference(iLPResource2.getResourceReference());
                    iLPResource.setTitle(iLPResource2.getTitle());
                }
                g.a().H().create((Object)iLPResource);
                iLPResource.setLmsContent(iLPLessonsContent);
                iLPLessonsContent.setResource(iLPResource);
                g.a().H().update((Object)iLPResource);
                g.a().aV().update((Object)iLPLessonsContent);
                logger.b((Object)("Successfully added lessonsContent: " + iLPLessonsContent));
            }
            arrayList.add(iLPLessonsContent);
        }
        return arrayList;
    }

    private void resolveAndDownloadAssets(List<ILPLessonsContent> list) throws IOException, SQLException {
        if (list == null || list.isEmpty()) {
            return;
        }
        for (ILPLessonsContent iLPLessonsContent : list) {
            if (iLPLessonsContent == null || !PRELOAD_CONTENT_TYPES.contains((Object)iLPLessonsContent.getTypeEnum()) || iLPLessonsContent.isContentDownloaded()) continue;
            try {
                iLPLessonsContent.download();
            }
            catch (Exception exception) {
                logger.d((Object)("Could not download lessonsContent and make it local available: " + iLPLessonsContent), (Throwable)exception);
            }
        }
    }

    private ILPUser handleOwner(bv bv2) throws j, SQLException {
        ILPUser iLPUser = f.a().B(bv2.a());
        if (iLPUser == null) {
            iLPUser = new ILPUser(bv2.a());
        }
        iLPUser.setFirstname(bv2.c());
        iLPUser.setLastname(bv2.d());
        iLPUser.setEmail(bv2.b());
        g.a().U().createOrUpdate((Object)iLPUser);
        return iLPUser;
    }

    private Long getCurrentTaskVersion() {
        return ILPBookSettingsHelper.instance().getLessonsCurrentTaskVersion();
    }

    private void setCurrentTaskVersion(Long l2) {
        ILPBookSettingsHelper.instance().setLessonsCurrentTaskVersion(l2);
    }

    public static interface TasksObserver {
        public void onTaskCreated();
    }
}

