/*
 * Decompiled with CFR 0.152.
 */
package ch.ionesoft.ilp.book.co;

import ch.ionesoft.ilp.base.co.ILPLogManager;
import ch.ionesoft.ilp.base.co.ILogger;
import ch.ionesoft.ilp.base.co.o;
import ch.ionesoft.ilp.base.he.ILPLogHelper;
import ch.ionesoft.ilp.base.he.StringHelper;
import ch.ionesoft.ilp.book.co.IALicenseManager;
import ch.ionesoft.ilp.book.co.ILPAbstractAssetProcessStrategy;
import ch.ionesoft.ilp.book.co.ILPBookHelper;
import ch.ionesoft.ilp.book.co.ILPBookSettingsHelper;
import ch.ionesoft.ilp.book.co.ILPBookTypes;
import ch.ionesoft.ilp.book.co.ILPConfigurationManager;
import ch.ionesoft.ilp.book.co.ILPInitializer;
import ch.ionesoft.ilp.book.co.ILPOrderSystemManager;
import ch.ionesoft.ilp.book.he.c;
import ch.ionesoft.ilp.book.ia.atma.a;
import ch.ionesoft.ilp.book.ia.atma.b;
import ch.ionesoft.ilp.book.ia.b;
import ch.ionesoft.ilp.book.mo.AbstractCoreDataModel;
import ch.ionesoft.ilp.book.mo.ILPAbstractDefinition;
import ch.ionesoft.ilp.book.mo.ILPAbstractProduct;
import ch.ionesoft.ilp.book.mo.ILPAssetDefinition;
import ch.ionesoft.ilp.book.mo.ILPAssetProduct;
import ch.ionesoft.ilp.book.mo.ILPCourseDef;
import ch.ionesoft.ilp.book.mo.ILPCourseProduct;
import ch.ionesoft.ilp.book.mo.ILPEProduct;
import ch.ionesoft.ilp.book.mo.ILPExercise;
import ch.ionesoft.ilp.book.mo.ILPExerciseDefinition;
import ch.ionesoft.ilp.book.mo.ILPExerciseProduct;
import ch.ionesoft.ilp.book.mo.ILPIssueDef;
import ch.ionesoft.ilp.book.mo.ILPIssueProduct;
import ch.ionesoft.ilp.book.mo.ILPLicense;
import ch.ionesoft.ilp.book.mo.ILPResource;
import ch.ionesoft.ilp.book.mo.ILPScenarioDefinition;
import ch.ionesoft.ilp.book.mo.ILPScenarioSpecification;
import ch.ionesoft.ilp.book.mo.ILPTopic;
import ch.ionesoft.ilp.book.mo.ILPTopicDefinition;
import ch.ionesoft.ilp.book.mo.ILPTopicProduct;
import ch.ionesoft.ilp.book.pa.d;
import ch.ionesoft.ilp.book.pa.e;
import ch.ionesoft.ilp.book.pe.f;
import ch.ionesoft.ilp.book.pe.g;
import ch.ionesoft.ilp.book.scenario.ILPScenarioManager;
import com.j256.ormlite.dao.ForeignCollection;
import java.io.File;
import java.io.Serializable;
import java.net.URL;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;

public class ILPInstallationManager {
    private InstallationScope installationScope;
    private static ILogger logger = ILPLogManager.getLogger(ILPInstallationManager.class);

    public void installEProduct(ILPEProduct iLPEProduct, c c2) {
        c2.a();
        c2.d();
        ILPEProduct.ProductType productType = iLPEProduct.getProductTypeEnum();
        switch (productType) {
            case PRODUCT_TYPE_COURSE_PRODUCT: {
                this.installationScope = InstallationScope.COURSE;
                if ((iLPEProduct.getCourseProduct().isAvailableForFree().booleanValue() || iLPEProduct.getCourseProduct().hasExcerpt()) && iLPEProduct.determineLicense() == null) {
                    this.createLicenseOrderAndInstallCourse(iLPEProduct.getCourseProduct(), c2);
                    break;
                }
                if (iLPEProduct.getLicense() == null) break;
                this.obtainLicenseUsageAndInstallCourse(iLPEProduct.getCourseProduct(), c2);
                break;
            }
            case PRODUCT_TYPE_ISSUE_PRODUCT: {
                this.installationScope = InstallationScope.ISSUE;
                if ((iLPEProduct.getIssueProduct().isAvailableForFree().booleanValue() || iLPEProduct.getIssueProduct().hasExcerpt()) && iLPEProduct.determineLicense() == null) {
                    this.createLicenseOrderAndInstallIssue(iLPEProduct.getIssueProduct(), c2);
                    break;
                }
                if (iLPEProduct.determineLicense() == null) break;
                this.obtainLicenseUsageAndInstallIssue(iLPEProduct.getIssueProduct(), c2);
                break;
            }
            case PRODUCT_TYPE_EXERCISE_PRODUCT: {
                this.installationScope = InstallationScope.EXERCISE;
                if ((iLPEProduct.getAvailableForFree() == null || iLPEProduct.getAvailableForFree().booleanValue()) && iLPEProduct.determineLicense() == null) {
                    this.createLicenseOrderAndInstallExercise(iLPEProduct.getExerciseProduct(), c2);
                    break;
                }
                if (iLPEProduct.determineLicense() == null) break;
                this.obtainLicenseUsageAndInstallExercise(iLPEProduct.getExerciseProduct(), c2);
                break;
            }
            case PRODUCT_TYPE_ASSET_PRODUCT: {
                this.installationScope = InstallationScope.ASSET;
                if ((iLPEProduct.getAvailableForFree() == null || iLPEProduct.getAvailableForFree().booleanValue()) && iLPEProduct.determineLicense() == null) {
                    this.createLicenseOrderAndInstallAsset(iLPEProduct.getAssetProduct(), c2);
                    break;
                }
                if (iLPEProduct.determineLicense() == null) break;
                this.obtainLicenseUsageAndInstallAsset(iLPEProduct.getAssetProduct(), c2);
                break;
            }
            case PRODUCT_TYPE_TOPIC_PRODUCT: {
                this.installationScope = InstallationScope.TOPIC;
                if ((iLPEProduct.getAvailableForFree() == null || iLPEProduct.getAvailableForFree().booleanValue()) && iLPEProduct.determineLicense() == null) {
                    this.createLicenseOrderAndInstallTopic(iLPEProduct.getTopicProduct(), c2);
                    break;
                }
                if (iLPEProduct.determineLicense() == null) break;
                this.obtainLicenseUsageAndInstallTopic(iLPEProduct.getTopicProduct(), c2);
                break;
            }
            case PRODUCT_TYPE_PERMISSION_PRODUCT: {
                break;
            }
            default: {
                logger.d((Object)("No product type defined to install eproduct: " + iLPEProduct));
            }
        }
    }

    private void createLicenseOrderAndInstallIssue(final ILPIssueProduct iLPIssueProduct, final c c2) {
        c2.a(o.a().d("installation.manager.label.generateLicense"));
        c2.a(0.5f);
        ILPOrderSystemManager iLPOrderSystemManager = new ILPOrderSystemManager();
        iLPOrderSystemManager.createLicenseOrderAndGetLicense(iLPIssueProduct.getEProduct(), new ILPOrderSystemManager.OnCreateLicenseOrderCallback(){

            @Override
            public void onSuccess(ch.ionesoft.ilp.book.ia.b b2) {
                logger.b((Object)"Successfully created a license for free eProduct. ");
                ILPInstallationManager.this.obtainLicenseUsageAndInstallIssue(iLPIssueProduct, c2);
            }

            @Override
            public void onFailure(ch.ionesoft.ilp.book.ia.b b2) {
                logger.d((Object)("Could not create license order for issueProduct: " + iLPIssueProduct + ". Abort issue installation: " + b2));
                c2.a(b2);
            }
        });
    }

    private void createLicenseOrderAndInstallCourse(final ILPCourseProduct iLPCourseProduct, final c c2) {
        c2.a(o.a().d("installation.manager.label.generateLicense"));
        c2.a(0.5f);
        ILPOrderSystemManager iLPOrderSystemManager = new ILPOrderSystemManager();
        iLPOrderSystemManager.createLicenseOrderAndGetLicense(iLPCourseProduct.getEProduct(), new ILPOrderSystemManager.OnCreateLicenseOrderCallback(){

            @Override
            public void onSuccess(ch.ionesoft.ilp.book.ia.b b2) {
                logger.b((Object)"Successfully created a license for free eProduct. ");
                ILPInstallationManager.this.obtainLicenseUsageAndInstallCourse(iLPCourseProduct, c2);
            }

            @Override
            public void onFailure(ch.ionesoft.ilp.book.ia.b b2) {
                logger.d((Object)("Could not create license order for courseProduct: " + iLPCourseProduct + ". Abort course installation: " + b2));
                c2.a(b2);
            }
        });
    }

    private void createLicenseOrderAndInstallAsset(final ILPAssetProduct iLPAssetProduct, final c c2) {
        c2.a(o.a().d("installation.manager.label.generateLicense"));
        c2.a(0.5f);
        ILPOrderSystemManager iLPOrderSystemManager = new ILPOrderSystemManager();
        iLPOrderSystemManager.createLicenseOrderAndGetLicense(iLPAssetProduct.getEProduct(), new ILPOrderSystemManager.OnCreateLicenseOrderCallback(){

            @Override
            public void onSuccess(ch.ionesoft.ilp.book.ia.b b2) {
                logger.b((Object)"Successfully created a license for free eProduct. ");
                ILPInstallationManager.this.obtainLicenseUsageAndInstallAsset(iLPAssetProduct, c2);
            }

            @Override
            public void onFailure(ch.ionesoft.ilp.book.ia.b b2) {
                logger.d((Object)("Could not create license order for exerciseProduct: " + iLPAssetProduct + ". Abort exerciseProduct installation: " + b2));
                c2.a(b2);
            }
        });
    }

    private void createLicenseOrderAndInstallExercise(final ILPExerciseProduct iLPExerciseProduct, final c c2) {
        c2.a(o.a().d("installation.manager.label.generateLicense"));
        c2.a(0.5f);
        ILPOrderSystemManager iLPOrderSystemManager = new ILPOrderSystemManager();
        iLPOrderSystemManager.createLicenseOrderAndGetLicense(iLPExerciseProduct.getEProduct(), new ILPOrderSystemManager.OnCreateLicenseOrderCallback(){

            @Override
            public void onSuccess(ch.ionesoft.ilp.book.ia.b b2) {
                logger.b((Object)"Successfully created a license for free eProduct. ");
                ILPInstallationManager.this.obtainLicenseUsageAndInstallExercise(iLPExerciseProduct, c2);
            }

            @Override
            public void onFailure(ch.ionesoft.ilp.book.ia.b b2) {
                logger.d((Object)("Could not create license order for exerciseProduct: " + iLPExerciseProduct + ". Abort exerciseProduct installation: " + b2));
                c2.a(b2);
            }
        });
    }

    private void createLicenseOrderAndInstallTopic(final ILPTopicProduct iLPTopicProduct, final c c2) {
        c2.a(o.a().d("installation.manager.label.generateLicense"));
        c2.a(0.5f);
        ILPOrderSystemManager iLPOrderSystemManager = new ILPOrderSystemManager();
        iLPOrderSystemManager.createLicenseOrderAndGetLicense(iLPTopicProduct.getEProduct(), new ILPOrderSystemManager.OnCreateLicenseOrderCallback(){

            @Override
            public void onSuccess(ch.ionesoft.ilp.book.ia.b b2) {
                logger.b((Object)"Successfully created a license for free eProduct. ");
                ILPInstallationManager.this.obtainLicenseUsageAndInstallTopic(iLPTopicProduct, c2);
            }

            @Override
            public void onFailure(ch.ionesoft.ilp.book.ia.b b2) {
                logger.d((Object)("Could not create license order for topicProduct: " + iLPTopicProduct + ". Abort topic installation: " + b2));
                c2.a(b2);
            }
        });
    }

    private void obtainLicenseUsageAndInstallCourse(final ILPCourseProduct iLPCourseProduct, final c c2) {
        ILPLicense iLPLicense = iLPCourseProduct.determineLicense();
        if (iLPLicense == null) {
            logger.d((Object)("Cannot get licenseUsage for null license of eProduct: " + iLPCourseProduct));
            ch.ionesoft.ilp.base.co.f.b().D().displayWarningCode("message.internalError", new Object[0]);
            return;
        }
        if (iLPLicense.isLicenseUsageGranted()) {
            this.installCourseProduct(iLPCourseProduct, c2);
        } else {
            logger.b((Object)("Obtain license usage for course product: " + iLPCourseProduct));
            this.obtainLicenseUsage(iLPLicense, new IALicenseManager.LicenseManagerCallBack(){

                @Override
                public void onSuccess() {
                    ILPInstallationManager.this.installCourseProduct(iLPCourseProduct, c2);
                }

                @Override
                public void onFailure(ch.ionesoft.ilp.book.ia.b b2) {
                    logger.d((Object)("Could not obtain license usage for courseProduct: " + iLPCourseProduct + ". Abort course installation: " + b2));
                    c2.a(b2);
                }

                @Override
                public void onWarning(List<ch.ionesoft.ilp.book.ia.e> list) {
                    logger.d((Object)("Could not obtain all license usage for courseProduct: " + iLPCourseProduct + ". Abort course installation: " + list));
                    c2.a(list);
                }
            });
        }
    }

    private void obtainLicenseUsageAndInstallIssue(final ILPIssueProduct iLPIssueProduct, final c c2) {
        ILPLicense iLPLicense = iLPIssueProduct.determineLicense();
        if (iLPLicense != null && iLPLicense.isLicenseUsageGranted()) {
            this.installIssueProduct(iLPIssueProduct, c2);
        } else {
            logger.b((Object)("Obtain license usage for issue product: " + iLPIssueProduct));
            this.obtainLicenseUsage(iLPLicense, new IALicenseManager.LicenseManagerCallBack(){

                @Override
                public void onSuccess() {
                    ILPInstallationManager.this.installIssueProduct(iLPIssueProduct, c2);
                }

                @Override
                public void onFailure(ch.ionesoft.ilp.book.ia.b b2) {
                    logger.d((Object)("Could not obtain license usage for issueProduct: " + iLPIssueProduct + ". Abort issue installation: " + b2));
                    c2.a(b2);
                }

                @Override
                public void onWarning(List<ch.ionesoft.ilp.book.ia.e> list) {
                    logger.d((Object)("Could not obtain all license usage for issueProduct: " + iLPIssueProduct + ". Abort issue installation: " + list));
                    c2.a(list);
                }
            });
        }
    }

    private void obtainLicenseUsageAndInstallAsset(final ILPAssetProduct iLPAssetProduct, final c c2) {
        ILPLicense iLPLicense = iLPAssetProduct.determineLicense();
        if (iLPLicense != null && iLPLicense.isLicenseUsageGranted()) {
            this.installAssetProduct(iLPAssetProduct, c2);
        } else {
            logger.b((Object)("Obtain license usage for asset product: " + iLPAssetProduct));
            this.obtainLicenseUsage(iLPLicense, new IALicenseManager.LicenseManagerCallBack(){

                @Override
                public void onSuccess() {
                    ILPInstallationManager.this.installAssetProduct(iLPAssetProduct, c2);
                }

                @Override
                public void onFailure(ch.ionesoft.ilp.book.ia.b b2) {
                    logger.d((Object)("Could not obtain license usage for assetProduct: " + iLPAssetProduct + ". Abort asset installation: " + b2));
                    c2.a(b2);
                }

                @Override
                public void onWarning(List<ch.ionesoft.ilp.book.ia.e> list) {
                    logger.d((Object)("Could not obtain all license usage for assetProduct: " + iLPAssetProduct + ". Abort asset installation: " + list));
                    c2.a(list);
                }
            });
        }
    }

    private void obtainLicenseUsageAndInstallExercise(final ILPExerciseProduct iLPExerciseProduct, final c c2) {
        ILPLicense iLPLicense = iLPExerciseProduct.determineLicense();
        if (iLPLicense != null && iLPLicense.isLicenseUsageGranted()) {
            this.installExerciseProduct(iLPExerciseProduct, c2);
        } else {
            logger.b((Object)("Obtain license usage for exercise product: " + iLPExerciseProduct));
            this.obtainLicenseUsage(iLPLicense, new IALicenseManager.LicenseManagerCallBack(){

                @Override
                public void onSuccess() {
                    ILPInstallationManager.this.installExerciseProduct(iLPExerciseProduct, c2);
                }

                @Override
                public void onFailure(ch.ionesoft.ilp.book.ia.b b2) {
                    logger.d((Object)("Could not obtain license usage for exerciseProduct: " + iLPExerciseProduct + ". Abort exercise installation: " + b2));
                    c2.a(b2);
                }

                @Override
                public void onWarning(List<ch.ionesoft.ilp.book.ia.e> list) {
                    logger.d((Object)("Could not obtain all license usage for exerciseProduct: " + iLPExerciseProduct + ". Abort exercise installation: " + list));
                    c2.a(list);
                }
            });
        }
    }

    private void obtainLicenseUsageAndInstallTopic(final ILPTopicProduct iLPTopicProduct, final c c2) {
        ILPLicense iLPLicense = iLPTopicProduct.determineLicense();
        if (iLPLicense != null && iLPLicense.isLicenseUsageGranted()) {
            this.installTopicProduct(iLPTopicProduct, c2);
        } else {
            logger.b((Object)("Obtain license usage for topic product: " + iLPTopicProduct));
            this.obtainLicenseUsage(iLPLicense, new IALicenseManager.LicenseManagerCallBack(){

                @Override
                public void onSuccess() {
                    ILPInstallationManager.this.installTopicProduct(iLPTopicProduct, c2);
                }

                @Override
                public void onFailure(ch.ionesoft.ilp.book.ia.b b2) {
                    logger.d((Object)("Could not obtain license usage for topicProduct: " + iLPTopicProduct + ". Abort issue installation: " + b2));
                    c2.a(b2);
                }

                @Override
                public void onWarning(List<ch.ionesoft.ilp.book.ia.e> list) {
                    logger.d((Object)("Could not obtain all license usage for topicProduct: " + iLPTopicProduct + ". Abort issue installation: " + list));
                    c2.a(list);
                }
            });
        }
    }

    private void installCourseProduct(ILPCourseProduct iLPCourseProduct, c c2) {
        List<ILPAssetProduct> list;
        List<ILPExerciseProduct> list2;
        logger.b((Object)("Starting install course: " + iLPCourseProduct));
        c2.a();
        c2.d();
        List<ILPIssueProduct> list3 = f.a().g(iLPCourseProduct);
        if (list3 != null && !list3.isEmpty()) {
            this.installIssueProducts(list3, c2);
        }
        if ((list2 = f.a().j(iLPCourseProduct)) != null && !list2.isEmpty()) {
            this.installExerciseProducts(list2, c2);
        }
        if ((list = f.a().l(iLPCourseProduct)) != null && !list.isEmpty()) {
            this.installAssetProducts(list, c2);
        }
        if (this.installationScope == InstallationScope.COURSE) {
            ILPInitializer.instance().linkResourcesOfCourse(iLPCourseProduct.getCourse(), c2);
            this.finalizeCourseInstallation(iLPCourseProduct, c2);
        }
    }

    private void finalizeCourseInstallation(ILPCourseProduct iLPCourseProduct, c c2) {
        ILPEProduct iLPEProduct = iLPCourseProduct.getEProduct();
        try {
            g.a().a(iLPCourseProduct);
            g.a().c(iLPCourseProduct.getCourse());
            if (!ILPBookHelper.hasPropertyInherited_forCourse("disableResourceEmbedder", iLPCourseProduct.getCourse(), false)) {
                ILPInitializer.instance().embedResourcesOfCourse(iLPCourseProduct.getCourse(), c2);
            }
        }
        catch (Exception exception) {
            logger.d((Object)("Could not resource embedd installed course: " + iLPCourseProduct.getCourse()), (Throwable)exception);
        }
        this.rebuildContentStates(iLPEProduct);
        c2.a(o.a().d("label.progress.synchronizing"));
        ch.ionesoft.ilp.book.syn.d.a().a(iLPCourseProduct.getCourse(), true, true);
        ch.ionesoft.ilp.book.syn.d.a().e(true);
        c2.b();
        g.a().b(iLPEProduct);
        try {
            ch.ionesoft.ilp.book.syn.b.b().e();
        }
        catch (Exception exception) {
            logger.d((Object)("Could not write profile to cloud after installing course: " + iLPCourseProduct), (Throwable)exception);
        }
        if (iLPEProduct.getContentStateEnum() == ILPBookTypes.ContentState.CONTENT_STATE_FULLY_LOADED || iLPEProduct.getContentStateEnum() == ILPBookTypes.ContentState.CONTENT_STATE_PARTIALLY_LOADED) {
            c2.c();
        } else {
            c2.a(new ch.ionesoft.ilp.book.ia.b());
        }
    }

    private void installIssueProducts(List<ILPIssueProduct> list, c c2) {
        for (ILPIssueProduct iLPIssueProduct : list) {
            this.installIssueProduct(iLPIssueProduct, c2);
        }
    }

    private void installIssueProduct(ILPIssueProduct iLPIssueProduct, c c2) {
        List<ILPAssetProduct> list;
        List<ILPExerciseProduct> list2;
        List<ILPTopicProduct> list3 = f.a().e(iLPIssueProduct);
        if (list3 != null && !list3.isEmpty()) {
            this.installTopicProducts(list3, c2);
        }
        if ((list2 = f.a().f(iLPIssueProduct)) != null && !list2.isEmpty()) {
            this.installExerciseProducts(list2, c2);
        }
        if ((list = f.a().h(iLPIssueProduct)) != null && !list.isEmpty()) {
            this.installAssetProducts(list, c2);
        }
        if (this.installationScope == InstallationScope.ISSUE) {
            ILPInitializer.instance().linkResourcesOfIssue(iLPIssueProduct.getIssue(), c2);
            this.finalizeIssueInstallation(iLPIssueProduct, c2);
        }
    }

    private void finalizeIssueInstallation(ILPIssueProduct iLPIssueProduct, c c2) {
        ILPEProduct iLPEProduct = iLPIssueProduct.getEProduct();
        try {
            g.a().a(iLPIssueProduct);
            g.a().b(iLPIssueProduct.getIssue());
            if (!ILPBookHelper.hasPropertyInherited_forIssue("disableResourceEmbedder", iLPIssueProduct.getIssue(), false)) {
                ILPInitializer.instance().embedResourcesOfIssue(iLPIssueProduct.getIssue(), c2);
            }
        }
        catch (Exception exception) {
            logger.d((Object)("Could not resource embedd installed issue: " + iLPIssueProduct.getIssue()), (Throwable)exception);
        }
        this.rebuildContentStates(iLPEProduct);
        c2.a(o.a().d("label.progress.synchronizing"));
        ch.ionesoft.ilp.book.syn.d.a().a(iLPIssueProduct.getIssue(), true, true);
        ch.ionesoft.ilp.book.syn.d.a().e(true);
        c2.b();
        g.a().b(iLPEProduct);
        if (iLPEProduct.getContentStateEnum() == ILPBookTypes.ContentState.CONTENT_STATE_FULLY_LOADED || iLPEProduct.getContentStateEnum() == ILPBookTypes.ContentState.CONTENT_STATE_PARTIALLY_LOADED) {
            c2.c();
        } else {
            logger.c((Object)("Issue is not fully loaded: " + iLPIssueProduct));
            c2.a(new ch.ionesoft.ilp.book.ia.b());
        }
    }

    private void installTopicProducts(List<ILPTopicProduct> list, c c2) {
        Serializable serializable;
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        ArrayList<ch.ionesoft.ilp.book.ia.atma.e> arrayList = new ArrayList<ch.ionesoft.ilp.book.ia.atma.e>();
        for (ILPTopicProduct object22 : list) {
            if (object22.getEProduct().isFullyLoaded()) continue;
            object22.setTopicDefinitions(null);
            ForeignCollection<ILPTopicDefinition> foreignCollection = object22.getTopicDefinitions();
            if (foreignCollection == null || foreignCollection.isEmpty()) {
                logger.c((Object)("Topic product has no topicDefinition: " + object22));
                logger.c((Object)"This should not happen on a book that has topicDefinisions defined in pros. Maybe the courseConfig is not loaded.");
                ILPLogHelper.printStackTrace((Thread)Thread.currentThread(), (ILogger)logger);
                continue;
            }
            for (Object object : foreignCollection) {
                if (((ILPTopicDefinition)object).getContentLoaded().booleanValue()) continue;
                serializable = object22.determineLicenseWithValidUsage();
                if (serializable == null) {
                    logger.c((Object)("No license with a valid usage found for topicProduct: " + object22));
                    continue;
                }
                arrayList.add(new ch.ionesoft.ilp.book.ia.atma.e((ILPTopicDefinition)object, (ILPLicense)serializable));
                hashMap.put(((ILPTopicDefinition)object).getFileReference(), object);
            }
        }
        if (arrayList.isEmpty()) {
            logger.c((Object)("Nothing to download for topic products (might already be loaded): " + list));
            return;
        }
        a a2 = new a();
        List<b> list2 = a2.b(arrayList);
        if (list2 != null && !list2.isEmpty()) {
            for (b b2 : list2) {
                if (!b2.g()) {
                    logger.d((Object)("Could not download topic file: " + b2.a() + ", errorCode: " + b2.f()));
                    continue;
                }
                Object object = null;
                try {
                    object = (ILPTopicDefinition)hashMap.get(b2.c().a());
                    serializable = new URL(b2.d());
                    this.downloadAndImportEPub((ILPTopicDefinition)object, (URL)serializable, c2);
                }
                catch (Exception exception) {
                    logger.d((Object)("Could not import epub: " + b2.a() + " of topicDefinition: " + object), (Throwable)exception);
                }
            }
        }
    }

    private void installTopicProduct(ILPTopicProduct iLPTopicProduct, c c2) {
        ArrayList<ILPTopicProduct> arrayList = new ArrayList<ILPTopicProduct>();
        arrayList.add(iLPTopicProduct);
        this.installTopicProducts(arrayList, c2);
        if (this.installationScope == InstallationScope.TOPIC) {
            this.finalizeTopicInstallation(iLPTopicProduct, c2);
        }
    }

    private void finalizeExerciseInstallation(ILPExerciseProduct iLPExerciseProduct, c c2) {
        ILPEProduct iLPEProduct = iLPExerciseProduct.getEProduct();
        for (ILPExerciseDefinition iLPExerciseDefinition : f.a().a(iLPExerciseProduct)) {
            List<ILPExercise> list = f.a().a(iLPExerciseDefinition);
            ILPInitializer.instance().linkResourcesOfExercises(list, c2);
            if (ILPBookHelper.hasPropertyInherited_forIssue("disableResourceEmbedder", iLPExerciseProduct.getIssueProduct().getIssue(), false)) continue;
            ILPInitializer.instance().embedResourcesOfExercises(list, c2);
        }
        this.rebuildContentStates(iLPEProduct);
        c2.a(o.a().d("label.progress.synchronizing"));
        if (iLPExerciseProduct.getIssueProduct() != null) {
            ch.ionesoft.ilp.book.syn.d.a().a(iLPExerciseProduct.getIssueProduct().getIssue(), true, true);
        } else if (iLPExerciseProduct.getEProduct() != null && iLPExerciseProduct.getEProduct().determineCourseProduct() != null) {
            ch.ionesoft.ilp.book.syn.d.a().a(iLPExerciseProduct.getEProduct().determineCourseProduct().getCourse(), true, true);
        }
        ch.ionesoft.ilp.book.syn.d.a().e(true);
        c2.b();
        g.a().b(iLPEProduct);
        if (iLPEProduct.getContentStateEnum() == ILPBookTypes.ContentState.CONTENT_STATE_FULLY_LOADED || iLPEProduct.getContentStateEnum() == ILPBookTypes.ContentState.CONTENT_STATE_PARTIALLY_LOADED) {
            c2.c();
        } else {
            c2.a(new ch.ionesoft.ilp.book.ia.b());
        }
    }

    private void finalizeTopicInstallation(ILPTopicProduct iLPTopicProduct, c c2) {
        ILPEProduct iLPEProduct = iLPTopicProduct.getEProduct();
        for (ILPTopicDefinition iLPTopicDefinition : iLPTopicProduct.getTopicDefinitions()) {
            List<ILPTopic> list = f.a().a(iLPTopicDefinition);
            ILPInitializer.instance().linkResourcesOfTopics(list, c2);
            if (ILPBookHelper.hasPropertyInherited_forIssue("disableResourceEmbedder", iLPTopicProduct.getIssueProduct().getIssue(), false)) continue;
            ILPInitializer.instance().embedResourcesOfTopics(list, c2);
        }
        this.rebuildContentStates(iLPEProduct);
        c2.a(o.a().d("label.progress.synchronizing"));
        ch.ionesoft.ilp.book.syn.d.a().a(iLPTopicProduct.getIssueProduct().getIssue(), true, true);
        ch.ionesoft.ilp.book.syn.d.a().e(true);
        c2.b();
        g.a().b(iLPEProduct);
        if (iLPEProduct.getContentStateEnum() == ILPBookTypes.ContentState.CONTENT_STATE_FULLY_LOADED || iLPEProduct.getContentStateEnum() == ILPBookTypes.ContentState.CONTENT_STATE_PARTIALLY_LOADED) {
            c2.c();
        } else {
            c2.a(new ch.ionesoft.ilp.book.ia.b());
        }
    }

    private void installExerciseProducts(List<ILPExerciseProduct> list, c c2) {
        Object object;
        Object object2;
        Object object3;
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        ArrayList<ch.ionesoft.ilp.book.ia.atma.e> arrayList = new ArrayList<ch.ionesoft.ilp.book.ia.atma.e>();
        for (ILPExerciseProduct object42 : list) {
            object42.setExerciseDefinitions(null);
            object3 = f.a().a(object42);
            if (object3 == null || object3.isEmpty()) continue;
            object2 = object3.iterator();
            while (object2.hasNext()) {
                object = object2.next();
                if (((ILPExerciseDefinition)object).getContentLoaded().booleanValue()) continue;
                arrayList.add(new ch.ionesoft.ilp.book.ia.atma.e((ILPExerciseDefinition)object, object42.determineLicenseWithValidUsage()));
                hashMap.put(((ILPExerciseDefinition)object).getFileReference(), object);
            }
        }
        if (hashMap.isEmpty()) {
            return;
        }
        a a2 = new a();
        c2.a(o.a().d("resourceDetail.label.download"));
        List<b> list2 = a2.b(arrayList);
        if (list2 == null || list2.isEmpty()) {
            return;
        }
        object = list2.iterator();
        while (object.hasNext()) {
            object3 = (b)object.next();
            if (!((b)object3).g()) {
                logger.d((Object)("Could not download exercise file: " + ((b)object3).a() + ", errorCode: " + ((b)object3).f()));
                continue;
            }
            object2 = null;
            try {
                object2 = (ILPExerciseDefinition)hashMap.get(((b)object3).c().a());
                URL exception = new URL(((b)object3).d());
                this.importExercisesFromDefinition((ILPExerciseDefinition)object2, exception, c2);
                ((ILPExerciseDefinition)object2).setContentLoaded(true);
                ((ILPAbstractDefinition)object2).setCurrentVersion(((ILPAbstractDefinition)object2).getLatestVersion());
                g.a().aq().update(object2);
            }
            catch (Exception exception) {
                logger.d((Object)("Could not import exercises from: " + ((b)object3).a() + " of exerciseDefinition: " + object2), (Throwable)exception);
            }
        }
    }

    private void installExerciseProduct(ILPExerciseProduct iLPExerciseProduct, c c2) {
        ArrayList<ILPExerciseProduct> arrayList = new ArrayList<ILPExerciseProduct>();
        arrayList.add(iLPExerciseProduct);
        this.installExerciseProducts(arrayList, c2);
        if (this.installationScope == InstallationScope.EXERCISE) {
            this.finalizeExerciseInstallation(iLPExerciseProduct, c2);
        }
    }

    private void installAssetProducts(List<ILPAssetProduct> list, c c2) {
        for (ILPAssetProduct iLPAssetProduct : list) {
            this.installAssetProduct(iLPAssetProduct, c2);
        }
    }

    private void installAssetProduct(ILPAssetProduct iLPAssetProduct, c c2) {
        Object object;
        AbstractCoreDataModel abstractCoreDataModel;
        iLPAssetProduct.setAssetDefinitions(null);
        c2.a(String.valueOf(o.a().d("label.progress.installing")) + " " + iLPAssetProduct.getEProduct().getTitle());
        ForeignCollection<ILPAssetDefinition> foreignCollection = iLPAssetProduct.getAssetDefinitions();
        int n2 = foreignCollection.size();
        HashMap<Object, AbstractCoreDataModel> hashMap = new HashMap<Object, AbstractCoreDataModel>();
        int n3 = 0;
        if (foreignCollection != null && !foreignCollection.isEmpty()) {
            for (AbstractCoreDataModel abstractCoreDataModel2 : foreignCollection) {
                try {
                    abstractCoreDataModel = null;
                    if (((ILPAssetDefinition)abstractCoreDataModel2).getAssetProduct().getIssueProduct() != null) {
                        abstractCoreDataModel = ((ILPAssetDefinition)abstractCoreDataModel2).getAssetProduct().getIssueProduct().getIssue();
                    } else if (((ILPAssetDefinition)abstractCoreDataModel2).getAssetProduct().getCourseProduct() != null) {
                        abstractCoreDataModel = ((ILPAssetDefinition)abstractCoreDataModel2).getAssetProduct().getCourseProduct().getCourse().firstIssue();
                    }
                    object = f.a().k(((ILPAssetDefinition)abstractCoreDataModel2).getIdentifier(), (ILPIssueDef)abstractCoreDataModel);
                    if (object == null) {
                        object = ((ILPAssetDefinition)abstractCoreDataModel2).isMediaEdit() ? new ILPResource(ILPResource.ResourceLocation.RESOURCE_LOCATION_MEDIA_EDIT_SERVER) : new ILPResource(ILPResource.ResourceLocation.RESOURCE_LOCATION_ASSET_SERVER);
                        ((ILPResource)object).setIssue((ILPIssueDef)abstractCoreDataModel);
                        ((ILPResource)object).setIdentifier(((ILPAssetDefinition)abstractCoreDataModel2).getIdentifier());
                    }
                    ((ILPResource)object).setMediaType(((ILPAssetDefinition)abstractCoreDataModel2).getMediaType());
                    ((ILPResource)object).setAssetDefinition((ILPAssetDefinition)abstractCoreDataModel2);
                    ((ILPResource)object).setSizeBytes(((ILPAssetDefinition)abstractCoreDataModel2).getFileSizeBytes());
                    if (StringUtils.isNotBlank((CharSequence)((ILPAbstractDefinition)abstractCoreDataModel2).getLabel())) {
                        ((ILPResource)object).setTitle(((ILPAbstractDefinition)abstractCoreDataModel2).getLabel());
                    } else if (StringUtils.isNotBlank((CharSequence)((ILPAssetDefinition)abstractCoreDataModel2).getRelativeFilePath())) {
                        ((ILPResource)object).setTitle(StringHelper.extractTrailingString_after((String)((ILPAssetDefinition)abstractCoreDataModel2).getRelativeFilePath(), (String)"/"));
                    }
                    ((ILPAssetDefinition)abstractCoreDataModel2).setContentLoaded(true);
                    ((ILPAbstractDefinition)abstractCoreDataModel2).setCurrentVersion(((ILPAbstractDefinition)abstractCoreDataModel2).getLatestVersion());
                    g.a().ar().update((Object)abstractCoreDataModel2);
                    if (((AbstractCoreDataModel)object).isInDatabase()) {
                        g.a().H().update(object);
                    } else {
                        g.a().H().create(object);
                    }
                    if (((ILPAssetDefinition)abstractCoreDataModel2).getAssetTypeDefinition().getPreload().booleanValue()) {
                        hashMap.put(object, abstractCoreDataModel2);
                    }
                    ++n3;
                }
                catch (Exception exception) {
                    logger.d((Object)("Could not create resource for assetDefinition: " + abstractCoreDataModel2), (Throwable)exception);
                }
            }
            if (n3 == n2) {
                iLPAssetProduct.getEProduct().setContentState(ILPBookTypes.ContentState.CONTENT_STATE_FULLY_LOADED);
            } else if (n3 > 0) {
                iLPAssetProduct.getEProduct().setContentState(ILPBookTypes.ContentState.CONTENT_STATE_PARTIALLY_LOADED);
            }
            try {
                g.a().an().update((Object)iLPAssetProduct);
                g.a().ah().update((Object)iLPAssetProduct.getEProduct());
            }
            catch (SQLException sQLException) {
                logger.d((Object)("Could not update eProduct: " + iLPAssetProduct.getEProduct() + " of assetProduct: " + foreignCollection), (Throwable)sQLException);
            }
        }
        for (AbstractCoreDataModel abstractCoreDataModel2 : hashMap.keySet()) {
            ch.ionesoft.ilp.book.rm.a.a().a((ILPResource)abstractCoreDataModel2, c2);
            abstractCoreDataModel = (ILPAssetDefinition)hashMap.get(abstractCoreDataModel2);
            object = ILPAbstractAssetProcessStrategy.getStrategy(abstractCoreDataModel.getAssetTypeDefinition());
            ((ILPAbstractAssetProcessStrategy)object).processAssetDefinition((ILPAssetDefinition)abstractCoreDataModel, (ILPResource)abstractCoreDataModel2);
        }
        if (this.installationScope == InstallationScope.ASSET) {
            this.finalizeAssetInstallation(iLPAssetProduct, c2);
        }
    }

    private void finalizeAssetInstallation(ILPAssetProduct iLPAssetProduct, c c2) {
        c2.b();
        c2.c();
    }

    private void obtainLicenseUsage(ILPLicense iLPLicense, IALicenseManager.LicenseManagerCallBack licenseManagerCallBack) {
        IALicenseManager iALicenseManager = new IALicenseManager();
        iALicenseManager.obtainLicenseUsage(iLPLicense, licenseManagerCallBack);
    }

    private void downloadAndImportEPub(ILPTopicDefinition iLPTopicDefinition, URL uRL, c c2) {
        e e2 = e.a(iLPTopicDefinition);
        logger.b((Object)("Installing " + iLPTopicDefinition));
        e2.a(uRL, c2);
    }

    private void importExercisesFromDefinition(ILPExerciseDefinition iLPExerciseDefinition, URL uRL, c c2) throws SQLException {
        c2.a(iLPExerciseDefinition.getLabel());
        logger.b((Object)("Installing " + iLPExerciseDefinition));
        d d2 = d.a(iLPExerciseDefinition);
        d2.a(uRL, c2);
    }

    public void uninstallEProduct(ILPEProduct iLPEProduct, boolean bl2, c c2) {
        ILPEProduct.ProductType productType = iLPEProduct.getProductTypeEnum();
        boolean bl3 = false;
        c2.a();
        c2.d();
        ILPLicense iLPLicense = null;
        switch (productType) {
            case PRODUCT_TYPE_COURSE_PRODUCT: {
                this.installationScope = InstallationScope.COURSE;
                boolean bl4 = false;
                this.backupAndSynchronizeCourseProduct(iLPEProduct.getCourseProduct(), bl2, c2);
                this.uninstallCourseProduct(iLPEProduct.getCourseProduct(), bl3, bl4, bl2, c2);
                iLPLicense = iLPEProduct.getCourseProduct().determineLicenseWithValidUsage();
                break;
            }
            case PRODUCT_TYPE_ISSUE_PRODUCT: {
                this.installationScope = InstallationScope.ISSUE;
                boolean bl4 = true;
                this.backupAndSynchronizeIssueProduct(iLPEProduct.getIssueProduct(), bl2, c2);
                this.uninstallIssueProduct(iLPEProduct.getIssueProduct(), bl3, bl4, c2);
                iLPLicense = iLPEProduct.getIssueProduct().determineLicenseWithValidUsage();
                break;
            }
            case PRODUCT_TYPE_TOPIC_PRODUCT: {
                this.installationScope = InstallationScope.TOPIC;
                boolean bl4 = true;
                this.backupAndSynchronizeIssueProduct(iLPEProduct.getTopicProduct().getIssueProduct(), bl2, c2);
                this.uninstallTopicProduct(iLPEProduct.getTopicProduct(), bl3, bl4, c2);
                iLPLicense = iLPEProduct.getTopicProduct().determineLicenseWithValidUsage();
                break;
            }
            case PRODUCT_TYPE_EXERCISE_PRODUCT: {
                this.installationScope = InstallationScope.EXERCISE;
                boolean bl4 = true;
                this.backupAndSynchronizeIssueProduct(iLPEProduct.getExerciseProduct().getIssueProduct(), bl2, c2);
                this.uninstallExerciseProduct(iLPEProduct.getExerciseProduct(), bl3, bl4, c2);
                iLPLicense = iLPEProduct.getExerciseProduct().determineLicenseWithValidUsage();
                break;
            }
            case PRODUCT_TYPE_ASSET_PRODUCT: {
                this.installationScope = InstallationScope.ASSET;
                boolean bl4 = true;
                this.backupAndSynchronizeIssueProduct(iLPEProduct.getAssetProduct().getIssueProduct(), bl2, c2);
                this.uninstallAssetProduct(iLPEProduct.getAssetProduct(), bl3, bl4, c2);
                iLPLicense = iLPEProduct.getAssetProduct().determineLicenseWithValidUsage();
                break;
            }
            case PRODUCT_TYPE_PERMISSION_PRODUCT: {
                iLPLicense = iLPEProduct.getPermissionProduct().determineLicenseWithValidUsage();
            }
            default: {
                logger.d((Object)("No product type defined to uninstall eproduct: " + iLPEProduct));
            }
        }
        if (iLPLicense != null) {
            ch.ionesoft.ilp.book.ia.lima.d d2 = new ch.ionesoft.ilp.book.ia.lima.d();
            ch.ionesoft.ilp.book.ia.b b2 = d2.a(iLPLicense, ch.ionesoft.ilp.base.co.g.a().ag());
            if (b2.a() == b.a.a) {
                logger.b((Object)("Licenses succefully pruned. : " + b2));
            } else {
                logger.d((Object)("Licenses succefully pruned. : " + b2));
            }
        }
    }

    private void uninstallCourseProduct(ILPCourseProduct iLPCourseProduct, boolean bl2, boolean bl3, boolean bl4, c c2) {
        c2.a();
        c2.d();
        ILPCourseDef iLPCourseDef = iLPCourseProduct.getCourse();
        c2.a(0.5f);
        c2.a(String.valueOf(o.a().d("label.progress.deinstalling")) + " " + iLPCourseDef.getTitle());
        List<ILPIssueProduct> list = f.a().f(iLPCourseProduct);
        this.uninstallIssueProducts(list, bl2, bl3, c2);
        List<ILPExerciseProduct> list2 = f.a().i(iLPCourseProduct);
        this.uninstallExerciseProducts(list2, bl2, bl3, c2);
        List<ILPAssetProduct> list3 = f.a().n(iLPCourseProduct);
        this.uninstallAssetProducts(list3, bl2, bl3, c2);
        this.uninstallResourceSynch(iLPCourseProduct);
        this.uninstallScenariosFromEBook(iLPCourseProduct);
        try {
            f.a().a(iLPCourseProduct.getCourse(), c2);
        }
        catch (Exception exception) {
            logger.d((Object)("Could not finish deinstallation of course: " + iLPCourseProduct.getCourse()), (Throwable)exception);
        }
        try {
            iLPCourseProduct.setConfigCurrentVersion(null);
            iLPCourseProduct.getEProduct().setContentState(ILPBookTypes.ContentState.CONTENT_STATE_NOT_LOADED);
            g.a().aj().update((Object)iLPCourseProduct);
            this.setContentStateOfEProduct(iLPCourseProduct.getEProduct(), ILPBookTypes.ContentState.CONTENT_STATE_NOT_LOADED);
            try {
                ch.ionesoft.ilp.book.syn.b.b().e();
            }
            catch (Exception exception) {
                logger.d((Object)("Could not write profile to cloud after uninstall course: " + iLPCourseProduct), (Throwable)exception);
            }
            if (this.installationScope == InstallationScope.COURSE) {
                ILPBookSettingsHelper.instance().removeSettingsForCourse(iLPCourseDef);
                c2.b();
                c2.c();
            }
        }
        catch (SQLException sQLException) {
            logger.d((Object)"Could update courseProduct. ");
            c2.a(new ch.ionesoft.ilp.book.ia.b(sQLException));
        }
    }

    private void uninstallIssueProduct(ILPIssueProduct iLPIssueProduct, boolean bl2, boolean bl3, c c2) {
        ArrayList<ILPIssueProduct> arrayList = new ArrayList<ILPIssueProduct>();
        arrayList.add(iLPIssueProduct);
        this.uninstallIssueProducts(arrayList, bl2, bl3, c2);
        if (this.installationScope == InstallationScope.ISSUE && !bl2) {
            ILPCourseDef iLPCourseDef = iLPIssueProduct.getCourseProduct().getCourse();
            if (iLPCourseDef != null && ILPBookHelper.hasCourseTopicsLoaded(iLPCourseDef)) {
                ILPBookSettingsHelper.instance().removeSettingsForCourse(iLPCourseDef);
            }
            c2.b();
            c2.c();
        }
    }

    public void uninstallIssueProducts(List<ILPIssueProduct> list, boolean bl2, boolean bl3, c c2) {
        if (list != null && !list.isEmpty()) {
            for (ILPIssueProduct iLPIssueProduct : list) {
                logger.b((Object)("Deleting issue: " + iLPIssueProduct));
                try {
                    ForeignCollection<ILPAssetProduct> foreignCollection;
                    ForeignCollection<ILPExerciseProduct> foreignCollection2;
                    c2.a(String.valueOf(o.a().d("label.progress.deinstalling")) + " " + iLPIssueProduct.getTitle());
                    c2.a(0.5f);
                    ILPIssueDef iLPIssueDef = iLPIssueProduct.getIssue();
                    f.a().L(iLPIssueDef);
                    f.a().K(iLPIssueDef);
                    f.a().M(iLPIssueDef);
                    ForeignCollection<ILPTopicProduct> foreignCollection3 = iLPIssueProduct.getTopicProducts();
                    if (foreignCollection3 != null && !foreignCollection3.isEmpty()) {
                        this.uninstallTopicProducts(new ArrayList<ILPTopicProduct>((Collection<ILPTopicProduct>)foreignCollection3), bl2, bl3, c2);
                    }
                    if ((foreignCollection2 = iLPIssueProduct.getExerciseProducts()) != null && !foreignCollection2.isEmpty()) {
                        this.uninstallExerciseProducts(new ArrayList<ILPExerciseProduct>((Collection<ILPExerciseProduct>)foreignCollection2), bl2, bl3, c2);
                    }
                    if ((foreignCollection = iLPIssueProduct.getAssetProducts()) != null && !foreignCollection.isEmpty()) {
                        this.uninstallAssetProducts(new ArrayList<ILPAssetProduct>((Collection<ILPAssetProduct>)foreignCollection), bl2, bl3, c2);
                    }
                    if (!bl3) {
                        g.a().F().delete((Object)iLPIssueDef);
                    } else {
                        iLPIssueDef.setLastSync((DateTime)null);
                        g.a().F().update((Object)iLPIssueDef);
                    }
                    this.setContentStateOfEProduct(iLPIssueProduct.getEProduct(), ILPBookTypes.ContentState.CONTENT_STATE_NOT_LOADED);
                }
                catch (Exception exception) {
                    logger.d((Object)("Could not delete issueProduct: " + iLPIssueProduct), (Throwable)exception);
                    ch.ionesoft.ilp.base.co.f.b().D().displayWarningCode("message.internalError", new Object[0]);
                }
            }
        }
    }

    private void backupAndSynchronizeCourseProduct(ILPCourseProduct iLPCourseProduct, boolean bl2, c c2) {
        ILPCourseDef iLPCourseDef = iLPCourseProduct.getCourse();
        if (bl2) {
            logger.b((Object)String.format(Locale.ENGLISH, "Exporting user data for course: %s", iLPCourseDef.getCourseId()));
            c2.a(o.a().d("label.progress.synchronizing"));
            c2.a(0.3f);
            ch.ionesoft.ilp.book.syn.d.a().a(iLPCourseDef, true, false);
            ch.ionesoft.ilp.book.syn.d.a().d(iLPCourseDef);
            ch.ionesoft.ilp.book.syn.d.a().a(iLPCourseDef);
        } else {
            logger.b((Object)String.format(Locale.ENGLISH, "Deleting user data for course: %s", iLPCourseDef.getCourseId()));
            ch.ionesoft.ilp.book.syn.d.a().d(iLPCourseDef);
        }
    }

    private void backupAndSynchronizeIssueProduct(ILPIssueProduct iLPIssueProduct, boolean bl2, c c2) {
        if (iLPIssueProduct == null) {
            return;
        }
        ILPIssueDef iLPIssueDef = iLPIssueProduct.getIssue();
        Date date = new Date();
        if (bl2) {
            logger.b((Object)String.format(Locale.ENGLISH, "Exporting user data for issue: %s", iLPIssueProduct.getIssueIdentifier()));
            c2.a(o.a().d("label.progress.synchronizing"));
            c2.a(0.3f);
            logger.b((Object)("Creating backup of synched data into " + ch.ionesoft.ilp.book.cl.e.b(date)));
            ch.ionesoft.ilp.book.syn.d.a().a(iLPIssueDef, true, false);
            ch.ionesoft.ilp.book.syn.d.a().a(iLPIssueDef, date);
            ch.ionesoft.ilp.book.syn.d.a().a(iLPIssueDef);
        } else {
            logger.b((Object)String.format(Locale.ENGLISH, "Deleting user data for issue: %s", iLPIssueProduct.getIssueIdentifier()));
            logger.b((Object)("Creating backup of synched data into " + ch.ionesoft.ilp.book.cl.e.b(date)));
            ch.ionesoft.ilp.book.syn.d.a().a(iLPIssueDef, date);
        }
        ILPBookSettingsHelper.instance().removeETestSettingsForIssue(iLPIssueDef);
    }

    private void uninstallTopicProduct(ILPTopicProduct iLPTopicProduct, boolean bl2, boolean bl3, c c2) {
        try {
            f.a().a(iLPTopicProduct, bl3);
            this.setContentStateOfEProduct(iLPTopicProduct.getEProduct(), ILPBookTypes.ContentState.CONTENT_STATE_NOT_LOADED);
            if (this.installationScope == InstallationScope.TOPIC && !bl2) {
                c2.b();
                c2.c();
            }
        }
        catch (SQLException sQLException) {
            logger.d((Object)("Could not delete topicProduct: " + iLPTopicProduct), (Throwable)sQLException);
        }
    }

    private void uninstallTopicProducts(List<ILPTopicProduct> list, boolean bl2, boolean bl3, c c2) {
        if (list != null && !list.isEmpty()) {
            for (ILPTopicProduct iLPTopicProduct : list) {
                this.uninstallTopicProduct(iLPTopicProduct, bl2, bl3, c2);
            }
        }
    }

    private void uninstallExerciseProduct(ILPExerciseProduct iLPExerciseProduct, boolean bl2, boolean bl3, c c2) {
        try {
            f.a().a(iLPExerciseProduct, bl3);
            this.setContentStateOfEProduct(iLPExerciseProduct.getEProduct(), ILPBookTypes.ContentState.CONTENT_STATE_NOT_LOADED);
            if (this.installationScope == InstallationScope.EXERCISE && !bl2) {
                c2.b();
                c2.c();
            }
        }
        catch (SQLException sQLException) {
            logger.d((Object)("Could not delete exercise of exerciseProduct: " + iLPExerciseProduct), (Throwable)sQLException);
        }
    }

    private void uninstallExerciseProducts(List<ILPExerciseProduct> list, boolean bl2, boolean bl3, c c2) {
        if (list != null && !list.isEmpty()) {
            for (ILPExerciseProduct iLPExerciseProduct : list) {
                this.uninstallExerciseProduct(iLPExerciseProduct, bl2, bl3, c2);
            }
        }
    }

    private void uninstallAssetProduct(ILPAssetProduct iLPAssetProduct, boolean bl2, boolean bl3, c c2) {
        try {
            f.a().a(iLPAssetProduct, bl3);
            this.setContentStateOfEProduct(iLPAssetProduct.getEProduct(), ILPBookTypes.ContentState.CONTENT_STATE_NOT_LOADED);
            if (this.installationScope == InstallationScope.ASSET && !bl2) {
                c2.b();
                c2.c();
            }
        }
        catch (SQLException sQLException) {
            logger.d((Object)("Could not delete assets of assetProduct: " + iLPAssetProduct), (Throwable)sQLException);
        }
    }

    private void uninstallAssetProducts(List<ILPAssetProduct> list, boolean bl2, boolean bl3, c c2) {
        if (list != null && !list.isEmpty()) {
            for (ILPAssetProduct iLPAssetProduct : list) {
                this.uninstallAssetProduct(iLPAssetProduct, bl2, bl3, c2);
            }
        }
    }

    private void uninstallResourceSynch(ILPCourseProduct iLPCourseProduct) {
        String string = ILPBookSettingsHelper.instance().resourceSynchDirForCourse(iLPCourseProduct);
        File file = new File(string);
        FileUtils.deleteQuietly((File)file);
    }

    private void uninstallScenariosFromEBook(ILPCourseProduct iLPCourseProduct) {
        List<ILPScenarioSpecification> list = f.a().z(iLPCourseProduct.getCourse());
        int n2 = list.size();
        if (n2 > 0) {
            logger.b((Object)("Remove " + n2 + " scenario specifications of course."));
        }
        for (ILPScenarioSpecification iLPScenarioSpecification : list) {
            try {
                if (iLPScenarioSpecification.getVersion() != null && iLPScenarioSpecification.getVersion() == 2) {
                    logger.b((Object)"Skipped delete of scenarioDefinition on course uninstall --> definition is related to task specification");
                    continue;
                }
                ILPScenarioDefinition iLPScenarioDefinition = iLPScenarioSpecification.getScenarioDefinition();
                if (iLPScenarioDefinition != null) {
                    ILPScenarioManager.getInstance().deleteScenarioDefinitionFromDatabase(iLPScenarioDefinition);
                }
                g.a().aM().delete((Object)iLPScenarioSpecification);
            }
            catch (Exception exception) {
                logger.d((Object)("Could not delete scenario spcecification: " + iLPScenarioSpecification), (Throwable)exception);
            }
        }
    }

    public void updateEProduct(ILPEProduct iLPEProduct, boolean bl2, c c2) {
        c2.a();
        c2.d();
        ILPEProduct.ProductType productType = iLPEProduct.getProductTypeEnum();
        switch (productType) {
            case PRODUCT_TYPE_COURSE_PRODUCT: {
                this.installationScope = InstallationScope.COURSE;
                this.backupAndSynchronizeCourseProduct(iLPEProduct.getCourseProduct(), bl2, c2);
                this.updateCourseProduct(iLPEProduct.getCourseProduct(), c2);
                break;
            }
            case PRODUCT_TYPE_ISSUE_PRODUCT: {
                this.installationScope = InstallationScope.ISSUE;
                this.backupAndSynchronizeIssueProduct(iLPEProduct.getIssueProduct(), bl2, c2);
                ILPConfigurationManager iLPConfigurationManager = new ILPConfigurationManager();
                if (iLPEProduct.getIssueProduct().getCourseProduct().isUpdateAvailable()) {
                    logger.b((Object)("Updating courseConfig for course: " + iLPEProduct.getIssueProduct().getCourseProduct()));
                    iLPConfigurationManager.downloadAndInstallCourseConfig(iLPEProduct.getIssueProduct().getCourseProduct(), c2);
                }
                this.updateIssueProduct(iLPEProduct.getIssueProduct(), c2);
                break;
            }
            case PRODUCT_TYPE_EXERCISE_PRODUCT: {
                this.installationScope = InstallationScope.EXERCISE;
                this.backupAndSynchronizeIssueProduct(iLPEProduct.getIssueProduct(), bl2, c2);
                this.updateExerciseProduct(iLPEProduct.getExerciseProduct(), c2);
                break;
            }
            case PRODUCT_TYPE_ASSET_PRODUCT: {
                this.installationScope = InstallationScope.ASSET;
                this.backupAndSynchronizeIssueProduct(iLPEProduct.getIssueProduct(), bl2, c2);
                this.updateAssetProduct(iLPEProduct.getAssetProduct(), c2);
                break;
            }
            case PRODUCT_TYPE_TOPIC_PRODUCT: {
                this.installationScope = InstallationScope.TOPIC;
                this.backupAndSynchronizeIssueProduct(iLPEProduct.getIssueProduct(), bl2, c2);
                this.updateTopicProduct(iLPEProduct.getTopicProduct(), c2);
                break;
            }
            default: {
                logger.d((Object)("No product type defined to update eproduct: " + iLPEProduct));
            }
        }
    }

    private void updateCourseProduct(ILPCourseProduct iLPCourseProduct, c c2) {
        int n2 = iLPCourseProduct.getIssueProducts().size();
        int n3 = 0;
        ILPConfigurationManager iLPConfigurationManager = new ILPConfigurationManager();
        logger.b((Object)("Updating courseConfig for course: " + iLPCourseProduct));
        iLPConfigurationManager.downloadAndInstallCourseConfig(iLPCourseProduct, c2);
        for (ILPAbstractProduct iLPAbstractProduct : iLPCourseProduct.getIssueProducts()) {
            c2.a(n3 * 1 / n2);
            this.updateIssueProduct((ILPIssueProduct)iLPAbstractProduct, c2);
        }
        c2.a(0.9f);
        for (ILPAbstractProduct iLPAbstractProduct : iLPCourseProduct.getAssetProducts()) {
            this.updateAssetProduct((ILPAssetProduct)iLPAbstractProduct, c2);
        }
        for (ILPAbstractProduct iLPAbstractProduct : iLPCourseProduct.getExerciseProducts()) {
            this.updateExerciseProduct((ILPExerciseProduct)iLPAbstractProduct, c2);
        }
        ILPInitializer.instance().linkResourcesOfCourse(iLPCourseProduct.getCourse(), c2);
        this.finalizeCourseInstallation(iLPCourseProduct, c2);
        c2.a(1.0f);
        if (iLPCourseProduct.getEProduct().getContentStateEnum() == ILPBookTypes.ContentState.CONTENT_STATE_FULLY_LOADED || iLPCourseProduct.getEProduct().getContentStateEnum() == ILPBookTypes.ContentState.CONTENT_STATE_PARTIALLY_LOADED) {
            c2.c();
        } else {
            c2.a(new ch.ionesoft.ilp.book.ia.b());
        }
    }

    private void updateIssueProduct(ILPIssueProduct iLPIssueProduct, c c2) {
        boolean bl2 = true;
        boolean bl3 = true;
        if (iLPIssueProduct.isUpdateAvailable()) {
            this.uninstallIssueProduct(iLPIssueProduct, bl2, bl3, c2);
            this.installIssueProduct(iLPIssueProduct, c2);
        }
    }

    private void updateTopicProduct(ILPTopicProduct iLPTopicProduct, c c2) {
        if (iLPTopicProduct.isUpdateAvailable()) {
            this.uninstallTopicProduct(iLPTopicProduct, true, true, c2);
            this.installTopicProduct(iLPTopicProduct, c2);
        }
    }

    private void updateExerciseProduct(ILPExerciseProduct iLPExerciseProduct, c c2) {
        if (iLPExerciseProduct.isUpdateAvailable()) {
            this.uninstallExerciseProduct(iLPExerciseProduct, true, true, c2);
            this.installExerciseProduct(iLPExerciseProduct, c2);
        }
    }

    private void updateAssetProduct(ILPAssetProduct iLPAssetProduct, c c2) {
        if (iLPAssetProduct.isUpdateAvailable()) {
            this.uninstallAssetProduct(iLPAssetProduct, true, true, c2);
            this.installAssetProduct(iLPAssetProduct, c2);
        }
    }

    public void rebuildContentStates(ILPEProduct iLPEProduct) {
        this.rebuildContentStateOfCourseProduct(iLPEProduct.determineCourseProduct());
    }

    private void rebuildContentStateOfCourseProduct(ILPCourseProduct iLPCourseProduct) {
        List<ILPExerciseProduct> list;
        try {
            g.a().aj().refresh((Object)iLPCourseProduct);
        }
        catch (SQLException sQLException) {
            logger.d((Object)("Could not refresh courseProduct: " + iLPCourseProduct));
        }
        List<ILPIssueProduct> list2 = f.a().f(iLPCourseProduct);
        if (list2 != null && !list2.isEmpty()) {
            for (ILPIssueProduct object32 : list2) {
                this.rebuildContentStateOfIssueProduct(object32);
            }
        }
        if ((list = f.a().i(iLPCourseProduct)) != null & !list.isEmpty()) {
            for (Object object : list) {
                this.rebuildContentStateOfExerciseProduct((ILPExerciseProduct)object);
            }
        }
        try {
            Object object;
            g.a().a(iLPCourseProduct);
            object = f.a().p(iLPCourseProduct);
            ILPEProduct iLPEProduct = iLPCourseProduct.getEProduct();
            iLPEProduct.setContentState((ILPBookTypes.ContentState)((Object)object));
            g.a().ah().update((Object)iLPEProduct);
            if (object != ILPBookTypes.ContentState.CONTENT_STATE_FULLY_LOADED) {
                logger.c((Object)("CourseProduct: " + iLPCourseProduct + ", seems not to be fully loaded: " + object));
            }
        }
        catch (Exception exception) {
            logger.d((Object)("Could not update eProduct: " + iLPCourseProduct.getEProduct()), (Throwable)exception);
        }
    }

    private void rebuildContentStateOfIssueProduct(ILPIssueProduct iLPIssueProduct) {
        Object object3;
        Object object22;
        try {
            g.a().ak().refresh((Object)iLPIssueProduct);
        }
        catch (SQLException sQLException) {
            logger.d((Object)("Could not refresh issueProduct: " + iLPIssueProduct));
        }
        ForeignCollection<ILPTopicProduct> foreignCollection = iLPIssueProduct.getTopicProducts();
        if (foreignCollection != null && !foreignCollection.isEmpty()) {
            for (Object object22 : foreignCollection) {
                this.rebuildContentStateOfTopicProduct((ILPTopicProduct)object22);
            }
        }
        if ((object22 = iLPIssueProduct.getExerciseProducts()) != null && !object22.isEmpty()) {
            for (Object object3 : object22) {
                this.rebuildContentStateOfExerciseProduct((ILPExerciseProduct)object3);
            }
        }
        object3 = f.a().a(iLPIssueProduct);
        ILPEProduct iLPEProduct = iLPIssueProduct.getEProduct();
        if (object3 != ILPBookTypes.ContentState.CONTENT_STATE_FULLY_LOADED) {
            logger.c((Object)("IssueProduct: " + iLPIssueProduct + ", seems not to be fully loaded: " + object3));
        }
        iLPEProduct.setContentState(((ILPBookTypes.ContentState)((Object)object3)).getType());
        try {
            g.a().ah().update((Object)iLPEProduct);
        }
        catch (SQLException sQLException) {
            logger.d((Object)("Could not update eProduct: " + iLPIssueProduct.getEProduct()), (Throwable)sQLException);
        }
    }

    private void rebuildContentStateOfExerciseProduct(ILPExerciseProduct iLPExerciseProduct) {
        try {
            g.a().am().refresh((Object)iLPExerciseProduct);
        }
        catch (SQLException sQLException) {
            logger.d((Object)("Could not refresh exerciseProduct: " + iLPExerciseProduct));
        }
        ILPBookTypes.ContentState contentState = f.a().b(iLPExerciseProduct);
        ILPEProduct iLPEProduct = iLPExerciseProduct.getEProduct();
        if (contentState != ILPBookTypes.ContentState.CONTENT_STATE_FULLY_LOADED) {
            logger.c((Object)("ExerciseProduct: " + iLPExerciseProduct + ", seems not to be fully loaded: " + (Object)((Object)contentState)));
        }
        iLPEProduct.setContentState(contentState);
        try {
            g.a().ah().update((Object)iLPEProduct);
        }
        catch (SQLException sQLException) {
            logger.d((Object)("Could not update content state of eProduct: " + iLPExerciseProduct.getEProduct()));
        }
    }

    private void rebuildContentStateOfTopicProduct(ILPTopicProduct iLPTopicProduct) {
        try {
            g.a().al().refresh((Object)iLPTopicProduct);
        }
        catch (SQLException sQLException) {
            logger.d((Object)("Could not refresh topicProduct: " + iLPTopicProduct));
        }
        ILPBookTypes.ContentState contentState = f.a().b(iLPTopicProduct);
        ILPEProduct iLPEProduct = iLPTopicProduct.getEProduct();
        if (contentState != ILPBookTypes.ContentState.CONTENT_STATE_FULLY_LOADED) {
            logger.c((Object)("TopicProduct: " + iLPTopicProduct + ", seems not to be fully loaded: " + (Object)((Object)contentState)));
        }
        iLPEProduct.setContentState(contentState);
        try {
            g.a().ah().update((Object)iLPEProduct);
        }
        catch (SQLException sQLException) {
            logger.d((Object)("Could not update content state of eProduct: " + iLPTopicProduct.getEProduct()));
        }
    }

    private void setContentStateOfEProduct(ILPEProduct iLPEProduct, ILPBookTypes.ContentState contentState) {
        try {
            g.a().b(iLPEProduct);
            iLPEProduct.setContentState(contentState);
            g.a().ah().update((Object)iLPEProduct);
        }
        catch (Exception exception) {
            logger.d((Object)("Could not update eProduct: " + iLPEProduct), (Throwable)exception);
        }
    }

    public static enum InstallationScope {
        COURSE,
        ISSUE,
        TOPIC,
        EXERCISE,
        ASSET;

    }
}

