/*
 * Decompiled with CFR 0.152.
 */
package ch.ionesoft.ilp.book.co;

import ch.ionesoft.ilp.base.co.ILPLogManager;
import ch.ionesoft.ilp.base.co.ILogger;
import ch.ionesoft.ilp.base.co.h;
import ch.ionesoft.ilp.base.co.n;
import ch.ionesoft.ilp.base.co.o;
import ch.ionesoft.ilp.base.co.p;
import ch.ionesoft.ilp.base.fo.x;
import ch.ionesoft.ilp.base.fo.z;
import ch.ionesoft.ilp.base.he.ConverterUtil;
import ch.ionesoft.ilp.base.he.DESEncrypter;
import ch.ionesoft.ilp.base.he.ILPLogHelper;
import ch.ionesoft.ilp.base.he.StringHelper;
import ch.ionesoft.ilp.base.he.SystemHelper;
import ch.ionesoft.ilp.book.au.c;
import ch.ionesoft.ilp.book.cl.g;
import ch.ionesoft.ilp.book.co.IAUserManager;
import ch.ionesoft.ilp.book.co.ILPBookHelper;
import ch.ionesoft.ilp.book.co.ILPBookRegistry;
import ch.ionesoft.ilp.book.co.ILPBookTypes;
import ch.ionesoft.ilp.book.co.ILPProfileManager;
import ch.ionesoft.ilp.book.dto.a;
import ch.ionesoft.ilp.book.he.e;
import ch.ionesoft.ilp.book.ia.lima.b;
import ch.ionesoft.ilp.book.mo.AbstractCoreDataModel;
import ch.ionesoft.ilp.book.mo.ILPAbstractProduct;
import ch.ionesoft.ilp.book.mo.ILPAccount;
import ch.ionesoft.ilp.book.mo.ILPAgent;
import ch.ionesoft.ilp.book.mo.ILPAnswer;
import ch.ionesoft.ilp.book.mo.ILPCourseDef;
import ch.ionesoft.ilp.book.mo.ILPCourseProduct;
import ch.ionesoft.ilp.book.mo.ILPEProduct;
import ch.ionesoft.ilp.book.mo.ILPExercise;
import ch.ionesoft.ilp.book.mo.ILPGroup;
import ch.ionesoft.ilp.book.mo.ILPIssueDef;
import ch.ionesoft.ilp.book.mo.ILPIssueProduct;
import ch.ionesoft.ilp.book.mo.ILPLicense;
import ch.ionesoft.ilp.book.mo.ILPMandant;
import ch.ionesoft.ilp.book.mo.ILPNote;
import ch.ionesoft.ilp.book.mo.ILPProperty;
import ch.ionesoft.ilp.book.mo.ILPQuestion;
import ch.ionesoft.ilp.book.mo.ILPResource;
import ch.ionesoft.ilp.book.mo.ILPSystemProperty;
import ch.ionesoft.ilp.book.mo.ILPTopic;
import ch.ionesoft.ilp.book.mo.ILPUser;
import ch.ionesoft.ilp.book.pe.g;
import com.j256.ormlite.dao.ForeignCollection;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.net.util.SubnetUtils;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.ISODateTimeFormat;
import org.json.ionesoft.f;
import org.json.ionesoft.i;

public class ILPBookSettingsHelper {
    private static ILogger logger = ILPLogManager.getLogger(ILPBookSettingsHelper.class);
    public static final String kApplicationConfigOpenUrlsExternally = "open.urls.externally";
    public static final String EBOOK_SYNCHRONIZE_NEVER = "EBOOK_SYNCHRONIZE_NEVER";
    public static final String EBOOK_SYNCHRONIZE_MANUALLY = "EBOOK_SYNCHRONIZE_MANUALLY";
    public static final String EBOOK_SYNCHRONIZE_HOURLY = "EBOOK_SYNCHRONIZE_HOURLY";
    public static final String EBOOK_SYNCHRONIZE_ON_LEAVE = "EBOOK_SYNCHRONIZE_ON_LEAVE";
    public static final String KEYCHAIN_GROUP_ENCRYPTION_SERVICE = "GroupEncryptionService";
    public static final String KEYCHAIN_GROUP_ENCRYPTION_KEY = "GroupEncryptionKey";
    public static final String kApplicationConfigCloudRootDirectory = "cloud.root.directory";
    public static final String kApplicationConfigCloudService = "cloud.service.linked";
    public static final String kApplicationConfigEbookSynchronizeStrategy = "ebook.synchronize";
    public static final String kApplicationConfigCloudSyncMedia = "cloud.sync.media";
    public static final String kApplicationConfigCloudSyncMediaAutomatically = "cloud.sync.media.automatically";
    public static final String kApplicationConfigCloudEncryptMedia = "cloud.encrypt.media";
    private static final String kApplicationConfigCloudSync3G = "cloud.sync.3g";
    private static final String kApplicationConfigAutoRegisterLicenses = "license.autoregister";
    public static final String DEVICE_INFO = "device.info";
    public static final String kApplicationConfigHighestProfileNumber = "highest.profile.number";
    public static final String kApplicationConfigAlwaysShrinkImages = "always.shrink.images.extended.usertopic";
    public static final String kSystemPropertyGroupServerLastSynch = "GROUPSERVER_GROUPS_LASTSYNCH_ISODATETIME_STRING";
    public static final String kSystemPropertyGroupServerHighestTransactionIndex = "GROUPSERVER_GROUPS_HIGHEST_TRANSACTION_INDEX_STRING";
    public static final String kSystemPropertyLessonsCurrentTaskVersion = "BEOOKLMS_HIGHEST_TASK_VERSION";
    private static final String kExternalEmailClientHint = "email.hint.disabled";
    private DESEncrypter databaseDESEncrypter;
    private String cloudEncryptionIV;
    private String globalSharingEncryptionKey;
    private String globalSharingEncryptionIV;
    private String veledesEtestingClientSecret;
    private String mmtsEtestingApiKey;
    private boolean askedForLogin;
    private static ILPBookSettingsHelper sharedInstance = null;
    private static final String ANSWER_ENCRYPTION_PREFIX = "AT$";
    private static final String QUESTION_ENCRYPTION_PREFIX = "QT$";
    private static final String EXERCISE_ENCRYPTION_PREFIX = "ET$";
    private static final String USER_ENCRYPTION_PREFIX = "UT$";
    private static final String GROUP_ENCRYPTION_PREFIX = "GT$";
    private static final String PROPERTY_ENCRYPTION_PREFIX = "PR$";

    public static void initLogger() {
        logger = ILPLogManager.getLogger(ILPBookSettingsHelper.class);
    }

    public static ILPBookSettingsHelper instance() {
        if (sharedInstance == null) {
            sharedInstance = new ILPBookSettingsHelper();
            try {
                ILPBookSettingsHelper.sharedInstance.databaseDESEncrypter = new DESEncrypter(sharedInstance.databaseEncryptionKey(), sharedInstance.databaseEncryptionIV());
            }
            catch (Exception exception) {
                logger.d((Object)("Could not create databaseDESEncrypter: " + exception));
            }
        }
        return sharedInstance;
    }

    public void updateDeviceInfo() {
        this.setDeviceInfo(new b());
        logger.b((Object)"Successfully updated device info in user profile.");
    }

    public void setDeviceInfo(b b2) {
        p.e().a(DEVICE_INFO, (Object)b2.hashCode());
        p.e().g();
    }

    public int getDeviceInfoHash() {
        try {
            return p.e().f(DEVICE_INFO);
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public boolean hasDeviceInfoChanged() {
        b b2 = new b();
        int n2 = b2.hashCode();
        return n2 != this.getDeviceInfoHash();
    }

    public void setOpenUrlsExternally(boolean bl2) {
        p.e().a(kApplicationConfigOpenUrlsExternally, (Object)bl2);
        p.e().g();
    }

    public boolean isOpenUrlsExternally() {
        if (!ILPBookRegistry.instance().authorizationManager().a(c.b.t, true)) {
            return true;
        }
        if (n.b().a("disableInternalBrowser", false)) {
            return true;
        }
        if (IAUserManager.isBrowserDisallowedForCurrentUser()) {
            return true;
        }
        return p.e().a(kApplicationConfigOpenUrlsExternally, Boolean.valueOf(false));
    }

    public String formattedLicenseInfo() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(o.a().d("message.license.product.info"));
        stringBuffer.append("\n");
        c c2 = ILPBookRegistry.instance().authorizationManager();
        if (c2 != null) {
            try {
                List<ILPEProduct> list = ch.ionesoft.ilp.book.pe.f.a().G();
                for (ILPEProduct iLPEProduct : list) {
                    boolean bl2 = c2.c(iLPEProduct);
                    if (!bl2) continue;
                    stringBuffer.append("\n- ");
                    stringBuffer.append(iLPEProduct.getTitle());
                    try {
                        if (iLPEProduct.isIssueProduct()) {
                            stringBuffer.append(" \u2013 " + iLPEProduct.getIssueProduct().getCourseProduct().getTitle());
                        }
                    }
                    catch (Exception exception) {
                        logger.c((Object)("Could not get courseProduct: " + iLPEProduct));
                    }
                    stringBuffer.append(", " + c2.d(iLPEProduct).getShortName());
                    ILPLicense iLPLicense = iLPEProduct.determineLicense();
                    stringBuffer.append(", " + (iLPLicense != null ? iLPLicense.getLocalizedLicenseState() : "-"));
                }
            }
            catch (Exception exception) {
                logger.d((Object)"Could not get EProducts with licenseInfo", (Throwable)exception);
                stringBuffer.append(o.a().d("message.import.failure"));
            }
        }
        stringBuffer.append("\n\n");
        return stringBuffer.toString();
    }

    public static void logInstallationStatus() {
        try {
            logger.b((Object)String.format(Locale.ENGLISH, "Installation status  - - - - - - - - - - - - - - - - - - - - - - - -", new Object[0]));
            boolean bl2 = g.a().f();
            logger.b((Object)("Database health check is: " + (bl2 ? "fine" : "unknown")));
            ILPBookSettingsHelper.logCompleteLicenseInfo();
            String string = ILPProfileManager.instance().getCurrentProfile().currentCourseReference();
            String string2 = ILPProfileManager.instance().getCurrentProfile().currentCourseId();
            if (string2 != null && string != null) {
                logger.b((Object)String.format(Locale.ENGLISH, "Current course id: %s, reference: %s", string2, string));
                ILPIssueDef iLPIssueDef = ILPProfileManager.instance().getCurrentProfile().currentIssueForCourseId_courseReference(string2, string, false);
                if (iLPIssueDef != null) {
                    logger.b((Object)String.format(Locale.ENGLISH, "Current issue id: %s (for mentioned course above)", iLPIssueDef != null ? iLPIssueDef.getIssueId() : "-"));
                } else {
                    logger.b((Object)"No current issue set.");
                }
            } else {
                logger.b((Object)"No current course set.");
            }
        }
        catch (Exception exception) {
            logger.c((Object)"Could not properly log installation status.", (Throwable)exception);
        }
    }

    private static void logCompleteLicenseInfo() {
        try {
            ILPLogHelper iLPLogHelper = new ILPLogHelper();
            List<ILPLicense> list = ch.ionesoft.ilp.book.pe.f.a().S();
            if (list == null || list.isEmpty()) {
                logger.c((Object)"User does not have any licenses. ");
                return;
            }
            for (ILPLicense iLPLicense : list) {
                try {
                    AbstractCoreDataModel abstractCoreDataModel;
                    ILPEProduct iLPEProduct = iLPLicense.getEProduct();
                    if (iLPEProduct == null) {
                        logger.d((Object)("Invalid license, has no eProduct: " + iLPLicense));
                        continue;
                    }
                    g.a().b(iLPEProduct);
                    String string = iLPEProduct.isCourseProduct() && iLPEProduct.getCourseProduct() != null ? iLPEProduct.getCourseProduct().getCourseIdentifier() : iLPEProduct.getProductReference();
                    iLPLogHelper.add(String.valueOf(string) + " \u2013 " + iLPEProduct.getTitle());
                    iLPLogHelper.add(ILPBookSettingsHelper.fli(String.format("[Detail] eProduct productReference: %s, productType: %s, releaseDate: %s, detailInfo: %s", iLPEProduct.getProductReference(), iLPEProduct.getProductTypeEnum().getCode(), iLPEProduct.getReleaseDate() != null ? iLPEProduct.getReleaseDate().toDate() : null, iLPEProduct.getProductImpl() != null ? iLPEProduct.getProductImpl().getDetailInfo() : null)));
                    if (iLPLicense.getLicenseStateType() == ILPLicense.LicenseState.LICENSE_STATE_VALID) {
                        iLPLogHelper.add(ILPBookSettingsHelper.fli(String.format("LicenseState: %s", iLPLicense.getLicenseStateType().getCode()), ILPLogHelper.LogAttentionType.LOG_ATTENTION_TYPE_NONE));
                    } else {
                        iLPLogHelper.add(ILPBookSettingsHelper.fli(String.format("LicenseState: %s", iLPLicense.getLicenseStateType().getCode()), ILPLogHelper.LogAttentionType.LOG_ATTENTION_TYPE_HINT));
                    }
                    iLPLogHelper.add(ILPBookSettingsHelper.fli(String.format("LicenseStrategy: %s", iLPLicense.getLicenseStrategyType().getShortName()), ILPLogHelper.LogAttentionType.LOG_ATTENTION_TYPE_NONE));
                    if (iLPEProduct.isCourseProduct()) {
                        abstractCoreDataModel = iLPEProduct.getCourseProduct().getCourse();
                        if (abstractCoreDataModel != null) {
                            iLPLogHelper.add(ILPBookSettingsHelper.fli(String.format("Num Topics: %s", ch.ionesoft.ilp.book.pe.f.a().m((ILPCourseDef)abstractCoreDataModel)), ILPLogHelper.LogAttentionType.LOG_ATTENTION_TYPE_NONE));
                            iLPLogHelper.add(ILPBookSettingsHelper.fli(String.format("Num Exercises: %s", ch.ionesoft.ilp.book.pe.f.a().v((ILPCourseDef)abstractCoreDataModel)), ILPLogHelper.LogAttentionType.LOG_ATTENTION_TYPE_NONE));
                        }
                    } else if (iLPEProduct.isIssueProduct() && (abstractCoreDataModel = iLPEProduct.getIssueProduct().getIssue()) != null) {
                        iLPLogHelper.add(ILPBookSettingsHelper.fli(String.format("Num Topics: %s", ch.ionesoft.ilp.book.pe.f.a().s((ILPIssueDef)abstractCoreDataModel)), ILPLogHelper.LogAttentionType.LOG_ATTENTION_TYPE_NONE));
                        iLPLogHelper.add(ILPBookSettingsHelper.fli(String.format("Num Exercises: %s", ch.ionesoft.ilp.book.pe.f.a().e((ILPIssueDef)abstractCoreDataModel, null)), ILPLogHelper.LogAttentionType.LOG_ATTENTION_TYPE_NONE));
                    }
                    if (iLPEProduct.isFullyLoaded()) {
                        iLPLogHelper.add(ILPBookSettingsHelper.fli(String.format("All issues installed.", new Object[0]), ILPLogHelper.LogAttentionType.LOG_ATTENTION_TYPE_NONE));
                    } else if (iLPEProduct.getContentStateEnum() == ILPBookTypes.ContentState.CONTENT_STATE_PARTIALLY_LOADED) {
                        iLPLogHelper.add(ILPBookSettingsHelper.fli(String.format("Issues partially installed.", new Object[0]), ILPLogHelper.LogAttentionType.LOG_ATTENTION_TYPE_HINT));
                    } else if (iLPEProduct.getContentStateEnum() == ILPBookTypes.ContentState.CONTENT_STATE_NOT_LOADED) {
                        iLPLogHelper.add(ILPBookSettingsHelper.fli(String.format("No issues installed.", new Object[0]), ILPLogHelper.LogAttentionType.LOG_ATTENTION_TYPE_NONE));
                    } else {
                        iLPLogHelper.add(ILPBookSettingsHelper.fli(String.format("Undefined courseState.", new Object[0]), ILPLogHelper.LogAttentionType.LOG_ATTENTION_TYPE_NONE));
                    }
                    if (iLPEProduct.isUpdateAvailable()) {
                        iLPLogHelper.add(ILPBookSettingsHelper.fli(String.format("Update available.", new Object[0]), ILPLogHelper.LogAttentionType.LOG_ATTENTION_TYPE_HINT));
                        continue;
                    }
                    iLPLogHelper.add(ILPBookSettingsHelper.fli(String.format("No update available.", new Object[0]), ILPLogHelper.LogAttentionType.LOG_ATTENTION_TYPE_NONE));
                }
                catch (Exception exception) {
                    logger.d((Object)("Invalid license, could not be logged: " + iLPLicense), (Throwable)exception);
                }
            }
            logger.d((Object)iLPLogHelper.getContent());
        }
        catch (Exception exception) {
            logger.d((Object)"Could not properly log complete license info", (Throwable)exception);
        }
    }

    private static String fli(String string) {
        return ILPBookSettingsHelper.fli(string, ILPLogHelper.LogAttentionType.LOG_ATTENTION_TYPE_NONE);
    }

    private static String fli(String string, ILPLogHelper.LogAttentionType logAttentionType) {
        return ILPBookSettingsHelper.fli(string, logAttentionType, 1);
    }

    private static String fli(String string, int n2) {
        return ILPBookSettingsHelper.fli(string, ILPLogHelper.LogAttentionType.LOG_ATTENTION_TYPE_NONE, n2);
    }

    private static String fli(String string, ILPLogHelper.LogAttentionType logAttentionType, int n2) {
        return ILPLogHelper.logStatementForLicenseInfo((String)string, (ILPLogHelper.LogAttentionType)logAttentionType, (int)n2);
    }

    public static String collectAndFormatEbookConversionDatesOfCourse(ILPCourseProduct iLPCourseProduct) {
        ForeignCollection<ILPIssueProduct> foreignCollection = iLPCourseProduct.getIssueProducts();
        Date date = iLPCourseProduct.getReleaseDate() != null ? iLPCourseProduct.getReleaseDate().toDate() : null;
        for (ILPAbstractProduct iLPAbstractProduct : foreignCollection) {
            DateTime dateTime = iLPAbstractProduct.getReleaseDate();
            if (dateTime == null || date != null && !date.before(dateTime.toDate())) continue;
            date = dateTime.toDate();
        }
        return date != null ? ConverterUtil.formatTimestampNicely((Date)date) : "-";
    }

    private String availibilityStatusCodeForCourse(ILPCourseDef iLPCourseDef) {
        boolean bl2 = ILPBookHelper.hasCourseBeenGranted(iLPCourseDef);
        boolean bl3 = ILPBookHelper.hasCourseTopicsLoaded(iLPCourseDef);
        if (!bl2 && !bl3) {
            return "notLoaded";
        }
        if (!bl2 && bl3) {
            return "excerpt";
        }
        if (bl2 && bl3) {
            return "fullVersion";
        }
        if (bl2 && !bl3) {
            return "licensed";
        }
        return "?";
    }

    private String availibilityStatusCodeForIssue(ILPIssueDef iLPIssueDef) {
        boolean bl2 = ILPBookHelper.hasIssueBeenGranted(iLPIssueDef);
        boolean bl3 = ILPBookHelper.hasIssueTopicsLoaded(iLPIssueDef);
        if (!bl2 && !bl3) {
            return "notLoaded";
        }
        if (!bl2 && bl3) {
            return "excerpt";
        }
        if (bl2 && bl3) {
            return "fullVersion";
        }
        if (bl2 && !bl3) {
            return "licensed";
        }
        return "?";
    }

    public String localizedAvailibilityStatusCodeForCourse(ILPCourseDef iLPCourseDef) {
        String string = this.availibilityStatusCodeForCourse(iLPCourseDef);
        String string2 = ch.ionesoft.ilp.base.co.g.b((String)"label.availability.", (String)string);
        return string2;
    }

    public String localizedAvailibilityStatusCodeForIssue(ILPIssueDef iLPIssueDef) {
        String string = this.availibilityStatusCodeForIssue(iLPIssueDef);
        String string2 = ch.ionesoft.ilp.base.co.g.b((String)"label.availability.", (String)string);
        return string2;
    }

    public List<String> availableLanguageCodesOfCurrentMandant() {
        try {
            if (ILPProfileManager.instance().getCurrentProfile().currentMandant() != null) {
                List<String> list = ch.ionesoft.ilp.book.pe.f.a().h(ILPProfileManager.instance().getCurrentProfile().currentMandant().getMandantIdentifier());
                return list;
            }
            return new ArrayList<String>();
        }
        catch (Exception exception) {
            logger.d((Object)("Could not get availableLanguageCodes, reason: " + exception));
            return new ArrayList<String>();
        }
    }

    public String resourceSynchDirForCourse(ILPCourseDef iLPCourseDef) {
        return this.resourceSynchDirForCourse(iLPCourseDef.getCourseProduct());
    }

    public String resourceSynchDirForCourse(ILPCourseProduct iLPCourseProduct) {
        return String.format("%s/%s/%s", h.q(), iLPCourseProduct.getCourseIdentifier(), iLPCourseProduct.getCourseReference());
    }

    public String assetsDirForCourse(ILPCourseDef iLPCourseDef) {
        return this.assetsDirForCourse(iLPCourseDef.getCourseProduct());
    }

    public String assetsDirForCourse(ILPCourseProduct iLPCourseProduct) {
        return String.format("%s/%s/mandants/%s/courses/%s/%s/assets", h.I(), SystemHelper.applicationBaseName(), iLPCourseProduct.getMandantId(), iLPCourseProduct.getCourseIdentifier(), iLPCourseProduct.getCourseReference());
    }

    public String topicTemplatesDirForCourse(ILPCourseDef iLPCourseDef) {
        return String.format("%s/%s", this.resourceSynchDirForCourse(iLPCourseDef), "topicTemplates");
    }

    String mappingsDirForCourse(ILPCourseDef iLPCourseDef) {
        return this.mappingsDirForCourse(iLPCourseDef.getCourseProduct());
    }

    String mappingsDirForCourse(ILPCourseProduct iLPCourseProduct) {
        return String.format("%s/%s", this.assetsDirForCourse(iLPCourseProduct), "mappings");
    }

    public String blobsDirForIssue(ILPIssueDef iLPIssueDef) {
        return String.format("%s/%s/%s/%s/%s", SystemHelper.blobsCachesDirectory(), iLPIssueDef.getCourse().getCourseId(), iLPIssueDef.getCourse().getReference(), iLPIssueDef.getIssueId(), iLPIssueDef.getReference());
    }

    public File blobFilepathForResourceData(ILPResource iLPResource) {
        return this.blobFilepathForResourceData(iLPResource.getIssue(), iLPResource.getHref());
    }

    public File blobFilepathForResourceData(ILPIssueDef iLPIssueDef, String string) {
        String string2 = String.valueOf(this.blobsDirForIssue(iLPIssueDef)) + "/" + string;
        return new File(string2);
    }

    public File blobFilepathForResourcePlainData(ILPResource iLPResource) {
        return this.blobFilepathForResourcePlainData(iLPResource.getIssue(), iLPResource.getHref());
    }

    public File blobFilepathForResourcePlainData(ILPIssueDef iLPIssueDef, String string) {
        String string2 = String.valueOf(this.blobsDirForIssue(iLPIssueDef)) + "/" + string + ".plain";
        return new File(string2);
    }

    public String localhostPKUrlForIssue(ILPIssueDef iLPIssueDef) {
        if (iLPIssueDef == null) {
            return "";
        }
        return String.valueOf(e.a()) + iLPIssueDef.getPk();
    }

    public String localhostPKUrlForTopic(ILPTopic iLPTopic) {
        if (iLPTopic == null) {
            return "";
        }
        return String.valueOf(e.b()) + iLPTopic.getPk();
    }

    public String localhostPKUrlForExercise(ILPExercise iLPExercise) {
        if (iLPExercise == null) {
            return "";
        }
        return String.valueOf(e.c()) + iLPExercise.getPk();
    }

    public String localhostUrlForTopic(ILPTopic iLPTopic) {
        String string = "http://localhost";
        string = e.d(string, iLPTopic.getIssue());
        string = e.a(string, iLPTopic);
        return string;
    }

    public String applicationUrlForTopic(ILPTopic iLPTopic) {
        String string = ch.ionesoft.ilp.base.co.b.b().t("ILPBase.application.url.scheme");
        String string2 = String.format("%s:/", string);
        string2 = e.d(string2, iLPTopic.getIssue());
        string2 = e.a(string2, iLPTopic);
        return string2;
    }

    public String applicationUrlFormattedForTopic(ILPTopic iLPTopic) {
        String string = this.applicationUrlForTopic(iLPTopic);
        String string2 = String.format("<a href='%s' class='applicationUrl-topic'>%s</a>", string, iLPTopic.getFullTitle());
        return string2;
    }

    private String applicationUrlForNote(ILPNote iLPNote) {
        String string = ch.ionesoft.ilp.base.co.b.b().t("ILPBase.application.url.scheme");
        String string2 = String.format("%s:/", string);
        string2 = e.d(string2, iLPNote.getIssue());
        ILPTopic iLPTopic = iLPNote.getTopic();
        ILPExercise iLPExercise = iLPNote.getExercise();
        if (iLPTopic != null) {
            string2 = e.a(string2, iLPTopic);
        } else if (iLPExercise != null) {
            string2 = e.a(string2, iLPExercise);
        }
        string2 = String.format("%s/noteKey/%s", string2, iLPNote.getKey());
        return string2;
    }

    private String applicationUrlFormattedForNote(ILPNote iLPNote) {
        String string = this.applicationUrlForNote(iLPNote);
        String string2 = String.format("<a href='%s' class='applicationUrl-note'>%s</a>", string, iLPNote.getAnyTitle());
        return string2;
    }

    public String applicationUrlForExercise(ILPExercise iLPExercise) {
        if (iLPExercise == null) {
            return null;
        }
        String string = ch.ionesoft.ilp.base.co.b.b().t("ILPBase.application.url.scheme");
        String string2 = String.format("%s:/", string);
        string2 = e.d(string2, iLPExercise.getIssue());
        string2 = e.a(string2, iLPExercise);
        return string2;
    }

    public String applicationUrlFormattedForExercise(ILPExercise iLPExercise) {
        String string = this.applicationUrlForExercise(iLPExercise);
        String string2 = String.format("<a href='%s' class='applicationUrl-exercise'>%s</a>", string, iLPExercise.getTitle());
        return string2;
    }

    public String applicationUrlForModel(ILPTopic iLPTopic) {
        return this.applicationUrlForTopic(iLPTopic);
    }

    public String applicationUrlForModel(ILPNote iLPNote) {
        return this.applicationUrlForNote(iLPNote);
    }

    public String applicationUrlForModel(ILPExercise iLPExercise) {
        return this.applicationUrlForExercise(iLPExercise);
    }

    public String applicationUrlFormattedForModel(ILPTopic iLPTopic) {
        return this.applicationUrlFormattedForTopic(iLPTopic);
    }

    public String applicationUrlFormattedForModel(ILPNote iLPNote) {
        return this.applicationUrlFormattedForNote(iLPNote);
    }

    public String applicationUrlFormattedForModel(ILPExercise iLPExercise) {
        return this.applicationUrlFormattedForExercise(iLPExercise);
    }

    private String databaseEncryptionKey() {
        return String.format("%s%c%s%c%c%s", "fd\u00e4K?s^d", Character.valueOf('w'), "-+\u00e7", Character.valueOf(','), Character.valueOf('W'), "!El");
    }

    private String databaseEncryptionIV() {
        return String.format("%c%s%s%c%c%s", Character.valueOf('/'), "D}", "$2", Character.valueOf('a'), Character.valueOf('l'), "!");
    }

    public String encryptAnswerText_forAnswer(String string, ILPAnswer iLPAnswer) {
        if (ch.ionesoft.ilp.base.co.g.a().s()) {
            return string;
        }
        return this.encryptText_withEncryptedPrefix_withIdString(string, ANSWER_ENCRYPTION_PREFIX, String.format(Locale.ENGLISH, "%s-%d", iLPAnswer.getQuestion().getExercise().getExerciseId(), iLPAnswer.getNumber()));
    }

    public String decryptAnswerText_forAnswer(String string, ILPAnswer iLPAnswer) {
        if (ch.ionesoft.ilp.base.co.g.a().s()) {
            return string;
        }
        return this.decryptText_withEncryptedPrefix_withIdString(string, ANSWER_ENCRYPTION_PREFIX, String.format(Locale.ENGLISH, "%s-%d", iLPAnswer.getQuestion().getExercise().getExerciseId(), iLPAnswer.getNumber()));
    }

    public String decryptAnswerText_forAnswer(String string, String string2, int n2) {
        if (ch.ionesoft.ilp.base.co.g.a().s()) {
            return string;
        }
        return this.decryptText_withEncryptedPrefix_withIdString(string, ANSWER_ENCRYPTION_PREFIX, String.format(Locale.ENGLISH, "%s-%d", string2, n2));
    }

    public String encryptQuestionText_forQuestion(String string, ILPQuestion iLPQuestion) {
        if (ch.ionesoft.ilp.base.co.g.a().s()) {
            return string;
        }
        return this.encryptText_withEncryptedPrefix_withIdString(string, QUESTION_ENCRYPTION_PREFIX, String.format(Locale.ENGLISH, "%s-%d", iLPQuestion.getExercise().getExerciseId(), iLPQuestion.getNumber()));
    }

    public String decryptQuestionText_forQuestion(String string, ILPQuestion iLPQuestion) {
        if (ch.ionesoft.ilp.base.co.g.a().s()) {
            return string;
        }
        return this.decryptText_withEncryptedPrefix_withIdString(string, QUESTION_ENCRYPTION_PREFIX, String.format(Locale.ENGLISH, "%s-%d", iLPQuestion.getExercise().getExerciseId(), iLPQuestion.getNumber()));
    }

    public String encryptExerciseText_forExercise(String string, ILPExercise iLPExercise) {
        if (ch.ionesoft.ilp.base.co.g.a().s()) {
            return string;
        }
        return this.encryptText_withEncryptedPrefix_withIdString(string, EXERCISE_ENCRYPTION_PREFIX, String.format(Locale.ENGLISH, "%s", iLPExercise.getExerciseId()));
    }

    public String decryptExerciseText_forExercise(String string, ILPExercise iLPExercise) {
        if (ch.ionesoft.ilp.base.co.g.a().s()) {
            return string;
        }
        return this.decryptText_withEncryptedPrefix_withIdString(string, EXERCISE_ENCRYPTION_PREFIX, String.format(Locale.ENGLISH, "%s", iLPExercise.getExerciseId()));
    }

    public String encryptExerciseExplanationText_forExercise(String string, ILPExercise iLPExercise) {
        if (ch.ionesoft.ilp.base.co.g.a().s()) {
            return string;
        }
        return this.encryptText_withEncryptedPrefix_withIdString(string, EXERCISE_ENCRYPTION_PREFIX, String.format(Locale.ENGLISH, "%s", iLPExercise.getExerciseId()));
    }

    public String decryptExerciseExplanationText_forExercise(String string, ILPExercise iLPExercise) {
        if (ch.ionesoft.ilp.base.co.g.a().s()) {
            return string;
        }
        return this.decryptText_withEncryptedPrefix_withIdString(string, EXERCISE_ENCRYPTION_PREFIX, String.format(Locale.ENGLISH, "%s", iLPExercise.getExerciseId()));
    }

    public String encryptCloudID_forUser(String string, ILPUser iLPUser) {
        return this.encryptText_withEncryptedPrefix_withIdString(string, USER_ENCRYPTION_PREFIX, iLPUser.getSubject());
    }

    public String decryptCloudID_forUser(String string, ILPUser iLPUser) {
        return this.decryptText_withEncryptedPrefix_withIdString(string, USER_ENCRYPTION_PREFIX, iLPUser.getSubject());
    }

    public String encryptGroupID_forGroup(String string, ILPGroup iLPGroup) {
        return this.encryptText_withEncryptedPrefix_withIdString(string, GROUP_ENCRYPTION_PREFIX, "GRID");
    }

    public String decryptGroupID_forGroup(String string, ILPGroup iLPGroup) {
        return this.decryptText_withEncryptedPrefix_withIdString(string, GROUP_ENCRYPTION_PREFIX, "GRID");
    }

    public String encryptGroupString(String string) {
        return this.encryptText_withEncryptedPrefix_withIdString(string, GROUP_ENCRYPTION_PREFIX, "GRSP");
    }

    public String decryptGroupString(String string) {
        return this.decryptText_withEncryptedPrefix_withIdString(string, GROUP_ENCRYPTION_PREFIX, "GRSP");
    }

    public String encryptPropertyValue_forProperty(String string, ILPProperty iLPProperty) {
        return this.encryptText_withEncryptedPrefix_withIdString(string, PROPERTY_ENCRYPTION_PREFIX, iLPProperty.getKey());
    }

    public String decryptPropertyValue_forProperty(String string, ILPProperty iLPProperty) {
        return this.decryptText_withEncryptedPrefix_withIdString(string, PROPERTY_ENCRYPTION_PREFIX, iLPProperty.getKey());
    }

    private String encryptText_withEncryptedPrefix_withIdString(String string, String string2, String string3) {
        if (string == null) {
            return null;
        }
        if (StringUtils.isEmpty((CharSequence)string)) {
            return string;
        }
        if (string.startsWith(string2)) {
            return string;
        }
        String string4 = String.format("%s:%s", string3, string);
        String string5 = this.databaseDESEncrypter.encryptString(string4);
        String string6 = String.format("%s%s", string2, string5);
        return string6;
    }

    private String decryptText_withEncryptedPrefix_withIdString(String string, String string2, String string3) {
        if (string == null) {
            return null;
        }
        if (StringUtils.isEmpty((CharSequence)string)) {
            return string;
        }
        if (!string.startsWith(string2)) {
            return string;
        }
        String string4 = StringHelper.extractString_after((String)string, (String)string2);
        String string5 = this.databaseDESEncrypter.decryptString(string4);
        String string6 = StringHelper.extractString_after((String)string5, (String)String.format(Locale.ENGLISH, "%s:", string3));
        if (string6 == null) {
            string6 = StringHelper.extractString_after((String)string5, (String)":");
        }
        return string6;
    }

    public String getCoursesIdRefString(List<ILPCourseDef> list) {
        StringBuilder stringBuilder = new StringBuilder(120);
        for (ILPCourseDef iLPCourseDef : list) {
            stringBuilder.append(String.valueOf(iLPCourseDef.getCourseId()) + ":" + iLPCourseDef.getReference());
            if (list.indexOf(iLPCourseDef) == list.size() - 1) continue;
            stringBuilder.append(",");
        }
        return stringBuilder.toString();
    }

    public String getIssuesIdString(List<ILPIssueDef> list) {
        StringBuilder stringBuilder = new StringBuilder(120);
        for (ILPIssueDef iLPIssueDef : list) {
            stringBuilder.append(iLPIssueDef.getIssueId());
            if (list.indexOf(iLPIssueDef) == list.size() - 1) continue;
            stringBuilder.append(",");
        }
        return stringBuilder.toString();
    }

    public String markerColorHtmlNameForIndex(ILPNote.AnnotationColor annotationColor) {
        String[] stringArray = ch.ionesoft.ilp.base.co.b.b().d("ILPBook.marker.html.colorNames");
        int n2 = annotationColor.getCode();
        int n3 = n2 - 1;
        if (n3 >= stringArray.length) {
            n3 = 0;
        }
        return stringArray[n3];
    }

    public String noteColorHtmlNameForIndex(ILPNote.AnnotationColor annotationColor) {
        String[] stringArray = ch.ionesoft.ilp.base.co.b.b().d("ILPBook.note.html.colorNames");
        int n2 = annotationColor.getCode();
        int n3 = n2 - 1;
        if (n3 >= stringArray.length) {
            n3 = 0;
        }
        return stringArray[n3];
    }

    public boolean isIssueETest(ILPIssueDef iLPIssueDef) {
        String string;
        return iLPIssueDef != null && StringUtils.equals((CharSequence)(string = iLPIssueDef.propertyStringWithName_defaultValue("additionalController", "")), (CharSequence)"eTestingController");
    }

    public boolean supportsAnyCloud() {
        String string = ILPProfileManager.instance().getCurrentProfile().getEnvironment().propertyStringById("CLOUD_AVAILABLE_SERVICES");
        return StringUtils.isNotBlank((CharSequence)string);
    }

    void environmentConfigChanged() {
    }

    public List<g.a> supportedCloudServices(boolean bl2) {
        String string = "";
        if (ILPProfileManager.instance().getCurrentProfile().getEnvironment() != null) {
            string = ILPProfileManager.instance().getCurrentProfile().getEnvironment().propertyStringById("CLOUD_AVAILABLE_SERVICES");
        }
        String[] stringArray = string.split(",");
        int n2 = stringArray.length;
        ArrayList<g.a> arrayList = new ArrayList<g.a>();
        if (n2 > 0) {
            if (bl2) {
                arrayList.add(g.a.a);
            }
            String[] stringArray2 = stringArray;
            int n3 = stringArray.length;
            int n4 = 0;
            while (n4 < n3) {
                String string2 = stringArray2[n4];
                try {
                    g.a a2 = g.a.valueOf(string2.trim());
                    arrayList.add(a2);
                }
                catch (Exception exception) {
                    logger.c((Object)("Could not add cloud service " + string2 + " to supported service types, reason: " + exception));
                }
                ++n4;
            }
        }
        if (SystemHelper.isAndroidSystem()) {
            arrayList.remove((Object)g.a.b);
        }
        return arrayList;
    }

    public void setCloudServiceType(g.a a2) {
        p.e().a(a2.name(), kApplicationConfigCloudService);
        p.e().g();
    }

    public g.a getCloudServiceType() {
        String string = p.e().b(kApplicationConfigCloudService, g.a.a.name());
        return g.a.valueOf(string);
    }

    public String getCloudRootDirectory() {
        return p.e().b(kApplicationConfigCloudRootDirectory, null);
    }

    public void setCloudRootDirectory(String string) {
        p.e().a(string, kApplicationConfigCloudRootDirectory);
        p.e().g();
        logger.b((Object)("Setting Cloud Root Dir to: " + ILPBookSettingsHelper.instance().getCloudRootDirectory()));
    }

    public void setSynchronizeStrategy(String string) {
        p.e().a(string, kApplicationConfigEbookSynchronizeStrategy);
        p.e().g();
    }

    public String getSynchronizeStrategy() {
        return p.e().b(kApplicationConfigEbookSynchronizeStrategy, EBOOK_SYNCHRONIZE_ON_LEAVE);
    }

    public boolean isSynchronizeOnLeave() {
        String string = this.getSynchronizeStrategy();
        return EBOOK_SYNCHRONIZE_ON_LEAVE.equals(string) || "EBOOK_SYNCHRONIZE_ON_EDIT".equals(string);
    }

    public boolean isSynchronizeManually() {
        String string = this.getSynchronizeStrategy();
        return EBOOK_SYNCHRONIZE_MANUALLY.equals(string);
    }

    public boolean isSynchronizeNever() {
        String string = this.getSynchronizeStrategy();
        return EBOOK_SYNCHRONIZE_NEVER.equals(string);
    }

    public void setCloudSyncMedia(boolean bl2) {
        p.e().b(kApplicationConfigCloudSyncMedia, Boolean.valueOf(bl2));
        p.e().g();
    }

    public boolean isCloudSyncMedia() {
        return p.e().a(kApplicationConfigCloudSyncMedia, Boolean.valueOf(true));
    }

    public void setCloudSyncMediaAutomatically(boolean bl2) {
        p.e().b(kApplicationConfigCloudSyncMediaAutomatically, Boolean.valueOf(bl2));
        p.e().g();
    }

    public boolean isCloudSyncMediaAutomatically() {
        return this.isCloudSyncMedia() && p.e().a(kApplicationConfigCloudSyncMediaAutomatically, Boolean.valueOf(false)) != false;
    }

    public void setCloudEncryptMedia(boolean bl2) {
        p.e().b(kApplicationConfigCloudEncryptMedia, Boolean.valueOf(bl2));
        p.e().g();
    }

    public boolean isCloudEncryptMedia() {
        return p.e().a(kApplicationConfigCloudEncryptMedia, Boolean.valueOf(true));
    }

    public String getGlobalSharingEncryptionKey() {
        return this.globalSharingEncryptionKey;
    }

    public void setGlobalSharingEncryptionKey(String string) {
        this.globalSharingEncryptionKey = string;
    }

    public void setGroupServerLastSynchDate(DateTime dateTime) {
        String string;
        ch.ionesoft.ilp.book.pe.f f2 = ch.ionesoft.ilp.book.pe.f.a();
        ILPSystemProperty iLPSystemProperty = f2.k(kSystemPropertyGroupServerLastSynch, string = ISODateTimeFormat.dateTime().print((ReadableInstant)dateTime));
        if (iLPSystemProperty == null) {
            logger.d((Object)"Setting last synch date with group server to database failed.");
        }
    }

    public DateTime getGroupServerLastSynchDate() {
        ch.ionesoft.ilp.book.pe.f f2 = ch.ionesoft.ilp.book.pe.f.a();
        ILPSystemProperty iLPSystemProperty = f2.az(kSystemPropertyGroupServerLastSynch);
        if (iLPSystemProperty == null) {
            String string = ISODateTimeFormat.dateTime().print((ReadableInstant)new DateTime(0L));
            iLPSystemProperty = f2.k(kSystemPropertyGroupServerLastSynch, string);
        }
        return ISODateTimeFormat.dateTime().parseDateTime(iLPSystemProperty.getValue());
    }

    public void setGroupServerHighestTransactionIndex(Integer n2) {
        ch.ionesoft.ilp.book.pe.f f2 = ch.ionesoft.ilp.book.pe.f.a();
        ILPSystemProperty iLPSystemProperty = f2.k(kSystemPropertyGroupServerHighestTransactionIndex, String.valueOf(n2));
        if (iLPSystemProperty == null) {
            logger.d((Object)"Setting last synch date with group server to database failed.");
        }
    }

    public Integer groupServerHighestTransactionIndex() {
        ch.ionesoft.ilp.book.pe.f f2 = ch.ionesoft.ilp.book.pe.f.a();
        ILPSystemProperty iLPSystemProperty = f2.az(kSystemPropertyGroupServerHighestTransactionIndex);
        if (iLPSystemProperty == null) {
            iLPSystemProperty = f2.k(kSystemPropertyGroupServerHighestTransactionIndex, "0");
        }
        return Integer.parseInt(iLPSystemProperty.getValue());
    }

    public void setLessonsCurrentTaskVersion(Long l2) {
        ch.ionesoft.ilp.book.pe.f f2 = ch.ionesoft.ilp.book.pe.f.a();
        f2.k(kSystemPropertyLessonsCurrentTaskVersion, String.valueOf(l2));
    }

    public Long getLessonsCurrentTaskVersion() {
        ch.ionesoft.ilp.book.pe.f f2 = ch.ionesoft.ilp.book.pe.f.a();
        ILPSystemProperty iLPSystemProperty = f2.az(kSystemPropertyLessonsCurrentTaskVersion);
        if (iLPSystemProperty == null) {
            iLPSystemProperty = f2.k(kSystemPropertyLessonsCurrentTaskVersion, "0");
        }
        return iLPSystemProperty.getValueLong();
    }

    public DESEncrypter cloudDESEncrypter() {
        DESEncrypter dESEncrypter = null;
        String string = this.getCloudEncryptionIV();
        try {
            String string2;
            String string3 = string2 = ILPProfileManager.instance().getCurrentProfile() != null ? ILPProfileManager.instance().getCurrentProfile().getCloudEncryptionKey() : null;
            if (string2 != null) {
                dESEncrypter = new DESEncrypter(string2, string);
            } else {
                logger.d((Object)"Cannot create des encryptor. Empty key");
            }
        }
        catch (Exception exception) {
            logger.d((Object)"Could not create DESEncrypter for cloud", (Throwable)exception);
        }
        return dESEncrypter;
    }

    public DESEncrypter globalSharingDESEncrypter() {
        DESEncrypter dESEncrypter = null;
        String string = this.getGlobalSharingEncryptionKey();
        try {
            if (string != null) {
                dESEncrypter = new DESEncrypter(string, this.getGlobalSharingEncryptionIV());
            } else {
                logger.d((Object)"Cannot create global sharing DES encryptor. Empty key");
            }
        }
        catch (Exception exception) {
            logger.d((Object)("Could not create DESEncrypter for global sharing: " + exception));
        }
        return dESEncrypter;
    }

    public String getCloudEncryptionIV() {
        return this.cloudEncryptionIV;
    }

    public void setCloudEncryptionIV(String string) {
        this.cloudEncryptionIV = string;
    }

    public String getGlobalSharingEncryptionIV() {
        return this.globalSharingEncryptionIV;
    }

    public void setGlobalSharingEncryptionIV(String string) {
        this.globalSharingEncryptionIV = string;
    }

    public String getVeledesEtestingClientSecret() {
        return this.veledesEtestingClientSecret;
    }

    public void setVeledesEtestingClientSecret(String string) {
        this.veledesEtestingClientSecret = string;
    }

    public String getMmtsEtestingApiKey() {
        return this.mmtsEtestingApiKey;
    }

    public void setMmtsEtestingApiKey(String string) {
        this.mmtsEtestingApiKey = string;
    }

    public Date getSlaAcceptedDate() {
        String string;
        block5: {
            ILPUser iLPUser;
            block4: {
                string = null;
                try {
                    iLPUser = ILPProfileManager.instance().getCurrentProfile().getCurrentUser();
                    if (iLPUser != null) break block4;
                    return null;
                }
                catch (Exception exception) {
                    logger.d((Object)("Could not parse slaAcceptedDate: " + string), (Throwable)exception);
                    return null;
                }
            }
            string = iLPUser.propertyStringById_defaultValue("user.accepted.sla-V1_3", null);
            if (string != null && !StringUtils.isBlank((CharSequence)string)) break block5;
            return null;
        }
        Date date = ConverterUtil.parseDateISO((String)string);
        return date;
    }

    public boolean isSlaAccepted() {
        Object object;
        Date date;
        block4: {
            try {
                date = new Date(0L);
                if (ILPProfileManager.instance().getCurrentProfile().getEnvironment() != null && StringUtils.isNotBlank((CharSequence)(object = ILPProfileManager.instance().getCurrentProfile().getEnvironment().propertyStringById("LAST_SLA_UPDATE")))) {
                    date = ConverterUtil.parseDateISO((String)object);
                }
                if ((object = this.getSlaAcceptedDate()) != null) break block4;
                return false;
            }
            catch (Exception exception) {
                logger.d((Object)("Could not compare sla accepted date with environment property: " + exception));
                return false;
            }
        }
        return ((Date)object).after(date);
    }

    public boolean isNewsletterAccepted() {
        String string = null;
        try {
            ILPUser iLPUser = ILPProfileManager.instance().getCurrentProfile().getCurrentUser();
            string = iLPUser.propertyStringById_defaultValue("user.accepted.newsletter", null);
            return ConverterUtil.convertToBoolean_defaultValue((String)string, (Boolean)false);
        }
        catch (Exception exception) {
            logger.d((Object)("Could not parse newsletterAccepted: " + string), (Throwable)exception);
            return false;
        }
    }

    public boolean isDisallowedToUseCloud() {
        try {
            ILPUser iLPUser = ILPProfileManager.instance().getCurrentProfile().getCurrentUser();
            if (iLPUser != null) {
                return iLPUser.propertyBooleanById_defaultValue("permission.cloud.disallowed", false);
            }
            return true;
        }
        catch (Exception exception) {
            logger.d((Object)"Could not check isDisallowedToUseCloud", (Throwable)exception);
            return true;
        }
    }

    public boolean isDisallowedToActivateCoupon() {
        try {
            ILPUser iLPUser = ILPProfileManager.instance().getCurrentProfile().getCurrentUser();
            if (iLPUser != null) {
                return iLPUser.propertyBooleanById_defaultValue("permission.activate.coupon.disallowed", false);
            }
            return true;
        }
        catch (Exception exception) {
            logger.d((Object)"Could not check isDisallowedToActivateCoupon", (Throwable)exception);
            return true;
        }
    }

    public boolean isDisallowedToChangeUserInformation() {
        try {
            ILPUser iLPUser = ILPProfileManager.instance().getCurrentProfile().getCurrentUser();
            if (iLPUser != null) {
                return iLPUser.propertyBooleanById_defaultValue("permission.change.user.disallowed", false);
            }
            return true;
        }
        catch (Exception exception) {
            logger.d((Object)"Could not check isDisallowedToChangeUserInformation", (Throwable)exception);
            return true;
        }
    }

    private String applicationUrlSchemePrefix() {
        String string = ch.ionesoft.ilp.base.co.b.b().a("ILPBase.application.url.scheme", "");
        return string;
    }

    public String applicationUrlSchemeComplete() {
        return String.valueOf(this.applicationUrlSchemePrefix()) + "://";
    }

    public String[] recipientsContactTo() {
        String string = ILPProfileManager.instance().getCurrentProfile().getEnvironment().currentAgentMandantEnvironmentPropertyStringById("RECIPIENTS_FEEDBACK_CONTACT_TO");
        if (string != null) {
            return string.split(",");
        }
        return new String[0];
    }

    public String[] recipientsGeneralFeedbackTo() {
        String string = ILPProfileManager.instance().getCurrentProfile().getEnvironment().currentAgentMandantEnvironmentPropertyStringById("RECIPIENTS_FEEDBACK_GENERAL_TO");
        if (string != null) {
            return string.split(",");
        }
        return new String[0];
    }

    public String[] recipientsGeneralFeedbackCC() {
        String string = ILPProfileManager.instance().getCurrentProfile().getEnvironment().currentAgentMandantEnvironmentPropertyStringById("RECIPIENTS_FEEDBACK_GENERAL_CC");
        if (string != null) {
            return string.split(",");
        }
        return new String[0];
    }

    public String[] recipientsTechnicalFeedbackTo() {
        String string = ILPProfileManager.instance().getCurrentProfile().getEnvironment().currentAgentMandantEnvironmentPropertyStringById("RECIPIENTS_FEEDBACK_TECHNICAL_TO");
        if (string != null) {
            return string.split(",");
        }
        return new String[0];
    }

    public String[] recipientsTechnicalFeedbackCC() {
        String string = ILPProfileManager.instance().getCurrentProfile().getEnvironment().currentAgentMandantEnvironmentPropertyStringById("RECIPIENTS_FEEDBACK_TECHNICAL_CC");
        if (string != null) {
            return string.split(",");
        }
        return new String[0];
    }

    public String reviewAppUrl() {
        String string = ILPProfileManager.instance().getCurrentProfile().getEnvironment().propertyStringById("REVIEW_APP_URL");
        return string;
    }

    public String downloadAppUrl() {
        String string = ILPProfileManager.instance().getCurrentProfile().getEnvironment().propertyStringById("DOWNLOAD_APP_URL");
        return string;
    }

    public String appWebsiteUrl() {
        String string = ILPProfileManager.instance().getCurrentProfile().getEnvironment().propertyStringById("APP_WEBSITE_URL");
        return string;
    }

    public String getLocalizedAppAlertMessage() {
        if (ILPProfileManager.instance().getCurrentProfile().getEnvironment() != null) {
            String string = ILPProfileManager.instance().getCurrentProfile().getEnvironment().propertyStringById("APP_ALERT_MESSAGE_" + ch.ionesoft.ilp.base.co.g.a().e().toUpperCase());
            return string;
        }
        logger.c((Object)"No environment config available to show app allert message");
        return null;
    }

    public boolean trackingMatomoEnabled() {
        return ILPProfileManager.instance().getCurrentProfile().getEnvironment().propertyBooleanById_defaultValue("TRACKING_MATOMO_ENABLE", false);
    }

    public String trackingMatomoUrl() {
        return ILPProfileManager.instance().getCurrentProfile().getEnvironment().propertyStringById_defaultValue("TRACKING_MATOMO_URL", "https://matomo.ionesoft.ch/matomo.php");
    }

    public int trackingMatomoSiteId() {
        return ILPProfileManager.instance().getCurrentProfile().getEnvironment().propertyIntById_defaultValue("TRACKING_MATOMO_SITE_ID", 5);
    }

    public String currentUserSubject() {
        ILPUser iLPUser = ILPBookRegistry.instance().getCurrentUser();
        if (iLPUser != null) {
            return iLPUser.getSubject();
        }
        return null;
    }

    public String licensePassword() {
        logger.d((Object)"No licensePassword stored anymore, change implementation");
        return null;
    }

    public boolean isLoggedIn() {
        return ILPBookRegistry.instance().getAuthenticationService().h();
    }

    public boolean isAutoUnregisterLicenses() {
        boolean bl2 = p.e().a(kApplicationConfigAutoRegisterLicenses, Boolean.valueOf(true));
        String string = n.b().b("licensePrincipal", "").trim();
        if (StringUtils.isNotBlank((CharSequence)string)) {
            bl2 = true;
        }
        return bl2;
    }

    public void setAutoUnregisterLicenses(boolean bl2) {
        p.e().a(Boolean.valueOf(bl2), kApplicationConfigAutoRegisterLicenses);
        p.e().g();
    }

    public List<String> getForceLicenseTypeFloatingWithIPFromInstallationConfig() {
        ArrayList<String> arrayList;
        block6: {
            arrayList = new ArrayList<String>();
            try {
                String string = ch.ionesoft.ilp.base.co.f.b().y();
                String string2 = n.b().b("forceLicenseTypeFloatingWithIP", "").trim();
                if (string2.length() <= 0) break block6;
                logger.b((Object)"Got ip addresses to force floating license from installation");
                try {
                    DESEncrypter dESEncrypter = new DESEncrypter(string);
                    String string3 = dESEncrypter.decryptString(string2);
                    i i2 = new i(string3);
                    f f2 = i2.p("ip");
                    if (f2 != null) {
                        int n2 = 0;
                        while (n2 < f2.a()) {
                            arrayList.add(f2.h(n2));
                            ++n2;
                        }
                    }
                }
                catch (Exception exception) {
                    logger.d((Object)("Could not read forceLicenseTypeFloatingWithIP from installation.properties: " + exception));
                }
            }
            catch (Exception exception) {
                logger.d((Object)("Could not parse forceLicenseTypeFloatingWithIP: " + n.b().b("forceLicenseTypeFloatingWithIP", "")));
            }
        }
        return arrayList;
    }

    public boolean isAllowedToSwitchForFloatingDevice() {
        List<String> list = this.getForceLicenseTypeFloatingWithIPFromInstallationConfig();
        List<String> list2 = this.getForceLicenseTypeFloatingWithEmailDomainFromInstallationConfig();
        boolean bl2 = false;
        if (list.size() > 0) {
            String string = x.a().p();
            if (string != null) {
                if (list.contains(string)) {
                    return true;
                }
                for (String string2 : list) {
                    String string3 = string2;
                    if (!string3.contains("/")) continue;
                    try {
                        SubnetUtils subnetUtils = new SubnetUtils(string3);
                        if (!subnetUtils.getInfo().isInRange(string)) continue;
                        return true;
                    }
                    catch (Exception exception) {
                        logger.c((Object)("IP address does not match the correct format: " + string3));
                    }
                }
            }
            logger.c((Object)("External IP not allowed to force floating licenses: " + string));
        }
        if (list2.size() > 0) {
            bl2 |= this.isEmailAllowedToSwitchForFloatingDevice(ILPBookRegistry.instance().getCurrentUser());
        }
        return bl2;
    }

    public List<String> getForceLicenseTypeFloatingWithEmailDomainFromInstallationConfig() {
        String string = ch.ionesoft.ilp.base.co.f.b().y();
        String string2 = n.b().b("forceLicenseTypeFloatingWithEmailDomain", "").trim();
        ArrayList<String> arrayList = new ArrayList<String>();
        if (string2.length() > 0) {
            logger.b((Object)"Got email domains to force floating license from installation");
            try {
                DESEncrypter dESEncrypter = new DESEncrypter(string);
                String string3 = dESEncrypter.decryptString(string2);
                i i2 = new i(string3);
                f f2 = i2.p("emailDomain");
                if (f2 != null) {
                    int n2 = 0;
                    while (n2 < f2.a()) {
                        arrayList.add(f2.h(n2));
                        ++n2;
                    }
                }
            }
            catch (Exception exception) {
                logger.d((Object)("Could not read forceLicenseTypeFloatingWithEmailDomain from installation.properties: " + exception));
            }
        }
        return arrayList;
    }

    private boolean isEmailAllowedToSwitchForFloatingDevice(ILPUser iLPUser) {
        if (iLPUser == null) {
            return false;
        }
        List<String> list = this.getForceLicenseTypeFloatingWithEmailDomainFromInstallationConfig();
        boolean bl2 = false;
        for (String string : list) {
            for (ILPAccount iLPAccount : iLPUser.getAccounts()) {
                String string2 = iLPAccount.getLoginNameOrExternalId();
                if (!StringHelper.isNotBlank((String)string2) || !StringHelper.extractPostfixAfter((String)string2, (String)"@").equals(string)) continue;
                bl2 = true;
            }
        }
        return bl2;
    }

    public String getUrlForLmsLogin() {
        ILPAgent iLPAgent = ILPProfileManager.instance().getCurrentProfile().currentAgent();
        String string = iLPAgent.propertyStringById("LMS_LOGIN_URL");
        return string;
    }

    public String getLmsName() {
        ILPAgent iLPAgent = ILPProfileManager.instance().getCurrentProfile().currentAgent();
        String string = iLPAgent.propertyStringById("LMS_NAME");
        return string;
    }

    public URL urlForLms() {
        return this.urlForLmsOfAgent(ILPProfileManager.instance().getCurrentProfile().currentAgent());
    }

    private URL urlForLmsOfAgent(ILPAgent iLPAgent) {
        String string = iLPAgent.propertyStringById("LMS_URL");
        try {
            return new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            logger.c((Object)"Cold not get LMS URL");
            return null;
        }
    }

    public boolean hasUrlValueForLmsOfAgent(ILPAgent iLPAgent) {
        String string = iLPAgent.propertyStringById("LMS_LOGIN_URL");
        return StringHelper.isNotBlank((String)string);
    }

    public URL urlForLmsLogin() {
        ILPAgent iLPAgent = ILPProfileManager.instance().getCurrentProfile().currentAgent();
        if (iLPAgent == null) {
            return null;
        }
        String string = iLPAgent.propertyStringById("LMS_LOGIN_URL");
        if (string == null || string.isEmpty()) {
            return null;
        }
        try {
            return new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            logger.c((Object)"Cold not get LMS URL Login");
            return null;
        }
    }

    public URL urlForLmsLogout() {
        ILPAgent iLPAgent = ILPProfileManager.instance().getCurrentProfile().currentAgent();
        String string = iLPAgent.propertyStringById("LMS_LOGOUT_URL");
        try {
            return new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            logger.c((Object)"Cold not get LMS URL Logout");
            return null;
        }
    }

    public String lmsSuccessfullLoginCookie() {
        ILPAgent iLPAgent = ILPProfileManager.instance().getCurrentProfile().currentAgent();
        String string = iLPAgent.propertyStringById("LMS_COOKIE");
        return string;
    }

    public z logoImage() {
        ILPAgent iLPAgent = ILPProfileManager.instance().getCurrentProfile().currentAgent();
        if (iLPAgent != null && !iLPAgent.isDefaultAgent()) {
            return ILPProfileManager.instance().getCurrentProfile().getImageForCurrentAgent();
        }
        return ILPProfileManager.instance().getCurrentProfile().getImageForCurrentMandant();
    }

    public String logoImagePath() {
        ILPAgent iLPAgent = ILPProfileManager.instance().getCurrentProfile().currentAgent();
        if (iLPAgent != null && !iLPAgent.isDefaultAgent()) {
            return String.valueOf(h.W()) + "imageresource/" + iLPAgent.pathCoverImage();
        }
        ILPMandant iLPMandant = ILPProfileManager.instance().getCurrentProfile().currentMandant();
        if (iLPMandant != null) {
            return String.valueOf(h.W()) + "imageresource/" + iLPMandant.pathCoverImage();
        }
        return "";
    }

    public void setAskedFirstTimeForLogin(boolean bl2) {
        this.askedForLogin = bl2;
    }

    public boolean isExternalEmailClientHintDisabled() {
        return p.e().i(kExternalEmailClientHint);
    }

    public void setExternalEmailClientHint(boolean bl2) {
        p.e().a(Boolean.valueOf(bl2), kExternalEmailClientHint);
        p.e().g();
    }

    public boolean isSyncWith3G() {
        return p.e().a(kApplicationConfigCloudSync3G, Boolean.valueOf(false));
    }

    public void setSyncWith3G(boolean bl2) {
        p.e().b(kApplicationConfigCloudSync3G, Boolean.valueOf(bl2));
    }

    private String getKeychainKeyForGroupId(String string) {
        return "GroupEncryptionKey_" + string;
    }

    public int getNextProfileNumber() {
        return p.c().f(kApplicationConfigHighestProfileNumber);
    }

    public void setNextProfileNumber(Integer n2) {
        p.c().a(kApplicationConfigHighestProfileNumber, n2);
        p.c().g();
    }

    public void setAlwaysShrinkImagesExtendedUserTopic(Boolean bl2) {
        p.e().b(kApplicationConfigAlwaysShrinkImages, bl2);
        p.e().g();
    }

    public boolean getAlwaysShrinkImagesExtendedUserTopic() {
        return p.e().a(kApplicationConfigAlwaysShrinkImages, Boolean.valueOf(false));
    }

    public void removeSettingsForCourse(ILPCourseDef iLPCourseDef) {
        try {
            ILPProfileManager.instance().getCurrentProfile().removeCurrentIssueForCourseId_courseReference(iLPCourseDef.getCourseId(), iLPCourseDef.getReference());
            for (ILPIssueDef iLPIssueDef : iLPCourseDef.getIssues()) {
                this.removeETestSettingsForIssue(iLPIssueDef);
            }
            p.e().b(String.format("deviceWidth.course.%s.reference.%s", iLPCourseDef.getCourseId(), iLPCourseDef.getReference()));
            p.e().b(String.format("web.zoomLevel.course.%s.reference.%s", iLPCourseDef.getCourseId(), iLPCourseDef.getReference()));
            p.e().g();
        }
        catch (Exception exception) {
            logger.d((Object)"Remove settings for course failed.", (Throwable)exception);
        }
    }

    public void removeETestSettingsForETest(a a2) {
        this.removeETestSettingsForIssue_exerciseGroupCode(a2.d(), a2.e().getCode());
    }

    public void removeETestSettingsForIssue(ILPIssueDef iLPIssueDef) {
        try {
            List<ILPExercise.ExerciseGroup> list = ch.ionesoft.ilp.book.pe.f.a().I(iLPIssueDef);
            for (ILPExercise.ExerciseGroup exerciseGroup : list) {
                this.removeETestSettingsForIssue_exerciseGroupCode(iLPIssueDef, exerciseGroup.getCode());
            }
        }
        catch (Exception exception) {
            logger.d((Object)"Remove etest settings for issue failed.", (Throwable)exception);
        }
    }

    private void removeETestSettingsForIssue_exerciseGroupCode(ILPIssueDef iLPIssueDef, int n2) {
        this.removeETestSettingsPastTimeForIssue_exerciseGroupCode(iLPIssueDef, n2);
        this.removeETestSettingsUsernameForIssue_exerciseGroupCode(iLPIssueDef, n2);
        this.removeETestSettingsStateForIssue_exerciseGroupCode(iLPIssueDef, n2);
    }

    private void removeETestSettingsPastTimeForIssue_exerciseGroupCode(ILPIssueDef iLPIssueDef, int n2) {
        String string = String.format(Locale.ENGLISH, "etest.course.%s.reference.%s.issueId.%s.exerciseGroupCode.%d.pastTime", iLPIssueDef.getCourse().getCourseId(), iLPIssueDef.getCourse().getReference(), iLPIssueDef.getIssueId(), n2);
        p.e().b(string);
    }

    private void removeETestSettingsUsernameForIssue_exerciseGroupCode(ILPIssueDef iLPIssueDef, int n2) {
        String string = String.format(Locale.ENGLISH, "etest.course.%s.reference.%s.issueId.%s.exerciseGroupCode.%d.username", iLPIssueDef.getCourse().getCourseId(), iLPIssueDef.getCourse().getReference(), iLPIssueDef.getIssueId(), n2);
        p.e().b(string);
    }

    private void removeETestSettingsStateForIssue_exerciseGroupCode(ILPIssueDef iLPIssueDef, int n2) {
        String string = String.format(Locale.ENGLISH, "etest.course.%s.reference.%s.issueId.%s.exerciseGroupCode.%d.state", iLPIssueDef.getCourse().getCourseId(), iLPIssueDef.getCourse().getReference(), iLPIssueDef.getIssueId(), n2);
        p.e().b(string);
    }
}

