/*
 * Decompiled with CFR 0.152.
 */
package ch.ionesoft.ilp.book.co;

import ch.ionesoft.ilp.base.co.ILPLogManager;
import ch.ionesoft.ilp.base.co.ILogger;
import ch.ionesoft.ilp.base.co.o;
import ch.ionesoft.ilp.base.fo.x;
import ch.ionesoft.ilp.base.he.StringHelper;
import ch.ionesoft.ilp.base.he.SystemHelper;
import ch.ionesoft.ilp.book.au.c;
import ch.ionesoft.ilp.book.cl.g;
import ch.ionesoft.ilp.book.co.ILPBookRegistry;
import ch.ionesoft.ilp.book.co.ILPBookSettingsHelper;
import ch.ionesoft.ilp.book.co.ILPBookTypes;
import ch.ionesoft.ilp.book.co.ILPProfileManager;
import ch.ionesoft.ilp.book.co.ILPResourceHtmlEmbedder;
import ch.ionesoft.ilp.book.mo.ILPCourseDef;
import ch.ionesoft.ilp.book.mo.ILPCourseProduct;
import ch.ionesoft.ilp.book.mo.ILPEProduct;
import ch.ionesoft.ilp.book.mo.ILPEnvironment;
import ch.ionesoft.ilp.book.mo.ILPExercise;
import ch.ionesoft.ilp.book.mo.ILPIssueDef;
import ch.ionesoft.ilp.book.mo.ILPLicense;
import ch.ionesoft.ilp.book.mo.ILPMandant;
import ch.ionesoft.ilp.book.mo.ILPProperty;
import ch.ionesoft.ilp.book.mo.ILPTopic;
import ch.ionesoft.ilp.book.mo.ILPTransientIssueDef;
import ch.ionesoft.ilp.book.pe.f;
import ch.ionesoft.ilp.book.pe.g;
import ch.ionesoft.ilp.book.pe.j;
import java.util.ArrayList;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class ILPBookHelper {
    private static ILogger logger = ILPLogManager.getLogger(ILPBookHelper.class);
    private static final long NETWORK_TIME_TOLLERANCE_SECS = 60L;
    private static ILPBookHelper sharedInstance = new ILPBookHelper();

    public static ILPBookHelper instance() {
        return sharedInstance;
    }

    public static boolean hasCourseBeenGranted(ILPCourseDef iLPCourseDef) {
        c c2 = ILPBookRegistry.instance().authorizationManager();
        if (iLPCourseDef == null) {
            return false;
        }
        if (c2 == null) {
            logger.c((Object)("Not authorizationManager defined, refusing course: " + iLPCourseDef));
            return false;
        }
        boolean bl2 = false;
        if (c2 != null) {
            bl2 = c2.c(iLPCourseDef);
        }
        return bl2;
    }

    public static boolean hasCourseBeenLicensed(ILPCourseDef iLPCourseDef) {
        c c2 = ILPBookRegistry.instance().authorizationManager();
        if (iLPCourseDef == null) {
            return false;
        }
        if (c2 == null) {
            logger.c((Object)("Not authorizationManager defined, refusing course: " + iLPCourseDef));
            return false;
        }
        boolean bl2 = false;
        if (c2 != null) {
            bl2 = c2.d(iLPCourseDef);
        }
        return bl2;
    }

    public static boolean hasCourseLicenseInfo(ILPCourseDef iLPCourseDef) {
        c c2 = ILPBookRegistry.instance().authorizationManager();
        if (iLPCourseDef == null) {
            return false;
        }
        if (c2 == null) {
            logger.c((Object)("Not authorizationManager defined, refusing course: " + iLPCourseDef));
            return false;
        }
        boolean bl2 = false;
        if (c2 != null) {
            bl2 = c2.b(iLPCourseDef);
        }
        return bl2;
    }

    public static boolean hasIssueBeenGranted(ILPIssueDef iLPIssueDef) {
        if (iLPIssueDef == null) {
            return false;
        }
        return iLPIssueDef.getIssueProduct().hasAccessGranted();
    }

    public static boolean hasIssueBeenGrantedOrExcerpt(ILPIssueDef iLPIssueDef) {
        if (iLPIssueDef == null || iLPIssueDef instanceof ILPTransientIssueDef) {
            return false;
        }
        if (iLPIssueDef.getIssueProduct().isExcerpt()) {
            return true;
        }
        return ILPBookHelper.hasIssueBeenGranted(iLPIssueDef);
    }

    public static boolean hasAnyIssueOfCourseBeenGranted(ILPCourseDef iLPCourseDef) {
        if (iLPCourseDef == null) {
            return false;
        }
        for (ILPIssueDef iLPIssueDef : iLPCourseDef.getIssues()) {
            if (!ILPBookHelper.hasIssueBeenGranted(iLPIssueDef)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasBeenGrantedForAnything() {
        return ILPBookHelper.firstGrantedCourse() != null;
    }

    public static boolean hasBeenLicensedForAnything() {
        return ILPBookHelper.firstLicensedCourse() != null;
    }

    public static ILPCourseDef firstGrantedCourse() {
        try {
            List<ILPCourseDef> list = f.a().b();
            for (ILPCourseDef iLPCourseDef : list) {
                if (!ILPBookHelper.hasCourseBeenGranted(iLPCourseDef)) continue;
                return iLPCourseDef;
            }
        }
        catch (j j2) {
            String string = String.format(Locale.ENGLISH, "Could not fetch courses. Exception: %s", j2.getMessage());
            logger.d((Object)string);
        }
        return null;
    }

    public static ILPCourseDef firstLicensedCourse() {
        List<ILPCourseDef> list = f.a().f();
        return list != null && list.size() > 0 ? list.get(0) : null;
    }

    public static ILPCourseDef firstLoadedCourse() {
        List<ILPCourseDef> list = f.a().d();
        for (ILPCourseDef iLPCourseDef : list) {
            if (!ILPBookHelper.hasCourseTopicsLoaded(iLPCourseDef)) continue;
            return iLPCourseDef;
        }
        return null;
    }

    public static boolean hasCourseUnrestrictedAccess(ILPCourseDef iLPCourseDef) {
        c c2 = ILPBookRegistry.instance().authorizationManager();
        boolean bl2 = c2.a(iLPCourseDef);
        return bl2;
    }

    public static boolean hasCourseLoadedUnrestrictedAccess(ILPCourseDef iLPCourseDef) {
        c c2 = ILPBookRegistry.instance().authorizationManager();
        boolean bl2 = c2.a(iLPCourseDef);
        if (bl2) {
            return true;
        }
        bl2 = true;
        for (ILPIssueDef iLPIssueDef : iLPCourseDef.getIssues()) {
            boolean bl3 = iLPIssueDef.isExcerpt();
            if (bl3 || !ILPBookHelper.hasIssueTopicsOrExercisesLoaded(iLPIssueDef)) continue;
            bl2 = false;
            break;
        }
        return bl2;
    }

    public static boolean hasIssueLoadedUnrestrictedAccess(ILPIssueDef iLPIssueDef) {
        c c2 = ILPBookRegistry.instance().authorizationManager();
        boolean bl2 = c2.a(iLPIssueDef.getCourse());
        if (bl2) {
            return true;
        }
        boolean bl3 = iLPIssueDef.isExcerpt();
        return bl3;
    }

    public static boolean hasCourseTopicsLoaded(ILPCourseDef iLPCourseDef) {
        if (iLPCourseDef == null) {
            return false;
        }
        boolean bl2 = false;
        try {
            ILPIssueDef iLPIssueDef = iLPCourseDef.firstIssue();
            bl2 = ILPBookHelper.hasIssueTopicsLoaded(iLPIssueDef);
            if (!bl2) {
                bl2 = f.a().m(iLPCourseDef) > 0L;
            }
        }
        catch (Exception exception) {
            String string = String.format(Locale.ENGLISH, "Can't countNonUserTopicsOfCourse. Exception: %s", exception.getMessage());
            logger.d((Object)string);
        }
        return bl2;
    }

    public static boolean hasCourseTopicsOrExercisesLoaded(ILPCourseDef iLPCourseDef) {
        if (iLPCourseDef == null) {
            return false;
        }
        boolean bl2 = ILPBookHelper.hasCourseTopicsLoaded(iLPCourseDef);
        if (!bl2) {
            return ILPBookHelper.hasCourseExercisesLoaded(iLPCourseDef);
        }
        return true;
    }

    public static boolean hasCourseExercisesLoaded(ILPCourseDef iLPCourseDef) {
        if (iLPCourseDef == null) {
            return false;
        }
        boolean bl2 = f.a().v(iLPCourseDef) > 0L;
        return bl2;
    }

    public static boolean hasCourseDashboard(ILPCourseDef iLPCourseDef) {
        String string = iLPCourseDef.propertyStringWithName_defaultValue("dashboardWidgets", "");
        return StringHelper.isNotBlank((String)string);
    }

    public static boolean hasIssueTopicsLoaded(ILPIssueDef iLPIssueDef) {
        boolean bl2;
        if (iLPIssueDef == null) {
            return false;
        }
        try {
            bl2 = f.a().s(iLPIssueDef) > 0L;
        }
        catch (j j2) {
            logger.d((Object)("Could not determine if issue has topics loaded: " + iLPIssueDef.getReference()), (Throwable)j2);
            bl2 = false;
        }
        return bl2;
    }

    public static boolean hasIssueNonUserTopicsLoaded(ILPIssueDef iLPIssueDef) {
        boolean bl2;
        if (iLPIssueDef == null) {
            return false;
        }
        try {
            bl2 = f.a().u(iLPIssueDef) > 0L;
        }
        catch (j j2) {
            logger.d((Object)("Could not determine if issue has topics loaded: " + iLPIssueDef.getReference()), (Throwable)j2);
            bl2 = false;
        }
        return bl2;
    }

    public static boolean hasAnyExercises() {
        return f.a().r() > 0L;
    }

    public static boolean hasIssueExercisesLoaded(ILPIssueDef iLPIssueDef) {
        boolean bl2;
        if (iLPIssueDef == null) {
            return false;
        }
        try {
            bl2 = f.a().e(iLPIssueDef, ILPExercise.ExerciseGroup.EXERCISE_GROUP_ANY) > 0L;
        }
        catch (j j2) {
            logger.d((Object)("Could not determine if issue has exercises loaded: " + iLPIssueDef.getReference()), (Throwable)j2);
            bl2 = false;
        }
        return bl2;
    }

    public static boolean hasIssueTopicsOrExercisesLoaded(ILPIssueDef iLPIssueDef) {
        return ILPBookHelper.hasIssueTopicsLoaded(iLPIssueDef) || ILPBookHelper.hasIssueExercisesLoaded(iLPIssueDef);
    }

    public static boolean isFullyLoadedCourse(ILPCourseDef iLPCourseDef) {
        if (iLPCourseDef == null) {
            return false;
        }
        if (iLPCourseDef.getIssues().size() == 0) {
            return false;
        }
        boolean bl2 = false;
        try {
            for (ILPIssueDef iLPIssueDef : iLPCourseDef.getIssues()) {
                bl2 |= ILPBookHelper.isFullyLoadedIssue(iLPIssueDef);
            }
        }
        catch (Exception exception) {
            String string = String.format(Locale.ENGLISH, "Could not get if course %s %s is fully loaded.", iLPCourseDef.getCourseId(), iLPCourseDef.getReference());
            logger.d((Object)string, (Throwable)exception);
        }
        return bl2;
    }

    public static boolean isFullyLoadedIssue(ILPIssueDef iLPIssueDef) {
        try {
            return iLPIssueDef.isAvailableForDownload() != false && f.a().s(iLPIssueDef) == 0L && f.a().e(iLPIssueDef, null) == 0L;
        }
        catch (j j2) {
            logger.d((Object)"Could not detect issue fully loaded", (Throwable)j2);
            return false;
        }
    }

    public static int countLoadedIssuesOfCourse(ILPCourseDef iLPCourseDef) {
        int n2 = 0;
        if (iLPCourseDef == null) {
            return n2;
        }
        for (ILPIssueDef iLPIssueDef : iLPCourseDef.getIssues()) {
            if (!ILPBookHelper.hasIssueTopicsOrExercisesLoaded(iLPIssueDef)) continue;
            ++n2;
        }
        return n2;
    }

    public static List<ILPIssueDef> getLicensedButUnloadedIssuesOfCourse(ILPCourseDef iLPCourseDef) {
        ArrayList<ILPIssueDef> arrayList = new ArrayList<ILPIssueDef>();
        boolean bl2 = iLPCourseDef.isIssueBased();
        for (ILPIssueDef iLPIssueDef : iLPCourseDef.getIssues()) {
            if (ILPBookHelper.hasIssueTopicsOrExercisesLoaded(iLPIssueDef) || bl2 && !ILPBookHelper.hasIssueBeenGranted(iLPIssueDef)) continue;
            arrayList.add(iLPIssueDef);
        }
        return arrayList;
    }

    public static boolean hasApplicationFeatureAccess(c.b b2) {
        c c2 = ILPBookRegistry.instance().authorizationManager();
        if (c2 != null) {
            return c2.a(b2);
        }
        return false;
    }

    public static boolean hasFeatureAccess_forCourse(c.b b2, ILPCourseDef iLPCourseDef, boolean bl2) {
        if (iLPCourseDef == null) {
            return bl2;
        }
        c c2 = ILPBookRegistry.instance().authorizationManager();
        return c2.a(b2, iLPCourseDef, bl2);
    }

    public static boolean hasFeatureAccess_forIssue(c.b b2, ILPIssueDef iLPIssueDef, boolean bl2) {
        if (iLPIssueDef == null) {
            return bl2;
        }
        c c2 = ILPBookRegistry.instance().authorizationManager();
        return c2.a(b2, iLPIssueDef, bl2);
    }

    public static boolean hasFeatureAccess_forIssue_exerciseGroup(c.b b2, ILPIssueDef iLPIssueDef, ILPExercise.ExerciseGroup exerciseGroup, boolean bl2) {
        if (iLPIssueDef == null) {
            return bl2;
        }
        c c2 = ILPBookRegistry.instance().authorizationManager();
        return c2.a(b2, iLPIssueDef, exerciseGroup, bl2);
    }

    public static boolean hasFeatureAccess_forExercise(c.b b2, ILPExercise iLPExercise) {
        return iLPExercise != null && ILPBookHelper.hasFeatureAccess_forIssue_exerciseGroup(b2, iLPExercise.getIssue(), iLPExercise.getExerciseGroup(), false);
    }

    public static boolean hasPropertyInherited_forCourse(String string, ILPCourseDef iLPCourseDef, boolean bl2) {
        if (iLPCourseDef == null) {
            return bl2;
        }
        ILPMandant iLPMandant = iLPCourseDef.getEProduct().getMandantConfig().getMandant();
        ILPEnvironment iLPEnvironment = iLPMandant.getEnvironmentConfig().getEnvironment();
        return iLPCourseDef.propertyBooleanWithName_defaultValue(string, iLPMandant.propertyBooleanById_defaultValue(string, iLPEnvironment.propertyBooleanById_defaultValue(string, bl2)));
    }

    public static boolean hasPropertyInherited_forIssue(String string, ILPIssueDef iLPIssueDef, boolean bl2) {
        if (iLPIssueDef == null) {
            return bl2;
        }
        ILPCourseDef iLPCourseDef = iLPIssueDef.getCourse();
        ILPMandant iLPMandant = iLPCourseDef.getEProduct().getMandantConfig().getMandant();
        ILPEnvironment iLPEnvironment = iLPMandant.getEnvironmentConfig().getEnvironment();
        return iLPIssueDef.propertyBooleanWithName_defaultValue(string, iLPCourseDef.propertyBooleanWithName_defaultValue(string, iLPMandant.propertyBooleanById_defaultValue(string, iLPEnvironment.propertyBooleanById_defaultValue(string, bl2))));
    }

    public static boolean hasBeenGrantedAndFeatureAccess_forExercise(c.b b2, ILPExercise iLPExercise) {
        if (iLPExercise == null) {
            return false;
        }
        if (ILPBookHelper.hasIssueBeenGranted(iLPExercise.getIssue())) {
            return ILPBookHelper.hasFeatureAccess_forExercise(b2, iLPExercise);
        }
        return false;
    }

    public static boolean hasFeatureAccessOrLicensePermissionsToToggleExerciseAnswerSolution(ILPExercise iLPExercise) {
        if (iLPExercise == null) {
            return false;
        }
        if (ILPProfileManager.instance().getCurrentProfile().getLicensePermissionManager().a(iLPExercise)) {
            return true;
        }
        return ILPBookHelper.hasFeatureAccessOrLicensePermissionsToToggleExerciseAnswerSolution(iLPExercise.getIssue(), iLPExercise.getExerciseGroup());
    }

    public static boolean hasFeatureAccessOrLicensePermissionsToToggleExerciseAnswerSolution(ILPIssueDef iLPIssueDef, ILPExercise.ExerciseGroup exerciseGroup) {
        if (ILPBookHelper.hasFeatureAccess_forIssue_exerciseGroup(c.b.f, iLPIssueDef, exerciseGroup, false)) {
            return true;
        }
        return ILPProfileManager.instance().getCurrentProfile().getLicensePermissionManager().a("permission.toggle.exercise.answer.solution", iLPIssueDef, exerciseGroup);
    }

    public static boolean hasFeatureAccessOrLicensePermissionsToToggleExerciseAnswerCorrection(ILPExercise iLPExercise) {
        if (iLPExercise == null) {
            return false;
        }
        if (ILPProfileManager.instance().getCurrentProfile().getLicensePermissionManager().b(iLPExercise)) {
            return true;
        }
        return ILPBookHelper.hasFeatureAccessOrLicensePermissionsToToggleExerciseAnswerCorrection(iLPExercise.getIssue(), iLPExercise.getExerciseGroup());
    }

    public static boolean hasFeatureAccessOrLicensePermissionsToToggleExerciseAnswerCorrection(ILPIssueDef iLPIssueDef, ILPExercise.ExerciseGroup exerciseGroup) {
        if (ILPBookHelper.hasFeatureAccess_forIssue_exerciseGroup(c.b.g, iLPIssueDef, exerciseGroup, false)) {
            return true;
        }
        return ILPProfileManager.instance().getCurrentProfile().getLicensePermissionManager().a("permission.toggle.exercise.answer.correction", iLPIssueDef, exerciseGroup);
    }

    public static boolean hasLicensePermissionToSendExerciseCorrectionPermission(ILPExercise iLPExercise) {
        return ILPProfileManager.instance().getCurrentProfile().getLicensePermissionManager().c(iLPExercise);
    }

    public static boolean hasFeatureAccessToShowStatisticsPopup(ILPIssueDef iLPIssueDef, ILPExercise.ExerciseGroup exerciseGroup) {
        return ILPBookHelper.hasFeatureAccess_forIssue_exerciseGroup(c.b.i, iLPIssueDef, exerciseGroup, false);
    }

    public static boolean isAllowedToggleAnswersForExercise(ILPExercise iLPExercise) {
        boolean bl2 = true;
        boolean bl3 = ILPBookHelper.hasFeatureAccess_forExercise(c.b.j, iLPExercise);
        boolean bl4 = ILPBookHelper.hasFeatureAccess_forExercise(c.b.l, iLPExercise);
        if (bl3) {
            try {
                long l2 = f.a().f(iLPExercise.getIssue(), iLPExercise.getExerciseGroup());
                long l3 = f.a().e(iLPExercise.getIssue(), iLPExercise.getExerciseGroup());
                bl2 = l2 == l3;
            }
            catch (Exception exception) {
                logger.d((Object)"Could not count exercises", (Throwable)exception);
                return false;
            }
        }
        if (!bl2) {
            return false;
        }
        if (bl4 && !ILPBookHelper.hasIssueBeenGranted(iLPExercise.getIssue())) {
            return false;
        }
        return bl2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean evaluateFeatureValueWithExerciseGroup(String string, ILPExercise.ExerciseGroup exerciseGroup) {
        if (string == null) {
            return false;
        }
        if (string.equalsIgnoreCase("true")) {
            return true;
        }
        if (string.equalsIgnoreCase("false")) {
            return false;
        }
        if (exerciseGroup == null) return false;
        if (exerciseGroup.equals(ILPExercise.ExerciseGroup.EXERCISE_GROUP_ANY)) return false;
        try {
            String[] stringArray;
            String[] stringArray2 = stringArray = string.split(",");
            int n2 = stringArray.length;
            int n3 = 0;
            while (true) {
                if (n3 >= n2) {
                    return false;
                }
                String string2 = stringArray2[n3];
                if ((string2 = string2.trim()).equals("" + exerciseGroup.getCode())) {
                    return true;
                }
                ++n3;
            }
        }
        catch (Exception exception) {
            logger.d((Object)("Could not evaluateFeatureValue: " + string + " for exerciseGroup: " + exerciseGroup));
        }
        return false;
    }

    public static ILPCourseDef associateCourseForCourse(ILPCourseDef iLPCourseDef) {
        String string = iLPCourseDef.propertyStringWithName_defaultValue("associateCourseId", null);
        String string2 = iLPCourseDef.propertyStringWithName_defaultValue("associateCourseReference", null);
        if (StringUtils.isNotBlank((CharSequence)string) && StringUtils.isNotBlank((CharSequence)string2)) {
            try {
                return f.a().a(string, string2);
            }
            catch (j j2) {
                logger.d((Object)("Could not fetch an associated course with courseId: " + string + ", courseReference: " + string2), (Throwable)j2);
            }
        }
        return null;
    }

    public static ILPIssueDef associateIssueForIssue(ILPIssueDef iLPIssueDef) {
        String string = iLPIssueDef.propertyStringWithName_defaultValue("associateIssueId", null);
        if (StringUtils.isNotBlank((CharSequence)string) && !string.equals(iLPIssueDef.getIssueId())) {
            try {
                return f.a().d(string, iLPIssueDef.getCourse().getCourseId(), iLPIssueDef.getCourse().getReference());
            }
            catch (j j2) {
                logger.d((Object)("Could not fetch an associated issue with associatedIssueId: " + string), (Throwable)j2);
            }
        }
        return null;
    }

    public static String getAdditionalExerciseCSS(ILPIssueDef iLPIssueDef) {
        if (ILPBookHelper.hasExerciseAdditionsCSS(iLPIssueDef)) {
            return ILPBookHelper.getEmbeddedUrlIfEnabled("http://localhost/xassets/ILPExerciseAdditions.css", iLPIssueDef);
        }
        return ILPBookHelper.getEmbeddedUrlIfEnabled("http://localhost/assets/ILPBookAdditions.css", iLPIssueDef);
    }

    public static String getAdditionalExerciseJS(ILPIssueDef iLPIssueDef) {
        if (ILPBookHelper.hasExerciseAdditionsJS(iLPIssueDef)) {
            return ILPBookHelper.getEmbeddedUrlIfEnabled("http://localhost/xassets/ILPExerciseAdditions.js", iLPIssueDef);
        }
        return ILPBookHelper.getEmbeddedUrlIfEnabled("http://localhost/assets/ILPBookAdditions.js", iLPIssueDef);
    }

    public static String getEmbeddedUrlIfEnabled(String string, ILPIssueDef iLPIssueDef) {
        ILPResourceHtmlEmbedder iLPResourceHtmlEmbedder = new ILPResourceHtmlEmbedder();
        boolean bl2 = ILPBookHelper.hasPropertyInherited_forCourse("disableResourceEmbedder", iLPIssueDef.getCourse(), false);
        return bl2 ? string : iLPResourceHtmlEmbedder.fetchAndEncodeToResourcePkUrl(string, false, iLPIssueDef);
    }

    public static boolean hasExerciseAdditionsJS(ILPIssueDef iLPIssueDef) {
        ILPResourceHtmlEmbedder iLPResourceHtmlEmbedder = new ILPResourceHtmlEmbedder();
        return iLPResourceHtmlEmbedder.fetchResourceByIdentifierOrHref("http://localhost/xassets/ILPExerciseAdditions.js", false, iLPIssueDef) != null;
    }

    public static boolean hasExerciseAdditionsCSS(ILPIssueDef iLPIssueDef) {
        ILPResourceHtmlEmbedder iLPResourceHtmlEmbedder = new ILPResourceHtmlEmbedder();
        return iLPResourceHtmlEmbedder.fetchResourceByIdentifierOrHref("http://localhost/xassets/ILPExerciseAdditions.css", false, iLPIssueDef) != null;
    }

    public static void createCitationWithSelectedText(String string) {
        if (string.length() > 0) {
            String string2 = string;
            ILPCourseProduct iLPCourseProduct = ILPBookRegistry.instance().getCurrentIssue().getCourse().getCourseProduct();
            string2 = String.valueOf(string2) + "\n--------------\n";
            string2 = String.valueOf(string2) + iLPCourseProduct.getAuthorsAsText() + ", ";
            string2 = String.valueOf(string2) + iLPCourseProduct.getTitle() + " (";
            string2 = String.valueOf(string2) + iLPCourseProduct.getPrintCode() + "), ";
            string2 = String.valueOf(string2) + iLPCourseProduct.getEProduct().getMandantConfig().getMandant().getName() + ", ";
            string2 = String.valueOf(string2) + iLPCourseProduct.getIsbnOrReference();
            string2 = String.valueOf(string2) + "\n--------------\n";
            ch.ionesoft.ilp.base.co.f.b().I().copyToClipboard(string2);
            ch.ionesoft.ilp.base.co.f.b().D().displayNoticeCode("message.citation.clipboard", new Object[0]);
        }
    }

    public boolean glossaryAvailableInCourse(ILPCourseDef iLPCourseDef) {
        ILPProperty iLPProperty = iLPCourseDef.propertyWithName_defaultProperty("glossaryIssueId", null);
        return iLPProperty != null;
    }

    public ILPTopic glossaryTopicForName_course(String string, ILPCourseDef iLPCourseDef) {
        ILPProperty iLPProperty = iLPCourseDef.propertyWithName_defaultProperty("glossaryIssueId", null);
        if (string == null || string.length() > 100) {
            return null;
        }
        if (iLPProperty != null) {
            Object object;
            String string2 = iLPProperty.getValue();
            f f2 = f.a();
            ILPIssueDef iLPIssueDef = null;
            try {
                iLPIssueDef = f2.d(string2, iLPCourseDef.getCourseId(), iLPCourseDef.getReference());
            }
            catch (j j2) {
                object = String.format(Locale.ENGLISH, "Can't fetchIssueWithId. IssueId: %s, courseId: %s, courseReference: %s, Exception: %s", string2, iLPCourseDef.getCourseId(), iLPCourseDef.getReference(), j2.getMessage());
                logger.d(object);
            }
            if (iLPIssueDef != null) {
                int n2 = -3;
                if (string.length() <= 3) {
                    n2 = 0;
                } else if (string.length() == 4) {
                    n2 = -1;
                } else if (string.length() == 5) {
                    n2 = -2;
                }
                object = null;
                try {
                    object = f2.a(string, n2, true, true, iLPIssueDef, iLPCourseDef);
                }
                catch (Exception exception) {
                    logger.d((Object)String.format(Locale.ENGLISH, "Error fetching topic with similar title: %s, minLength: %d, Reason: %s", string, n2, exception.getMessage()));
                }
                return object;
            }
        }
        return null;
    }

    public static String pathFragmentForUserDataInIssue(ILPIssueDef iLPIssueDef) {
        return "UserData/" + ILPBookHelper.courseToIssueFragment(iLPIssueDef) + "/";
    }

    private static String courseToIssueFragment(ILPIssueDef iLPIssueDef) {
        return String.format("%s/%s/%s/%s", iLPIssueDef.getCourse().getCourseId(), iLPIssueDef.getCourse().getReference(), iLPIssueDef.getIssueId(), iLPIssueDef.getReference());
    }

    public static boolean isCloudAllowedForReason(g.a a2, List<String> list) {
        boolean bl2 = false;
        boolean bl3 = x.a().a(false);
        String string = "Cloud is not allowed, reason: ";
        switch (a2) {
            case c: {
                boolean bl4 = false;
                boolean bl5 = false;
                boolean bl6 = false;
                try {
                    bl4 = ILPBookSettingsHelper.instance().isLoggedIn();
                    bl5 = ILPBookSettingsHelper.instance().isSlaAccepted();
                    bl6 = ILPBookRegistry.instance().isAllowedToUseCloud();
                }
                catch (Exception exception) {
                    logger.c((Object)"Could not fetch courses for authorization state registered.");
                }
                if (!bl3) {
                    list.add(o.a().d("message.epub.notConnectedError"));
                    logger.c((Object)(String.valueOf(string) + "Device has no network connection."));
                }
                if (!bl4) {
                    logger.c((Object)(String.valueOf(string) + "User is not logged in."));
                    list.add(o.a().d("message.cloud.connection.refuse.not.logged.in"));
                }
                if (!bl5) {
                    list.add(o.a().d("message.cloud.connection.refuse.slaNotAccepted"));
                    logger.c((Object)(String.valueOf(string) + "User has not accepted SLA."));
                }
                if (!bl6) {
                    list.add(o.a().d("message.cloud.user.notAllowed"));
                    logger.c((Object)(String.valueOf(string) + "User has not allowed to use cloud, quota -1."));
                }
                bl2 = bl3 && bl4 && bl5 && bl6;
                break;
            }
            case a: {
                bl2 = false;
                break;
            }
            case b: {
                bl2 = bl3;
                break;
            }
        }
        return bl2;
    }

    public static void checkClockTime() {
        if (ILPBookSettingsHelper.instance().getCloudServiceType().equals((Object)g.a.a)) {
            return;
        }
        if (!x.a().a(false)) {
            return;
        }
        ILPBookHelper.isLocalTimeCorresponding(true);
    }

    public static boolean isLocalTimeCorresponding(boolean bl2) {
        long l2;
        Date date = SystemHelper.currentNetworkTime();
        Date date2 = new Date();
        if (date != null && (l2 = Math.abs(date2.getTime() - date.getTime()) / 1000L) > 60L) {
            logger.d((Object)("Users local time is shifted by: " + l2 + " seconds. Inform him with an alert."));
            if (bl2) {
                ch.ionesoft.ilp.base.co.f.b().D().showAlertView_titleCode(o.a((String)"message.network.time.difference", (Object[])new Object[]{l2}), "title.warning", false);
            }
            return false;
        }
        return true;
    }

    public static String formatNodeId(String string, int n2, String string2) {
        String string3;
        if (StringUtils.isEmpty((CharSequence)string2)) {
            return null;
        }
        if (StringHelper.startsNumeric((String)string2)) {
            string3 = String.valueOf(string) + "-" + n2 + "-" + string2;
        } else if (string2.indexOf("-") == string2.lastIndexOf("-")) {
            string2 = string2.substring(string2.lastIndexOf("-") + 1);
            string3 = String.valueOf(string) + "-" + n2 + "-" + string2;
        } else {
            string3 = string2;
        }
        return string3;
    }

    public static Integer extractedNodeId(String string) {
        if (StringUtils.isEmpty((CharSequence)string)) {
            return null;
        }
        String[] stringArray = string.split("-");
        if (stringArray == null || stringArray.length < 1) {
            return null;
        }
        String string2 = stringArray[stringArray.length - 1];
        try {
            return Integer.parseInt(string2);
        }
        catch (Exception exception) {
            logger.d((Object)("Could not extract nodeId from composite: " + string));
            return null;
        }
    }

    public static EProductState getEProductState(ILPEProduct iLPEProduct, boolean bl2) {
        try {
            ILPCourseProduct iLPCourseProduct;
            boolean bl3;
            g.a().b(iLPEProduct);
            if (iLPEProduct == null) {
                return EProductState.PORTAL_EPRODUCT_STATE_UNDEFINED;
            }
            if (iLPEProduct.isLicenseAuthorized() && iLPEProduct.isPermissionProduct()) {
                return EProductState.PORTAL_EPRODUCT_STATE_UP_TO_DATE;
            }
            ILPLicense.LicenseState licenseState = iLPEProduct.getLicense() != null ? iLPEProduct.getLicense().getLicenseStateType() : (iLPEProduct.determineLicense() != null ? iLPEProduct.determineLicense().getLicenseStateType() : ILPLicense.LicenseState.LICENSE_STATE_UNDEFINED);
            if (iLPEProduct.getAvailableForFree() != null && iLPEProduct.getAvailableForFree().booleanValue() && licenseState != ILPLicense.LicenseState.LICENSE_STATE_EXCEEDED && licenseState != ILPLicense.LicenseState.LICENSE_STATE_WITHDRAWN) {
                if (iLPEProduct.getContentStateEnum() == ILPBookTypes.ContentState.CONTENT_STATE_FULLY_LOADED) {
                    if (iLPEProduct.isUpdateAvailable()) {
                        return EProductState.PORTAL_EPRODUCT_STATE_UPDATE_AVAILABLE;
                    }
                    return EProductState.PORTAL_EPRODUCT_STATE_UP_TO_DATE;
                }
                if (iLPEProduct.getContentStateEnum() == ILPBookTypes.ContentState.CONTENT_STATE_NOT_LOADED) {
                    return EProductState.PORTAL_EPRODUCT_STATE_READY_TO_INSTALL;
                }
                if (iLPEProduct.getContentStateEnum() == ILPBookTypes.ContentState.CONTENT_STATE_PARTIALLY_LOADED) {
                    return EProductState.PORTAL_EPRODUCT_STATE_INSTALL_INCOMPLETE;
                }
            }
            boolean bl4 = bl3 = iLPEProduct.getContentStateEnum().equals((Object)ILPBookTypes.ContentState.CONTENT_STATE_FULLY_LOADED) || iLPEProduct.getContentStateEnum().equals((Object)ILPBookTypes.ContentState.CONTENT_STATE_PARTIALLY_LOADED);
            if (licenseState.equals((Object)ILPLicense.LicenseState.LICENSE_STATE_UNDEFINED)) {
                ILPCourseProduct iLPCourseProduct2 = iLPEProduct.getCourseProduct();
                if (bl2 && iLPEProduct.isCourseProduct() && iLPCourseProduct2.isNewerConfigVersionAvailable()) {
                    return EProductState.PORTAL_EPRODUCT_STATE_UPDATE_AVAILABLE;
                }
                if (bl2 && !iLPEProduct.areAllLicensedSubProductsInstalled()) {
                    return EProductState.PORTAL_EPRODUCT_STATE_READY_TO_INSTALL;
                }
                if (bl2 && iLPEProduct.areAllLicensedSubProductsInstalled()) {
                    return EProductState.PORTAL_EPRODUCT_STATE_UP_TO_DATE;
                }
                if (bl3) {
                    return EProductState.PORTAL_EPRODUCT_STATE_EXCERPT;
                }
                if (iLPEProduct.hasExcerpt()) {
                    return EProductState.PORTAL_EPRODUCT_STATE_EXCERPT_AVAILABLE;
                }
                return EProductState.PORTAL_EPRODUCT_STATE_UNAVAILABLE;
            }
            if (licenseState.equals((Object)ILPLicense.LicenseState.LICENSE_STATE_EXPIRED)) {
                return EProductState.PORTAL_EPRODUCT_STATE_EXPIRED;
            }
            if (licenseState.equals((Object)ILPLicense.LicenseState.LICENSE_STATE_EXCEEDED)) {
                return EProductState.PORTAL_EPRODUCT_STATE_DEVICE_FAILURE;
            }
            if (licenseState.equals((Object)ILPLicense.LicenseState.LICENSE_STATE_OVERDUE)) {
                return EProductState.PORTAL_EPRODUCT_STATE_DEVICE_FAILURE;
            }
            if (licenseState.equals((Object)ILPLicense.LicenseState.LICENSE_STATE_DEVICE_FAILURE)) {
                return EProductState.PORTAL_EPRODUCT_STATE_DEVICE_VERIFICATION_FAILED;
            }
            if (licenseState.equals((Object)ILPLicense.LicenseState.LICENSE_STATE_WITHDRAWN)) {
                return EProductState.PORTAL_EPRODUCT_STATE_EXPIRED;
            }
            if (licenseState.equals((Object)ILPLicense.LicenseState.LICENSE_STATE_VALID) && bl2 && (iLPCourseProduct = iLPEProduct.getCourseProduct()).isIssueBased()) {
                if (bl2 && iLPEProduct.isCourseProduct() && iLPCourseProduct.isNewerConfigVersionAvailable()) {
                    return EProductState.PORTAL_EPRODUCT_STATE_UPDATE_AVAILABLE;
                }
                if (bl2 && !iLPEProduct.areAllLicensedSubProductsInstalled()) {
                    return EProductState.PORTAL_EPRODUCT_STATE_READY_TO_INSTALL;
                }
                if (bl2 && iLPEProduct.areAllLicensedSubProductsInstalled()) {
                    return EProductState.PORTAL_EPRODUCT_STATE_UP_TO_DATE;
                }
            }
            if (!bl3) {
                return EProductState.PORTAL_EPRODUCT_STATE_READY_TO_INSTALL;
            }
            boolean bl5 = iLPEProduct.isFullyLoaded();
            if (!bl5) {
                return EProductState.PORTAL_EPRODUCT_STATE_INSTALL_INCOMPLETE;
            }
            if (iLPEProduct.isUpdateAvailable()) {
                return EProductState.PORTAL_EPRODUCT_STATE_UPDATE_AVAILABLE;
            }
        }
        catch (Exception exception) {
            logger.d((Object)("Could not determine state of eProduct: " + iLPEProduct), (Throwable)exception);
            return EProductState.PORTAL_EPRODUCT_STATE_READY_TO_INSTALL;
        }
        return EProductState.PORTAL_EPRODUCT_STATE_UP_TO_DATE;
    }

    public static List<ILPEProduct> filterEbookUpdatesAvailable(List<ILPEProduct> list) {
        ArrayList<ILPEProduct> arrayList = new ArrayList<ILPEProduct>();
        for (ILPEProduct iLPEProduct : list) {
            try {
                EProductState eProductState = ILPBookHelper.getEProductState(iLPEProduct, false);
                if (iLPEProduct.determineLicense() == null || !eProductState.equals((Object)EProductState.PORTAL_EPRODUCT_STATE_UPDATE_AVAILABLE)) continue;
                arrayList.add(iLPEProduct);
            }
            catch (Exception exception) {
                logger.d((Object)("Could not check if update is available for eproduct: " + iLPEProduct), (Throwable)exception);
            }
        }
        return arrayList;
    }

    public static boolean hasTopicEditableFieldsWithSolution(String string) {
        try {
            String string2 = "<(div|span)\\b(?=[^>]*\\bclass=\"[^\"]*\\beditableField\\b[^\"]*\")(?=[^>]*\\bclass=\"[^\"]*\\b(editableText|editableTextEntry)\\b[^\"]*\")(?=[^>]*\\bdata-solution-text=\"[^\"]+\")[^>]*>.*?</\\1>";
            Pattern pattern = Pattern.compile(string2, 34);
            Matcher matcher = pattern.matcher(string);
            if (matcher.find()) {
                return true;
            }
        }
        catch (Exception exception) {
            logger.d((Object)"Could not check for editableFields with solutions", (Throwable)exception);
        }
        return false;
    }

    public static enum EProductState {
        PORTAL_EPRODUCT_STATE_READY_TO_INSTALL("portalV2.label.status.readyToInstall", "statusReadyToInstall"),
        PORTAL_EPRODUCT_STATE_UPDATE_AVAILABLE("portalV2.label.status.updateAvailable", "statusUpdateAvailable"),
        PORTAL_EPRODUCT_STATE_UP_TO_DATE("portalV2.label.status.upToDate", "statusUpToDate"),
        PORTAL_EPRODUCT_STATE_EXCERPT("portalV2.label.status.excerpt", "statusExcerpt"),
        PORTAL_EPRODUCT_STATE_UNDEFINED("authorizationState.undefined", "statusUndefined"),
        PORTAL_EPRODUCT_STATE_UNREGISTERED("authorizationState.unregistered", "statusUnregistered"),
        PORTAL_EPRODUCT_STATE_EXPIRED("authorizationState.expired", "statusExpired"),
        PORTAL_EPRODUCT_STATE_DEVICE_FAILURE("authorizationState.deviceFailure", "statusDeviceFailure"),
        PORTAL_EPRODUCT_STATE_DEVICE_VERIFICATION_FAILED("authorizationState.verificationFailed", "statusVerificationFailed"),
        PORTAL_EPRODUCT_STATE_INSTALL_INCOMPLETE("portalV2.label.status.installIncomplete", "statusInstallIncomplete"),
        PORTAL_EPRODUCT_STATE_EXCERPT_AVAILABLE("portalV2.label.status.excerptAvailable", "statusExcerptAvailable"),
        PORTAL_EPRODUCT_STATE_UNAVAILABLE("portalV2.label.status.unavailable", "statusUnavailable"),
        PORTAL_EPRODUCT_STATE_EMPTY("portalV2.label.status.empty", "statusTransparent"),
        PORTAL_EPRODUCT_STATE_READY_TO_INSTALL_TOUCHED("portalV2.label.status.readyToInstallTouched", "statusReadyToInstallTouched");

        private String localizable;
        private String cssClass;

        private EProductState(String string2, String string3) {
            this.localizable = string2;
            this.cssClass = string3;
        }

        public String getLocalizable() {
            return this.localizable;
        }

        public String getCssClass() {
            return this.cssClass;
        }
    }

    public static enum SynchronizedDataStrategy {
        SYNCHRONIZED_DATA_IMPORT(1),
        SYNCHRONIZED_DATA_DELETE(2),
        SYNCHRONIZED_DATA_ASK(3);

        private static final Map<Integer, SynchronizedDataStrategy> lookup;
        private int code;

        static {
            lookup = new HashMap<Integer, SynchronizedDataStrategy>();
            for (SynchronizedDataStrategy synchronizedDataStrategy : EnumSet.allOf(SynchronizedDataStrategy.class)) {
                lookup.put(synchronizedDataStrategy.getCode(), synchronizedDataStrategy);
            }
        }

        private SynchronizedDataStrategy(int n3) {
            this.code = n3;
        }

        public int getCode() {
            return this.code;
        }

        public static SynchronizedDataStrategy get(int n2) {
            return lookup.get(n2);
        }

        public static SynchronizedDataStrategy get(String string) {
            int n2 = Integer.parseInt(string);
            return lookup.get(n2);
        }
    }
}

