/*
 * Decompiled with CFR 0.152.
 */
package ch.ionesoft.ilp.book.co;

import ch.ionesoft.ilp.base.co.ILPLogManager;
import ch.ionesoft.ilp.base.co.ILogger;
import ch.ionesoft.ilp.base.co.o;
import ch.ionesoft.ilp.base.he.DateHelper;
import ch.ionesoft.ilp.book.mo.AbstractCoreDataModel;
import ch.ionesoft.ilp.book.mo.ILPAnswer;
import ch.ionesoft.ilp.book.mo.ILPCourseDef;
import ch.ionesoft.ilp.book.mo.ILPExercise;
import ch.ionesoft.ilp.book.mo.ILPIssueDef;
import ch.ionesoft.ilp.book.mo.ILPLocalStoreItem;
import ch.ionesoft.ilp.book.mo.ILPNote;
import ch.ionesoft.ilp.book.mo.ILPQuestion;
import ch.ionesoft.ilp.book.mo.ILPTopic;
import ch.ionesoft.ilp.book.pe.f;
import ch.ionesoft.ilp.book.pe.g;
import ch.ionesoft.ilp.book.pe.j;
import com.j256.ormlite.dao.CloseableIterator;
import com.j256.ormlite.misc.TransactionManager;
import com.j256.ormlite.support.ConnectionSource;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;

public class ILPAnnotationImporter {
    private static ILogger logger = ILPLogManager.getLogger(ILPAnnotationImporter.class);
    private int numImportedAnnotations = 0;
    private int numNotExistingAnnotations = 0;
    private int numOverwrittenOlderAnnotations = 0;
    private int numOverwrittenNewerAnnotations = 0;
    private int numFailedAnnotations = 0;
    private ILPCourseDef course;
    private List<ILPCourseDef> importedCourses = new ArrayList<ILPCourseDef>();
    private boolean overwriteNewerAlso;
    private boolean overwriteExisting;

    public void takeoverAnnotationsFromAnyNodesIntoCourse(ILPCourseDef iLPCourseDef, boolean bl2, boolean bl3) {
        logger.b((Object)("Importing annotations with same nodeId into course: " + iLPCourseDef));
        this.course = iLPCourseDef;
        this.overwriteExisting = bl2;
        this.overwriteNewerAlso = bl3;
        for (ILPIssueDef iLPIssueDef : iLPCourseDef.getIssues()) {
            logger.b((Object)("Searching annotations that match into issue: " + iLPIssueDef));
            try {
                this.importAnnotationsIntoIssue(iLPIssueDef);
            }
            catch (Exception exception) {
                logger.d((Object)("Could not import annotations into issue: " + iLPIssueDef), (Throwable)exception);
                ch.ionesoft.ilp.base.co.f.b().D().displayWarningCode("message.internalError", new Object[0]);
            }
        }
        try {
            this.importUserTopics();
        }
        catch (SQLException sQLException) {
            logger.d((Object)("Could not import annotations into course: " + iLPCourseDef), (Throwable)sQLException);
            ch.ionesoft.ilp.base.co.f.b().D().displayWarningCode("message.internalError", new Object[0]);
        }
        logger.b((Object)"Finished importing annotations");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void importAnnotationsIntoIssue(final ILPIssueDef iLPIssueDef) throws SQLException {
        ConnectionSource connectionSource = g.a().I();
        synchronized (connectionSource) {
            TransactionManager.callInTransaction((ConnectionSource)g.a().I(), (Callable)new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    for (AbstractCoreDataModel abstractCoreDataModel : iLPIssueDef.getTopics()) {
                        if (StringUtils.isEmpty((CharSequence)((ILPTopic)abstractCoreDataModel).getNodeId())) {
                            logger.c((Object)("Topic has no nodeId and can therefore not be updated with annotations: " + abstractCoreDataModel));
                            continue;
                        }
                        ILPAnnotationImporter.this.importAnnotationsIntoTopic((ILPTopic)abstractCoreDataModel);
                    }
                    for (AbstractCoreDataModel abstractCoreDataModel : iLPIssueDef.getExercises()) {
                        if (StringUtils.isEmpty((CharSequence)((ILPExercise)abstractCoreDataModel).getNodeId())) {
                            logger.c((Object)("Exercise has no nodeId and can therefore not be updated with annotations: " + abstractCoreDataModel));
                            continue;
                        }
                        ILPAnnotationImporter.this.importAnnotationsIntoExercise((ILPExercise)abstractCoreDataModel);
                    }
                    for (AbstractCoreDataModel abstractCoreDataModel : iLPIssueDef.getExercises()) {
                        if (StringUtils.isEmpty((CharSequence)((ILPExercise)abstractCoreDataModel).getNodeId())) {
                            logger.c((Object)("Exercise has no nodeId and can therefore not be updated with annotations: " + abstractCoreDataModel));
                            continue;
                        }
                        ILPAnnotationImporter.this.importAnswersIntoExercise((ILPExercise)abstractCoreDataModel);
                    }
                    return null;
                }
            });
        }
    }

    private void importAnnotationsIntoTopic(ILPTopic iLPTopic) {
        List<ILPTopic> list = f.a().i(iLPTopic.getNodeId());
        for (ILPTopic iLPTopic2 : list) {
            if (iLPTopic2.equals(iLPTopic)) continue;
            this.addToImportedCourse(iLPTopic2.getIssue().getCourse());
            for (ILPNote iLPNote : iLPTopic2.getNotes()) {
                this.importNoteIntoTopic(iLPNote, iLPTopic);
            }
            iLPTopic.setBookmarked(iLPTopic2.getBookmarked());
            iLPTopic.setBookmarkColorIndex(iLPTopic2.getBookmarkColorIndex());
            iLPTopic.setLastAccess(iLPTopic2.getLastAccess());
            iLPTopic.setLastUpdate(iLPTopic2.getLastUpdate());
            iLPTopic.setProcessed(iLPTopic2.getProcessed());
            iLPTopic.setSelected(iLPTopic2.getSelected());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void importNoteIntoTopic(ILPNote iLPNote, ILPTopic iLPTopic) {
        try {
            ILPNote iLPNote2 = f.a().c(iLPTopic, iLPNote.getKey());
            if (iLPNote2 != null) {
                if (!this.overwriteExisting) return;
                if (DateHelper.isNewer((DateTime)iLPNote2.getLastUpdate(), (DateTime)iLPNote.getLastUpdate())) {
                    if (!this.overwriteNewerAlso) return;
                    ++this.numOverwrittenNewerAnnotations;
                } else {
                    ++this.numOverwrittenOlderAnnotations;
                }
            } else {
                iLPNote2 = new ILPNote();
                iLPNote2.setTopic(iLPTopic);
                ++this.numNotExistingAnnotations;
            }
            iLPNote.copyInto(iLPNote2);
            ++this.numImportedAnnotations;
            return;
        }
        catch (Exception exception) {
            logger.c((Object)("Could not import note: " + iLPNote + " into topic: " + iLPTopic), (Throwable)exception);
            this.numFailedAnnotations = this.getNumFailedAnnotations() + 1;
        }
    }

    private void importAnnotationsIntoExercise(ILPExercise iLPExercise) {
        List<ILPExercise> list = f.a().p(iLPExercise.getNodeId());
        for (ILPExercise iLPExercise2 : list) {
            if (iLPExercise2.equals(iLPExercise)) continue;
            this.addToImportedCourse(iLPExercise2.getIssue().getCourse());
            for (ILPNote iLPNote : iLPExercise2.getNotes()) {
                this.importNoteIntoExercise(iLPNote, iLPExercise);
            }
            iLPExercise.setBookmarkColorIndex(iLPExercise2.getBookmarkColorIndex());
            iLPExercise.setLastAccess(iLPExercise2.getLastAccess());
            iLPExercise.setProcessed(iLPExercise2.getProcessed());
            iLPExercise.setProcessedDate(iLPExercise2.getProcessedDate());
            iLPExercise.setRating(iLPExercise2.getRating());
            iLPExercise.setSelected(iLPExercise2.getSelected());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void importNoteIntoExercise(ILPNote iLPNote, ILPExercise iLPExercise) {
        try {
            ILPNote iLPNote2 = f.a().a(iLPExercise, iLPNote.getKey());
            if (iLPNote2 != null) {
                if (!this.overwriteExisting) return;
                if (DateHelper.isNewer((DateTime)iLPNote2.getLastUpdate(), (DateTime)iLPNote.getLastUpdate())) {
                    if (!this.overwriteNewerAlso) return;
                    ++this.numOverwrittenNewerAnnotations;
                } else {
                    ++this.numOverwrittenOlderAnnotations;
                }
            } else {
                iLPNote2 = new ILPNote();
                iLPNote2.setExercise(iLPExercise);
                ++this.numNotExistingAnnotations;
            }
            iLPNote.copyInto(iLPNote2);
            ++this.numImportedAnnotations;
            return;
        }
        catch (Exception exception) {
            logger.c((Object)("Could not import note: " + iLPNote + " into exercise: " + iLPExercise), (Throwable)exception);
            this.numFailedAnnotations = this.getNumFailedAnnotations() + 1;
        }
    }

    private void importAnswersIntoExercise(ILPExercise iLPExercise) throws j {
        List<ILPExercise> list = f.a().p(iLPExercise.getNodeId());
        for (ILPExercise iLPExercise2 : list) {
            if (iLPExercise2.equals(iLPExercise)) continue;
            this.addToImportedCourse(iLPExercise2.getIssue().getCourse());
            for (ILPAnswer iLPAnswer : f.a().a(ILPAnswer.AnswerType.ANSWER_TYPE_USER, iLPExercise2)) {
                this.importAnswerIntoExercise(iLPAnswer, iLPExercise);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void importAnswerIntoExercise(ILPAnswer iLPAnswer, ILPExercise iLPExercise) {
        try {
            if (!iLPAnswer.getQuestion().isAnswered()) {
                return;
            }
            ILPQuestion iLPQuestion = f.a().a((int)iLPAnswer.getQuestion().getNumber(), iLPExercise);
            if (iLPQuestion == null) {
                logger.c((Object)("Question of answer: " + iLPAnswer + " does not match in targetExercise"));
                return;
            }
            ILPAnswer iLPAnswer2 = f.a().a(iLPAnswer.getAnswerType(), iLPAnswer.getNumber(), iLPQuestion);
            if (iLPAnswer2 != null) {
                if (DateHelper.isNewer((DateTime)iLPAnswer2.getLastUpdate(), (DateTime)iLPAnswer.getLastUpdate())) {
                    if (!this.overwriteNewerAlso) return;
                    ++this.numOverwrittenNewerAnnotations;
                } else {
                    ++this.numOverwrittenOlderAnnotations;
                }
            } else {
                iLPAnswer2 = new ILPAnswer();
                iLPAnswer2.setQuestion(iLPQuestion);
                ++this.numNotExistingAnnotations;
            }
            iLPAnswer.copyInto(iLPAnswer2);
            iLPQuestion.setAnswered(iLPAnswer.getQuestion().getAnswered());
            iLPExercise.setProcessed(iLPAnswer.getQuestion().getExercise().getProcessed());
            iLPExercise.setProcessedDate(iLPAnswer.getQuestion().getExercise().getProcessedDate());
            if (iLPAnswer2.isInDatabase()) {
                g.a().L().update((Object)iLPAnswer2);
            } else {
                g.a().L().create((Object)iLPAnswer2);
            }
            g.a().K().update((Object)iLPQuestion);
            g.a().J().update((Object)iLPExercise);
            ++this.numImportedAnnotations;
            return;
        }
        catch (Exception exception) {
            logger.c((Object)("Could not import note: " + iLPAnswer + " into exercise: " + iLPExercise), (Throwable)exception);
            this.numFailedAnnotations = this.getNumFailedAnnotations() + 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void importUserTopics() throws SQLException {
        ConnectionSource connectionSource = g.a().I();
        synchronized (connectionSource) {
            TransactionManager.callInTransaction((ConnectionSource)g.a().I(), (Callable)new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    for (ILPCourseDef iLPCourseDef : ILPAnnotationImporter.this.importedCourses) {
                        for (ILPIssueDef iLPIssueDef : iLPCourseDef.getIssues()) {
                            try {
                                for (ILPTopic iLPTopic : f.a().m(iLPIssueDef)) {
                                    ILPIssueDef iLPIssueDef2 = null;
                                    ILPTopic iLPTopic2 = null;
                                    ILPTopic iLPTopic3 = iLPTopic.getParent();
                                    if (iLPTopic3 != null && (iLPTopic2 = f.a().a(iLPTopic3.getNodeId(), ILPAnnotationImporter.this.course)) != null) {
                                        iLPIssueDef2 = iLPTopic2.getIssue();
                                    }
                                    if (iLPIssueDef2 == null && (iLPIssueDef2 = f.a().d(iLPIssueDef.getIssueId(), ILPAnnotationImporter.this.course.getCourseId(), ILPAnnotationImporter.this.course.getReference())) == null && (iLPIssueDef2 = ILPAnnotationImporter.this.detectIssueWithAnyNodeInOtherIssue(iLPTopic.getIssue())) == null) {
                                        logger.c((Object)("Cannot takeover userTopic: " + iLPTopic + " due to no matching issue found"));
                                        continue;
                                    }
                                    ILPTopic iLPTopic4 = null;
                                    iLPTopic4 = StringUtils.isNotEmpty((CharSequence)iLPTopic.getReference()) ? f.a().c(iLPTopic.getReference(), iLPIssueDef2) : f.a().a(iLPTopic.getTitle(), iLPTopic.getAccessPath(), iLPTopic.getTag(), true, iLPIssueDef2);
                                    if (iLPTopic4 != null) {
                                        if (DateHelper.isNewer((DateTime)iLPTopic4.getResource().getLastUpdate(), (DateTime)iLPTopic.getResource().getLastUpdate())) {
                                            if (!ILPAnnotationImporter.this.overwriteNewerAlso) continue;
                                            ILPAnnotationImporter iLPAnnotationImporter = ILPAnnotationImporter.this;
                                            iLPAnnotationImporter.numOverwrittenNewerAnnotations = iLPAnnotationImporter.numOverwrittenNewerAnnotations + 1;
                                        } else {
                                            ILPAnnotationImporter iLPAnnotationImporter = ILPAnnotationImporter.this;
                                            iLPAnnotationImporter.numOverwrittenOlderAnnotations = iLPAnnotationImporter.numOverwrittenOlderAnnotations + 1;
                                        }
                                    } else {
                                        iLPTopic4 = new ILPTopic();
                                        iLPTopic4.setIssue(iLPIssueDef2);
                                        iLPTopic4.setParent(iLPTopic2);
                                        ILPAnnotationImporter iLPAnnotationImporter = ILPAnnotationImporter.this;
                                        iLPAnnotationImporter.numNotExistingAnnotations = iLPAnnotationImporter.numNotExistingAnnotations + 1;
                                    }
                                    iLPTopic.copyIntoUserTopic(iLPTopic4);
                                    for (ILPLocalStoreItem iLPLocalStoreItem : iLPTopic.getLocalStoreItems()) {
                                        ILPLocalStoreItem iLPLocalStoreItem2 = f.a().a(iLPTopic4, iLPLocalStoreItem.getSegment(), iLPLocalStoreItem.getKey());
                                        iLPLocalStoreItem2.setValue(iLPLocalStoreItem.getValue());
                                        if (iLPLocalStoreItem2.isInDatabase()) {
                                            g.a().N().update((Object)iLPLocalStoreItem2);
                                            continue;
                                        }
                                        g.a().N().create((Object)iLPLocalStoreItem2);
                                    }
                                    if (iLPTopic4.isInDatabase()) {
                                        g.a().G().update((Object)iLPTopic4);
                                        continue;
                                    }
                                    g.a().G().create((Object)iLPTopic4);
                                }
                            }
                            catch (Exception exception) {
                                logger.d((Object)("Could not fetch userTopics on issue: " + iLPIssueDef), (Throwable)exception);
                            }
                        }
                    }
                    return null;
                }
            });
        }
    }

    private ILPIssueDef detectIssueWithAnyNodeInOtherIssue(ILPIssueDef iLPIssueDef) {
        CloseableIterator closeableIterator = iLPIssueDef.getTopics().closeableIterator();
        try {
            while (closeableIterator.hasNext()) {
                ILPTopic iLPTopic;
                ILPTopic iLPTopic2 = (ILPTopic)closeableIterator.next();
                if (iLPTopic2.getNodeId() == null || (iLPTopic = f.a().a(iLPTopic2.getNodeId(), this.course)) == null) continue;
                ILPIssueDef iLPIssueDef2 = iLPTopic.getIssue();
                return iLPIssueDef2;
            }
        }
        finally {
            try {
                if (closeableIterator != null) {
                    closeableIterator.close();
                }
            }
            catch (IOException iOException) {
                logger.c((Object)("Could not close topics: " + iOException.getMessage()));
            }
        }
        return null;
    }

    private void addToImportedCourse(ILPCourseDef iLPCourseDef) {
        if (!this.importedCourses.contains(iLPCourseDef)) {
            this.importedCourses.add(iLPCourseDef);
        }
    }

    public String formatResultString() {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator<ILPCourseDef> iterator = this.importedCourses.iterator();
        while (iterator.hasNext()) {
            ILPCourseDef iLPCourseDef = iterator.next();
            stringBuffer.append(String.valueOf(iLPCourseDef.getTitle()) + ", " + iLPCourseDef.getPrintCodeOrEdition());
            if (!iterator.hasNext()) continue;
            stringBuffer.append(" / ");
        }
        return o.a((String)"portalV2.message.takeoverAnnotationsFromSameNodes.result", (Object[])new Object[]{this.getNumImportedAnnotations(), stringBuffer, this.getNumNotExistingAnnotations(), this.getNumOverwrittenOlderAnnotations(), this.getNumOverwrittenNewerAnnotations(), this.getNumFailedAnnotations()});
    }

    public int getNumImportedAnnotations() {
        return this.numImportedAnnotations;
    }

    public int getNumNotExistingAnnotations() {
        return this.numNotExistingAnnotations;
    }

    public int getNumOverwrittenOlderAnnotations() {
        return this.numOverwrittenOlderAnnotations;
    }

    public int getNumOverwrittenNewerAnnotations() {
        return this.numOverwrittenNewerAnnotations;
    }

    public int getNumFailedAnnotations() {
        return this.numFailedAnnotations;
    }
}

