/*
 * Decompiled with CFR 0.152.
 */
package ch.ionesoft.ilp.book.co;

import ch.ionesoft.ilp.base.co.ILPLogManager;
import ch.ionesoft.ilp.base.co.ILogger;
import ch.ionesoft.ilp.base.co.h;
import ch.ionesoft.ilp.base.fo.x;
import ch.ionesoft.ilp.base.he.ConverterUtil;
import ch.ionesoft.ilp.base.he.FileHelper;
import ch.ionesoft.ilp.base.he.ViewHelper;
import ch.ionesoft.ilp.book.au.b;
import ch.ionesoft.ilp.book.aua.model.ac;
import ch.ionesoft.ilp.book.co.ILPBookRegistry;
import ch.ionesoft.ilp.book.co.ILPBookSettingsHelper;
import ch.ionesoft.ilp.book.co.ILPProfileManager;
import ch.ionesoft.ilp.book.ia.aua.a;
import ch.ionesoft.ilp.book.ia.lima.d;
import ch.ionesoft.ilp.book.ia.osc.a;
import ch.ionesoft.ilp.book.mo.ILPAccount;
import ch.ionesoft.ilp.book.mo.ILPLicense;
import ch.ionesoft.ilp.book.mo.ILPOrderSystem;
import ch.ionesoft.ilp.book.mo.ILPProperty;
import ch.ionesoft.ilp.book.mo.ILPUser;
import ch.ionesoft.ilp.book.pe.f;
import ch.ionesoft.ilp.book.pe.g;
import ch.ionesoft.ilp.book.pe.j;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

public class IAUserManager {
    private static final int USER_PROFILE_RESPONSE_TIMEOUT = 300;
    private static final String SWISSMEM_IDENTITY_PROVIDER_IDENTIFIER = "SWISSMEM_1";
    private static final String HEP_IDENTITY_PROVIDER_IDENTIFIER = "HEP_MAGENTO_1";
    private static final String BEOOK_IDENTITY_PROVIDER_IDENTIFIER = "BEOOK_1";
    private static ILogger logger = ILPLogManager.getLogger(IAUserManager.class);

    public void updateUserAndLicensesSynch() {
        boolean bl2 = ILPBookRegistry.instance().isLongDbOperationsIsRunning();
        try {
            ILPBookRegistry.instance().setLongDbOperationsIsRunning(true);
            this.updateUserAndLicensesSynch(false, new OnUpdateUserProfileCallback(){

                @Override
                public void onSuccess() {
                    logger.b((Object)"Successfully updated user profile");
                }

                @Override
                public void onFailure(b b2) {
                    logger.d((Object)("Could not update user profile: " + b2));
                }
            });
        }
        finally {
            ILPBookRegistry.instance().setLongDbOperationsIsRunning(bl2);
        }
    }

    public void updateUserAndLicensesSynch(final boolean bl2, final OnUpdateUserProfileCallback onUpdateUserProfileCallback) {
        if (!x.a().a(false)) {
            String string = "No network. Could not do update user and licenses synch.";
            logger.c((Object)string);
            onUpdateUserProfileCallback.onFailure(new b(false, string));
            return;
        }
        logger.b((Object)"Get user information synchronously");
        final a a2 = new a();
        final ch.ionesoft.ilp.book.ia.osc.a a3 = new ch.ionesoft.ilp.book.ia.osc.a();
        a2.a(new a.e(){

            @Override
            public void onSuccess(ch.ionesoft.ilp.book.ia.b b2) {
                logger.b((Object)"Get identities from AUA successful");
                a2.b(new a.f(){

                    @Override
                    public void onSuccess(ILPUser iLPUser, ch.ionesoft.ilp.book.ia.b b2) {
                        try {
                            logger.b((Object)"Received user info successfully");
                            g.a().U().createOrUpdate((Object)iLPUser);
                            List<ILPProperty> list = a2.f();
                            IAUserManager.this.storeUserProperties(list);
                            a3.a(bl2, new a.d(){

                                @Override
                                public void onSuccess(ch.ionesoft.ilp.book.ia.b b2) {
                                    IAUserManager.this.retrieveLicensesAndPropertiesSynch(new OnUpdateUserProfileCallback(){

                                        @Override
                                        public void onSuccess() {
                                            onUpdateUserProfileCallback.onSuccess();
                                        }

                                        @Override
                                        public void onFailure(b b2) {
                                            logger.d((Object)("Could not update user and license: " + b2));
                                            onUpdateUserProfileCallback.onFailure(b2);
                                        }
                                    });
                                }

                                @Override
                                public void onFailure(ch.ionesoft.ilp.book.ia.b b2) {
                                    IAUserManager.this.retrieveLicensesAndPropertiesSynch(new OnUpdateUserProfileCallback(){

                                        @Override
                                        public void onSuccess() {
                                            ILPProfileManager.instance().saveCurrentProfile();
                                            onUpdateUserProfileCallback.onSuccess();
                                        }

                                        @Override
                                        public void onFailure(b b2) {
                                            logger.d((Object)("Could not update user and license: " + b2));
                                            onUpdateUserProfileCallback.onFailure(b2);
                                        }
                                    });
                                }
                            });
                        }
                        catch (SQLException sQLException) {
                            logger.d((Object)"Could not update user with user information from AUA, reason: ", (Throwable)sQLException);
                        }
                    }

                    @Override
                    public void onFailure(ch.ionesoft.ilp.book.ia.f f2) {
                        logger.d((Object)("Could not fetch user information, reason: " + f2));
                        onUpdateUserProfileCallback.onFailure(new b(false, f2.b()));
                    }
                });
            }

            @Override
            public void onFailure(ch.ionesoft.ilp.book.ia.f f2) {
                logger.d((Object)("Could not fetch user proprties, reason: " + f2));
                onUpdateUserProfileCallback.onFailure(new b(false, f2.b()));
            }
        });
    }

    public void updateUserOnAuaAsynch(String string, String string2, String string3, String string4, String string5, a.f f2) {
        a a2 = new a();
        a2.a(string5, string4, string3, string2, string, f2);
    }

    protected void retrieveLicensesAndPropertiesSynch(final OnUpdateUserProfileCallback onUpdateUserProfileCallback) {
        a a2 = new a();
        final d d2 = new d();
        if (!ILPProfileManager.isInitialProfileActive()) {
            d2.b(new d.a(){

                @Override
                public void onSuccess(ch.ionesoft.ilp.book.ia.b b2) {
                    logger.b((Object)"Got licenses successfully");
                    try {
                        IAUserManager.this.obtainAllLicensesFromInstalledEProducts(d2);
                    }
                    catch (Exception exception) {
                        logger.d((Object)("Could not obtain licenses from installed eproducts. " + exception));
                    }
                }

                @Override
                public void onFailure(ch.ionesoft.ilp.book.ia.f f2) {
                    logger.d((Object)("Could not refresh licenses for user profile, reason: " + f2));
                }
            });
        }
        a2.b(new a.g(){

            @Override
            public void onSuccess(List<ILPProperty> list, ch.ionesoft.ilp.book.ia.b b2) {
                IAUserManager.this.storeUserProperties(list);
                onUpdateUserProfileCallback.onSuccess();
            }

            @Override
            public void onFailure(ch.ionesoft.ilp.book.ia.f f2) {
                logger.d((Object)("Could not fetch user proprties, reason: " + f2));
                onUpdateUserProfileCallback.onFailure(new b(false, "Timeout"));
            }
        });
    }

    public static ILPUser getCurrentUser() {
        return ILPProfileManager.instance().getCurrentProfile().getCurrentUser();
    }

    public void storeUserProperties(List<ILPProperty> list) {
        ILPUser iLPUser;
        if (list == null || list.isEmpty()) {
            return;
        }
        logger.b((Object)"Received user properties successfully");
        String string = ILPBookRegistry.instance().getAuthenticationService().n();
        try {
            iLPUser = f.a().B(string);
        }
        catch (j j2) {
            logger.d((Object)("Could not fetch user with subject " + string + ", reason: "), (Throwable)j2);
            return;
        }
        if (iLPUser == null) {
            logger.d((Object)("Could not find user with subject " + string));
            return;
        }
        for (ILPProperty iLPProperty : list) {
            ILPProperty iLPProperty2 = f.a().a(iLPUser, iLPProperty.getKey());
            if (iLPProperty2 == null) {
                iLPProperty.setUser(iLPUser);
                iLPProperty2 = iLPProperty;
            } else if (iLPProperty.getTargetType().b(iLPProperty2.getTargetType()) && iLPProperty.getAssetStageType().a(iLPProperty2.getAssetStageType())) {
                iLPProperty2.setValueEncrypted(iLPProperty.getValueDecrypted());
                iLPProperty2.setTargetType(iLPProperty.getTargetType());
            }
            try {
                g.a().Q().createOrUpdate((Object)iLPProperty2);
            }
            catch (Exception exception) {
                logger.d((Object)"Could not create or update property, reason: ", (Throwable)exception);
            }
        }
        iLPUser.setProperties(null);
    }

    public static boolean hasCurrentUserSwissmemAccount() {
        return IAUserManager.hasCurrentUserSpecificIdentityProvider(SWISSMEM_IDENTITY_PROVIDER_IDENTIFIER);
    }

    public static boolean hasCurrentUserHepAccount() {
        return IAUserManager.hasCurrentUserSpecificIdentityProvider(HEP_IDENTITY_PROVIDER_IDENTIFIER);
    }

    public static boolean hasCurrentUserSpecificIdentityProvider(String string) {
        IAUserManager.getCurrentUser().setAccounts(null);
        boolean bl2 = false;
        for (ILPAccount iLPAccount : IAUserManager.getCurrentUser().getAccounts()) {
            if (!iLPAccount.getIdentityProvider().getIdentityProviderIdentifier().equals(string)) continue;
            bl2 = true;
        }
        return bl2;
    }

    public static boolean hasCurrentUserBeookAccount() {
        IAUserManager.getCurrentUser().setAccounts(null);
        boolean bl2 = false;
        for (ILPAccount iLPAccount : IAUserManager.getCurrentUser().getAccounts()) {
            if (!iLPAccount.getIdentityProvider().getIdentityProviderIdentifier().equals(BEOOK_IDENTITY_PROVIDER_IDENTIFIER)) continue;
            bl2 = true;
        }
        return bl2;
    }

    public static boolean hasCurrentUserIdentityProvider(String string) {
        IAUserManager.getCurrentUser().setAccounts(null);
        boolean bl2 = false;
        for (ILPAccount iLPAccount : IAUserManager.getCurrentUser().getAccounts()) {
            if (!iLPAccount.getIdentityProvider().getIdentityProviderIdentifier().equals(string)) continue;
            bl2 = true;
        }
        return bl2;
    }

    public static boolean hasCurrentUserCloudSwissmemMigrated() {
        ILPUser iLPUser = IAUserManager.getCurrentUser();
        if (iLPUser == null) {
            logger.b((Object)"Could not check if current user has cloud hep migrated. Current user is null.");
            return false;
        }
        return iLPUser.propertyBooleanById_defaultValue("cloud.swissmem.migrated", false);
    }

    public static boolean hasCurrentUserAccessToAssetStageQs() {
        if (IAUserManager.getCurrentUser() == null) {
            return false;
        }
        return IAUserManager.getCurrentUser().propertyBooleanById_defaultValue("permission.access.assetStage.qs", false) != false || IAUserManager.getCurrentUser().propertyBooleanById_defaultValue("assetStage.qs", false) != false;
    }

    public static boolean hasCurrentUserAccessToAssetStageDev() {
        if (IAUserManager.getCurrentUser() == null) {
            return false;
        }
        return IAUserManager.getCurrentUser().propertyBooleanById_defaultValue("permission.access.assetStage.dev", false) != false || IAUserManager.getCurrentUser().propertyBooleanById_defaultValue("assetStage.dev", false) != false;
    }

    public static boolean isBrowserDisallowedForCurrentUser() {
        if (IAUserManager.getCurrentUser() == null) {
            return false;
        }
        return IAUserManager.getCurrentUser().propertyBooleanById_defaultValue("permission.internal.browser.disallowed", false);
    }

    public static List<ILPOrderSystem> getCurrentUserOrderSystems(boolean bl2) {
        List<ILPOrderSystem> list;
        try {
            list = f.a().a(IAUserManager.getCurrentUser(), bl2);
        }
        catch (j j2) {
            logger.d((Object)"Could not get order systems for current user", (Throwable)j2);
            list = new ArrayList<ILPOrderSystem>();
        }
        return list;
    }

    public static ILPUser updateUserWithDTOData(ILPUser iLPUser, ac ac2) {
        iLPUser.setEmail(ac2.m());
        iLPUser.setFirstname(ac2.d());
        iLPUser.setLastname(ac2.e());
        iLPUser.setAvatar(ac2.j());
        iLPUser.setGender(ac2.l());
        iLPUser.setSubject(ac2.b());
        iLPUser.setCreationDate(ch.ionesoft.ilp.book.ia.d.a(ac2.v()));
        return iLPUser;
    }

    public static ILPUser updateUserDTOWithUserData(ac ac2, ILPUser iLPUser) {
        ac2.z(iLPUser.getEmail());
        ac2.h(iLPUser.getFirstname());
        ac2.j(iLPUser.getLastname());
        ac2.t(iLPUser.getAvatar());
        ac2.x(iLPUser.getGender());
        ac2.d(iLPUser.getSubject());
        return iLPUser;
    }

    public static void checkCloudMigration() {
        if (IAUserManager.getCurrentUser() == null) {
            logger.c((Object)"Tried to check swissmem cloud migration. CurrentUser is null.");
            return;
        }
        if (!IAUserManager.hasCurrentUserSwissmemAccount()) {
            logger.b((Object)"No swissmem cloud migration needed - User has no swissmem account");
            return;
        }
        if (IAUserManager.hasCurrentUserCloudSwissmemMigrated()) {
            logger.b((Object)"Skipping swissmem cloud migration, already done.");
            return;
        }
        if (!IAUserManager.hasCurrentUserSwissmemAccount() && IAUserManager.getCurrentUser().getAccounts().size() > 1) {
            logger.b((Object)"No swissmem cloud migration needed - Most likely already done, or currently running. ");
            return;
        }
        ch.ionesoft.ilp.base.co.f.b().D().displayNoticeCode("sharing.swissmem.cloud.migration", new Object[0]);
        a a2 = new a();
        a2.c(new a.f(){

            @Override
            public void onSuccess(ILPUser iLPUser, ch.ionesoft.ilp.book.ia.b b2) {
                logger.b((Object)"Swissmem cloud migration successful started.");
                ILPProfileManager.instance().getCurrentProfile().getCurrentUser().addPropertyInDatabase("cloud.swissmem.migrated", "true", h.e.a);
            }

            @Override
            public void onFailure(ch.ionesoft.ilp.book.ia.f f2) {
                logger.d((Object)("Could not migrate swissmem cloud, reason: " + f2));
            }
        });
    }

    public String linkIdentities(String string, String string2, final LinkProfileCallback linkProfileCallback, String string3) {
        a a2 = new a();
        a2.a(string, string2, true, new a.c(){

            @Override
            public void onSuccess(String string, ch.ionesoft.ilp.book.ia.f f2) {
                ch.ionesoft.ilp.book.ia.osc.a a2 = new ch.ionesoft.ilp.book.ia.osc.a();
                a2.a(true, new a.d(){

                    @Override
                    public void onSuccess(ch.ionesoft.ilp.book.ia.b b2) {
                        IAUserManager.this.updateUserAndLicensesSynch();
                        linkProfileCallback.onSuccess();
                    }

                    @Override
                    public void onFailure(ch.ionesoft.ilp.book.ia.b b2) {
                        logger.d((Object)("Could not synch orderSystems for user: " + b2));
                        linkProfileCallback.onFailure((ch.ionesoft.ilp.book.ia.f)b2);
                    }
                });
            }

            @Override
            public void onFailure(ch.ionesoft.ilp.book.ia.f f2) {
                logger.d((Object)("Could not link identites: " + f2));
                linkProfileCallback.onFailure(f2);
            }
        }, string3);
        return null;
    }

    public void obtainAllLicensesFromInstalledEProducts(d d2) {
        List<ILPLicense> list = f.a().T();
        if (list == null || list.isEmpty()) {
            return;
        }
        for (ILPLicense iLPLicense : list) {
            logger.b((Object)("Installed eproduct with no license usage found: " + iLPLicense.getEProduct()));
        }
        d2.a(list, new d.b(){

            @Override
            public void onSuccess(ch.ionesoft.ilp.book.ia.b b2) {
                logger.b((Object)"Successfully obtained licenses for installed eProducts.");
            }

            @Override
            public void onFailure(ch.ionesoft.ilp.book.ia.b b2) {
                logger.d((Object)"Could not reobtain licensec usages from installed products.");
            }
        });
    }

    public void pruneAllLicensesFromInstalledEProducts(d d2, String string) {
        List<ILPLicense> list = f.a().U();
        d2.a(list, string);
    }

    public static void askForSLA(boolean bl2, boolean bl3) {
        if (ILPProfileManager.isInitialProfileActive() || !ch.ionesoft.ilp.base.co.b.b().a("ILPBase.ask.for.sla", false)) {
            return;
        }
        if (ILPBookSettingsHelper.instance().isSlaAccepted()) {
            return;
        }
        if (!ILPBookRegistry.instance().getAuthenticationService().g()) {
            logger.b((Object)"User is not authenticated skip sla dialog for now.");
            return;
        }
        if (!x.a().a(false)) {
            logger.b((Object)"Device has no network skip sla dialog for now.");
            return;
        }
        String string = FileHelper.localizedContentsOfAppConfigBundleResource((String)"acceptSLA.html");
        ViewHelper viewHelper = ch.ionesoft.ilp.base.co.f.b().D();
        logger.b((Object)"Show user SLA-V1.3 dialog. ");
        viewHelper.showBlockingBrowserDialog(string, bl2, bl3, new ViewHelper.OnResultCallback(){

            public void onYes() {
                logger.b((Object)"User clicked 'accept' on sla dialog. Try to set property on aua. ");
                ILPUser iLPUser = ILPProfileManager.instance().getCurrentProfile().getCurrentUser();
                ILPProperty iLPProperty = iLPUser.addPropertyInDatabase("user.accepted.sla-V1_3", ConverterUtil.formatDateISODateString((Date)new Date()), h.e.a);
                a a2 = new a();
                a2.a(Arrays.asList(iLPProperty), new a.g(){

                    @Override
                    public void onSuccess(List<ILPProperty> list, ch.ionesoft.ilp.book.ia.b b2) {
                        logger.b((Object)"Successfully set SLA-Property user.accepted.sla-V1_3 on aua. ");
                    }

                    @Override
                    public void onFailure(ch.ionesoft.ilp.book.ia.f f2) {
                        logger.d((Object)("Could not set SLA property user.accepted.sla-V1_3 on aua. " + f2));
                        ch.ionesoft.ilp.base.co.f.b().D().displayNoticeCode("message.network.notAvailable", new Object[0]);
                        IAUserManager.askForSLA(true, true);
                    }
                });
            }

            public void onNo() {
            }

            public void onCancel() {
                logger.c((Object)"User has clicked cancel on SLA dialog. Ask again. ");
                IAUserManager.askForSLA(true, true);
            }
        });
    }

    public static interface LinkProfileCallback {
        public void onSuccess();

        public void onFailure(ch.ionesoft.ilp.book.ia.f var1);
    }

    public static interface OnUpdateUserProfileCallback {
        public void onSuccess();

        public void onFailure(b var1);
    }
}

