/*
 * Decompiled with CFR 0.152.
 */
package ch.ionesoft.ilp.book.co;

import ch.ionesoft.ilp.base.co.ILPLogManager;
import ch.ionesoft.ilp.base.co.ILogger;
import ch.ionesoft.ilp.base.co.g;
import ch.ionesoft.ilp.base.fo.x;
import ch.ionesoft.ilp.book.co.IAUserManager;
import ch.ionesoft.ilp.book.co.ILPBookSettingsHelper;
import ch.ionesoft.ilp.book.ia.b;
import ch.ionesoft.ilp.book.ia.e;
import ch.ionesoft.ilp.book.ia.lima.d;
import ch.ionesoft.ilp.book.ia.osc.a;
import ch.ionesoft.ilp.book.mo.ILPLicense;
import ch.ionesoft.ilp.book.mo.ILPMandantConfig;
import ch.ionesoft.ilp.book.mo.ILPOrderSystem;
import ch.ionesoft.ilp.book.pe.f;
import java.util.ArrayList;
import java.util.List;

public class IALicenseManager {
    private static ILogger logger = ILPLogManager.getLogger(IALicenseManager.class);
    private static int couponActivateDelay = 0;

    public static ILPLicense.LicenseState getAuthStateForLicense(ILPLicense iLPLicense) {
        if (iLPLicense.getExpirationDate() != null && iLPLicense.getExpirationDate().isAfterNow()) {
            return ILPLicense.LicenseState.LICENSE_STATE_EXPIRED;
        }
        if (iLPLicense.getMaxDevices() > iLPLicense.getUsedDevices()) {
            return ILPLicense.LicenseState.LICENSE_STATE_VALID;
        }
        return ILPLicense.LicenseState.LICENSE_STATE_EXCEEDED;
    }

    public void obtainLicenseUsage(ILPLicense iLPLicense, final LicenseManagerCallBack licenseManagerCallBack) {
        d d2 = new d();
        ArrayList<ILPLicense> arrayList = new ArrayList<ILPLicense>();
        arrayList.add(iLPLicense);
        d2.a(arrayList, new d.b(){

            @Override
            public void onSuccess(b b2) {
                logger.b((Object)"Licenses successfully obtained.");
                licenseManagerCallBack.onSuccess();
            }

            @Override
            public void onFailure(b b2) {
                logger.d((Object)("Could not obtain license usage, reason: " + b2));
                licenseManagerCallBack.onFailure(b2);
            }
        });
    }

    public void redeemCouponAndGetLicense(final List<String> list, ILPOrderSystem iLPOrderSystem, final boolean bl2, final LicenseManagerCallBack licenseManagerCallBack) {
        final a a2 = new a();
        final ArrayList arrayList = new ArrayList();
        try {
            Thread.sleep(couponActivateDelay * 1000);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        a2.a(list, iLPOrderSystem, new a.a(){

            @Override
            public void onSuccess(b b2) {
                if (ch.ionesoft.ilp.book.ia.d.c(b2.a())) {
                    logger.b((Object)("Activated " + list.size() + " coupon(s) successfully"));
                } else {
                    couponActivateDelay = couponActivateDelay + 1;
                    ch.ionesoft.ilp.book.ia.f f2 = (ch.ionesoft.ilp.book.ia.f)b2;
                    if (!f2.c(b.a.a) && !f2.e("OSC_WARNING_ORDER_SAVE_PARTIALLY_SAVED")) {
                        b b3 = f2.f().size() == 1 ? (b)f2.f().get(0) : b2;
                        for (e e2 : f2.f()) {
                            logger.c((Object)("Could not activate coupon: " + e2));
                        }
                        licenseManagerCallBack.onFailure(b3);
                        return;
                    }
                    List<e> list2 = f2.e(b.a.a);
                    arrayList.addAll(list2);
                    for (e e3 : arrayList) {
                        logger.c((Object)("Could not activate coupon: " + e3));
                    }
                }
                a2.a(bl2, new a.d(){

                    @Override
                    public void onSuccess(b b2) {
                        logger.b((Object)"Synchronized order systmems successfully");
                        d d2 = new d();
                        d2.a(new d.a(){

                            @Override
                            public void onSuccess(b b2) {
                                if (!ch.ionesoft.ilp.book.ia.d.c(b2.a().a())) {
                                    logger.c((Object)("Got licenses for user and device but having warning. Code: " + b2.c() + ", reason: " + b2.b()));
                                    licenseManagerCallBack.onFailure(b2);
                                } else if (arrayList.size() > 0) {
                                    licenseManagerCallBack.onWarning(arrayList);
                                } else {
                                    licenseManagerCallBack.onSuccess();
                                }
                            }

                            @Override
                            public void onFailure(ch.ionesoft.ilp.book.ia.f f2) {
                                logger.d((Object)("Could not get licenses for user, reason: " + f2));
                                licenseManagerCallBack.onFailure(f2);
                            }
                        });
                    }

                    @Override
                    public void onFailure(b b2) {
                        logger.d((Object)("Could not synch order system on coupon activation, reason: " + b2));
                        licenseManagerCallBack.onFailure(b2);
                    }
                });
            }

            @Override
            public void onFailure(b b2) {
                logger.d((Object)("Could not activate coupons, reason: " + b2));
                licenseManagerCallBack.onFailure(b2);
            }
        });
    }

    public void downloadMissingMandantConfigs(String string) {
        try {
            ILPMandantConfig iLPMandantConfig = f.a().Y(string);
            if (iLPMandantConfig == null) {
                logger.c((Object)("MandantConfig with fileReference: " + string + " not found."));
                return;
            }
            if (!iLPMandantConfig.isInstalled()) {
                iLPMandantConfig.install();
            }
        }
        catch (Exception exception) {
            logger.d((Object)("Could not download and install mandantConfig with fileReference: " + string), (Throwable)exception);
        }
    }

    public static void pruneAllFloatingLicenses() {
        logger.b((Object)"Start pruning all floating licenses. ");
        try {
            boolean bl2 = ILPBookSettingsHelper.instance().isAllowedToSwitchForFloatingDevice();
            ArrayList<ILPLicense> arrayList = new ArrayList<ILPLicense>();
            if (bl2) {
                logger.b((Object)"Device is allowed to unregister device licenses. ");
                arrayList.addAll(f.a().a(ILPLicense.LicenseStrategy.LICENSE_STRATEGY_DEVICE, ILPLicense.LicenseStrategy.LICENSE_STRATEGY_FLOATING));
            } else {
                arrayList.addAll(f.a().a(ILPLicense.LicenseStrategy.LICENSE_STRATEGY_FLOATING));
            }
            if (arrayList == null || arrayList.isEmpty()) {
                logger.b((Object)"No floating licenses to prune.");
                return;
            }
            d d2 = new d();
            b b2 = d2.a(arrayList, g.a().ag());
            if (b2.a() == b.a.a) {
                logger.b((Object)("Licenses succefully pruned. : " + b2));
            } else {
                logger.d((Object)("Licenses succefully pruned. : " + b2));
            }
        }
        catch (Exception exception) {
            logger.d((Object)"Could not prune licenses", (Throwable)exception);
        }
    }

    public static void obtainAllFloatingLicenses() {
        if (!x.a().a(false)) {
            logger.b((Object)"Cannot obtain floating licenses due to no network.");
            return;
        }
        logger.b((Object)"Start obtaining license usages for floating licenses.");
        boolean bl2 = ILPBookSettingsHelper.instance().isAllowedToSwitchForFloatingDevice();
        final ArrayList<ILPLicense> arrayList = new ArrayList<ILPLicense>();
        if (bl2) {
            logger.b((Object)"Device is allowed to register device licenses. ");
            arrayList.addAll(f.a().a(ILPLicense.LicenseStrategy.LICENSE_STRATEGY_DEVICE, ILPLicense.LicenseStrategy.LICENSE_STRATEGY_FLOATING));
        } else {
            arrayList.addAll(f.a().a(ILPLicense.LicenseStrategy.LICENSE_STRATEGY_FLOATING));
        }
        if (arrayList == null || arrayList.isEmpty()) {
            logger.b((Object)"No floating licenses to obtain. ");
            return;
        }
        d d2 = new d();
        d2.a(arrayList, new d.b(){

            @Override
            public void onSuccess(b b2) {
                logger.b((Object)("Floating licenses successfully obtained for " + arrayList.size() + " licenses: " + b2));
            }

            @Override
            public void onFailure(b b2) {
                logger.d((Object)("Could not obtain license usage for floating licenses: " + b2));
            }
        });
    }

    public static void checkForDeviceChanged() {
        try {
            if (!x.a().a(false)) {
                return;
            }
            if (!ILPBookSettingsHelper.instance().hasDeviceInfoChanged()) {
                return;
            }
            logger.b((Object)"The device specifications has changed.");
            d d2 = new d();
            d2.a(new d.d(){

                @Override
                public void onSuccess(b b2) {
                    logger.b((Object)("Device info successfully updated on lima: " + b2));
                    ILPBookSettingsHelper.instance().updateDeviceInfo();
                }

                @Override
                public void onFailure(b b2) {
                    logger.d((Object)("Could not update device info: " + b2));
                }
            });
        }
        catch (Exception exception) {
            logger.d((Object)"Could not check for device update, reason: ", (Throwable)exception);
        }
    }

    public static void pruneAndReObtainLicences(String string) {
        try {
            d d2 = new d();
            IAUserManager iAUserManager = new IAUserManager();
            iAUserManager.pruneAllLicensesFromInstalledEProducts(d2, string);
            iAUserManager.obtainAllLicensesFromInstalledEProducts(d2);
        }
        catch (Exception exception) {
            logger.d((Object)"Could not prune device");
        }
    }

    public static interface LicenseManagerCallBack {
        public void onSuccess();

        public void onFailure(b var1);

        public void onWarning(List<e> var1);
    }
}

